/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 3
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.transferwebhooks.Amount;
import com.adyen.model.transferwebhooks.BalanceMutation;
import com.adyen.model.transferwebhooks.CounterpartyV3;
import com.adyen.model.transferwebhooks.PaymentInstrument;
import com.adyen.model.transferwebhooks.RelayedAuthorisationData;
import com.adyen.model.transferwebhooks.ResourceReference;
import com.adyen.model.transferwebhooks.TransactionRulesResult;
import com.adyen.model.transferwebhooks.TransferEvent;
import com.adyen.model.transferwebhooks.TransferNotificationTransferTracking;
import com.adyen.model.transferwebhooks.TransferNotificationValidationFact;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.transferwebhooks.JSON;

/**
 * TransferNotificationData
 */

public class TransferNotificationData {
  public static final String SERIALIZED_NAME_ACCOUNT_HOLDER = "accountHolder";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_HOLDER)
  private ResourceReference accountHolder;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Amount amount;

  public static final String SERIALIZED_NAME_BALANCE_ACCOUNT = "balanceAccount";
  @SerializedName(SERIALIZED_NAME_BALANCE_ACCOUNT)
  private ResourceReference balanceAccount;

  public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_BALANCE_ACCOUNT_ID)
  private String balanceAccountId;

  public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
  @SerializedName(SERIALIZED_NAME_BALANCE_PLATFORM)
  private String balancePlatform;

  public static final String SERIALIZED_NAME_BALANCES = "balances";
  @SerializedName(SERIALIZED_NAME_BALANCES)
  private List<BalanceMutation> balances = null;

  /**
   * The type of transfer.  Possible values:   - **bank**: Transfer to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: Transfer initiated by a Adyen-issued card.  - **platformPayment**: Fund movements related to payments that are acquired for your users.
   */
  @JsonAdapter(CategoryEnum.Adapter.class)
  public enum CategoryEnum {
    BANK("bank"),
    
    INTERNAL("internal"),
    
    ISSUEDCARD("issuedCard"),
    
    PLATFORMPAYMENT("platformPayment");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CategoryEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CategoryEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CategoryEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CategoryEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CATEGORY = "category";
  @SerializedName(SERIALIZED_NAME_CATEGORY)
  private CategoryEnum category;

  public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
  @SerializedName(SERIALIZED_NAME_COUNTERPARTY)
  private CounterpartyV3 counterparty;

  public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
  @SerializedName(SERIALIZED_NAME_CREATION_DATE)
  private OffsetDateTime creationDate;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  /**
   * The direction of the transfer.  Possible values: **incoming**, **outgoing**.
   */
  @JsonAdapter(DirectionEnum.Adapter.class)
  public enum DirectionEnum {
    INCOMING("incoming"),
    
    OUTGOING("outgoing");

    private String value;

    DirectionEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DirectionEnum fromValue(String value) {
      for (DirectionEnum b : DirectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DirectionEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DirectionEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DirectionEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DirectionEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DIRECTION = "direction";
  @SerializedName(SERIALIZED_NAME_DIRECTION)
  private DirectionEnum direction;

  public static final String SERIALIZED_NAME_EVENTS = "events";
  @SerializedName(SERIALIZED_NAME_EVENTS)
  private List<TransferEvent> events = null;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_MODIFICATION_MERCHANT_REFERENCE = "modificationMerchantReference";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_MODIFICATION_MERCHANT_REFERENCE)
  private String modificationMerchantReference;

  public static final String SERIALIZED_NAME_MODIFICATION_PSP_REFERENCE = "modificationPspReference";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_MODIFICATION_PSP_REFERENCE)
  private String modificationPspReference;

  /**
   * Indicates the method used for entering the PAN to initiate a transaction.  Possible values: **manual**, **chip**, **magstripe**, **contactless**, **cof**, **ecommerce**, **token**.
   */
  @JsonAdapter(PanEntryModeEnum.Adapter.class)
  public enum PanEntryModeEnum {
    CHIP("chip"),
    
    COF("cof"),
    
    CONTACTLESS("contactless"),
    
    ECOMMERCE("ecommerce"),
    
    MAGSTRIPE("magstripe"),
    
    MANUAL("manual"),
    
    TOKEN("token");

    private String value;

    PanEntryModeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static PanEntryModeEnum fromValue(String value) {
      for (PanEntryModeEnum b : PanEntryModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<PanEntryModeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PanEntryModeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public PanEntryModeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return PanEntryModeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PAN_ENTRY_MODE = "panEntryMode";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_PAN_ENTRY_MODE)
  private PanEntryModeEnum panEntryMode;

  public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT = "paymentInstrument";
  @SerializedName(SERIALIZED_NAME_PAYMENT_INSTRUMENT)
  private PaymentInstrument paymentInstrument;

  public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID)
  private String paymentInstrumentId;

  public static final String SERIALIZED_NAME_PAYMENT_MERCHANT_REFERENCE = "paymentMerchantReference";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_PAYMENT_MERCHANT_REFERENCE)
  private String paymentMerchantReference;

  /**
   * The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with &#x60;category&#x60; **bank**.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).
   */
  @JsonAdapter(PriorityEnum.Adapter.class)
  public enum PriorityEnum {
    CROSSBORDER("crossBorder"),
    
    DIRECTDEBIT("directDebit"),
    
    FAST("fast"),
    
    INSTANT("instant"),
    
    INTERNAL("internal"),
    
    REGULAR("regular"),
    
    WIRE("wire");

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<PriorityEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PriorityEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public PriorityEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return PriorityEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PRIORITY = "priority";
  @SerializedName(SERIALIZED_NAME_PRIORITY)
  private PriorityEnum priority;

  /**
   * Contains information about how the payment was processed. For example, **ecommerce** for online or **pos** for in-person payments.
   */
  @JsonAdapter(ProcessingTypeEnum.Adapter.class)
  public enum ProcessingTypeEnum {
    ATMWITHDRAW("atmWithdraw"),
    
    BALANCEINQUIRY("balanceInquiry"),
    
    ECOMMERCE("ecommerce"),
    
    MOTO("moto"),
    
    POS("pos"),
    
    PURCHASEWITHCASHBACK("purchaseWithCashback"),
    
    RECURRING("recurring"),
    
    TOKEN("token");

    private String value;

    ProcessingTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ProcessingTypeEnum fromValue(String value) {
      for (ProcessingTypeEnum b : ProcessingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ProcessingTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ProcessingTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ProcessingTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ProcessingTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PROCESSING_TYPE = "processingType";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_PROCESSING_TYPE)
  private ProcessingTypeEnum processingType;

  public static final String SERIALIZED_NAME_PSP_PAYMENT_REFERENCE = "pspPaymentReference";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_PSP_PAYMENT_REFERENCE)
  private String pspPaymentReference;

  /**
   * Additional information about the status of the transfer.
   */
  @JsonAdapter(ReasonEnum.Adapter.class)
  public enum ReasonEnum {
    AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
    
    APPROVED("approved"),
    
    COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
    
    COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
    
    COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
    
    COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
    
    COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
    
    COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
    
    ERROR("error"),
    
    NOTENOUGHBALANCE("notEnoughBalance"),
    
    REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
    
    ROUTENOTFOUND("routeNotFound"),
    
    UNKNOWN("unknown");

    private String value;

    ReasonEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ReasonEnum fromValue(String value) {
      for (ReasonEnum b : ReasonEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ReasonEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ReasonEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ReasonEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ReasonEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_REASON = "reason";
  @SerializedName(SERIALIZED_NAME_REASON)
  private ReasonEnum reason;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
  @SerializedName(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY)
  private String referenceForBeneficiary;

  public static final String SERIALIZED_NAME_RELAYED_AUTHORISATION_DATA = "relayedAuthorisationData";
  @SerializedName(SERIALIZED_NAME_RELAYED_AUTHORISATION_DATA)
  private RelayedAuthorisationData relayedAuthorisationData;

  public static final String SERIALIZED_NAME_SEQUENCE_NUMBER = "sequenceNumber";
  @SerializedName(SERIALIZED_NAME_SEQUENCE_NUMBER)
  private Integer sequenceNumber;

  /**
   * The result of the transfer.   For example, **authorised**, **refused**, or **error**.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    APPROVALPENDING("approvalPending"),
    
    ATMWITHDRAWAL("atmWithdrawal"),
    
    ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
    
    ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
    
    AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
    
    AUTHADJUSTMENTERROR("authAdjustmentError"),
    
    AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
    
    AUTHORISED("authorised"),
    
    BANKTRANSFER("bankTransfer"),
    
    BANKTRANSFERPENDING("bankTransferPending"),
    
    BOOKED("booked"),
    
    BOOKINGPENDING("bookingPending"),
    
    CANCELLED("cancelled"),
    
    CAPTUREPENDING("capturePending"),
    
    CAPTUREREVERSALPENDING("captureReversalPending"),
    
    CAPTUREREVERSED("captureReversed"),
    
    CAPTURED("captured"),
    
    CHARGEBACK("chargeback"),
    
    CHARGEBACKPENDING("chargebackPending"),
    
    CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
    
    CHARGEBACKREVERSED("chargebackReversed"),
    
    CREDITED("credited"),
    
    DEPOSITCORRECTION("depositCorrection"),
    
    DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
    
    DISPUTE("dispute"),
    
    DISPUTECLOSED("disputeClosed"),
    
    DISPUTEEXPIRED("disputeExpired"),
    
    DISPUTENEEDSREVIEW("disputeNeedsReview"),
    
    ERROR("error"),
    
    EXPIRED("expired"),
    
    FAILED("failed"),
    
    FEE("fee"),
    
    FEEPENDING("feePending"),
    
    INTERNALTRANSFER("internalTransfer"),
    
    INTERNALTRANSFERPENDING("internalTransferPending"),
    
    INVOICEDEDUCTION("invoiceDeduction"),
    
    INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
    
    MANUALCORRECTIONPENDING("manualCorrectionPending"),
    
    MANUALLYCORRECTED("manuallyCorrected"),
    
    MATCHEDSTATEMENT("matchedStatement"),
    
    MATCHEDSTATEMENTPENDING("matchedStatementPending"),
    
    MERCHANTPAYIN("merchantPayin"),
    
    MERCHANTPAYINPENDING("merchantPayinPending"),
    
    MERCHANTPAYINREVERSED("merchantPayinReversed"),
    
    MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
    
    MISCCOST("miscCost"),
    
    MISCCOSTPENDING("miscCostPending"),
    
    PAYMENTCOST("paymentCost"),
    
    PAYMENTCOSTPENDING("paymentCostPending"),
    
    RECEIVED("received"),
    
    REFUNDPENDING("refundPending"),
    
    REFUNDREVERSALPENDING("refundReversalPending"),
    
    REFUNDREVERSED("refundReversed"),
    
    REFUNDED("refunded"),
    
    REFUSED("refused"),
    
    RESERVEADJUSTMENT("reserveAdjustment"),
    
    RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
    
    RETURNED("returned"),
    
    SECONDCHARGEBACK("secondChargeback"),
    
    SECONDCHARGEBACKPENDING("secondChargebackPending"),
    
    UNDEFINED("undefined");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_TRACKING = "tracking";
  @SerializedName(SERIALIZED_NAME_TRACKING)
  private TransferNotificationTransferTracking tracking;

  public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_TRANSACTION_ID)
  private String transactionId;

  public static final String SERIALIZED_NAME_TRANSACTION_RULES_RESULT = "transactionRulesResult";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_RULES_RESULT)
  private TransactionRulesResult transactionRulesResult;

  /**
   * The type of transfer or transaction. For example, **refund**, **payment**, **internalTransfer**, **bankTransfer**.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    ATMWITHDRAWAL("atmWithdrawal"),
    
    ATMWITHDRAWALREVERSAL("atmWithdrawalReversal"),
    
    BALANCEADJUSTMENT("balanceAdjustment"),
    
    BALANCEROLLOVER("balanceRollover"),
    
    BANKTRANSFER("bankTransfer"),
    
    CAPTURE("capture"),
    
    CAPTUREREVERSAL("captureReversal"),
    
    CHARGEBACK("chargeback"),
    
    CHARGEBACKREVERSAL("chargebackReversal"),
    
    DEPOSITCORRECTION("depositCorrection"),
    
    FEE("fee"),
    
    GRANT("grant"),
    
    INSTALLMENT("installment"),
    
    INSTALLMENTREVERSAL("installmentReversal"),
    
    INTERNALTRANSFER("internalTransfer"),
    
    INVOICEDEDUCTION("invoiceDeduction"),
    
    LEFTOVER("leftover"),
    
    MANUALCORRECTION("manualCorrection"),
    
    MISCCOST("miscCost"),
    
    PAYMENT("payment"),
    
    PAYMENTCOST("paymentCost"),
    
    REFUND("refund"),
    
    REFUNDREVERSAL("refundReversal"),
    
    REPAYMENT("repayment"),
    
    RESERVEADJUSTMENT("reserveAdjustment"),
    
    SECONDCHARGEBACK("secondChargeback");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_VALIDATION_FACTS = "validationFacts";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_VALIDATION_FACTS)
  private List<TransferNotificationValidationFact> validationFacts = null;

  public TransferNotificationData() { 
  }

  public TransferNotificationData accountHolder(ResourceReference accountHolder) {
    
    this.accountHolder = accountHolder;
    return this;
  }

   /**
   * Get accountHolder
   * @return accountHolder
  **/
  @ApiModelProperty(value = "")

  public ResourceReference getAccountHolder() {
    return accountHolder;
  }


  public void setAccountHolder(ResourceReference accountHolder) {
    this.accountHolder = accountHolder;
  }


  public TransferNotificationData amount(Amount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")

  public Amount getAmount() {
    return amount;
  }


  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public TransferNotificationData balanceAccount(ResourceReference balanceAccount) {
    
    this.balanceAccount = balanceAccount;
    return this;
  }

   /**
   * Get balanceAccount
   * @return balanceAccount
  **/
  @ApiModelProperty(value = "")

  public ResourceReference getBalanceAccount() {
    return balanceAccount;
  }


  public void setBalanceAccount(ResourceReference balanceAccount) {
    this.balanceAccount = balanceAccount;
  }


  @Deprecated
  public TransferNotificationData balanceAccountId(String balanceAccountId) {
    
    this.balanceAccountId = balanceAccountId;
    return this;
  }

   /**
   * The unique identifier of the source [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).
   * @return balanceAccountId
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The unique identifier of the source [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).")

  public String getBalanceAccountId() {
    return balanceAccountId;
  }


  @Deprecated
  public void setBalanceAccountId(String balanceAccountId) {
    this.balanceAccountId = balanceAccountId;
  }


  public TransferNotificationData balancePlatform(String balancePlatform) {
    
    this.balancePlatform = balancePlatform;
    return this;
  }

   /**
   * The unique identifier of the balance platform.
   * @return balancePlatform
  **/
  @ApiModelProperty(value = "The unique identifier of the balance platform.")

  public String getBalancePlatform() {
    return balancePlatform;
  }


  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }


  public TransferNotificationData balances(List<BalanceMutation> balances) {
    
    this.balances = balances;
    return this;
  }

  public TransferNotificationData addBalancesItem(BalanceMutation balancesItem) {
    if (this.balances == null) {
      this.balances = new ArrayList<>();
    }
    this.balances.add(balancesItem);
    return this;
  }

   /**
   * The list of the latest balance statuses in the transfer.
   * @return balances
  **/
  @ApiModelProperty(value = "The list of the latest balance statuses in the transfer.")

  public List<BalanceMutation> getBalances() {
    return balances;
  }


  public void setBalances(List<BalanceMutation> balances) {
    this.balances = balances;
  }


  public TransferNotificationData category(CategoryEnum category) {
    
    this.category = category;
    return this;
  }

   /**
   * The type of transfer.  Possible values:   - **bank**: Transfer to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: Transfer initiated by a Adyen-issued card.  - **platformPayment**: Fund movements related to payments that are acquired for your users.
   * @return category
  **/
  @ApiModelProperty(required = true, value = "The type of transfer.  Possible values:   - **bank**: Transfer to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: Transfer initiated by a Adyen-issued card.  - **platformPayment**: Fund movements related to payments that are acquired for your users.")

  public CategoryEnum getCategory() {
    return category;
  }


  public void setCategory(CategoryEnum category) {
    this.category = category;
  }


  public TransferNotificationData counterparty(CounterpartyV3 counterparty) {
    
    this.counterparty = counterparty;
    return this;
  }

   /**
   * Get counterparty
   * @return counterparty
  **/
  @ApiModelProperty(value = "")

  public CounterpartyV3 getCounterparty() {
    return counterparty;
  }


  public void setCounterparty(CounterpartyV3 counterparty) {
    this.counterparty = counterparty;
  }


  public TransferNotificationData creationDate(OffsetDateTime creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.
   * @return creationDate
  **/
  @ApiModelProperty(value = "The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")

  public OffsetDateTime getCreationDate() {
    return creationDate;
  }


  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }


  public TransferNotificationData description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , &#39; + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] &amp; $ % # @** **~ &#x3D; + - _ &#39; \&quot; ! ?**
   * @return description
  **/
  @ApiModelProperty(value = "Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , ' + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] & $ % # @** **~ = + - _ ' \" ! ?**")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public TransferNotificationData direction(DirectionEnum direction) {
    
    this.direction = direction;
    return this;
  }

   /**
   * The direction of the transfer.  Possible values: **incoming**, **outgoing**.
   * @return direction
  **/
  @ApiModelProperty(value = "The direction of the transfer.  Possible values: **incoming**, **outgoing**.")

  public DirectionEnum getDirection() {
    return direction;
  }


  public void setDirection(DirectionEnum direction) {
    this.direction = direction;
  }


  public TransferNotificationData events(List<TransferEvent> events) {
    
    this.events = events;
    return this;
  }

  public TransferNotificationData addEventsItem(TransferEvent eventsItem) {
    if (this.events == null) {
      this.events = new ArrayList<>();
    }
    this.events.add(eventsItem);
    return this;
  }

   /**
   * The list of events leading up to the current status of the transfer.
   * @return events
  **/
  @ApiModelProperty(value = "The list of events leading up to the current status of the transfer.")

  public List<TransferEvent> getEvents() {
    return events;
  }


  public void setEvents(List<TransferEvent> events) {
    this.events = events;
  }


  public TransferNotificationData id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of the resource.
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the resource.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  @Deprecated
  public TransferNotificationData modificationMerchantReference(String modificationMerchantReference) {
    
    this.modificationMerchantReference = modificationMerchantReference;
    return this;
  }

   /**
   * The capture&#39;s merchant reference included in the transfer.
   * @return modificationMerchantReference
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The capture's merchant reference included in the transfer.")

  public String getModificationMerchantReference() {
    return modificationMerchantReference;
  }


  @Deprecated
  public void setModificationMerchantReference(String modificationMerchantReference) {
    this.modificationMerchantReference = modificationMerchantReference;
  }


  @Deprecated
  public TransferNotificationData modificationPspReference(String modificationPspReference) {
    
    this.modificationPspReference = modificationPspReference;
    return this;
  }

   /**
   * The capture reference included in the transfer.
   * @return modificationPspReference
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The capture reference included in the transfer.")

  public String getModificationPspReference() {
    return modificationPspReference;
  }


  @Deprecated
  public void setModificationPspReference(String modificationPspReference) {
    this.modificationPspReference = modificationPspReference;
  }


  @Deprecated
  public TransferNotificationData panEntryMode(PanEntryModeEnum panEntryMode) {
    
    this.panEntryMode = panEntryMode;
    return this;
  }

   /**
   * Indicates the method used for entering the PAN to initiate a transaction.  Possible values: **manual**, **chip**, **magstripe**, **contactless**, **cof**, **ecommerce**, **token**.
   * @return panEntryMode
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "Indicates the method used for entering the PAN to initiate a transaction.  Possible values: **manual**, **chip**, **magstripe**, **contactless**, **cof**, **ecommerce**, **token**.")

  public PanEntryModeEnum getPanEntryMode() {
    return panEntryMode;
  }


  @Deprecated
  public void setPanEntryMode(PanEntryModeEnum panEntryMode) {
    this.panEntryMode = panEntryMode;
  }


  public TransferNotificationData paymentInstrument(PaymentInstrument paymentInstrument) {
    
    this.paymentInstrument = paymentInstrument;
    return this;
  }

   /**
   * Get paymentInstrument
   * @return paymentInstrument
  **/
  @ApiModelProperty(value = "")

  public PaymentInstrument getPaymentInstrument() {
    return paymentInstrument;
  }


  public void setPaymentInstrument(PaymentInstrument paymentInstrument) {
    this.paymentInstrument = paymentInstrument;
  }


  @Deprecated
  public TransferNotificationData paymentInstrumentId(String paymentInstrumentId) {
    
    this.paymentInstrumentId = paymentInstrumentId;
    return this;
  }

   /**
   * The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) used in the transfer.
   * @return paymentInstrumentId
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) used in the transfer.")

  public String getPaymentInstrumentId() {
    return paymentInstrumentId;
  }


  @Deprecated
  public void setPaymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
  }


  @Deprecated
  public TransferNotificationData paymentMerchantReference(String paymentMerchantReference) {
    
    this.paymentMerchantReference = paymentMerchantReference;
    return this;
  }

   /**
   * The payment&#39;s merchant reference included in the transfer.
   * @return paymentMerchantReference
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The payment's merchant reference included in the transfer.")

  public String getPaymentMerchantReference() {
    return paymentMerchantReference;
  }


  @Deprecated
  public void setPaymentMerchantReference(String paymentMerchantReference) {
    this.paymentMerchantReference = paymentMerchantReference;
  }


  public TransferNotificationData priority(PriorityEnum priority) {
    
    this.priority = priority;
    return this;
  }

   /**
   * The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with &#x60;category&#x60; **bank**.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).
   * @return priority
  **/
  @ApiModelProperty(value = "The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with `category` **bank**.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).")

  public PriorityEnum getPriority() {
    return priority;
  }


  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }


  @Deprecated
  public TransferNotificationData processingType(ProcessingTypeEnum processingType) {
    
    this.processingType = processingType;
    return this;
  }

   /**
   * Contains information about how the payment was processed. For example, **ecommerce** for online or **pos** for in-person payments.
   * @return processingType
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "Contains information about how the payment was processed. For example, **ecommerce** for online or **pos** for in-person payments.")

  public ProcessingTypeEnum getProcessingType() {
    return processingType;
  }


  @Deprecated
  public void setProcessingType(ProcessingTypeEnum processingType) {
    this.processingType = processingType;
  }


  @Deprecated
  public TransferNotificationData pspPaymentReference(String pspPaymentReference) {
    
    this.pspPaymentReference = pspPaymentReference;
    return this;
  }

   /**
   * The payment reference included in the transfer.
   * @return pspPaymentReference
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The payment reference included in the transfer.")

  public String getPspPaymentReference() {
    return pspPaymentReference;
  }


  @Deprecated
  public void setPspPaymentReference(String pspPaymentReference) {
    this.pspPaymentReference = pspPaymentReference;
  }


  public TransferNotificationData reason(ReasonEnum reason) {
    
    this.reason = reason;
    return this;
  }

   /**
   * Additional information about the status of the transfer.
   * @return reason
  **/
  @ApiModelProperty(value = "Additional information about the status of the transfer.")

  public ReasonEnum getReason() {
    return reason;
  }


  public void setReason(ReasonEnum reason) {
    this.reason = reason;
  }


  public TransferNotificationData reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * Your reference for the transfer, used internally within your platform. If you don&#39;t provide this in the request, Adyen generates a unique reference.
   * @return reference
  **/
  @ApiModelProperty(value = "Your reference for the transfer, used internally within your platform. If you don't provide this in the request, Adyen generates a unique reference.")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public TransferNotificationData referenceForBeneficiary(String referenceForBeneficiary) {
    
    this.referenceForBeneficiary = referenceForBeneficiary;
    return this;
  }

   /**
   *  A reference that is sent to the recipient. This reference is also sent in all webhooks related to the transfer, so you can use it to track statuses for both the source and recipient of funds.   Supported characters: **a-z**, **A-Z**, **0-9**. The maximum length depends on the &#x60;category&#x60;.  - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.
   * @return referenceForBeneficiary
  **/
  @ApiModelProperty(value = " A reference that is sent to the recipient. This reference is also sent in all webhooks related to the transfer, so you can use it to track statuses for both the source and recipient of funds.   Supported characters: **a-z**, **A-Z**, **0-9**. The maximum length depends on the `category`.  - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.")

  public String getReferenceForBeneficiary() {
    return referenceForBeneficiary;
  }


  public void setReferenceForBeneficiary(String referenceForBeneficiary) {
    this.referenceForBeneficiary = referenceForBeneficiary;
  }


  public TransferNotificationData relayedAuthorisationData(RelayedAuthorisationData relayedAuthorisationData) {
    
    this.relayedAuthorisationData = relayedAuthorisationData;
    return this;
  }

   /**
   * Get relayedAuthorisationData
   * @return relayedAuthorisationData
  **/
  @ApiModelProperty(value = "")

  public RelayedAuthorisationData getRelayedAuthorisationData() {
    return relayedAuthorisationData;
  }


  public void setRelayedAuthorisationData(RelayedAuthorisationData relayedAuthorisationData) {
    this.relayedAuthorisationData = relayedAuthorisationData;
  }


  public TransferNotificationData sequenceNumber(Integer sequenceNumber) {
    
    this.sequenceNumber = sequenceNumber;
    return this;
  }

   /**
   * The sequence number of the transfer notification. The numbers start from 1 and increase with each new notification for a specific transfer.  It can help you restore the correct sequence of events even if they arrive out of order.
   * @return sequenceNumber
  **/
  @ApiModelProperty(value = "The sequence number of the transfer notification. The numbers start from 1 and increase with each new notification for a specific transfer.  It can help you restore the correct sequence of events even if they arrive out of order.")

  public Integer getSequenceNumber() {
    return sequenceNumber;
  }


  public void setSequenceNumber(Integer sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
  }


  public TransferNotificationData status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The result of the transfer.   For example, **authorised**, **refused**, or **error**.
   * @return status
  **/
  @ApiModelProperty(required = true, value = "The result of the transfer.   For example, **authorised**, **refused**, or **error**.")

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public TransferNotificationData tracking(TransferNotificationTransferTracking tracking) {
    
    this.tracking = tracking;
    return this;
  }

   /**
   * Get tracking
   * @return tracking
  **/
  @ApiModelProperty(value = "")

  public TransferNotificationTransferTracking getTracking() {
    return tracking;
  }


  public void setTracking(TransferNotificationTransferTracking tracking) {
    this.tracking = tracking;
  }


  @Deprecated
  public TransferNotificationData transactionId(String transactionId) {
    
    this.transactionId = transactionId;
    return this;
  }

   /**
   * The ID of the transaction that is created based on the transfer.
   * @return transactionId
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The ID of the transaction that is created based on the transfer.")

  public String getTransactionId() {
    return transactionId;
  }


  @Deprecated
  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }


  public TransferNotificationData transactionRulesResult(TransactionRulesResult transactionRulesResult) {
    
    this.transactionRulesResult = transactionRulesResult;
    return this;
  }

   /**
   * Get transactionRulesResult
   * @return transactionRulesResult
  **/
  @ApiModelProperty(value = "")

  public TransactionRulesResult getTransactionRulesResult() {
    return transactionRulesResult;
  }


  public void setTransactionRulesResult(TransactionRulesResult transactionRulesResult) {
    this.transactionRulesResult = transactionRulesResult;
  }


  public TransferNotificationData type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of transfer or transaction. For example, **refund**, **payment**, **internalTransfer**, **bankTransfer**.
   * @return type
  **/
  @ApiModelProperty(value = "The type of transfer or transaction. For example, **refund**, **payment**, **internalTransfer**, **bankTransfer**.")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Deprecated
  public TransferNotificationData validationFacts(List<TransferNotificationValidationFact> validationFacts) {
    
    this.validationFacts = validationFacts;
    return this;
  }

  public TransferNotificationData addValidationFactsItem(TransferNotificationValidationFact validationFactsItem) {
    if (this.validationFacts == null) {
      this.validationFacts = new ArrayList<>();
    }
    this.validationFacts.add(validationFactsItem);
    return this;
  }

   /**
   * The evaluation of the validation facts. See [validation checks](https://docs.adyen.com/issuing/validation-checks) for more information.
   * @return validationFacts
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The evaluation of the validation facts. See [validation checks](https://docs.adyen.com/issuing/validation-checks) for more information.")

  public List<TransferNotificationValidationFact> getValidationFacts() {
    return validationFacts;
  }


  @Deprecated
  public void setValidationFacts(List<TransferNotificationValidationFact> validationFacts) {
    this.validationFacts = validationFacts;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferNotificationData transferNotificationData = (TransferNotificationData) o;
    return Objects.equals(this.accountHolder, transferNotificationData.accountHolder) &&
        Objects.equals(this.amount, transferNotificationData.amount) &&
        Objects.equals(this.balanceAccount, transferNotificationData.balanceAccount) &&
        Objects.equals(this.balanceAccountId, transferNotificationData.balanceAccountId) &&
        Objects.equals(this.balancePlatform, transferNotificationData.balancePlatform) &&
        Objects.equals(this.balances, transferNotificationData.balances) &&
        Objects.equals(this.category, transferNotificationData.category) &&
        Objects.equals(this.counterparty, transferNotificationData.counterparty) &&
        Objects.equals(this.creationDate, transferNotificationData.creationDate) &&
        Objects.equals(this.description, transferNotificationData.description) &&
        Objects.equals(this.direction, transferNotificationData.direction) &&
        Objects.equals(this.events, transferNotificationData.events) &&
        Objects.equals(this.id, transferNotificationData.id) &&
        Objects.equals(this.modificationMerchantReference, transferNotificationData.modificationMerchantReference) &&
        Objects.equals(this.modificationPspReference, transferNotificationData.modificationPspReference) &&
        Objects.equals(this.panEntryMode, transferNotificationData.panEntryMode) &&
        Objects.equals(this.paymentInstrument, transferNotificationData.paymentInstrument) &&
        Objects.equals(this.paymentInstrumentId, transferNotificationData.paymentInstrumentId) &&
        Objects.equals(this.paymentMerchantReference, transferNotificationData.paymentMerchantReference) &&
        Objects.equals(this.priority, transferNotificationData.priority) &&
        Objects.equals(this.processingType, transferNotificationData.processingType) &&
        Objects.equals(this.pspPaymentReference, transferNotificationData.pspPaymentReference) &&
        Objects.equals(this.reason, transferNotificationData.reason) &&
        Objects.equals(this.reference, transferNotificationData.reference) &&
        Objects.equals(this.referenceForBeneficiary, transferNotificationData.referenceForBeneficiary) &&
        Objects.equals(this.relayedAuthorisationData, transferNotificationData.relayedAuthorisationData) &&
        Objects.equals(this.sequenceNumber, transferNotificationData.sequenceNumber) &&
        Objects.equals(this.status, transferNotificationData.status) &&
        Objects.equals(this.tracking, transferNotificationData.tracking) &&
        Objects.equals(this.transactionId, transferNotificationData.transactionId) &&
        Objects.equals(this.transactionRulesResult, transferNotificationData.transactionRulesResult) &&
        Objects.equals(this.type, transferNotificationData.type) &&
        Objects.equals(this.validationFacts, transferNotificationData.validationFacts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountHolder, amount, balanceAccount, balanceAccountId, balancePlatform, balances, category, counterparty, creationDate, description, direction, events, id, modificationMerchantReference, modificationPspReference, panEntryMode, paymentInstrument, paymentInstrumentId, paymentMerchantReference, priority, processingType, pspPaymentReference, reason, reference, referenceForBeneficiary, relayedAuthorisationData, sequenceNumber, status, tracking, transactionId, transactionRulesResult, type, validationFacts);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferNotificationData {\n");
    sb.append("    accountHolder: ").append(toIndentedString(accountHolder)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balanceAccount: ").append(toIndentedString(balanceAccount)).append("\n");
    sb.append("    balanceAccountId: ").append(toIndentedString(balanceAccountId)).append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    balances: ").append(toIndentedString(balances)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    counterparty: ").append(toIndentedString(counterparty)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    direction: ").append(toIndentedString(direction)).append("\n");
    sb.append("    events: ").append(toIndentedString(events)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    modificationMerchantReference: ").append(toIndentedString(modificationMerchantReference)).append("\n");
    sb.append("    modificationPspReference: ").append(toIndentedString(modificationPspReference)).append("\n");
    sb.append("    panEntryMode: ").append(toIndentedString(panEntryMode)).append("\n");
    sb.append("    paymentInstrument: ").append(toIndentedString(paymentInstrument)).append("\n");
    sb.append("    paymentInstrumentId: ").append(toIndentedString(paymentInstrumentId)).append("\n");
    sb.append("    paymentMerchantReference: ").append(toIndentedString(paymentMerchantReference)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    processingType: ").append(toIndentedString(processingType)).append("\n");
    sb.append("    pspPaymentReference: ").append(toIndentedString(pspPaymentReference)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    referenceForBeneficiary: ").append(toIndentedString(referenceForBeneficiary)).append("\n");
    sb.append("    relayedAuthorisationData: ").append(toIndentedString(relayedAuthorisationData)).append("\n");
    sb.append("    sequenceNumber: ").append(toIndentedString(sequenceNumber)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    tracking: ").append(toIndentedString(tracking)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    transactionRulesResult: ").append(toIndentedString(transactionRulesResult)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validationFacts: ").append(toIndentedString(validationFacts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("accountHolder");
    openapiFields.add("amount");
    openapiFields.add("balanceAccount");
    openapiFields.add("balanceAccountId");
    openapiFields.add("balancePlatform");
    openapiFields.add("balances");
    openapiFields.add("category");
    openapiFields.add("counterparty");
    openapiFields.add("creationDate");
    openapiFields.add("description");
    openapiFields.add("direction");
    openapiFields.add("events");
    openapiFields.add("id");
    openapiFields.add("modificationMerchantReference");
    openapiFields.add("modificationPspReference");
    openapiFields.add("panEntryMode");
    openapiFields.add("paymentInstrument");
    openapiFields.add("paymentInstrumentId");
    openapiFields.add("paymentMerchantReference");
    openapiFields.add("priority");
    openapiFields.add("processingType");
    openapiFields.add("pspPaymentReference");
    openapiFields.add("reason");
    openapiFields.add("reference");
    openapiFields.add("referenceForBeneficiary");
    openapiFields.add("relayedAuthorisationData");
    openapiFields.add("sequenceNumber");
    openapiFields.add("status");
    openapiFields.add("tracking");
    openapiFields.add("transactionId");
    openapiFields.add("transactionRulesResult");
    openapiFields.add("type");
    openapiFields.add("validationFacts");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("amount");
    openapiRequiredFields.add("category");
    openapiRequiredFields.add("status");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(TransferNotificationData.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TransferNotificationData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TransferNotificationData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TransferNotificationData is not found in the empty JSON string", TransferNotificationData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!TransferNotificationData.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TransferNotificationData` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : TransferNotificationData.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `accountHolder`
      if (jsonObj.getAsJsonObject("accountHolder") != null) {
        ResourceReference.validateJsonObject(jsonObj.getAsJsonObject("accountHolder"));
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      // validate the optional field `balanceAccount`
      if (jsonObj.getAsJsonObject("balanceAccount") != null) {
        ResourceReference.validateJsonObject(jsonObj.getAsJsonObject("balanceAccount"));
      }
      // validate the optional field balanceAccountId
      if (jsonObj.get("balanceAccountId") != null && !jsonObj.get("balanceAccountId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("balanceAccountId").toString()));
      }
      // validate the optional field balancePlatform
      if (jsonObj.get("balancePlatform") != null && !jsonObj.get("balancePlatform").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get("balancePlatform").toString()));
      }
      JsonArray jsonArraybalances = jsonObj.getAsJsonArray("balances");
      if (jsonArraybalances != null) {
        // ensure the json data is an array
        if (!jsonObj.get("balances").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `balances` to be an array in the JSON string but got `%s`", jsonObj.get("balances").toString()));
        }

        // validate the optional field `balances` (array)
        for (int i = 0; i < jsonArraybalances.size(); i++) {
          BalanceMutation.validateJsonObject(jsonArraybalances.get(i).getAsJsonObject());
        }
      }
      // ensure the field category can be parsed to an enum value
      if (jsonObj.get("category") != null) {
        if(!jsonObj.get("category").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `category` to be a primitive type in the JSON string but got `%s`", jsonObj.get("category").toString()));
        }
        CategoryEnum.fromValue(jsonObj.get("category").getAsString());
      }
      // validate the optional field `counterparty`
      if (jsonObj.getAsJsonObject("counterparty") != null) {
        CounterpartyV3.validateJsonObject(jsonObj.getAsJsonObject("counterparty"));
      }
      // validate the optional field description
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // ensure the field direction can be parsed to an enum value
      if (jsonObj.get("direction") != null) {
        if(!jsonObj.get("direction").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `direction` to be a primitive type in the JSON string but got `%s`", jsonObj.get("direction").toString()));
        }
        DirectionEnum.fromValue(jsonObj.get("direction").getAsString());
      }
      JsonArray jsonArrayevents = jsonObj.getAsJsonArray("events");
      if (jsonArrayevents != null) {
        // ensure the json data is an array
        if (!jsonObj.get("events").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `events` to be an array in the JSON string but got `%s`", jsonObj.get("events").toString()));
        }

        // validate the optional field `events` (array)
        for (int i = 0; i < jsonArrayevents.size(); i++) {
          TransferEvent.validateJsonObject(jsonArrayevents.get(i).getAsJsonObject());
        }
      }
      // validate the optional field id
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field modificationMerchantReference
      if (jsonObj.get("modificationMerchantReference") != null && !jsonObj.get("modificationMerchantReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `modificationMerchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("modificationMerchantReference").toString()));
      }
      // validate the optional field modificationPspReference
      if (jsonObj.get("modificationPspReference") != null && !jsonObj.get("modificationPspReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `modificationPspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("modificationPspReference").toString()));
      }
      // ensure the field panEntryMode can be parsed to an enum value
      if (jsonObj.get("panEntryMode") != null) {
        if(!jsonObj.get("panEntryMode").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `panEntryMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("panEntryMode").toString()));
        }
        PanEntryModeEnum.fromValue(jsonObj.get("panEntryMode").getAsString());
      }
      // validate the optional field `paymentInstrument`
      if (jsonObj.getAsJsonObject("paymentInstrument") != null) {
        PaymentInstrument.validateJsonObject(jsonObj.getAsJsonObject("paymentInstrument"));
      }
      // validate the optional field paymentInstrumentId
      if (jsonObj.get("paymentInstrumentId") != null && !jsonObj.get("paymentInstrumentId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentInstrumentId").toString()));
      }
      // validate the optional field paymentMerchantReference
      if (jsonObj.get("paymentMerchantReference") != null && !jsonObj.get("paymentMerchantReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentMerchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentMerchantReference").toString()));
      }
      // ensure the field priority can be parsed to an enum value
      if (jsonObj.get("priority") != null) {
        if(!jsonObj.get("priority").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `priority` to be a primitive type in the JSON string but got `%s`", jsonObj.get("priority").toString()));
        }
        PriorityEnum.fromValue(jsonObj.get("priority").getAsString());
      }
      // ensure the field processingType can be parsed to an enum value
      if (jsonObj.get("processingType") != null) {
        if(!jsonObj.get("processingType").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `processingType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("processingType").toString()));
        }
        ProcessingTypeEnum.fromValue(jsonObj.get("processingType").getAsString());
      }
      // validate the optional field pspPaymentReference
      if (jsonObj.get("pspPaymentReference") != null && !jsonObj.get("pspPaymentReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `pspPaymentReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pspPaymentReference").toString()));
      }
      // ensure the field reason can be parsed to an enum value
      if (jsonObj.get("reason") != null) {
        if(!jsonObj.get("reason").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reason").toString()));
        }
        ReasonEnum.fromValue(jsonObj.get("reason").getAsString());
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // validate the optional field referenceForBeneficiary
      if (jsonObj.get("referenceForBeneficiary") != null && !jsonObj.get("referenceForBeneficiary").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `referenceForBeneficiary` to be a primitive type in the JSON string but got `%s`", jsonObj.get("referenceForBeneficiary").toString()));
      }
      // validate the optional field `relayedAuthorisationData`
      if (jsonObj.getAsJsonObject("relayedAuthorisationData") != null) {
        RelayedAuthorisationData.validateJsonObject(jsonObj.getAsJsonObject("relayedAuthorisationData"));
      }
      // ensure the field status can be parsed to an enum value
      if (jsonObj.get("status") != null) {
        if(!jsonObj.get("status").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
        }
        StatusEnum.fromValue(jsonObj.get("status").getAsString());
      }
      // validate the optional field `tracking`
      if (jsonObj.getAsJsonObject("tracking") != null) {
        TransferNotificationTransferTracking.validateJsonObject(jsonObj.getAsJsonObject("tracking"));
      }
      // validate the optional field transactionId
      if (jsonObj.get("transactionId") != null && !jsonObj.get("transactionId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transactionId").toString()));
      }
      // validate the optional field `transactionRulesResult`
      if (jsonObj.getAsJsonObject("transactionRulesResult") != null) {
        TransactionRulesResult.validateJsonObject(jsonObj.getAsJsonObject("transactionRulesResult"));
      }
      // ensure the field type can be parsed to an enum value
      if (jsonObj.get("type") != null) {
        if(!jsonObj.get("type").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
        }
        TypeEnum.fromValue(jsonObj.get("type").getAsString());
      }
      JsonArray jsonArrayvalidationFacts = jsonObj.getAsJsonArray("validationFacts");
      if (jsonArrayvalidationFacts != null) {
        // ensure the json data is an array
        if (!jsonObj.get("validationFacts").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `validationFacts` to be an array in the JSON string but got `%s`", jsonObj.get("validationFacts").toString()));
        }

        // validate the optional field `validationFacts` (array)
        for (int i = 0; i < jsonArrayvalidationFacts.size(); i++) {
          TransferNotificationValidationFact.validateJsonObject(jsonArrayvalidationFacts.get(i).getAsJsonObject());
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TransferNotificationData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TransferNotificationData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TransferNotificationData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TransferNotificationData.class));

       return (TypeAdapter<T>) new TypeAdapter<TransferNotificationData>() {
           @Override
           public void write(JsonWriter out, TransferNotificationData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TransferNotificationData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TransferNotificationData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TransferNotificationData
  * @throws IOException if the JSON string is invalid with respect to TransferNotificationData
  */
  public static TransferNotificationData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TransferNotificationData.class);
  }

 /**
  * Convert an instance of TransferNotificationData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

