/*
 * Capital API
 * Adyen Capital allows you to build an embedded financing offering for your users to serve their operational needs. Learn more about [Adyen Capital](https://docs.adyen.com/marketplaces-and-platforms/capital).  ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -H \"Content-Type: application/json\" \\ -U \"ws@BalancePlatform.YOUR_BALANCE_PLATFORM\":\"YOUR_WS_PASSWORD\" \\ ... ``` ## Roles and permissions To use the Capital API, you need an additional role for your API credential. Your Adyen contact will set up the roles and permissions for you. ## Versioning The Capital API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://balanceplatform-api-test.adyen.com/btl/v3/grants ``` ## Going live When going live, your Adyen contact will provide your API credential for the live environment. You can then use the username and password to send requests to `https://balanceplatform-api-live.adyen.com/btl/v3`.  
 *
 * The version of the OpenAPI document: 3
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.capital.CapitalGrant;
import com.adyen.model.capital.CapitalGrantInfo;
import com.adyen.model.capital.CapitalGrants;
import com.adyen.model.capital.RestServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CapitalApi extends Service {
    private final String baseURL;

    public CapitalApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/btl/v3");
    }

    /**
    * Get a capital account
    *
    * @return {@link CapitalGrants }
    * @throws ApiException if fails to make API call
    */
    public CapitalGrants getCapitalAccount() throws ApiException, IOException {
        return getCapitalAccount(null,  null);
    }

    /**
    * Get a capital account
    *
    * @param counterpartyAccountHolderId {@link String } Query: The counterparty account holder id. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CapitalGrants }
    * @throws ApiException if fails to make API call
    */
    public CapitalGrants getCapitalAccount(String counterpartyAccountHolderId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (counterpartyAccountHolderId != null) {
        queryParams.put("counterpartyAccountHolderId", counterpartyAccountHolderId);
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return CapitalGrants.fromJson(jsonResult);
    }

    /**
    * Get grant reference details
    *
    * @param id {@link String } The unique identifier of the grant. (required)
    * @return {@link CapitalGrant }
    * @throws ApiException if fails to make API call
    */
    public CapitalGrant getGrantReferenceDetails(String id) throws ApiException, IOException {
        return getGrantReferenceDetails(id, null);
    }

    /**
    * Get grant reference details
    *
    * @param id {@link String } The unique identifier of the grant. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CapitalGrant }
    * @throws ApiException if fails to make API call
    */
    public CapitalGrant getGrantReferenceDetails(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grants/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return CapitalGrant.fromJson(jsonResult);
    }

    /**
    * Request a grant payout
    *
    * @param capitalGrantInfo {@link CapitalGrantInfo }  (required)
    * @return {@link CapitalGrant }
    * @throws ApiException if fails to make API call
    */
    public CapitalGrant requestGrantPayout(CapitalGrantInfo capitalGrantInfo) throws ApiException, IOException {
        return requestGrantPayout(capitalGrantInfo, null);
    }

    /**
    * Request a grant payout
    *
    * @param capitalGrantInfo {@link CapitalGrantInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CapitalGrant }
    * @throws ApiException if fails to make API call
    */
    public CapitalGrant requestGrantPayout(CapitalGrantInfo capitalGrantInfo, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = capitalGrantInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/grants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CapitalGrant.fromJson(jsonResult);
    }
}
