/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.balanceplatform.PaymentInstrument;
import com.adyen.model.balanceplatform.PaymentInstrumentInfo;
import com.adyen.model.balanceplatform.PaymentInstrumentRevealInfo;
import com.adyen.model.balanceplatform.PaymentInstrumentUpdateRequest;
import com.adyen.model.balanceplatform.RestServiceError;
import com.adyen.model.balanceplatform.TransactionRulesResponse;
import com.adyen.model.balanceplatform.UpdatePaymentInstrument;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PaymentInstrumentsApi extends Service {
    private final String baseURL;

    public PaymentInstrumentsApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Get a payment instrument
    *
    * @param id {@link String } The unique identifier of the payment instrument. (required)
    * @return {@link PaymentInstrument }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrument getPaymentInstrument(String id) throws ApiException, IOException {
        return getPaymentInstrument(id, null);
    }

    /**
    * Get a payment instrument
    *
    * @param id {@link String } The unique identifier of the payment instrument. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentInstrument }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrument getPaymentInstrument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentInstrument.fromJson(jsonResult);
    }

    /**
    * Get the PAN of a payment instrument
    *
    * @param id {@link String } The unique identifier of the payment instrument. (required)
    * @return {@link PaymentInstrumentRevealInfo }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrumentRevealInfo getPanOfPaymentInstrument(String id) throws ApiException, IOException {
        return getPanOfPaymentInstrument(id, null);
    }

    /**
    * Get the PAN of a payment instrument
    *
    * @param id {@link String } The unique identifier of the payment instrument. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentInstrumentRevealInfo }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrumentRevealInfo getPanOfPaymentInstrument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}/reveal", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentInstrumentRevealInfo.fromJson(jsonResult);
    }

    /**
    * Get all transaction rules for a payment instrument
    *
    * @param id {@link String } The unique identifier of the payment instrument. (required)
    * @return {@link TransactionRulesResponse }
    * @throws ApiException if fails to make API call
    */
    public TransactionRulesResponse getAllTransactionRulesForPaymentInstrument(String id) throws ApiException, IOException {
        return getAllTransactionRulesForPaymentInstrument(id, null);
    }

    /**
    * Get all transaction rules for a payment instrument
    *
    * @param id {@link String } The unique identifier of the payment instrument. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TransactionRulesResponse }
    * @throws ApiException if fails to make API call
    */
    public TransactionRulesResponse getAllTransactionRulesForPaymentInstrument(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}/transactionRules", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransactionRulesResponse.fromJson(jsonResult);
    }

    /**
    * Update a payment instrument
    *
    * @param id {@link String } The unique identifier of the payment instrument. (required)
    * @param paymentInstrumentUpdateRequest {@link PaymentInstrumentUpdateRequest }  (required)
    * @return {@link UpdatePaymentInstrument }
    * @throws ApiException if fails to make API call
    */
    public UpdatePaymentInstrument updatePaymentInstrument(String id, PaymentInstrumentUpdateRequest paymentInstrumentUpdateRequest) throws ApiException, IOException {
        return updatePaymentInstrument(id, paymentInstrumentUpdateRequest, null);
    }

    /**
    * Update a payment instrument
    *
    * @param id {@link String } The unique identifier of the payment instrument. (required)
    * @param paymentInstrumentUpdateRequest {@link PaymentInstrumentUpdateRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link UpdatePaymentInstrument }
    * @throws ApiException if fails to make API call
    */
    public UpdatePaymentInstrument updatePaymentInstrument(String id, PaymentInstrumentUpdateRequest paymentInstrumentUpdateRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = paymentInstrumentUpdateRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return UpdatePaymentInstrument.fromJson(jsonResult);
    }

    /**
    * Create a payment instrument
    *
    * @param paymentInstrumentInfo {@link PaymentInstrumentInfo }  (required)
    * @return {@link PaymentInstrument }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrument createPaymentInstrument(PaymentInstrumentInfo paymentInstrumentInfo) throws ApiException, IOException {
        return createPaymentInstrument(paymentInstrumentInfo, null);
    }

    /**
    * Create a payment instrument
    *
    * @param paymentInstrumentInfo {@link PaymentInstrumentInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentInstrument }
    * @throws ApiException if fails to make API call
    */
    public PaymentInstrument createPaymentInstrument(PaymentInstrumentInfo paymentInstrumentInfo, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentInstrumentInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentInstrument.fromJson(jsonResult);
    }
}
