/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.checkout;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.checkout.CheckoutBalanceCheckRequest;
import com.adyen.model.checkout.CheckoutBalanceCheckResponse;
import com.adyen.model.checkout.CheckoutCancelOrderRequest;
import com.adyen.model.checkout.CheckoutCancelOrderResponse;
import com.adyen.model.checkout.CheckoutCreateOrderRequest;
import com.adyen.model.checkout.CheckoutCreateOrderResponse;
import com.adyen.model.checkout.ServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OrdersApi extends Service {
    private final String baseURL;

    public OrdersApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://checkout-test.adyen.com/v70");
    }

    /**
    * Create an order
    *
    * @param checkoutCreateOrderRequest {@link CheckoutCreateOrderRequest }  (required)
    * @return {@link CheckoutCreateOrderResponse }
    * @throws ApiException if fails to make API call
    */
    public CheckoutCreateOrderResponse orders(CheckoutCreateOrderRequest checkoutCreateOrderRequest) throws ApiException, IOException {
        return orders(checkoutCreateOrderRequest, null);
    }

    /**
    * Create an order
    *
    * @param checkoutCreateOrderRequest {@link CheckoutCreateOrderRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CheckoutCreateOrderResponse }
    * @throws ApiException if fails to make API call
    */
    public CheckoutCreateOrderResponse orders(CheckoutCreateOrderRequest checkoutCreateOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = checkoutCreateOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/orders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CheckoutCreateOrderResponse.fromJson(jsonResult);
    }

    /**
    * Cancel an order
    *
    * @param checkoutCancelOrderRequest {@link CheckoutCancelOrderRequest }  (required)
    * @return {@link CheckoutCancelOrderResponse }
    * @throws ApiException if fails to make API call
    */
    public CheckoutCancelOrderResponse cancelOrder(CheckoutCancelOrderRequest checkoutCancelOrderRequest) throws ApiException, IOException {
        return cancelOrder(checkoutCancelOrderRequest, null);
    }

    /**
    * Cancel an order
    *
    * @param checkoutCancelOrderRequest {@link CheckoutCancelOrderRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CheckoutCancelOrderResponse }
    * @throws ApiException if fails to make API call
    */
    public CheckoutCancelOrderResponse cancelOrder(CheckoutCancelOrderRequest checkoutCancelOrderRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = checkoutCancelOrderRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/orders/cancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CheckoutCancelOrderResponse.fromJson(jsonResult);
    }

    /**
    * Get the balance of a gift card
    *
    * @param checkoutBalanceCheckRequest {@link CheckoutBalanceCheckRequest }  (required)
    * @return {@link CheckoutBalanceCheckResponse }
    * @throws ApiException if fails to make API call
    */
    public CheckoutBalanceCheckResponse getBalanceOfGiftCard(CheckoutBalanceCheckRequest checkoutBalanceCheckRequest) throws ApiException, IOException {
        return getBalanceOfGiftCard(checkoutBalanceCheckRequest, null);
    }

    /**
    * Get the balance of a gift card
    *
    * @param checkoutBalanceCheckRequest {@link CheckoutBalanceCheckRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CheckoutBalanceCheckResponse }
    * @throws ApiException if fails to make API call
    */
    public CheckoutBalanceCheckResponse getBalanceOfGiftCard(CheckoutBalanceCheckRequest checkoutBalanceCheckRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = checkoutBalanceCheckRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentMethods/balance", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CheckoutBalanceCheckResponse.fromJson(jsonResult);
    }
}
