/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CardOrderItemDeliveryStatus {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_STATUS_ERROR = "statusError";
    @SerializedName(value="statusError")
    private String statusError;
    public static final String SERIALIZED_NAME_STATUS_ERROR_MESSAGE = "statusErrorMessage";
    @SerializedName(value="statusErrorMessage")
    private String statusErrorMessage;
    public static final String SERIALIZED_NAME_TRACKING_NUMBER = "trackingNumber";
    @SerializedName(value="trackingNumber")
    private String trackingNumber;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CardOrderItemDeliveryStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the delivery.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CardOrderItemDeliveryStatus statusError(String statusError) {
        this.statusError = statusError;
        return this;
    }

    @ApiModelProperty(value="Error status, if any.")
    public String getStatusError() {
        return this.statusError;
    }

    public void setStatusError(String statusError) {
        this.statusError = statusError;
    }

    public CardOrderItemDeliveryStatus statusErrorMessage(String statusErrorMessage) {
        this.statusErrorMessage = statusErrorMessage;
        return this;
    }

    @ApiModelProperty(value="Error message, if any.")
    public String getStatusErrorMessage() {
        return this.statusErrorMessage;
    }

    public void setStatusErrorMessage(String statusErrorMessage) {
        this.statusErrorMessage = statusErrorMessage;
    }

    public CardOrderItemDeliveryStatus trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @ApiModelProperty(value="Tracking number of the delivery.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardOrderItemDeliveryStatus cardOrderItemDeliveryStatus = (CardOrderItemDeliveryStatus)o;
        return Objects.equals((Object)this.status, (Object)cardOrderItemDeliveryStatus.status) && Objects.equals(this.statusError, cardOrderItemDeliveryStatus.statusError) && Objects.equals(this.statusErrorMessage, cardOrderItemDeliveryStatus.statusErrorMessage) && Objects.equals(this.trackingNumber, cardOrderItemDeliveryStatus.trackingNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.statusError, this.statusErrorMessage, this.trackingNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardOrderItemDeliveryStatus {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusError: ").append(this.toIndentedString(this.statusError)).append("\n");
        sb.append("    statusErrorMessage: ").append(this.toIndentedString(this.statusErrorMessage)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CardOrderItemDeliveryStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CardOrderItemDeliveryStatus` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS_ERROR) != null && !jsonObj.get(SERIALIZED_NAME_STATUS_ERROR).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `statusError` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS_ERROR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS_ERROR_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_STATUS_ERROR_MESSAGE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `statusErrorMessage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS_ERROR_MESSAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRACKING_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TRACKING_NUMBER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `trackingNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRACKING_NUMBER).toString()));
        }
    }

    public static CardOrderItemDeliveryStatus fromJson(String jsonString) throws IOException {
        return (CardOrderItemDeliveryStatus)JSON.getGson().fromJson(jsonString, CardOrderItemDeliveryStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_STATUS_ERROR);
        openapiFields.add(SERIALIZED_NAME_STATUS_ERROR_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_TRACKING_NUMBER);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(CardOrderItemDeliveryStatus.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CardOrderItemDeliveryStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CardOrderItemDeliveryStatus.class));
            return new TypeAdapter<CardOrderItemDeliveryStatus>(){

                public void write(JsonWriter out, CardOrderItemDeliveryStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CardOrderItemDeliveryStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CardOrderItemDeliveryStatus.validateJsonObject(jsonObj);
                    return (CardOrderItemDeliveryStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        CREATED("created"),
        DELIVERED("delivered"),
        PROCESSING("processing"),
        PRODUCED("produced"),
        REJECTED("rejected"),
        SHIPPED("shipped"),
        UNKNOWN("unknown");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

