/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Standalone {
    public static final String SERIALIZED_NAME_CURRENCY_CODE = "currencyCode";
    @SerializedName(value="currencyCode")
    private String currencyCode;
    public static final String SERIALIZED_NAME_ENABLE_STANDALONE = "enableStandalone";
    @SerializedName(value="enableStandalone")
    private Boolean enableStandalone;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Standalone currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The default currency of the standalone payment terminal as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Standalone enableStandalone(Boolean enableStandalone) {
        this.enableStandalone = enableStandalone;
        return this;
    }

    @ApiModelProperty(value="Enable standalone mode.")
    public Boolean getEnableStandalone() {
        return this.enableStandalone;
    }

    public void setEnableStandalone(Boolean enableStandalone) {
        this.enableStandalone = enableStandalone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Standalone standalone = (Standalone)o;
        return Objects.equals(this.currencyCode, standalone.currencyCode) && Objects.equals(this.enableStandalone, standalone.enableStandalone);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.enableStandalone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Standalone {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    enableStandalone: ").append(this.toIndentedString(this.enableStandalone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Standalone is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Standalone` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `currencyCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY_CODE).toString()));
        }
    }

    public static Standalone fromJson(String jsonString) throws IOException {
        return (Standalone)JSON.getGson().fromJson(jsonString, Standalone.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CURRENCY_CODE);
        openapiFields.add(SERIALIZED_NAME_ENABLE_STANDALONE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(Standalone.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Standalone.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Standalone.class));
            return new TypeAdapter<Standalone>(){

                public void write(JsonWriter out, Standalone value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Standalone read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Standalone.validateJsonObject(jsonObj);
                    return (Standalone)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

