/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.balanceplatform.DeliveryAddress;
import com.adyen.model.balanceplatform.Name;
import com.adyen.model.balanceplatform.PhoneNumber;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.balanceplatform.JSON;

/**
 * DeliveryContact
 */

public class DeliveryContact {
  public static final String SERIALIZED_NAME_ADDRESS = "address";
  @SerializedName(SERIALIZED_NAME_ADDRESS)
  private DeliveryAddress address;

  public static final String SERIALIZED_NAME_EMAIL = "email";
  @SerializedName(SERIALIZED_NAME_EMAIL)
  private String email;

  public static final String SERIALIZED_NAME_FULL_PHONE_NUMBER = "fullPhoneNumber";
  @SerializedName(SERIALIZED_NAME_FULL_PHONE_NUMBER)
  private String fullPhoneNumber;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private Name name;

  public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
  @SerializedName(SERIALIZED_NAME_PHONE_NUMBER)
  private PhoneNumber phoneNumber;

  public static final String SERIALIZED_NAME_WEB_ADDRESS = "webAddress";
  @SerializedName(SERIALIZED_NAME_WEB_ADDRESS)
  private String webAddress;

  public DeliveryContact() { 
  }

  public DeliveryContact address(DeliveryAddress address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @ApiModelProperty(required = true, value = "")

  public DeliveryAddress getAddress() {
    return address;
  }


  public void setAddress(DeliveryAddress address) {
    this.address = address;
  }


  public DeliveryContact email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * The email address of the contact.
   * @return email
  **/
  @ApiModelProperty(value = "The email address of the contact.")

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


  public DeliveryContact fullPhoneNumber(String fullPhoneNumber) {
    
    this.fullPhoneNumber = fullPhoneNumber;
    return this;
  }

   /**
   * The full phone number of the contact provided as a single string. It will be handled as a landline phone. **Examples:** \&quot;0031 6 11 22 33 44\&quot;, \&quot;+316/1122-3344\&quot;, \&quot;(0031) 611223344\&quot;
   * @return fullPhoneNumber
  **/
  @ApiModelProperty(value = "The full phone number of the contact provided as a single string. It will be handled as a landline phone. **Examples:** \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")

  public String getFullPhoneNumber() {
    return fullPhoneNumber;
  }


  public void setFullPhoneNumber(String fullPhoneNumber) {
    this.fullPhoneNumber = fullPhoneNumber;
  }


  public DeliveryContact name(Name name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(required = true, value = "")

  public Name getName() {
    return name;
  }


  public void setName(Name name) {
    this.name = name;
  }


  public DeliveryContact phoneNumber(PhoneNumber phoneNumber) {
    
    this.phoneNumber = phoneNumber;
    return this;
  }

   /**
   * Get phoneNumber
   * @return phoneNumber
  **/
  @ApiModelProperty(value = "")

  public PhoneNumber getPhoneNumber() {
    return phoneNumber;
  }


  public void setPhoneNumber(PhoneNumber phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  public DeliveryContact webAddress(String webAddress) {
    
    this.webAddress = webAddress;
    return this;
  }

   /**
   * The URL of the contact&#39;s website.
   * @return webAddress
  **/
  @ApiModelProperty(value = "The URL of the contact's website.")

  public String getWebAddress() {
    return webAddress;
  }


  public void setWebAddress(String webAddress) {
    this.webAddress = webAddress;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeliveryContact deliveryContact = (DeliveryContact) o;
    return Objects.equals(this.address, deliveryContact.address) &&
        Objects.equals(this.email, deliveryContact.email) &&
        Objects.equals(this.fullPhoneNumber, deliveryContact.fullPhoneNumber) &&
        Objects.equals(this.name, deliveryContact.name) &&
        Objects.equals(this.phoneNumber, deliveryContact.phoneNumber) &&
        Objects.equals(this.webAddress, deliveryContact.webAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, email, fullPhoneNumber, name, phoneNumber, webAddress);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeliveryContact {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    fullPhoneNumber: ").append(toIndentedString(fullPhoneNumber)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    webAddress: ").append(toIndentedString(webAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("address");
    openapiFields.add("email");
    openapiFields.add("fullPhoneNumber");
    openapiFields.add("name");
    openapiFields.add("phoneNumber");
    openapiFields.add("webAddress");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("address");
    openapiRequiredFields.add("name");
  }

  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
    validateJsonObject(jsonObj, false);
  }
 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @param strictValidation reject (new) fields missing from the specifications
  * @throws IOException if the JSON Object is invalid with respect to DeliveryContact
  */
  public static void validateJsonObject(JsonObject jsonObj, boolean strictValidation) throws IOException {
      if (jsonObj == null) {
        if (DeliveryContact.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in DeliveryContact is not found in the empty JSON string", DeliveryContact.openapiRequiredFields.toString()));
        }
      }
      if (strictValidation) {
          Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
          // check to see if the JSON string contains additional fields
          for (Entry<String, JsonElement> entry : entries) {
            if (!DeliveryContact.openapiFields.contains(entry.getKey())) {
              throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DeliveryContact` properties.", entry.getKey()));
            }
          }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : DeliveryContact.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `address`
      if (jsonObj.getAsJsonObject("address") != null) {
        DeliveryAddress.validateJsonObject(jsonObj.getAsJsonObject("address"));
      }
      // validate the optional field email
      if (jsonObj.get("email") != null && !jsonObj.get("email").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get("email").toString()));
      }
      // validate the optional field fullPhoneNumber
      if (jsonObj.get("fullPhoneNumber") != null && !jsonObj.get("fullPhoneNumber").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `fullPhoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fullPhoneNumber").toString()));
      }
      // validate the optional field `name`
      if (jsonObj.getAsJsonObject("name") != null) {
        Name.validateJsonObject(jsonObj.getAsJsonObject("name"));
      }
      // validate the optional field `phoneNumber`
      if (jsonObj.getAsJsonObject("phoneNumber") != null) {
        PhoneNumber.validateJsonObject(jsonObj.getAsJsonObject("phoneNumber"));
      }
      // validate the optional field webAddress
      if (jsonObj.get("webAddress") != null && !jsonObj.get("webAddress").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `webAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get("webAddress").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!DeliveryContact.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'DeliveryContact' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<DeliveryContact> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(DeliveryContact.class));

       return (TypeAdapter<T>) new TypeAdapter<DeliveryContact>() {
           @Override
           public void write(JsonWriter out, DeliveryContact value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public DeliveryContact read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of DeliveryContact given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of DeliveryContact
  * @throws IOException if the JSON string is invalid with respect to DeliveryContact
  */
  public static DeliveryContact fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, DeliveryContact.class);
  }

 /**
  * Convert an instance of DeliveryContact to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

