/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.balanceplatform.JSON;

/**
 * PhoneNumber
 */

public class PhoneNumber {
  public static final String SERIALIZED_NAME_PHONE_COUNTRY_CODE = "phoneCountryCode";
  @SerializedName(SERIALIZED_NAME_PHONE_COUNTRY_CODE)
  private String phoneCountryCode;

  public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
  @SerializedName(SERIALIZED_NAME_PHONE_NUMBER)
  private String phoneNumber;

  /**
   * The type of the phone number. Possible values: **Landline**, **Mobile**, **SIP**, **Fax**.
   */
  @JsonAdapter(PhoneTypeEnum.Adapter.class)
  public enum PhoneTypeEnum {
    FAX("Fax"),
    
    LANDLINE("Landline"),
    
    MOBILE("Mobile"),
    
    SIP("SIP");

    private String value;

    PhoneTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static PhoneTypeEnum fromValue(String value) {
      for (PhoneTypeEnum b : PhoneTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<PhoneTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PhoneTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public PhoneTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return PhoneTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PHONE_TYPE = "phoneType";
  @SerializedName(SERIALIZED_NAME_PHONE_TYPE)
  private PhoneTypeEnum phoneType;

  public PhoneNumber() { 
  }

  public PhoneNumber phoneCountryCode(String phoneCountryCode) {
    
    this.phoneCountryCode = phoneCountryCode;
    return this;
  }

   /**
   * The two-character ISO-3166-1 alpha-2 country code of the phone number. For example, **US** or **NL**.
   * @return phoneCountryCode
  **/
  @ApiModelProperty(value = "The two-character ISO-3166-1 alpha-2 country code of the phone number. For example, **US** or **NL**.")

  public String getPhoneCountryCode() {
    return phoneCountryCode;
  }


  public void setPhoneCountryCode(String phoneCountryCode) {
    this.phoneCountryCode = phoneCountryCode;
  }


  public PhoneNumber phoneNumber(String phoneNumber) {
    
    this.phoneNumber = phoneNumber;
    return this;
  }

   /**
   * The phone number. The inclusion of the phone number country code is not necessary.
   * @return phoneNumber
  **/
  @ApiModelProperty(value = "The phone number. The inclusion of the phone number country code is not necessary.")

  public String getPhoneNumber() {
    return phoneNumber;
  }


  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  public PhoneNumber phoneType(PhoneTypeEnum phoneType) {
    
    this.phoneType = phoneType;
    return this;
  }

   /**
   * The type of the phone number. Possible values: **Landline**, **Mobile**, **SIP**, **Fax**.
   * @return phoneType
  **/
  @ApiModelProperty(value = "The type of the phone number. Possible values: **Landline**, **Mobile**, **SIP**, **Fax**.")

  public PhoneTypeEnum getPhoneType() {
    return phoneType;
  }


  public void setPhoneType(PhoneTypeEnum phoneType) {
    this.phoneType = phoneType;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PhoneNumber phoneNumber = (PhoneNumber) o;
    return Objects.equals(this.phoneCountryCode, phoneNumber.phoneCountryCode) &&
        Objects.equals(this.phoneNumber, phoneNumber.phoneNumber) &&
        Objects.equals(this.phoneType, phoneNumber.phoneType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneCountryCode, phoneNumber, phoneType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PhoneNumber {\n");
    sb.append("    phoneCountryCode: ").append(toIndentedString(phoneCountryCode)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    phoneType: ").append(toIndentedString(phoneType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("phoneCountryCode");
    openapiFields.add("phoneNumber");
    openapiFields.add("phoneType");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
    validateJsonObject(jsonObj, false);
  }
 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @param strictValidation reject (new) fields missing from the specifications
  * @throws IOException if the JSON Object is invalid with respect to PhoneNumber
  */
  public static void validateJsonObject(JsonObject jsonObj, boolean strictValidation) throws IOException {
      if (jsonObj == null) {
        if (PhoneNumber.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PhoneNumber is not found in the empty JSON string", PhoneNumber.openapiRequiredFields.toString()));
        }
      }
      if (strictValidation) {
          Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
          // check to see if the JSON string contains additional fields
          for (Entry<String, JsonElement> entry : entries) {
            if (!PhoneNumber.openapiFields.contains(entry.getKey())) {
              throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PhoneNumber` properties.", entry.getKey()));
            }
          }
      }
      // validate the optional field phoneCountryCode
      if (jsonObj.get("phoneCountryCode") != null && !jsonObj.get("phoneCountryCode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `phoneCountryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("phoneCountryCode").toString()));
      }
      // validate the optional field phoneNumber
      if (jsonObj.get("phoneNumber") != null && !jsonObj.get("phoneNumber").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `phoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("phoneNumber").toString()));
      }
      // ensure the field phoneType can be parsed to an enum value
      if (jsonObj.get("phoneType") != null) {
        if(!jsonObj.get("phoneType").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `phoneType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("phoneType").toString()));
        }
        PhoneTypeEnum.fromValue(jsonObj.get("phoneType").getAsString());
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PhoneNumber.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PhoneNumber' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PhoneNumber> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PhoneNumber.class));

       return (TypeAdapter<T>) new TypeAdapter<PhoneNumber>() {
           @Override
           public void write(JsonWriter out, PhoneNumber value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PhoneNumber read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PhoneNumber given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PhoneNumber
  * @throws IOException if the JSON string is invalid with respect to PhoneNumber
  */
  public static PhoneNumber fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PhoneNumber.class);
  }

 /**
  * Convert an instance of PhoneNumber to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

