/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * AdditionalDataAirline
 */

public class AdditionalDataAirline {
  public static final String SERIALIZED_NAME_AIRLINE_AGENCY_INVOICE_NUMBER = "airline.agency_invoice_number";
  @SerializedName(SERIALIZED_NAME_AIRLINE_AGENCY_INVOICE_NUMBER)
  private String airlineAgencyInvoiceNumber;

  public static final String SERIALIZED_NAME_AIRLINE_AGENCY_PLAN_NAME = "airline.agency_plan_name";
  @SerializedName(SERIALIZED_NAME_AIRLINE_AGENCY_PLAN_NAME)
  private String airlineAgencyPlanName;

  public static final String SERIALIZED_NAME_AIRLINE_AIRLINE_CODE = "airline.airline_code";
  @SerializedName(SERIALIZED_NAME_AIRLINE_AIRLINE_CODE)
  private String airlineAirlineCode;

  public static final String SERIALIZED_NAME_AIRLINE_AIRLINE_DESIGNATOR_CODE = "airline.airline_designator_code";
  @SerializedName(SERIALIZED_NAME_AIRLINE_AIRLINE_DESIGNATOR_CODE)
  private String airlineAirlineDesignatorCode;

  public static final String SERIALIZED_NAME_AIRLINE_BOARDING_FEE = "airline.boarding_fee";
  @SerializedName(SERIALIZED_NAME_AIRLINE_BOARDING_FEE)
  private String airlineBoardingFee;

  public static final String SERIALIZED_NAME_AIRLINE_COMPUTERIZED_RESERVATION_SYSTEM = "airline.computerized_reservation_system";
  @SerializedName(SERIALIZED_NAME_AIRLINE_COMPUTERIZED_RESERVATION_SYSTEM)
  private String airlineComputerizedReservationSystem;

  public static final String SERIALIZED_NAME_AIRLINE_CUSTOMER_REFERENCE_NUMBER = "airline.customer_reference_number";
  @SerializedName(SERIALIZED_NAME_AIRLINE_CUSTOMER_REFERENCE_NUMBER)
  private String airlineCustomerReferenceNumber;

  public static final String SERIALIZED_NAME_AIRLINE_DOCUMENT_TYPE = "airline.document_type";
  @SerializedName(SERIALIZED_NAME_AIRLINE_DOCUMENT_TYPE)
  private String airlineDocumentType;

  public static final String SERIALIZED_NAME_AIRLINE_FLIGHT_DATE = "airline.flight_date";
  @SerializedName(SERIALIZED_NAME_AIRLINE_FLIGHT_DATE)
  private String airlineFlightDate;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_CARRIER_CODE = "airline.leg.carrier_code";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_CARRIER_CODE)
  private String airlineLegCarrierCode;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_CLASS_OF_TRAVEL = "airline.leg.class_of_travel";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_CLASS_OF_TRAVEL)
  private String airlineLegClassOfTravel;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_DATE_OF_TRAVEL = "airline.leg.date_of_travel";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_DATE_OF_TRAVEL)
  private String airlineLegDateOfTravel;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_DEPART_AIRPORT = "airline.leg.depart_airport";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_DEPART_AIRPORT)
  private String airlineLegDepartAirport;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_DEPART_TAX = "airline.leg.depart_tax";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_DEPART_TAX)
  private String airlineLegDepartTax;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_DESTINATION_CODE = "airline.leg.destination_code";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_DESTINATION_CODE)
  private String airlineLegDestinationCode;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_FARE_BASE_CODE = "airline.leg.fare_base_code";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_FARE_BASE_CODE)
  private String airlineLegFareBaseCode;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_FLIGHT_NUMBER = "airline.leg.flight_number";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_FLIGHT_NUMBER)
  private String airlineLegFlightNumber;

  public static final String SERIALIZED_NAME_AIRLINE_LEG_STOP_OVER_CODE = "airline.leg.stop_over_code";
  @SerializedName(SERIALIZED_NAME_AIRLINE_LEG_STOP_OVER_CODE)
  private String airlineLegStopOverCode;

  public static final String SERIALIZED_NAME_AIRLINE_PASSENGER_DATE_OF_BIRTH = "airline.passenger.date_of_birth";
  @SerializedName(SERIALIZED_NAME_AIRLINE_PASSENGER_DATE_OF_BIRTH)
  private String airlinePassengerDateOfBirth;

  public static final String SERIALIZED_NAME_AIRLINE_PASSENGER_FIRST_NAME = "airline.passenger.first_name";
  @SerializedName(SERIALIZED_NAME_AIRLINE_PASSENGER_FIRST_NAME)
  private String airlinePassengerFirstName;

  public static final String SERIALIZED_NAME_AIRLINE_PASSENGER_LAST_NAME = "airline.passenger.last_name";
  @SerializedName(SERIALIZED_NAME_AIRLINE_PASSENGER_LAST_NAME)
  private String airlinePassengerLastName;

  public static final String SERIALIZED_NAME_AIRLINE_PASSENGER_TELEPHONE_NUMBER = "airline.passenger.telephone_number";
  @SerializedName(SERIALIZED_NAME_AIRLINE_PASSENGER_TELEPHONE_NUMBER)
  private String airlinePassengerTelephoneNumber;

  public static final String SERIALIZED_NAME_AIRLINE_PASSENGER_TRAVELLER_TYPE = "airline.passenger.traveller_type";
  @SerializedName(SERIALIZED_NAME_AIRLINE_PASSENGER_TRAVELLER_TYPE)
  private String airlinePassengerTravellerType;

  public static final String SERIALIZED_NAME_AIRLINE_PASSENGER_NAME = "airline.passenger_name";
  @SerializedName(SERIALIZED_NAME_AIRLINE_PASSENGER_NAME)
  private String airlinePassengerName;

  public static final String SERIALIZED_NAME_AIRLINE_TICKET_ISSUE_ADDRESS = "airline.ticket_issue_address";
  @SerializedName(SERIALIZED_NAME_AIRLINE_TICKET_ISSUE_ADDRESS)
  private String airlineTicketIssueAddress;

  public static final String SERIALIZED_NAME_AIRLINE_TICKET_NUMBER = "airline.ticket_number";
  @SerializedName(SERIALIZED_NAME_AIRLINE_TICKET_NUMBER)
  private String airlineTicketNumber;

  public static final String SERIALIZED_NAME_AIRLINE_TRAVEL_AGENCY_CODE = "airline.travel_agency_code";
  @SerializedName(SERIALIZED_NAME_AIRLINE_TRAVEL_AGENCY_CODE)
  private String airlineTravelAgencyCode;

  public static final String SERIALIZED_NAME_AIRLINE_TRAVEL_AGENCY_NAME = "airline.travel_agency_name";
  @SerializedName(SERIALIZED_NAME_AIRLINE_TRAVEL_AGENCY_NAME)
  private String airlineTravelAgencyName;

  public AdditionalDataAirline() { 
  }

  public AdditionalDataAirline airlineAgencyInvoiceNumber(String airlineAgencyInvoiceNumber) {
    
    this.airlineAgencyInvoiceNumber = airlineAgencyInvoiceNumber;
    return this;
  }

   /**
   * The reference number for the invoice, issued by the agency. * Encoding: ASCII * minLength: 1 character * maxLength: 6 characters
   * @return airlineAgencyInvoiceNumber
  **/
  @ApiModelProperty(value = "The reference number for the invoice, issued by the agency. * Encoding: ASCII * minLength: 1 character * maxLength: 6 characters")

  public String getAirlineAgencyInvoiceNumber() {
    return airlineAgencyInvoiceNumber;
  }


  public void setAirlineAgencyInvoiceNumber(String airlineAgencyInvoiceNumber) {
    this.airlineAgencyInvoiceNumber = airlineAgencyInvoiceNumber;
  }


  public AdditionalDataAirline airlineAgencyPlanName(String airlineAgencyPlanName) {
    
    this.airlineAgencyPlanName = airlineAgencyPlanName;
    return this;
  }

   /**
   * The two-letter agency plan identifier. * Encoding: ASCII * minLength: 2 characters * maxLength: 2 characters
   * @return airlineAgencyPlanName
  **/
  @ApiModelProperty(value = "The two-letter agency plan identifier. * Encoding: ASCII * minLength: 2 characters * maxLength: 2 characters")

  public String getAirlineAgencyPlanName() {
    return airlineAgencyPlanName;
  }


  public void setAirlineAgencyPlanName(String airlineAgencyPlanName) {
    this.airlineAgencyPlanName = airlineAgencyPlanName;
  }


  public AdditionalDataAirline airlineAirlineCode(String airlineAirlineCode) {
    
    this.airlineAirlineCode = airlineAirlineCode;
    return this;
  }

   /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-digit accounting code (PAX) that identifies the carrier. * Format: IATA 3-digit accounting code (PAX) * Example: KLM &#x3D; 074 * minLength: 3 characters * maxLength: 3 characters * Must not be all spaces * Must not be all zeros
   * @return airlineAirlineCode
  **/
  @ApiModelProperty(value = "The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-digit accounting code (PAX) that identifies the carrier. * Format: IATA 3-digit accounting code (PAX) * Example: KLM = 074 * minLength: 3 characters * maxLength: 3 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineAirlineCode() {
    return airlineAirlineCode;
  }


  public void setAirlineAirlineCode(String airlineAirlineCode) {
    this.airlineAirlineCode = airlineAirlineCode;
  }


  public AdditionalDataAirline airlineAirlineDesignatorCode(String airlineAirlineDesignatorCode) {
    
    this.airlineAirlineDesignatorCode = airlineAirlineDesignatorCode;
    return this;
  }

   /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that identifies the carrier. * Encoding: ASCII * Example: KLM &#x3D; KL * minLength: 2 characters * maxLength: 2 characters * Must not be all spaces * Must not be all zeros
   * @return airlineAirlineDesignatorCode
  **/
  @ApiModelProperty(value = "The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that identifies the carrier. * Encoding: ASCII * Example: KLM = KL * minLength: 2 characters * maxLength: 2 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineAirlineDesignatorCode() {
    return airlineAirlineDesignatorCode;
  }


  public void setAirlineAirlineDesignatorCode(String airlineAirlineDesignatorCode) {
    this.airlineAirlineDesignatorCode = airlineAirlineDesignatorCode;
  }


  public AdditionalDataAirline airlineBoardingFee(String airlineBoardingFee) {
    
    this.airlineBoardingFee = airlineBoardingFee;
    return this;
  }

   /**
   * The amount charged for boarding the plane, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric * minLength: 1 character * maxLength: 18 characters
   * @return airlineBoardingFee
  **/
  @ApiModelProperty(value = "The amount charged for boarding the plane, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric * minLength: 1 character * maxLength: 18 characters")

  public String getAirlineBoardingFee() {
    return airlineBoardingFee;
  }


  public void setAirlineBoardingFee(String airlineBoardingFee) {
    this.airlineBoardingFee = airlineBoardingFee;
  }


  public AdditionalDataAirline airlineComputerizedReservationSystem(String airlineComputerizedReservationSystem) {
    
    this.airlineComputerizedReservationSystem = airlineComputerizedReservationSystem;
    return this;
  }

   /**
   * The [CRS](https://en.wikipedia.org/wiki/Computer_reservation_system) used to make the reservation and purchase the ticket. * Encoding: ASCII * minLength: 4 characters * maxLength: 4 characters
   * @return airlineComputerizedReservationSystem
  **/
  @ApiModelProperty(value = "The [CRS](https://en.wikipedia.org/wiki/Computer_reservation_system) used to make the reservation and purchase the ticket. * Encoding: ASCII * minLength: 4 characters * maxLength: 4 characters")

  public String getAirlineComputerizedReservationSystem() {
    return airlineComputerizedReservationSystem;
  }


  public void setAirlineComputerizedReservationSystem(String airlineComputerizedReservationSystem) {
    this.airlineComputerizedReservationSystem = airlineComputerizedReservationSystem;
  }


  public AdditionalDataAirline airlineCustomerReferenceNumber(String airlineCustomerReferenceNumber) {
    
    this.airlineCustomerReferenceNumber = airlineCustomerReferenceNumber;
    return this;
  }

   /**
   * The alphanumeric customer reference number. * Encoding: ASCII * maxLength: 20 characters * If you send more than 20 characters, the customer reference number is truncated * Must not be all spaces
   * @return airlineCustomerReferenceNumber
  **/
  @ApiModelProperty(value = "The alphanumeric customer reference number. * Encoding: ASCII * maxLength: 20 characters * If you send more than 20 characters, the customer reference number is truncated * Must not be all spaces")

  public String getAirlineCustomerReferenceNumber() {
    return airlineCustomerReferenceNumber;
  }


  public void setAirlineCustomerReferenceNumber(String airlineCustomerReferenceNumber) {
    this.airlineCustomerReferenceNumber = airlineCustomerReferenceNumber;
  }


  public AdditionalDataAirline airlineDocumentType(String airlineDocumentType) {
    
    this.airlineDocumentType = airlineDocumentType;
    return this;
  }

   /**
   * A code that identifies the type of item bought. The description of the code can appear on credit card statements. * Encoding: ASCII * Example: Passenger ticket &#x3D; 01 * minLength: 2 characters * maxLength: 2 characters
   * @return airlineDocumentType
  **/
  @ApiModelProperty(value = "A code that identifies the type of item bought. The description of the code can appear on credit card statements. * Encoding: ASCII * Example: Passenger ticket = 01 * minLength: 2 characters * maxLength: 2 characters")

  public String getAirlineDocumentType() {
    return airlineDocumentType;
  }


  public void setAirlineDocumentType(String airlineDocumentType) {
    this.airlineDocumentType = airlineDocumentType;
  }


  public AdditionalDataAirline airlineFlightDate(String airlineFlightDate) {
    
    this.airlineFlightDate = airlineFlightDate;
    return this;
  }

   /**
   * The flight departure date. Local time &#x60;(HH:mm)&#x60; is optional. * Date format: &#x60;yyyy-MM-dd&#x60; * Date and time format: &#x60;yyyy-MM-dd HH:mm&#x60; * minLength: 10 characters * maxLength: 16 characters
   * @return airlineFlightDate
  **/
  @ApiModelProperty(value = "The flight departure date. Local time `(HH:mm)` is optional. * Date format: `yyyy-MM-dd` * Date and time format: `yyyy-MM-dd HH:mm` * minLength: 10 characters * maxLength: 16 characters")

  public String getAirlineFlightDate() {
    return airlineFlightDate;
  }


  public void setAirlineFlightDate(String airlineFlightDate) {
    this.airlineFlightDate = airlineFlightDate;
  }


  public AdditionalDataAirline airlineLegCarrierCode(String airlineLegCarrierCode) {
    
    this.airlineLegCarrierCode = airlineLegCarrierCode;
    return this;
  }

   /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that identifies the carrier. This field is required if the airline data includes leg details. * Example: KLM &#x3D; KL * minLength: 2 characters * maxLength: 2 characters * Must not be all spaces * Must not be all zeros
   * @return airlineLegCarrierCode
  **/
  @ApiModelProperty(value = "The [IATA](https://www.iata.org/services/pages/codes.aspx) 2-letter accounting code (PAX) that identifies the carrier. This field is required if the airline data includes leg details. * Example: KLM = KL * minLength: 2 characters * maxLength: 2 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineLegCarrierCode() {
    return airlineLegCarrierCode;
  }


  public void setAirlineLegCarrierCode(String airlineLegCarrierCode) {
    this.airlineLegCarrierCode = airlineLegCarrierCode;
  }


  public AdditionalDataAirline airlineLegClassOfTravel(String airlineLegClassOfTravel) {
    
    this.airlineLegClassOfTravel = airlineLegClassOfTravel;
    return this;
  }

   /**
   * A one-letter travel class identifier.  The following are common:  * F: first class * J: business class * Y: economy class * W: premium economy  * Encoding: ASCII * minLength: 1 character * maxLength: 1 character * Must not be all spaces * Must not be all zeros
   * @return airlineLegClassOfTravel
  **/
  @ApiModelProperty(value = "A one-letter travel class identifier.  The following are common:  * F: first class * J: business class * Y: economy class * W: premium economy  * Encoding: ASCII * minLength: 1 character * maxLength: 1 character * Must not be all spaces * Must not be all zeros")

  public String getAirlineLegClassOfTravel() {
    return airlineLegClassOfTravel;
  }


  public void setAirlineLegClassOfTravel(String airlineLegClassOfTravel) {
    this.airlineLegClassOfTravel = airlineLegClassOfTravel;
  }


  public AdditionalDataAirline airlineLegDateOfTravel(String airlineLegDateOfTravel) {
    
    this.airlineLegDateOfTravel = airlineLegDateOfTravel;
    return this;
  }

   /**
   *   Date and time of travel in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format &#x60;yyyy-MM-dd HH:mm&#x60;. * Encoding: ASCII * minLength: 16 characters * maxLength: 16 characters
   * @return airlineLegDateOfTravel
  **/
  @ApiModelProperty(value = "  Date and time of travel in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format `yyyy-MM-dd HH:mm`. * Encoding: ASCII * minLength: 16 characters * maxLength: 16 characters")

  public String getAirlineLegDateOfTravel() {
    return airlineLegDateOfTravel;
  }


  public void setAirlineLegDateOfTravel(String airlineLegDateOfTravel) {
    this.airlineLegDateOfTravel = airlineLegDateOfTravel;
  }


  public AdditionalDataAirline airlineLegDepartAirport(String airlineLegDepartAirport) {
    
    this.airlineLegDepartAirport = airlineLegDepartAirport;
    return this;
  }

   /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) three-letter airport code of the departure airport. This field is required if the airline data includes leg details.  * Encoding: ASCII * Example: Amsterdam &#x3D; AMS * minLength: 3 characters * maxLength: 3 characters * Must not be all spaces * Must not be all zeros
   * @return airlineLegDepartAirport
  **/
  @ApiModelProperty(value = "The [IATA](https://www.iata.org/services/pages/codes.aspx) three-letter airport code of the departure airport. This field is required if the airline data includes leg details.  * Encoding: ASCII * Example: Amsterdam = AMS * minLength: 3 characters * maxLength: 3 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineLegDepartAirport() {
    return airlineLegDepartAirport;
  }


  public void setAirlineLegDepartAirport(String airlineLegDepartAirport) {
    this.airlineLegDepartAirport = airlineLegDepartAirport;
  }


  public AdditionalDataAirline airlineLegDepartTax(String airlineLegDepartTax) {
    
    this.airlineLegDepartTax = airlineLegDepartTax;
    return this;
  }

   /**
   * The amount of [departure tax](https://en.wikipedia.org/wiki/Departure_tax) charged, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric * minLength: 1 * maxLength: 12 * Must not be all zeros
   * @return airlineLegDepartTax
  **/
  @ApiModelProperty(value = "The amount of [departure tax](https://en.wikipedia.org/wiki/Departure_tax) charged, in [minor units](https://docs.adyen.com/development-resources/currency-codes). * Encoding: Numeric * minLength: 1 * maxLength: 12 * Must not be all zeros")

  public String getAirlineLegDepartTax() {
    return airlineLegDepartTax;
  }


  public void setAirlineLegDepartTax(String airlineLegDepartTax) {
    this.airlineLegDepartTax = airlineLegDepartTax;
  }


  public AdditionalDataAirline airlineLegDestinationCode(String airlineLegDestinationCode) {
    
    this.airlineLegDestinationCode = airlineLegDestinationCode;
    return this;
  }

   /**
   * The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-letter airport code of the destination airport. This field is required if the airline data includes leg details. * Example: Amsterdam &#x3D; AMS * Encoding: ASCII * minLength: 3 characters * maxLength: 3 characters * Must not be all spaces * Must not be all zeros
   * @return airlineLegDestinationCode
  **/
  @ApiModelProperty(value = "The [IATA](https://www.iata.org/services/pages/codes.aspx) 3-letter airport code of the destination airport. This field is required if the airline data includes leg details. * Example: Amsterdam = AMS * Encoding: ASCII * minLength: 3 characters * maxLength: 3 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineLegDestinationCode() {
    return airlineLegDestinationCode;
  }


  public void setAirlineLegDestinationCode(String airlineLegDestinationCode) {
    this.airlineLegDestinationCode = airlineLegDestinationCode;
  }


  public AdditionalDataAirline airlineLegFareBaseCode(String airlineLegFareBaseCode) {
    
    this.airlineLegFareBaseCode = airlineLegFareBaseCode;
    return this;
  }

   /**
   * The [fare basis code](https://en.wikipedia.org/wiki/Fare_basis_code), alphanumeric. * minLength: 1 character * maxLength: 6 characters * Must not be all spaces * Must not be all zeros
   * @return airlineLegFareBaseCode
  **/
  @ApiModelProperty(value = "The [fare basis code](https://en.wikipedia.org/wiki/Fare_basis_code), alphanumeric. * minLength: 1 character * maxLength: 6 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineLegFareBaseCode() {
    return airlineLegFareBaseCode;
  }


  public void setAirlineLegFareBaseCode(String airlineLegFareBaseCode) {
    this.airlineLegFareBaseCode = airlineLegFareBaseCode;
  }


  public AdditionalDataAirline airlineLegFlightNumber(String airlineLegFlightNumber) {
    
    this.airlineLegFlightNumber = airlineLegFlightNumber;
    return this;
  }

   /**
   * The flight identifier. * minLength: 1 character * maxLength: 5 characters * Must not be all spaces * Must not be all zeros
   * @return airlineLegFlightNumber
  **/
  @ApiModelProperty(value = "The flight identifier. * minLength: 1 character * maxLength: 5 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineLegFlightNumber() {
    return airlineLegFlightNumber;
  }


  public void setAirlineLegFlightNumber(String airlineLegFlightNumber) {
    this.airlineLegFlightNumber = airlineLegFlightNumber;
  }


  public AdditionalDataAirline airlineLegStopOverCode(String airlineLegStopOverCode) {
    
    this.airlineLegStopOverCode = airlineLegStopOverCode;
    return this;
  }

   /**
   * A one-letter code that indicates whether the passenger is entitled to make a stopover. Can be a space, O if the passenger is entitled to make a stopover, or X if they are not. * Encoding: ASCII * minLength: 1 character * maxLength: 1 character
   * @return airlineLegStopOverCode
  **/
  @ApiModelProperty(value = "A one-letter code that indicates whether the passenger is entitled to make a stopover. Can be a space, O if the passenger is entitled to make a stopover, or X if they are not. * Encoding: ASCII * minLength: 1 character * maxLength: 1 character")

  public String getAirlineLegStopOverCode() {
    return airlineLegStopOverCode;
  }


  public void setAirlineLegStopOverCode(String airlineLegStopOverCode) {
    this.airlineLegStopOverCode = airlineLegStopOverCode;
  }


  public AdditionalDataAirline airlinePassengerDateOfBirth(String airlinePassengerDateOfBirth) {
    
    this.airlinePassengerDateOfBirth = airlinePassengerDateOfBirth;
    return this;
  }

   /**
   * The passenger&#39;s date of birth.  Date format: &#x60;yyyy-MM-dd&#x60; * minLength: 10 * maxLength: 10
   * @return airlinePassengerDateOfBirth
  **/
  @ApiModelProperty(value = "The passenger's date of birth.  Date format: `yyyy-MM-dd` * minLength: 10 * maxLength: 10")

  public String getAirlinePassengerDateOfBirth() {
    return airlinePassengerDateOfBirth;
  }


  public void setAirlinePassengerDateOfBirth(String airlinePassengerDateOfBirth) {
    this.airlinePassengerDateOfBirth = airlinePassengerDateOfBirth;
  }


  public AdditionalDataAirline airlinePassengerFirstName(String airlinePassengerFirstName) {
    
    this.airlinePassengerFirstName = airlinePassengerFirstName;
    return this;
  }

   /**
   * The passenger&#39;s first name. &gt; This field is required if the airline data includes passenger details or leg details. * Encoding: ASCII
   * @return airlinePassengerFirstName
  **/
  @ApiModelProperty(value = "The passenger's first name. > This field is required if the airline data includes passenger details or leg details. * Encoding: ASCII")

  public String getAirlinePassengerFirstName() {
    return airlinePassengerFirstName;
  }


  public void setAirlinePassengerFirstName(String airlinePassengerFirstName) {
    this.airlinePassengerFirstName = airlinePassengerFirstName;
  }


  public AdditionalDataAirline airlinePassengerLastName(String airlinePassengerLastName) {
    
    this.airlinePassengerLastName = airlinePassengerLastName;
    return this;
  }

   /**
   * The passenger&#39;s last name. &gt; This field is required if the airline data includes passenger details or leg details. * Encoding: ASCII
   * @return airlinePassengerLastName
  **/
  @ApiModelProperty(value = "The passenger's last name. > This field is required if the airline data includes passenger details or leg details. * Encoding: ASCII")

  public String getAirlinePassengerLastName() {
    return airlinePassengerLastName;
  }


  public void setAirlinePassengerLastName(String airlinePassengerLastName) {
    this.airlinePassengerLastName = airlinePassengerLastName;
  }


  public AdditionalDataAirline airlinePassengerTelephoneNumber(String airlinePassengerTelephoneNumber) {
    
    this.airlinePassengerTelephoneNumber = airlinePassengerTelephoneNumber;
    return this;
  }

   /**
   * The passenger&#39;s telephone number, including country code. This is an alphanumeric field that can include the &#39;+&#39; and &#39;-&#39; signs. * Encoding: ASCII * minLength: 3 characters * maxLength: 30 characters
   * @return airlinePassengerTelephoneNumber
  **/
  @ApiModelProperty(value = "The passenger's telephone number, including country code. This is an alphanumeric field that can include the '+' and '-' signs. * Encoding: ASCII * minLength: 3 characters * maxLength: 30 characters")

  public String getAirlinePassengerTelephoneNumber() {
    return airlinePassengerTelephoneNumber;
  }


  public void setAirlinePassengerTelephoneNumber(String airlinePassengerTelephoneNumber) {
    this.airlinePassengerTelephoneNumber = airlinePassengerTelephoneNumber;
  }


  public AdditionalDataAirline airlinePassengerTravellerType(String airlinePassengerTravellerType) {
    
    this.airlinePassengerTravellerType = airlinePassengerTravellerType;
    return this;
  }

   /**
   * The IATA passenger type code (PTC). * Encoding: ASCII * minLength: 3 characters * maxLength: 6 characters
   * @return airlinePassengerTravellerType
  **/
  @ApiModelProperty(value = "The IATA passenger type code (PTC). * Encoding: ASCII * minLength: 3 characters * maxLength: 6 characters")

  public String getAirlinePassengerTravellerType() {
    return airlinePassengerTravellerType;
  }


  public void setAirlinePassengerTravellerType(String airlinePassengerTravellerType) {
    this.airlinePassengerTravellerType = airlinePassengerTravellerType;
  }


  public AdditionalDataAirline airlinePassengerName(String airlinePassengerName) {
    
    this.airlinePassengerName = airlinePassengerName;
    return this;
  }

   /**
   * The passenger&#39;s name, initials, and title. * Format: last name + first name or initials + title * Example: *FLYER / MARY MS* * minLength: 1 character * maxLength: 20 characters * If you send more than 20 characters, the name is truncated * Must not be all spaces * Must not be all zeros
   * @return airlinePassengerName
  **/
  @ApiModelProperty(required = true, value = "The passenger's name, initials, and title. * Format: last name + first name or initials + title * Example: *FLYER / MARY MS* * minLength: 1 character * maxLength: 20 characters * If you send more than 20 characters, the name is truncated * Must not be all spaces * Must not be all zeros")

  public String getAirlinePassengerName() {
    return airlinePassengerName;
  }


  public void setAirlinePassengerName(String airlinePassengerName) {
    this.airlinePassengerName = airlinePassengerName;
  }


  public AdditionalDataAirline airlineTicketIssueAddress(String airlineTicketIssueAddress) {
    
    this.airlineTicketIssueAddress = airlineTicketIssueAddress;
    return this;
  }

   /**
   * The address of the organization that issued the ticket. * minLength: 0 characters * maxLength: 16 characters
   * @return airlineTicketIssueAddress
  **/
  @ApiModelProperty(value = "The address of the organization that issued the ticket. * minLength: 0 characters * maxLength: 16 characters")

  public String getAirlineTicketIssueAddress() {
    return airlineTicketIssueAddress;
  }


  public void setAirlineTicketIssueAddress(String airlineTicketIssueAddress) {
    this.airlineTicketIssueAddress = airlineTicketIssueAddress;
  }


  public AdditionalDataAirline airlineTicketNumber(String airlineTicketNumber) {
    
    this.airlineTicketNumber = airlineTicketNumber;
    return this;
  }

   /**
   * The ticket&#39;s unique identifier. * minLength: 1 character * maxLength: 15 characters * Must not be all spaces * Must not be all zeros
   * @return airlineTicketNumber
  **/
  @ApiModelProperty(value = "The ticket's unique identifier. * minLength: 1 character * maxLength: 15 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineTicketNumber() {
    return airlineTicketNumber;
  }


  public void setAirlineTicketNumber(String airlineTicketNumber) {
    this.airlineTicketNumber = airlineTicketNumber;
  }


  public AdditionalDataAirline airlineTravelAgencyCode(String airlineTravelAgencyCode) {
    
    this.airlineTravelAgencyCode = airlineTravelAgencyCode;
    return this;
  }

   /**
   * The unique identifier from IATA or ARC for the travel agency that issues the ticket. * Encoding: ASCII * minLength: 1 character * maxLength: 8 characters * Must not be all spaces * Must not be all zeros
   * @return airlineTravelAgencyCode
  **/
  @ApiModelProperty(value = "The unique identifier from IATA or ARC for the travel agency that issues the ticket. * Encoding: ASCII * minLength: 1 character * maxLength: 8 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineTravelAgencyCode() {
    return airlineTravelAgencyCode;
  }


  public void setAirlineTravelAgencyCode(String airlineTravelAgencyCode) {
    this.airlineTravelAgencyCode = airlineTravelAgencyCode;
  }


  public AdditionalDataAirline airlineTravelAgencyName(String airlineTravelAgencyName) {
    
    this.airlineTravelAgencyName = airlineTravelAgencyName;
    return this;
  }

   /**
   * The name of the travel agency.  * Encoding: ASCII * minLength: 1 character * maxLength: 25 characters * Must not be all spaces * Must not be all zeros
   * @return airlineTravelAgencyName
  **/
  @ApiModelProperty(value = "The name of the travel agency.  * Encoding: ASCII * minLength: 1 character * maxLength: 25 characters * Must not be all spaces * Must not be all zeros")

  public String getAirlineTravelAgencyName() {
    return airlineTravelAgencyName;
  }


  public void setAirlineTravelAgencyName(String airlineTravelAgencyName) {
    this.airlineTravelAgencyName = airlineTravelAgencyName;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalDataAirline additionalDataAirline = (AdditionalDataAirline) o;
    return Objects.equals(this.airlineAgencyInvoiceNumber, additionalDataAirline.airlineAgencyInvoiceNumber) &&
        Objects.equals(this.airlineAgencyPlanName, additionalDataAirline.airlineAgencyPlanName) &&
        Objects.equals(this.airlineAirlineCode, additionalDataAirline.airlineAirlineCode) &&
        Objects.equals(this.airlineAirlineDesignatorCode, additionalDataAirline.airlineAirlineDesignatorCode) &&
        Objects.equals(this.airlineBoardingFee, additionalDataAirline.airlineBoardingFee) &&
        Objects.equals(this.airlineComputerizedReservationSystem, additionalDataAirline.airlineComputerizedReservationSystem) &&
        Objects.equals(this.airlineCustomerReferenceNumber, additionalDataAirline.airlineCustomerReferenceNumber) &&
        Objects.equals(this.airlineDocumentType, additionalDataAirline.airlineDocumentType) &&
        Objects.equals(this.airlineFlightDate, additionalDataAirline.airlineFlightDate) &&
        Objects.equals(this.airlineLegCarrierCode, additionalDataAirline.airlineLegCarrierCode) &&
        Objects.equals(this.airlineLegClassOfTravel, additionalDataAirline.airlineLegClassOfTravel) &&
        Objects.equals(this.airlineLegDateOfTravel, additionalDataAirline.airlineLegDateOfTravel) &&
        Objects.equals(this.airlineLegDepartAirport, additionalDataAirline.airlineLegDepartAirport) &&
        Objects.equals(this.airlineLegDepartTax, additionalDataAirline.airlineLegDepartTax) &&
        Objects.equals(this.airlineLegDestinationCode, additionalDataAirline.airlineLegDestinationCode) &&
        Objects.equals(this.airlineLegFareBaseCode, additionalDataAirline.airlineLegFareBaseCode) &&
        Objects.equals(this.airlineLegFlightNumber, additionalDataAirline.airlineLegFlightNumber) &&
        Objects.equals(this.airlineLegStopOverCode, additionalDataAirline.airlineLegStopOverCode) &&
        Objects.equals(this.airlinePassengerDateOfBirth, additionalDataAirline.airlinePassengerDateOfBirth) &&
        Objects.equals(this.airlinePassengerFirstName, additionalDataAirline.airlinePassengerFirstName) &&
        Objects.equals(this.airlinePassengerLastName, additionalDataAirline.airlinePassengerLastName) &&
        Objects.equals(this.airlinePassengerTelephoneNumber, additionalDataAirline.airlinePassengerTelephoneNumber) &&
        Objects.equals(this.airlinePassengerTravellerType, additionalDataAirline.airlinePassengerTravellerType) &&
        Objects.equals(this.airlinePassengerName, additionalDataAirline.airlinePassengerName) &&
        Objects.equals(this.airlineTicketIssueAddress, additionalDataAirline.airlineTicketIssueAddress) &&
        Objects.equals(this.airlineTicketNumber, additionalDataAirline.airlineTicketNumber) &&
        Objects.equals(this.airlineTravelAgencyCode, additionalDataAirline.airlineTravelAgencyCode) &&
        Objects.equals(this.airlineTravelAgencyName, additionalDataAirline.airlineTravelAgencyName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(airlineAgencyInvoiceNumber, airlineAgencyPlanName, airlineAirlineCode, airlineAirlineDesignatorCode, airlineBoardingFee, airlineComputerizedReservationSystem, airlineCustomerReferenceNumber, airlineDocumentType, airlineFlightDate, airlineLegCarrierCode, airlineLegClassOfTravel, airlineLegDateOfTravel, airlineLegDepartAirport, airlineLegDepartTax, airlineLegDestinationCode, airlineLegFareBaseCode, airlineLegFlightNumber, airlineLegStopOverCode, airlinePassengerDateOfBirth, airlinePassengerFirstName, airlinePassengerLastName, airlinePassengerTelephoneNumber, airlinePassengerTravellerType, airlinePassengerName, airlineTicketIssueAddress, airlineTicketNumber, airlineTravelAgencyCode, airlineTravelAgencyName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalDataAirline {\n");
    sb.append("    airlineAgencyInvoiceNumber: ").append(toIndentedString(airlineAgencyInvoiceNumber)).append("\n");
    sb.append("    airlineAgencyPlanName: ").append(toIndentedString(airlineAgencyPlanName)).append("\n");
    sb.append("    airlineAirlineCode: ").append(toIndentedString(airlineAirlineCode)).append("\n");
    sb.append("    airlineAirlineDesignatorCode: ").append(toIndentedString(airlineAirlineDesignatorCode)).append("\n");
    sb.append("    airlineBoardingFee: ").append(toIndentedString(airlineBoardingFee)).append("\n");
    sb.append("    airlineComputerizedReservationSystem: ").append(toIndentedString(airlineComputerizedReservationSystem)).append("\n");
    sb.append("    airlineCustomerReferenceNumber: ").append(toIndentedString(airlineCustomerReferenceNumber)).append("\n");
    sb.append("    airlineDocumentType: ").append(toIndentedString(airlineDocumentType)).append("\n");
    sb.append("    airlineFlightDate: ").append(toIndentedString(airlineFlightDate)).append("\n");
    sb.append("    airlineLegCarrierCode: ").append(toIndentedString(airlineLegCarrierCode)).append("\n");
    sb.append("    airlineLegClassOfTravel: ").append(toIndentedString(airlineLegClassOfTravel)).append("\n");
    sb.append("    airlineLegDateOfTravel: ").append(toIndentedString(airlineLegDateOfTravel)).append("\n");
    sb.append("    airlineLegDepartAirport: ").append(toIndentedString(airlineLegDepartAirport)).append("\n");
    sb.append("    airlineLegDepartTax: ").append(toIndentedString(airlineLegDepartTax)).append("\n");
    sb.append("    airlineLegDestinationCode: ").append(toIndentedString(airlineLegDestinationCode)).append("\n");
    sb.append("    airlineLegFareBaseCode: ").append(toIndentedString(airlineLegFareBaseCode)).append("\n");
    sb.append("    airlineLegFlightNumber: ").append(toIndentedString(airlineLegFlightNumber)).append("\n");
    sb.append("    airlineLegStopOverCode: ").append(toIndentedString(airlineLegStopOverCode)).append("\n");
    sb.append("    airlinePassengerDateOfBirth: ").append(toIndentedString(airlinePassengerDateOfBirth)).append("\n");
    sb.append("    airlinePassengerFirstName: ").append(toIndentedString(airlinePassengerFirstName)).append("\n");
    sb.append("    airlinePassengerLastName: ").append(toIndentedString(airlinePassengerLastName)).append("\n");
    sb.append("    airlinePassengerTelephoneNumber: ").append(toIndentedString(airlinePassengerTelephoneNumber)).append("\n");
    sb.append("    airlinePassengerTravellerType: ").append(toIndentedString(airlinePassengerTravellerType)).append("\n");
    sb.append("    airlinePassengerName: ").append(toIndentedString(airlinePassengerName)).append("\n");
    sb.append("    airlineTicketIssueAddress: ").append(toIndentedString(airlineTicketIssueAddress)).append("\n");
    sb.append("    airlineTicketNumber: ").append(toIndentedString(airlineTicketNumber)).append("\n");
    sb.append("    airlineTravelAgencyCode: ").append(toIndentedString(airlineTravelAgencyCode)).append("\n");
    sb.append("    airlineTravelAgencyName: ").append(toIndentedString(airlineTravelAgencyName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("airline.agency_invoice_number");
    openapiFields.add("airline.agency_plan_name");
    openapiFields.add("airline.airline_code");
    openapiFields.add("airline.airline_designator_code");
    openapiFields.add("airline.boarding_fee");
    openapiFields.add("airline.computerized_reservation_system");
    openapiFields.add("airline.customer_reference_number");
    openapiFields.add("airline.document_type");
    openapiFields.add("airline.flight_date");
    openapiFields.add("airline.leg.carrier_code");
    openapiFields.add("airline.leg.class_of_travel");
    openapiFields.add("airline.leg.date_of_travel");
    openapiFields.add("airline.leg.depart_airport");
    openapiFields.add("airline.leg.depart_tax");
    openapiFields.add("airline.leg.destination_code");
    openapiFields.add("airline.leg.fare_base_code");
    openapiFields.add("airline.leg.flight_number");
    openapiFields.add("airline.leg.stop_over_code");
    openapiFields.add("airline.passenger.date_of_birth");
    openapiFields.add("airline.passenger.first_name");
    openapiFields.add("airline.passenger.last_name");
    openapiFields.add("airline.passenger.telephone_number");
    openapiFields.add("airline.passenger.traveller_type");
    openapiFields.add("airline.passenger_name");
    openapiFields.add("airline.ticket_issue_address");
    openapiFields.add("airline.ticket_number");
    openapiFields.add("airline.travel_agency_code");
    openapiFields.add("airline.travel_agency_name");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("airline.passenger_name");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(AdditionalDataAirline.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to AdditionalDataAirline
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (AdditionalDataAirline.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in AdditionalDataAirline is not found in the empty JSON string", AdditionalDataAirline.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!AdditionalDataAirline.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AdditionalDataAirline` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : AdditionalDataAirline.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field airline.agency_invoice_number
      if (jsonObj.get("airline.agency_invoice_number") != null && !jsonObj.get("airline.agency_invoice_number").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.agency_invoice_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.agency_invoice_number").toString()));
      }
      // validate the optional field airline.agency_plan_name
      if (jsonObj.get("airline.agency_plan_name") != null && !jsonObj.get("airline.agency_plan_name").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.agency_plan_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.agency_plan_name").toString()));
      }
      // validate the optional field airline.airline_code
      if (jsonObj.get("airline.airline_code") != null && !jsonObj.get("airline.airline_code").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.airline_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.airline_code").toString()));
      }
      // validate the optional field airline.airline_designator_code
      if (jsonObj.get("airline.airline_designator_code") != null && !jsonObj.get("airline.airline_designator_code").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.airline_designator_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.airline_designator_code").toString()));
      }
      // validate the optional field airline.boarding_fee
      if (jsonObj.get("airline.boarding_fee") != null && !jsonObj.get("airline.boarding_fee").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.boarding_fee` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.boarding_fee").toString()));
      }
      // validate the optional field airline.computerized_reservation_system
      if (jsonObj.get("airline.computerized_reservation_system") != null && !jsonObj.get("airline.computerized_reservation_system").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.computerized_reservation_system` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.computerized_reservation_system").toString()));
      }
      // validate the optional field airline.customer_reference_number
      if (jsonObj.get("airline.customer_reference_number") != null && !jsonObj.get("airline.customer_reference_number").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.customer_reference_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.customer_reference_number").toString()));
      }
      // validate the optional field airline.document_type
      if (jsonObj.get("airline.document_type") != null && !jsonObj.get("airline.document_type").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.document_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.document_type").toString()));
      }
      // validate the optional field airline.flight_date
      if (jsonObj.get("airline.flight_date") != null && !jsonObj.get("airline.flight_date").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.flight_date` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.flight_date").toString()));
      }
      // validate the optional field airline.leg.carrier_code
      if (jsonObj.get("airline.leg.carrier_code") != null && !jsonObj.get("airline.leg.carrier_code").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.carrier_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.carrier_code").toString()));
      }
      // validate the optional field airline.leg.class_of_travel
      if (jsonObj.get("airline.leg.class_of_travel") != null && !jsonObj.get("airline.leg.class_of_travel").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.class_of_travel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.class_of_travel").toString()));
      }
      // validate the optional field airline.leg.date_of_travel
      if (jsonObj.get("airline.leg.date_of_travel") != null && !jsonObj.get("airline.leg.date_of_travel").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.date_of_travel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.date_of_travel").toString()));
      }
      // validate the optional field airline.leg.depart_airport
      if (jsonObj.get("airline.leg.depart_airport") != null && !jsonObj.get("airline.leg.depart_airport").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.depart_airport` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.depart_airport").toString()));
      }
      // validate the optional field airline.leg.depart_tax
      if (jsonObj.get("airline.leg.depart_tax") != null && !jsonObj.get("airline.leg.depart_tax").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.depart_tax` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.depart_tax").toString()));
      }
      // validate the optional field airline.leg.destination_code
      if (jsonObj.get("airline.leg.destination_code") != null && !jsonObj.get("airline.leg.destination_code").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.destination_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.destination_code").toString()));
      }
      // validate the optional field airline.leg.fare_base_code
      if (jsonObj.get("airline.leg.fare_base_code") != null && !jsonObj.get("airline.leg.fare_base_code").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.fare_base_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.fare_base_code").toString()));
      }
      // validate the optional field airline.leg.flight_number
      if (jsonObj.get("airline.leg.flight_number") != null && !jsonObj.get("airline.leg.flight_number").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.flight_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.flight_number").toString()));
      }
      // validate the optional field airline.leg.stop_over_code
      if (jsonObj.get("airline.leg.stop_over_code") != null && !jsonObj.get("airline.leg.stop_over_code").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.leg.stop_over_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.leg.stop_over_code").toString()));
      }
      // validate the optional field airline.passenger.date_of_birth
      if (jsonObj.get("airline.passenger.date_of_birth") != null && !jsonObj.get("airline.passenger.date_of_birth").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.passenger.date_of_birth` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.passenger.date_of_birth").toString()));
      }
      // validate the optional field airline.passenger.first_name
      if (jsonObj.get("airline.passenger.first_name") != null && !jsonObj.get("airline.passenger.first_name").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.passenger.first_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.passenger.first_name").toString()));
      }
      // validate the optional field airline.passenger.last_name
      if (jsonObj.get("airline.passenger.last_name") != null && !jsonObj.get("airline.passenger.last_name").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.passenger.last_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.passenger.last_name").toString()));
      }
      // validate the optional field airline.passenger.telephone_number
      if (jsonObj.get("airline.passenger.telephone_number") != null && !jsonObj.get("airline.passenger.telephone_number").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.passenger.telephone_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.passenger.telephone_number").toString()));
      }
      // validate the optional field airline.passenger.traveller_type
      if (jsonObj.get("airline.passenger.traveller_type") != null && !jsonObj.get("airline.passenger.traveller_type").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.passenger.traveller_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.passenger.traveller_type").toString()));
      }
      // validate the optional field airline.passenger_name
      if (jsonObj.get("airline.passenger_name") != null && !jsonObj.get("airline.passenger_name").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.passenger_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.passenger_name").toString()));
      }
      // validate the optional field airline.ticket_issue_address
      if (jsonObj.get("airline.ticket_issue_address") != null && !jsonObj.get("airline.ticket_issue_address").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.ticket_issue_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.ticket_issue_address").toString()));
      }
      // validate the optional field airline.ticket_number
      if (jsonObj.get("airline.ticket_number") != null && !jsonObj.get("airline.ticket_number").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.ticket_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.ticket_number").toString()));
      }
      // validate the optional field airline.travel_agency_code
      if (jsonObj.get("airline.travel_agency_code") != null && !jsonObj.get("airline.travel_agency_code").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.travel_agency_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.travel_agency_code").toString()));
      }
      // validate the optional field airline.travel_agency_name
      if (jsonObj.get("airline.travel_agency_name") != null && !jsonObj.get("airline.travel_agency_name").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `airline.travel_agency_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("airline.travel_agency_name").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AdditionalDataAirline.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AdditionalDataAirline' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AdditionalDataAirline> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AdditionalDataAirline.class));

       return (TypeAdapter<T>) new TypeAdapter<AdditionalDataAirline>() {
           @Override
           public void write(JsonWriter out, AdditionalDataAirline value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AdditionalDataAirline read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AdditionalDataAirline given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AdditionalDataAirline
  * @throws IOException if the JSON string is invalid with respect to AdditionalDataAirline
  */
  public static AdditionalDataAirline fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AdditionalDataAirline.class);
  }

 /**
  * Convert an instance of AdditionalDataAirline to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

