/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.checkout.Amount;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * CheckoutVoucherAction
 */

public class CheckoutVoucherAction {
  public static final String SERIALIZED_NAME_ALTERNATIVE_REFERENCE = "alternativeReference";
  @SerializedName(SERIALIZED_NAME_ALTERNATIVE_REFERENCE)
  private String alternativeReference;

  public static final String SERIALIZED_NAME_COLLECTION_INSTITUTION_NUMBER = "collectionInstitutionNumber";
  @SerializedName(SERIALIZED_NAME_COLLECTION_INSTITUTION_NUMBER)
  private String collectionInstitutionNumber;

  public static final String SERIALIZED_NAME_DOWNLOAD_URL = "downloadUrl";
  @SerializedName(SERIALIZED_NAME_DOWNLOAD_URL)
  private String downloadUrl;

  public static final String SERIALIZED_NAME_ENTITY = "entity";
  @SerializedName(SERIALIZED_NAME_ENTITY)
  private String entity;

  public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
  @SerializedName(SERIALIZED_NAME_EXPIRES_AT)
  private String expiresAt;

  public static final String SERIALIZED_NAME_INITIAL_AMOUNT = "initialAmount";
  @SerializedName(SERIALIZED_NAME_INITIAL_AMOUNT)
  private Amount initialAmount;

  public static final String SERIALIZED_NAME_INSTRUCTIONS_URL = "instructionsUrl";
  @SerializedName(SERIALIZED_NAME_INSTRUCTIONS_URL)
  private String instructionsUrl;

  public static final String SERIALIZED_NAME_ISSUER = "issuer";
  @SerializedName(SERIALIZED_NAME_ISSUER)
  private String issuer;

  public static final String SERIALIZED_NAME_MASKED_TELEPHONE_NUMBER = "maskedTelephoneNumber";
  @SerializedName(SERIALIZED_NAME_MASKED_TELEPHONE_NUMBER)
  private String maskedTelephoneNumber;

  public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchantName";
  @SerializedName(SERIALIZED_NAME_MERCHANT_NAME)
  private String merchantName;

  public static final String SERIALIZED_NAME_MERCHANT_REFERENCE = "merchantReference";
  @SerializedName(SERIALIZED_NAME_MERCHANT_REFERENCE)
  private String merchantReference;

  public static final String SERIALIZED_NAME_PAYMENT_DATA = "paymentData";
  @SerializedName(SERIALIZED_NAME_PAYMENT_DATA)
  private String paymentData;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD_TYPE = "paymentMethodType";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD_TYPE)
  private String paymentMethodType;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
  @SerializedName(SERIALIZED_NAME_SHOPPER_EMAIL)
  private String shopperEmail;

  public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
  @SerializedName(SERIALIZED_NAME_SHOPPER_NAME)
  private String shopperName;

  public static final String SERIALIZED_NAME_SURCHARGE = "surcharge";
  @SerializedName(SERIALIZED_NAME_SURCHARGE)
  private Amount surcharge;

  public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "totalAmount";
  @SerializedName(SERIALIZED_NAME_TOTAL_AMOUNT)
  private Amount totalAmount;

  /**
   * **voucher**
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    VOUCHER("voucher");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_URL = "url";
  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public CheckoutVoucherAction() { 
  }

  public CheckoutVoucherAction alternativeReference(String alternativeReference) {
    
    this.alternativeReference = alternativeReference;
    return this;
  }

   /**
   * The voucher alternative reference code.
   * @return alternativeReference
  **/
  @ApiModelProperty(value = "The voucher alternative reference code.")

  public String getAlternativeReference() {
    return alternativeReference;
  }


  public void setAlternativeReference(String alternativeReference) {
    this.alternativeReference = alternativeReference;
  }


  public CheckoutVoucherAction collectionInstitutionNumber(String collectionInstitutionNumber) {
    
    this.collectionInstitutionNumber = collectionInstitutionNumber;
    return this;
  }

   /**
   * A collection institution number (store number) for Econtext Pay-Easy ATM.
   * @return collectionInstitutionNumber
  **/
  @ApiModelProperty(value = "A collection institution number (store number) for Econtext Pay-Easy ATM.")

  public String getCollectionInstitutionNumber() {
    return collectionInstitutionNumber;
  }


  public void setCollectionInstitutionNumber(String collectionInstitutionNumber) {
    this.collectionInstitutionNumber = collectionInstitutionNumber;
  }


  public CheckoutVoucherAction downloadUrl(String downloadUrl) {
    
    this.downloadUrl = downloadUrl;
    return this;
  }

   /**
   * The URL to download the voucher.
   * @return downloadUrl
  **/
  @ApiModelProperty(value = "The URL to download the voucher.")

  public String getDownloadUrl() {
    return downloadUrl;
  }


  public void setDownloadUrl(String downloadUrl) {
    this.downloadUrl = downloadUrl;
  }


  public CheckoutVoucherAction entity(String entity) {
    
    this.entity = entity;
    return this;
  }

   /**
   * An entity number of Multibanco.
   * @return entity
  **/
  @ApiModelProperty(value = "An entity number of Multibanco.")

  public String getEntity() {
    return entity;
  }


  public void setEntity(String entity) {
    this.entity = entity;
  }


  public CheckoutVoucherAction expiresAt(String expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The date time of the voucher expiry.
   * @return expiresAt
  **/
  @ApiModelProperty(value = "The date time of the voucher expiry.")

  public String getExpiresAt() {
    return expiresAt;
  }


  public void setExpiresAt(String expiresAt) {
    this.expiresAt = expiresAt;
  }


  public CheckoutVoucherAction initialAmount(Amount initialAmount) {
    
    this.initialAmount = initialAmount;
    return this;
  }

   /**
   * Get initialAmount
   * @return initialAmount
  **/
  @ApiModelProperty(value = "")

  public Amount getInitialAmount() {
    return initialAmount;
  }


  public void setInitialAmount(Amount initialAmount) {
    this.initialAmount = initialAmount;
  }


  public CheckoutVoucherAction instructionsUrl(String instructionsUrl) {
    
    this.instructionsUrl = instructionsUrl;
    return this;
  }

   /**
   * The URL to the detailed instructions to make payment using the voucher.
   * @return instructionsUrl
  **/
  @ApiModelProperty(value = "The URL to the detailed instructions to make payment using the voucher.")

  public String getInstructionsUrl() {
    return instructionsUrl;
  }


  public void setInstructionsUrl(String instructionsUrl) {
    this.instructionsUrl = instructionsUrl;
  }


  public CheckoutVoucherAction issuer(String issuer) {
    
    this.issuer = issuer;
    return this;
  }

   /**
   * The issuer of the voucher.
   * @return issuer
  **/
  @ApiModelProperty(value = "The issuer of the voucher.")

  public String getIssuer() {
    return issuer;
  }


  public void setIssuer(String issuer) {
    this.issuer = issuer;
  }


  public CheckoutVoucherAction maskedTelephoneNumber(String maskedTelephoneNumber) {
    
    this.maskedTelephoneNumber = maskedTelephoneNumber;
    return this;
  }

   /**
   * The shopper telephone number (partially masked).
   * @return maskedTelephoneNumber
  **/
  @ApiModelProperty(value = "The shopper telephone number (partially masked).")

  public String getMaskedTelephoneNumber() {
    return maskedTelephoneNumber;
  }


  public void setMaskedTelephoneNumber(String maskedTelephoneNumber) {
    this.maskedTelephoneNumber = maskedTelephoneNumber;
  }


  public CheckoutVoucherAction merchantName(String merchantName) {
    
    this.merchantName = merchantName;
    return this;
  }

   /**
   * The merchant name.
   * @return merchantName
  **/
  @ApiModelProperty(value = "The merchant name.")

  public String getMerchantName() {
    return merchantName;
  }


  public void setMerchantName(String merchantName) {
    this.merchantName = merchantName;
  }


  public CheckoutVoucherAction merchantReference(String merchantReference) {
    
    this.merchantReference = merchantReference;
    return this;
  }

   /**
   * The merchant reference.
   * @return merchantReference
  **/
  @ApiModelProperty(value = "The merchant reference.")

  public String getMerchantReference() {
    return merchantReference;
  }


  public void setMerchantReference(String merchantReference) {
    this.merchantReference = merchantReference;
  }


  public CheckoutVoucherAction paymentData(String paymentData) {
    
    this.paymentData = paymentData;
    return this;
  }

   /**
   * A value that must be submitted to the &#x60;/payments/details&#x60; endpoint to verify this payment.
   * @return paymentData
  **/
  @ApiModelProperty(value = "A value that must be submitted to the `/payments/details` endpoint to verify this payment.")

  public String getPaymentData() {
    return paymentData;
  }


  public void setPaymentData(String paymentData) {
    this.paymentData = paymentData;
  }


  public CheckoutVoucherAction paymentMethodType(String paymentMethodType) {
    
    this.paymentMethodType = paymentMethodType;
    return this;
  }

   /**
   * Specifies the payment method.
   * @return paymentMethodType
  **/
  @ApiModelProperty(value = "Specifies the payment method.")

  public String getPaymentMethodType() {
    return paymentMethodType;
  }


  public void setPaymentMethodType(String paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
  }


  public CheckoutVoucherAction reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * The voucher reference code.
   * @return reference
  **/
  @ApiModelProperty(value = "The voucher reference code.")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public CheckoutVoucherAction shopperEmail(String shopperEmail) {
    
    this.shopperEmail = shopperEmail;
    return this;
  }

   /**
   * The shopper email.
   * @return shopperEmail
  **/
  @ApiModelProperty(value = "The shopper email.")

  public String getShopperEmail() {
    return shopperEmail;
  }


  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }


  public CheckoutVoucherAction shopperName(String shopperName) {
    
    this.shopperName = shopperName;
    return this;
  }

   /**
   * The shopper name.
   * @return shopperName
  **/
  @ApiModelProperty(value = "The shopper name.")

  public String getShopperName() {
    return shopperName;
  }


  public void setShopperName(String shopperName) {
    this.shopperName = shopperName;
  }


  public CheckoutVoucherAction surcharge(Amount surcharge) {
    
    this.surcharge = surcharge;
    return this;
  }

   /**
   * Get surcharge
   * @return surcharge
  **/
  @ApiModelProperty(value = "")

  public Amount getSurcharge() {
    return surcharge;
  }


  public void setSurcharge(Amount surcharge) {
    this.surcharge = surcharge;
  }


  public CheckoutVoucherAction totalAmount(Amount totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * Get totalAmount
   * @return totalAmount
  **/
  @ApiModelProperty(value = "")

  public Amount getTotalAmount() {
    return totalAmount;
  }


  public void setTotalAmount(Amount totalAmount) {
    this.totalAmount = totalAmount;
  }


  public CheckoutVoucherAction type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * **voucher**
   * @return type
  **/
  @ApiModelProperty(required = true, value = "**voucher**")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }


  public CheckoutVoucherAction url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Specifies the URL to redirect to.
   * @return url
  **/
  @ApiModelProperty(value = "Specifies the URL to redirect to.")

  public String getUrl() {
    return url;
  }


  public void setUrl(String url) {
    this.url = url;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckoutVoucherAction checkoutVoucherAction = (CheckoutVoucherAction) o;
    return Objects.equals(this.alternativeReference, checkoutVoucherAction.alternativeReference) &&
        Objects.equals(this.collectionInstitutionNumber, checkoutVoucherAction.collectionInstitutionNumber) &&
        Objects.equals(this.downloadUrl, checkoutVoucherAction.downloadUrl) &&
        Objects.equals(this.entity, checkoutVoucherAction.entity) &&
        Objects.equals(this.expiresAt, checkoutVoucherAction.expiresAt) &&
        Objects.equals(this.initialAmount, checkoutVoucherAction.initialAmount) &&
        Objects.equals(this.instructionsUrl, checkoutVoucherAction.instructionsUrl) &&
        Objects.equals(this.issuer, checkoutVoucherAction.issuer) &&
        Objects.equals(this.maskedTelephoneNumber, checkoutVoucherAction.maskedTelephoneNumber) &&
        Objects.equals(this.merchantName, checkoutVoucherAction.merchantName) &&
        Objects.equals(this.merchantReference, checkoutVoucherAction.merchantReference) &&
        Objects.equals(this.paymentData, checkoutVoucherAction.paymentData) &&
        Objects.equals(this.paymentMethodType, checkoutVoucherAction.paymentMethodType) &&
        Objects.equals(this.reference, checkoutVoucherAction.reference) &&
        Objects.equals(this.shopperEmail, checkoutVoucherAction.shopperEmail) &&
        Objects.equals(this.shopperName, checkoutVoucherAction.shopperName) &&
        Objects.equals(this.surcharge, checkoutVoucherAction.surcharge) &&
        Objects.equals(this.totalAmount, checkoutVoucherAction.totalAmount) &&
        Objects.equals(this.type, checkoutVoucherAction.type) &&
        Objects.equals(this.url, checkoutVoucherAction.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alternativeReference, collectionInstitutionNumber, downloadUrl, entity, expiresAt, initialAmount, instructionsUrl, issuer, maskedTelephoneNumber, merchantName, merchantReference, paymentData, paymentMethodType, reference, shopperEmail, shopperName, surcharge, totalAmount, type, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckoutVoucherAction {\n");
    sb.append("    alternativeReference: ").append(toIndentedString(alternativeReference)).append("\n");
    sb.append("    collectionInstitutionNumber: ").append(toIndentedString(collectionInstitutionNumber)).append("\n");
    sb.append("    downloadUrl: ").append(toIndentedString(downloadUrl)).append("\n");
    sb.append("    entity: ").append(toIndentedString(entity)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    initialAmount: ").append(toIndentedString(initialAmount)).append("\n");
    sb.append("    instructionsUrl: ").append(toIndentedString(instructionsUrl)).append("\n");
    sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
    sb.append("    maskedTelephoneNumber: ").append(toIndentedString(maskedTelephoneNumber)).append("\n");
    sb.append("    merchantName: ").append(toIndentedString(merchantName)).append("\n");
    sb.append("    merchantReference: ").append(toIndentedString(merchantReference)).append("\n");
    sb.append("    paymentData: ").append(toIndentedString(paymentData)).append("\n");
    sb.append("    paymentMethodType: ").append(toIndentedString(paymentMethodType)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    surcharge: ").append(toIndentedString(surcharge)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("alternativeReference");
    openapiFields.add("collectionInstitutionNumber");
    openapiFields.add("downloadUrl");
    openapiFields.add("entity");
    openapiFields.add("expiresAt");
    openapiFields.add("initialAmount");
    openapiFields.add("instructionsUrl");
    openapiFields.add("issuer");
    openapiFields.add("maskedTelephoneNumber");
    openapiFields.add("merchantName");
    openapiFields.add("merchantReference");
    openapiFields.add("paymentData");
    openapiFields.add("paymentMethodType");
    openapiFields.add("reference");
    openapiFields.add("shopperEmail");
    openapiFields.add("shopperName");
    openapiFields.add("surcharge");
    openapiFields.add("totalAmount");
    openapiFields.add("type");
    openapiFields.add("url");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("type");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(CheckoutVoucherAction.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CheckoutVoucherAction
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (CheckoutVoucherAction.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in CheckoutVoucherAction is not found in the empty JSON string", CheckoutVoucherAction.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CheckoutVoucherAction.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CheckoutVoucherAction` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : CheckoutVoucherAction.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field alternativeReference
      if (jsonObj.get("alternativeReference") != null && !jsonObj.get("alternativeReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `alternativeReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("alternativeReference").toString()));
      }
      // validate the optional field collectionInstitutionNumber
      if (jsonObj.get("collectionInstitutionNumber") != null && !jsonObj.get("collectionInstitutionNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `collectionInstitutionNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("collectionInstitutionNumber").toString()));
      }
      // validate the optional field downloadUrl
      if (jsonObj.get("downloadUrl") != null && !jsonObj.get("downloadUrl").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `downloadUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("downloadUrl").toString()));
      }
      // validate the optional field entity
      if (jsonObj.get("entity") != null && !jsonObj.get("entity").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `entity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("entity").toString()));
      }
      // validate the optional field expiresAt
      if (jsonObj.get("expiresAt") != null && !jsonObj.get("expiresAt").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `expiresAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get("expiresAt").toString()));
      }
      // validate the optional field `initialAmount`
      if (jsonObj.getAsJsonObject("initialAmount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("initialAmount"));
      }
      // validate the optional field instructionsUrl
      if (jsonObj.get("instructionsUrl") != null && !jsonObj.get("instructionsUrl").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `instructionsUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("instructionsUrl").toString()));
      }
      // validate the optional field issuer
      if (jsonObj.get("issuer") != null && !jsonObj.get("issuer").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `issuer` to be a primitive type in the JSON string but got `%s`", jsonObj.get("issuer").toString()));
      }
      // validate the optional field maskedTelephoneNumber
      if (jsonObj.get("maskedTelephoneNumber") != null && !jsonObj.get("maskedTelephoneNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `maskedTelephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("maskedTelephoneNumber").toString()));
      }
      // validate the optional field merchantName
      if (jsonObj.get("merchantName") != null && !jsonObj.get("merchantName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantName").toString()));
      }
      // validate the optional field merchantReference
      if (jsonObj.get("merchantReference") != null && !jsonObj.get("merchantReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantReference").toString()));
      }
      // validate the optional field paymentData
      if (jsonObj.get("paymentData") != null && !jsonObj.get("paymentData").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentData` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentData").toString()));
      }
      // validate the optional field paymentMethodType
      if (jsonObj.get("paymentMethodType") != null && !jsonObj.get("paymentMethodType").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentMethodType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentMethodType").toString()));
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // validate the optional field shopperEmail
      if (jsonObj.get("shopperEmail") != null && !jsonObj.get("shopperEmail").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperEmail").toString()));
      }
      // validate the optional field shopperName
      if (jsonObj.get("shopperName") != null && !jsonObj.get("shopperName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperName").toString()));
      }
      // validate the optional field `surcharge`
      if (jsonObj.getAsJsonObject("surcharge") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("surcharge"));
      }
      // validate the optional field `totalAmount`
      if (jsonObj.getAsJsonObject("totalAmount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("totalAmount"));
      }
      // ensure the field type can be parsed to an enum value
      if (jsonObj.get("type") != null) {
        if(!jsonObj.get("type").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
        }
        TypeEnum.fromValue(jsonObj.get("type").getAsString());
      }
      // validate the optional field url
      if (jsonObj.get("url") != null && !jsonObj.get("url").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("url").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CheckoutVoucherAction.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CheckoutVoucherAction' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CheckoutVoucherAction> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CheckoutVoucherAction.class));

       return (TypeAdapter<T>) new TypeAdapter<CheckoutVoucherAction>() {
           @Override
           public void write(JsonWriter out, CheckoutVoucherAction value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CheckoutVoucherAction read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CheckoutVoucherAction given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CheckoutVoucherAction
  * @throws IOException if the JSON string is invalid with respect to CheckoutVoucherAction
  */
  public static CheckoutVoucherAction fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CheckoutVoucherAction.class);
  }

 /**
  * Convert an instance of CheckoutVoucherAction to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

