/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.InstallmentOption;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * PaymentLinkResponse
 */

public class PaymentLinkResponse {
  public static final String SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS = "allowedPaymentMethods";
  @SerializedName(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS)
  private List<String> allowedPaymentMethods = null;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Amount amount;

  public static final String SERIALIZED_NAME_APPLICATION_INFO = "applicationInfo";
  @SerializedName(SERIALIZED_NAME_APPLICATION_INFO)
  private ApplicationInfo applicationInfo;

  public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
  @SerializedName(SERIALIZED_NAME_BILLING_ADDRESS)
  private Address billingAddress;

  public static final String SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS = "blockedPaymentMethods";
  @SerializedName(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS)
  private List<String> blockedPaymentMethods = null;

  public static final String SERIALIZED_NAME_CAPTURE_DELAY_HOURS = "captureDelayHours";
  @SerializedName(SERIALIZED_NAME_CAPTURE_DELAY_HOURS)
  private Integer captureDelayHours;

  public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
  @SerializedName(SERIALIZED_NAME_COUNTRY_CODE)
  private String countryCode;

  public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
  @SerializedName(SERIALIZED_NAME_DATE_OF_BIRTH)
  private LocalDate dateOfBirth;

  public static final String SERIALIZED_NAME_DELIVER_AT = "deliverAt";
  @SerializedName(SERIALIZED_NAME_DELIVER_AT)
  private OffsetDateTime deliverAt;

  public static final String SERIALIZED_NAME_DELIVERY_ADDRESS = "deliveryAddress";
  @SerializedName(SERIALIZED_NAME_DELIVERY_ADDRESS)
  private Address deliveryAddress;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
  @SerializedName(SERIALIZED_NAME_EXPIRES_AT)
  private String expiresAt;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_INSTALLMENT_OPTIONS = "installmentOptions";
  @SerializedName(SERIALIZED_NAME_INSTALLMENT_OPTIONS)
  private Map<String, InstallmentOption> installmentOptions = null;

  public static final String SERIALIZED_NAME_LINE_ITEMS = "lineItems";
  @SerializedName(SERIALIZED_NAME_LINE_ITEMS)
  private List<LineItem> lineItems = null;

  public static final String SERIALIZED_NAME_MANUAL_CAPTURE = "manualCapture";
  @SerializedName(SERIALIZED_NAME_MANUAL_CAPTURE)
  private Boolean manualCapture;

  public static final String SERIALIZED_NAME_MCC = "mcc";
  @SerializedName(SERIALIZED_NAME_MCC)
  private String mcc;

  public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ACCOUNT)
  private String merchantAccount;

  public static final String SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE)
  private String merchantOrderReference;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private Map<String, String> metadata = null;

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details. Possible values: * **Subscription** – A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  @JsonAdapter(RecurringProcessingModelEnum.Adapter.class)
  public enum RecurringProcessingModelEnum {
    CARDONFILE("CardOnFile"),
    
    SUBSCRIPTION("Subscription"),
    
    UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RecurringProcessingModelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RecurringProcessingModelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RecurringProcessingModelEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RecurringProcessingModelEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  @SerializedName(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL)
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  /**
   * Gets or Sets requiredShopperFields
   */
  @JsonAdapter(RequiredShopperFieldsEnum.Adapter.class)
  public enum RequiredShopperFieldsEnum {
    BILLINGADDRESS("billingAddress"),
    
    DELIVERYADDRESS("deliveryAddress"),
    
    SHOPPEREMAIL("shopperEmail"),
    
    SHOPPERNAME("shopperName"),
    
    TELEPHONENUMBER("telephoneNumber");

    private String value;

    RequiredShopperFieldsEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RequiredShopperFieldsEnum fromValue(String value) {
      for (RequiredShopperFieldsEnum b : RequiredShopperFieldsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RequiredShopperFieldsEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RequiredShopperFieldsEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RequiredShopperFieldsEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RequiredShopperFieldsEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_REQUIRED_SHOPPER_FIELDS = "requiredShopperFields";
  @SerializedName(SERIALIZED_NAME_REQUIRED_SHOPPER_FIELDS)
  private List<RequiredShopperFieldsEnum> requiredShopperFields = null;

  public static final String SERIALIZED_NAME_RETURN_URL = "returnUrl";
  @SerializedName(SERIALIZED_NAME_RETURN_URL)
  private String returnUrl;

  public static final String SERIALIZED_NAME_REUSABLE = "reusable";
  @SerializedName(SERIALIZED_NAME_REUSABLE)
  private Boolean reusable;

  public static final String SERIALIZED_NAME_RISK_DATA = "riskData";
  @SerializedName(SERIALIZED_NAME_RISK_DATA)
  private RiskData riskData;

  public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
  @SerializedName(SERIALIZED_NAME_SHOPPER_EMAIL)
  private String shopperEmail;

  public static final String SERIALIZED_NAME_SHOPPER_LOCALE = "shopperLocale";
  @SerializedName(SERIALIZED_NAME_SHOPPER_LOCALE)
  private String shopperLocale;

  public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
  @SerializedName(SERIALIZED_NAME_SHOPPER_NAME)
  private Name shopperName;

  public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
  @SerializedName(SERIALIZED_NAME_SHOPPER_REFERENCE)
  private String shopperReference;

  public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
  @SerializedName(SERIALIZED_NAME_SHOPPER_STATEMENT)
  private String shopperStatement;

  public static final String SERIALIZED_NAME_SHOW_REMOVE_PAYMENT_METHOD_BUTTON = "showRemovePaymentMethodButton";
  @SerializedName(SERIALIZED_NAME_SHOW_REMOVE_PAYMENT_METHOD_BUTTON)
  private Boolean showRemovePaymentMethodButton = true;

  public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
  @SerializedName(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER)
  private String socialSecurityNumber;

  public static final String SERIALIZED_NAME_SPLIT_CARD_FUNDING_SOURCES = "splitCardFundingSources";
  @SerializedName(SERIALIZED_NAME_SPLIT_CARD_FUNDING_SOURCES)
  private Boolean splitCardFundingSources = false;

  public static final String SERIALIZED_NAME_SPLITS = "splits";
  @SerializedName(SERIALIZED_NAME_SPLITS)
  private List<Split> splits = null;

  /**
   * Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    ACTIVE("active"),
    
    COMPLETED("completed"),
    
    EXPIRED("expired"),
    
    PAID("paid"),
    
    PAYMENTPENDING("paymentPending");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_STORE = "store";
  @SerializedName(SERIALIZED_NAME_STORE)
  private String store;

  /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided, the details will be stored without asking the shopper for consent.
   */
  @JsonAdapter(StorePaymentMethodModeEnum.Adapter.class)
  public enum StorePaymentMethodModeEnum {
    ASKFORCONSENT("askForConsent"),
    
    DISABLED("disabled"),
    
    ENABLED("enabled");

    private String value;

    StorePaymentMethodModeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StorePaymentMethodModeEnum fromValue(String value) {
      for (StorePaymentMethodModeEnum b : StorePaymentMethodModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StorePaymentMethodModeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StorePaymentMethodModeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StorePaymentMethodModeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StorePaymentMethodModeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE = "storePaymentMethodMode";
  @SerializedName(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE)
  private StorePaymentMethodModeEnum storePaymentMethodMode;

  public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
  @SerializedName(SERIALIZED_NAME_TELEPHONE_NUMBER)
  private String telephoneNumber;

  public static final String SERIALIZED_NAME_THEME_ID = "themeId";
  @SerializedName(SERIALIZED_NAME_THEME_ID)
  private String themeId;

  public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
  @SerializedName(SERIALIZED_NAME_UPDATED_AT)
  private OffsetDateTime updatedAt;

  public static final String SERIALIZED_NAME_URL = "url";
  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public PaymentLinkResponse() { 
  }

  
  public PaymentLinkResponse(
     String id, 
     String url
  ) {
    this();
    this.id = id;
    this.url = url;
  }

  public PaymentLinkResponse allowedPaymentMethods(List<String> allowedPaymentMethods) {
    
    this.allowedPaymentMethods = allowedPaymentMethods;
    return this;
  }

  public PaymentLinkResponse addAllowedPaymentMethodsItem(String allowedPaymentMethodsItem) {
    if (this.allowedPaymentMethods == null) {
      this.allowedPaymentMethods = new ArrayList<>();
    }
    this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
    return this;
  }

   /**
   * List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;allowedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
   * @return allowedPaymentMethods
  **/
  @ApiModelProperty(value = "List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"allowedPaymentMethods\":[\"ideal\",\"giropay\"]`")

  public List<String> getAllowedPaymentMethods() {
    return allowedPaymentMethods;
  }


  public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
    this.allowedPaymentMethods = allowedPaymentMethods;
  }


  public PaymentLinkResponse amount(Amount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")

  public Amount getAmount() {
    return amount;
  }


  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public PaymentLinkResponse applicationInfo(ApplicationInfo applicationInfo) {
    
    this.applicationInfo = applicationInfo;
    return this;
  }

   /**
   * Get applicationInfo
   * @return applicationInfo
  **/
  @ApiModelProperty(value = "")

  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }


  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }


  public PaymentLinkResponse billingAddress(Address billingAddress) {
    
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @ApiModelProperty(value = "")

  public Address getBillingAddress() {
    return billingAddress;
  }


  public void setBillingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
  }


  public PaymentLinkResponse blockedPaymentMethods(List<String> blockedPaymentMethods) {
    
    this.blockedPaymentMethods = blockedPaymentMethods;
    return this;
  }

  public PaymentLinkResponse addBlockedPaymentMethodsItem(String blockedPaymentMethodsItem) {
    if (this.blockedPaymentMethods == null) {
      this.blockedPaymentMethods = new ArrayList<>();
    }
    this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
    return this;
  }

   /**
   * List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: &#x60;\&quot;blockedPaymentMethods\&quot;:[\&quot;ideal\&quot;,\&quot;giropay\&quot;]&#x60;
   * @return blockedPaymentMethods
  **/
  @ApiModelProperty(value = "List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"blockedPaymentMethods\":[\"ideal\",\"giropay\"]`")

  public List<String> getBlockedPaymentMethods() {
    return blockedPaymentMethods;
  }


  public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
    this.blockedPaymentMethods = blockedPaymentMethods;
  }


  public PaymentLinkResponse captureDelayHours(Integer captureDelayHours) {
    
    this.captureDelayHours = captureDelayHours;
    return this;
  }

   /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   * @return captureDelayHours
  **/
  @ApiModelProperty(value = "The delay between the authorisation and scheduled auto-capture, specified in hours.")

  public Integer getCaptureDelayHours() {
    return captureDelayHours;
  }


  public void setCaptureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
  }


  public PaymentLinkResponse countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * The shopper&#39;s two-letter country code.
   * @return countryCode
  **/
  @ApiModelProperty(value = "The shopper's two-letter country code.")

  public String getCountryCode() {
    return countryCode;
  }


  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public PaymentLinkResponse dateOfBirth(LocalDate dateOfBirth) {
    
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   * @return dateOfBirth
  **/
  @ApiModelProperty(value = "The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }


  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public PaymentLinkResponse deliverAt(OffsetDateTime deliverAt) {
    
    this.deliverAt = deliverAt;
    return this;
  }

   /**
   * The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
   * @return deliverAt
  **/
  @ApiModelProperty(value = "The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")

  public OffsetDateTime getDeliverAt() {
    return deliverAt;
  }


  public void setDeliverAt(OffsetDateTime deliverAt) {
    this.deliverAt = deliverAt;
  }


  public PaymentLinkResponse deliveryAddress(Address deliveryAddress) {
    
    this.deliveryAddress = deliveryAddress;
    return this;
  }

   /**
   * Get deliveryAddress
   * @return deliveryAddress
  **/
  @ApiModelProperty(value = "")

  public Address getDeliveryAddress() {
    return deliveryAddress;
  }


  public void setDeliveryAddress(Address deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }


  public PaymentLinkResponse description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A short description visible on the payment page. Maximum length: 280 characters.
   * @return description
  **/
  @ApiModelProperty(value = "A short description visible on the payment page. Maximum length: 280 characters.")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public PaymentLinkResponse expiresAt(String expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The date when the payment link expires.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.  The maximum expiry date is 70 days after the payment link is created.  If not provided, the payment link expires 24 hours after it was created.
   * @return expiresAt
  **/
  @ApiModelProperty(value = "The date when the payment link expires.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.  The maximum expiry date is 70 days after the payment link is created.  If not provided, the payment link expires 24 hours after it was created.")

  public String getExpiresAt() {
    return expiresAt;
  }


  public void setExpiresAt(String expiresAt) {
    this.expiresAt = expiresAt;
  }


   /**
   * A unique identifier of the payment link.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "A unique identifier of the payment link.")

  public String getId() {
    return id;
  }




  public PaymentLinkResponse installmentOptions(Map<String, InstallmentOption> installmentOptions) {
    
    this.installmentOptions = installmentOptions;
    return this;
  }

  public PaymentLinkResponse putInstallmentOptionsItem(String key, InstallmentOption installmentOptionsItem) {
    if (this.installmentOptions == null) {
      this.installmentOptions = new HashMap<>();
    }
    this.installmentOptions.put(key, installmentOptionsItem);
    return this;
  }

   /**
   * A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.
   * @return installmentOptions
  **/
  @ApiModelProperty(value = "A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.")

  public Map<String, InstallmentOption> getInstallmentOptions() {
    return installmentOptions;
  }


  public void setInstallmentOptions(Map<String, InstallmentOption> installmentOptions) {
    this.installmentOptions = installmentOptions;
  }


  public PaymentLinkResponse lineItems(List<LineItem> lineItems) {
    
    this.lineItems = lineItems;
    return this;
  }

  public PaymentLinkResponse addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

   /**
   * Price and product information about the purchased items, to be included on the invoice sent to the shopper. This parameter is required for open invoice (_buy now, pay later_) payment methods such Afterpay, Clearpay, Klarna, RatePay, and Zip.
   * @return lineItems
  **/
  @ApiModelProperty(value = "Price and product information about the purchased items, to be included on the invoice sent to the shopper. This parameter is required for open invoice (_buy now, pay later_) payment methods such Afterpay, Clearpay, Klarna, RatePay, and Zip.")

  public List<LineItem> getLineItems() {
    return lineItems;
  }


  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }


  public PaymentLinkResponse manualCapture(Boolean manualCapture) {
    
    this.manualCapture = manualCapture;
    return this;
  }

   /**
   * Indicates if the payment must be [captured manually](https://docs.adyen.com/online-payments/capture).
   * @return manualCapture
  **/
  @ApiModelProperty(value = "Indicates if the payment must be [captured manually](https://docs.adyen.com/online-payments/capture).")

  public Boolean getManualCapture() {
    return manualCapture;
  }


  public void setManualCapture(Boolean manualCapture) {
    this.manualCapture = manualCapture;
  }


  public PaymentLinkResponse mcc(String mcc) {
    
    this.mcc = mcc;
    return this;
  }

   /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
   * @return mcc
  **/
  @ApiModelProperty(value = "The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")

  public String getMcc() {
    return mcc;
  }


  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  public PaymentLinkResponse merchantAccount(String merchantAccount) {
    
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account identifier for which the payment link is created.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account identifier for which the payment link is created.")

  public String getMerchantAccount() {
    return merchantAccount;
  }


  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public PaymentLinkResponse merchantOrderReference(String merchantOrderReference) {
    
    this.merchantOrderReference = merchantOrderReference;
    return this;
  }

   /**
   * This reference allows linking multiple transactions to each other for reporting purposes (for example, order auth-rate). The reference should be unique per billing cycle.
   * @return merchantOrderReference
  **/
  @ApiModelProperty(value = "This reference allows linking multiple transactions to each other for reporting purposes (for example, order auth-rate). The reference should be unique per billing cycle.")

  public String getMerchantOrderReference() {
    return merchantOrderReference;
  }


  public void setMerchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
  }


  public PaymentLinkResponse metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public PaymentLinkResponse putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Metadata consists of entries, each of which includes a key and a value. Limitations: * Maximum 20 key-value pairs per request. Otherwise, error \&quot;177\&quot; occurs: \&quot;Metadata size exceeds limit\&quot; * Maximum 20 characters per key. Otherwise, error \&quot;178\&quot; occurs: \&quot;Metadata key size exceeds limit\&quot; * A key cannot have the name &#x60;checkout.linkId&#x60;. Any value that you provide with this key is going to be replaced by the real payment link ID.
   * @return metadata
  **/
  @ApiModelProperty(value = "Metadata consists of entries, each of which includes a key and a value. Limitations: * Maximum 20 key-value pairs per request. Otherwise, error \"177\" occurs: \"Metadata size exceeds limit\" * Maximum 20 characters per key. Otherwise, error \"178\" occurs: \"Metadata key size exceeds limit\" * A key cannot have the name `checkout.linkId`. Any value that you provide with this key is going to be replaced by the real payment link ID.")

  public Map<String, String> getMetadata() {
    return metadata;
  }


  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public PaymentLinkResponse recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

   /**
   * Defines a recurring payment type. Required when creating a token to store payment details. Possible values: * **Subscription** – A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   * @return recurringProcessingModel
  **/
  @ApiModelProperty(value = "Defines a recurring payment type. Required when creating a token to store payment details. Possible values: * **Subscription** – A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")

  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }


  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }


  public PaymentLinkResponse reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * A reference that is used to uniquely identify the payment in future communications about the payment status.
   * @return reference
  **/
  @ApiModelProperty(required = true, value = "A reference that is used to uniquely identify the payment in future communications about the payment status.")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public PaymentLinkResponse requiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
    
    this.requiredShopperFields = requiredShopperFields;
    return this;
  }

  public PaymentLinkResponse addRequiredShopperFieldsItem(RequiredShopperFieldsEnum requiredShopperFieldsItem) {
    if (this.requiredShopperFields == null) {
      this.requiredShopperFields = new ArrayList<>();
    }
    this.requiredShopperFields.add(requiredShopperFieldsItem);
    return this;
  }

   /**
   * List of fields that the shopper has to provide on the payment page before completing the payment. For more information, refer to [Provide shopper information](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#shopper-information).  Possible values: * **billingAddress** – The address where to send the invoice. * **deliveryAddress** – The address where the purchased goods should be delivered. * **shopperEmail** – The shopper&#39;s email address. * **shopperName** – The shopper&#39;s full name. * **telephoneNumber** – The shopper&#39;s phone number. 
   * @return requiredShopperFields
  **/
  @ApiModelProperty(value = "List of fields that the shopper has to provide on the payment page before completing the payment. For more information, refer to [Provide shopper information](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#shopper-information).  Possible values: * **billingAddress** – The address where to send the invoice. * **deliveryAddress** – The address where the purchased goods should be delivered. * **shopperEmail** – The shopper's email address. * **shopperName** – The shopper's full name. * **telephoneNumber** – The shopper's phone number. ")

  public List<RequiredShopperFieldsEnum> getRequiredShopperFields() {
    return requiredShopperFields;
  }


  public void setRequiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
    this.requiredShopperFields = requiredShopperFields;
  }


  public PaymentLinkResponse returnUrl(String returnUrl) {
    
    this.returnUrl = returnUrl;
    return this;
  }

   /**
   * Website URL used for redirection after payment is completed. If provided, a **Continue** button will be shown on the payment page. If shoppers select the button, they are redirected to the specified URL.
   * @return returnUrl
  **/
  @ApiModelProperty(value = "Website URL used for redirection after payment is completed. If provided, a **Continue** button will be shown on the payment page. If shoppers select the button, they are redirected to the specified URL.")

  public String getReturnUrl() {
    return returnUrl;
  }


  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }


  public PaymentLinkResponse reusable(Boolean reusable) {
    
    this.reusable = reusable;
    return this;
  }

   /**
   * Indicates whether the payment link can be reused for multiple payments. If not provided, this defaults to **false** which means the link can be used for one successful payment only.
   * @return reusable
  **/
  @ApiModelProperty(value = "Indicates whether the payment link can be reused for multiple payments. If not provided, this defaults to **false** which means the link can be used for one successful payment only.")

  public Boolean getReusable() {
    return reusable;
  }


  public void setReusable(Boolean reusable) {
    this.reusable = reusable;
  }


  public PaymentLinkResponse riskData(RiskData riskData) {
    
    this.riskData = riskData;
    return this;
  }

   /**
   * Get riskData
   * @return riskData
  **/
  @ApiModelProperty(value = "")

  public RiskData getRiskData() {
    return riskData;
  }


  public void setRiskData(RiskData riskData) {
    this.riskData = riskData;
  }


  public PaymentLinkResponse shopperEmail(String shopperEmail) {
    
    this.shopperEmail = shopperEmail;
    return this;
  }

   /**
   * The shopper&#39;s email address.
   * @return shopperEmail
  **/
  @ApiModelProperty(value = "The shopper's email address.")

  public String getShopperEmail() {
    return shopperEmail;
  }


  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }


  public PaymentLinkResponse shopperLocale(String shopperLocale) {
    
    this.shopperLocale = shopperLocale;
    return this;
  }

   /**
   * The language to be used in the payment page, specified by a combination of a language and country code. For example, &#x60;en-US&#x60;.  For a list of shopper locales that Pay by Link supports, refer to [Language and localization](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#language).
   * @return shopperLocale
  **/
  @ApiModelProperty(value = "The language to be used in the payment page, specified by a combination of a language and country code. For example, `en-US`.  For a list of shopper locales that Pay by Link supports, refer to [Language and localization](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#language).")

  public String getShopperLocale() {
    return shopperLocale;
  }


  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }


  public PaymentLinkResponse shopperName(Name shopperName) {
    
    this.shopperName = shopperName;
    return this;
  }

   /**
   * Get shopperName
   * @return shopperName
  **/
  @ApiModelProperty(value = "")

  public Name getShopperName() {
    return shopperName;
  }


  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }


  public PaymentLinkResponse shopperReference(String shopperReference) {
    
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
   * @return shopperReference
  **/
  @ApiModelProperty(value = "Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")

  public String getShopperReference() {
    return shopperReference;
  }


  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public PaymentLinkResponse shopperStatement(String shopperStatement) {
    
    this.shopperStatement = shopperStatement;
    return this;
  }

   /**
   * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   * @return shopperStatement
  **/
  @ApiModelProperty(value = "The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")

  public String getShopperStatement() {
    return shopperStatement;
  }


  public void setShopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
  }


  public PaymentLinkResponse showRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
    
    this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
    return this;
  }

   /**
   * Set to **false** to hide the button that lets the shopper remove a stored payment method.
   * @return showRemovePaymentMethodButton
  **/
  @ApiModelProperty(value = "Set to **false** to hide the button that lets the shopper remove a stored payment method.")

  public Boolean getShowRemovePaymentMethodButton() {
    return showRemovePaymentMethodButton;
  }


  public void setShowRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
    this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
  }


  public PaymentLinkResponse socialSecurityNumber(String socialSecurityNumber) {
    
    this.socialSecurityNumber = socialSecurityNumber;
    return this;
  }

   /**
   * The shopper&#39;s social security number.
   * @return socialSecurityNumber
  **/
  @ApiModelProperty(value = "The shopper's social security number.")

  public String getSocialSecurityNumber() {
    return socialSecurityNumber;
  }


  public void setSocialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
  }


  public PaymentLinkResponse splitCardFundingSources(Boolean splitCardFundingSources) {
    
    this.splitCardFundingSources = splitCardFundingSources;
    return this;
  }

   /**
   * Boolean value indicating whether the card payment method should be split into separate debit and credit options.
   * @return splitCardFundingSources
  **/
  @ApiModelProperty(value = "Boolean value indicating whether the card payment method should be split into separate debit and credit options.")

  public Boolean getSplitCardFundingSources() {
    return splitCardFundingSources;
  }


  public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
    this.splitCardFundingSources = splitCardFundingSources;
  }


  public PaymentLinkResponse splits(List<Split> splits) {
    
    this.splits = splits;
    return this;
  }

  public PaymentLinkResponse addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

   /**
   * An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/marketplaces-and-platforms/classic/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).
   * @return splits
  **/
  @ApiModelProperty(value = "An array of objects specifying how to split a payment when using [Adyen for Platforms](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information), [Classic Platforms integration](https://docs.adyen.com/marketplaces-and-platforms/classic/processing-payments#providing-split-information), or [Issuing](https://docs.adyen.com/issuing/manage-funds#split).")

  public List<Split> getSplits() {
    return splits;
  }


  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }


  public PaymentLinkResponse status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.")

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public PaymentLinkResponse store(String store) {
    
    this.store = store;
    return this;
  }

   /**
   * The physical store, for which this payment is processed.
   * @return store
  **/
  @ApiModelProperty(value = "The physical store, for which this payment is processed.")

  public String getStore() {
    return store;
  }


  public void setStore(String store) {
    this.store = store;
  }


  public PaymentLinkResponse storePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
    
    this.storePaymentMethodMode = storePaymentMethodMode;
    return this;
  }

   /**
   * Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the &#x60;shopperReference&#x60; is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the &#x60;shopperReference&#x60; is provided, the details will be stored without asking the shopper for consent.
   * @return storePaymentMethodMode
  **/
  @ApiModelProperty(value = "Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** – No details will be stored (default). * **askForConsent** – If the `shopperReference` is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** – If the `shopperReference` is provided, the details will be stored without asking the shopper for consent.")

  public StorePaymentMethodModeEnum getStorePaymentMethodMode() {
    return storePaymentMethodMode;
  }


  public void setStorePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
    this.storePaymentMethodMode = storePaymentMethodMode;
  }


  public PaymentLinkResponse telephoneNumber(String telephoneNumber) {
    
    this.telephoneNumber = telephoneNumber;
    return this;
  }

   /**
   * The shopper&#39;s telephone number.
   * @return telephoneNumber
  **/
  @ApiModelProperty(value = "The shopper's telephone number.")

  public String getTelephoneNumber() {
    return telephoneNumber;
  }


  public void setTelephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
  }


  public PaymentLinkResponse themeId(String themeId) {
    
    this.themeId = themeId;
    return this;
  }

   /**
   * A [theme](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#themes) to customize the appearance of the payment page. If not specified, the payment page is rendered according to the theme set as default in your Customer Area.
   * @return themeId
  **/
  @ApiModelProperty(value = "A [theme](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#themes) to customize the appearance of the payment page. If not specified, the payment page is rendered according to the theme set as default in your Customer Area.")

  public String getThemeId() {
    return themeId;
  }


  public void setThemeId(String themeId) {
    this.themeId = themeId;
  }


  public PaymentLinkResponse updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The date when the payment link status was updated.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.
   * @return updatedAt
  **/
  @ApiModelProperty(value = "The date when the payment link status was updated.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


   /**
   * The URL at which the shopper can complete the payment.
   * @return url
  **/
  @ApiModelProperty(required = true, value = "The URL at which the shopper can complete the payment.")

  public String getUrl() {
    return url;
  }





  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentLinkResponse paymentLinkResponse = (PaymentLinkResponse) o;
    return Objects.equals(this.allowedPaymentMethods, paymentLinkResponse.allowedPaymentMethods) &&
        Objects.equals(this.amount, paymentLinkResponse.amount) &&
        Objects.equals(this.applicationInfo, paymentLinkResponse.applicationInfo) &&
        Objects.equals(this.billingAddress, paymentLinkResponse.billingAddress) &&
        Objects.equals(this.blockedPaymentMethods, paymentLinkResponse.blockedPaymentMethods) &&
        Objects.equals(this.captureDelayHours, paymentLinkResponse.captureDelayHours) &&
        Objects.equals(this.countryCode, paymentLinkResponse.countryCode) &&
        Objects.equals(this.dateOfBirth, paymentLinkResponse.dateOfBirth) &&
        Objects.equals(this.deliverAt, paymentLinkResponse.deliverAt) &&
        Objects.equals(this.deliveryAddress, paymentLinkResponse.deliveryAddress) &&
        Objects.equals(this.description, paymentLinkResponse.description) &&
        Objects.equals(this.expiresAt, paymentLinkResponse.expiresAt) &&
        Objects.equals(this.id, paymentLinkResponse.id) &&
        Objects.equals(this.installmentOptions, paymentLinkResponse.installmentOptions) &&
        Objects.equals(this.lineItems, paymentLinkResponse.lineItems) &&
        Objects.equals(this.manualCapture, paymentLinkResponse.manualCapture) &&
        Objects.equals(this.mcc, paymentLinkResponse.mcc) &&
        Objects.equals(this.merchantAccount, paymentLinkResponse.merchantAccount) &&
        Objects.equals(this.merchantOrderReference, paymentLinkResponse.merchantOrderReference) &&
        Objects.equals(this.metadata, paymentLinkResponse.metadata) &&
        Objects.equals(this.recurringProcessingModel, paymentLinkResponse.recurringProcessingModel) &&
        Objects.equals(this.reference, paymentLinkResponse.reference) &&
        Objects.equals(this.requiredShopperFields, paymentLinkResponse.requiredShopperFields) &&
        Objects.equals(this.returnUrl, paymentLinkResponse.returnUrl) &&
        Objects.equals(this.reusable, paymentLinkResponse.reusable) &&
        Objects.equals(this.riskData, paymentLinkResponse.riskData) &&
        Objects.equals(this.shopperEmail, paymentLinkResponse.shopperEmail) &&
        Objects.equals(this.shopperLocale, paymentLinkResponse.shopperLocale) &&
        Objects.equals(this.shopperName, paymentLinkResponse.shopperName) &&
        Objects.equals(this.shopperReference, paymentLinkResponse.shopperReference) &&
        Objects.equals(this.shopperStatement, paymentLinkResponse.shopperStatement) &&
        Objects.equals(this.showRemovePaymentMethodButton, paymentLinkResponse.showRemovePaymentMethodButton) &&
        Objects.equals(this.socialSecurityNumber, paymentLinkResponse.socialSecurityNumber) &&
        Objects.equals(this.splitCardFundingSources, paymentLinkResponse.splitCardFundingSources) &&
        Objects.equals(this.splits, paymentLinkResponse.splits) &&
        Objects.equals(this.status, paymentLinkResponse.status) &&
        Objects.equals(this.store, paymentLinkResponse.store) &&
        Objects.equals(this.storePaymentMethodMode, paymentLinkResponse.storePaymentMethodMode) &&
        Objects.equals(this.telephoneNumber, paymentLinkResponse.telephoneNumber) &&
        Objects.equals(this.themeId, paymentLinkResponse.themeId) &&
        Objects.equals(this.updatedAt, paymentLinkResponse.updatedAt) &&
        Objects.equals(this.url, paymentLinkResponse.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowedPaymentMethods, amount, applicationInfo, billingAddress, blockedPaymentMethods, captureDelayHours, countryCode, dateOfBirth, deliverAt, deliveryAddress, description, expiresAt, id, installmentOptions, lineItems, manualCapture, mcc, merchantAccount, merchantOrderReference, metadata, recurringProcessingModel, reference, requiredShopperFields, returnUrl, reusable, riskData, shopperEmail, shopperLocale, shopperName, shopperReference, shopperStatement, showRemovePaymentMethodButton, socialSecurityNumber, splitCardFundingSources, splits, status, store, storePaymentMethodMode, telephoneNumber, themeId, updatedAt, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentLinkResponse {\n");
    sb.append("    allowedPaymentMethods: ").append(toIndentedString(allowedPaymentMethods)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    blockedPaymentMethods: ").append(toIndentedString(blockedPaymentMethods)).append("\n");
    sb.append("    captureDelayHours: ").append(toIndentedString(captureDelayHours)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    deliverAt: ").append(toIndentedString(deliverAt)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    installmentOptions: ").append(toIndentedString(installmentOptions)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    manualCapture: ").append(toIndentedString(manualCapture)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    merchantOrderReference: ").append(toIndentedString(merchantOrderReference)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    requiredShopperFields: ").append(toIndentedString(requiredShopperFields)).append("\n");
    sb.append("    returnUrl: ").append(toIndentedString(returnUrl)).append("\n");
    sb.append("    reusable: ").append(toIndentedString(reusable)).append("\n");
    sb.append("    riskData: ").append(toIndentedString(riskData)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    shopperStatement: ").append(toIndentedString(shopperStatement)).append("\n");
    sb.append("    showRemovePaymentMethodButton: ").append(toIndentedString(showRemovePaymentMethodButton)).append("\n");
    sb.append("    socialSecurityNumber: ").append(toIndentedString(socialSecurityNumber)).append("\n");
    sb.append("    splitCardFundingSources: ").append(toIndentedString(splitCardFundingSources)).append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("    storePaymentMethodMode: ").append(toIndentedString(storePaymentMethodMode)).append("\n");
    sb.append("    telephoneNumber: ").append(toIndentedString(telephoneNumber)).append("\n");
    sb.append("    themeId: ").append(toIndentedString(themeId)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("allowedPaymentMethods");
    openapiFields.add("amount");
    openapiFields.add("applicationInfo");
    openapiFields.add("billingAddress");
    openapiFields.add("blockedPaymentMethods");
    openapiFields.add("captureDelayHours");
    openapiFields.add("countryCode");
    openapiFields.add("dateOfBirth");
    openapiFields.add("deliverAt");
    openapiFields.add("deliveryAddress");
    openapiFields.add("description");
    openapiFields.add("expiresAt");
    openapiFields.add("id");
    openapiFields.add("installmentOptions");
    openapiFields.add("lineItems");
    openapiFields.add("manualCapture");
    openapiFields.add("mcc");
    openapiFields.add("merchantAccount");
    openapiFields.add("merchantOrderReference");
    openapiFields.add("metadata");
    openapiFields.add("recurringProcessingModel");
    openapiFields.add("reference");
    openapiFields.add("requiredShopperFields");
    openapiFields.add("returnUrl");
    openapiFields.add("reusable");
    openapiFields.add("riskData");
    openapiFields.add("shopperEmail");
    openapiFields.add("shopperLocale");
    openapiFields.add("shopperName");
    openapiFields.add("shopperReference");
    openapiFields.add("shopperStatement");
    openapiFields.add("showRemovePaymentMethodButton");
    openapiFields.add("socialSecurityNumber");
    openapiFields.add("splitCardFundingSources");
    openapiFields.add("splits");
    openapiFields.add("status");
    openapiFields.add("store");
    openapiFields.add("storePaymentMethodMode");
    openapiFields.add("telephoneNumber");
    openapiFields.add("themeId");
    openapiFields.add("updatedAt");
    openapiFields.add("url");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("amount");
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("merchantAccount");
    openapiRequiredFields.add("reference");
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("url");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(PaymentLinkResponse.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PaymentLinkResponse
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PaymentLinkResponse.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentLinkResponse is not found in the empty JSON string", PaymentLinkResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PaymentLinkResponse.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PaymentLinkResponse` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : PaymentLinkResponse.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // ensure the json data is an array
      if (jsonObj.get("allowedPaymentMethods") != null && !jsonObj.get("allowedPaymentMethods").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `allowedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get("allowedPaymentMethods").toString()));
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      // validate the optional field `applicationInfo`
      if (jsonObj.getAsJsonObject("applicationInfo") != null) {
        ApplicationInfo.validateJsonObject(jsonObj.getAsJsonObject("applicationInfo"));
      }
      // validate the optional field `billingAddress`
      if (jsonObj.getAsJsonObject("billingAddress") != null) {
        Address.validateJsonObject(jsonObj.getAsJsonObject("billingAddress"));
      }
      // ensure the json data is an array
      if (jsonObj.get("blockedPaymentMethods") != null && !jsonObj.get("blockedPaymentMethods").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `blockedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get("blockedPaymentMethods").toString()));
      }
      // validate the optional field countryCode
      if (jsonObj.get("countryCode") != null && !jsonObj.get("countryCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("countryCode").toString()));
      }
      // validate the optional field `deliveryAddress`
      if (jsonObj.getAsJsonObject("deliveryAddress") != null) {
        Address.validateJsonObject(jsonObj.getAsJsonObject("deliveryAddress"));
      }
      // validate the optional field description
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // validate the optional field expiresAt
      if (jsonObj.get("expiresAt") != null && !jsonObj.get("expiresAt").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `expiresAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get("expiresAt").toString()));
      }
      // validate the optional field id
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      JsonArray jsonArraylineItems = jsonObj.getAsJsonArray("lineItems");
      if (jsonArraylineItems != null) {
        // ensure the json data is an array
        if (!jsonObj.get("lineItems").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `lineItems` to be an array in the JSON string but got `%s`", jsonObj.get("lineItems").toString()));
        }

        // validate the optional field `lineItems` (array)
        for (int i = 0; i < jsonArraylineItems.size(); i++) {
          LineItem.validateJsonObject(jsonArraylineItems.get(i).getAsJsonObject());
        }
      }
      // validate the optional field mcc
      if (jsonObj.get("mcc") != null && !jsonObj.get("mcc").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mcc").toString()));
      }
      // validate the optional field merchantAccount
      if (jsonObj.get("merchantAccount") != null && !jsonObj.get("merchantAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantAccount").toString()));
      }
      // validate the optional field merchantOrderReference
      if (jsonObj.get("merchantOrderReference") != null && !jsonObj.get("merchantOrderReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantOrderReference").toString()));
      }
      // ensure the field recurringProcessingModel can be parsed to an enum value
      if (jsonObj.get("recurringProcessingModel") != null) {
        if(!jsonObj.get("recurringProcessingModel").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `recurringProcessingModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringProcessingModel").toString()));
        }
        RecurringProcessingModelEnum.fromValue(jsonObj.get("recurringProcessingModel").getAsString());
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("requiredShopperFields") != null && !jsonObj.get("requiredShopperFields").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `requiredShopperFields` to be an array in the JSON string but got `%s`", jsonObj.get("requiredShopperFields").toString()));
      }
      // validate the optional field returnUrl
      if (jsonObj.get("returnUrl") != null && !jsonObj.get("returnUrl").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `returnUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("returnUrl").toString()));
      }
      // validate the optional field `riskData`
      if (jsonObj.getAsJsonObject("riskData") != null) {
        RiskData.validateJsonObject(jsonObj.getAsJsonObject("riskData"));
      }
      // validate the optional field shopperEmail
      if (jsonObj.get("shopperEmail") != null && !jsonObj.get("shopperEmail").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperEmail").toString()));
      }
      // validate the optional field shopperLocale
      if (jsonObj.get("shopperLocale") != null && !jsonObj.get("shopperLocale").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperLocale` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperLocale").toString()));
      }
      // validate the optional field `shopperName`
      if (jsonObj.getAsJsonObject("shopperName") != null) {
        Name.validateJsonObject(jsonObj.getAsJsonObject("shopperName"));
      }
      // validate the optional field shopperReference
      if (jsonObj.get("shopperReference") != null && !jsonObj.get("shopperReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperReference").toString()));
      }
      // validate the optional field shopperStatement
      if (jsonObj.get("shopperStatement") != null && !jsonObj.get("shopperStatement").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperStatement").toString()));
      }
      // validate the optional field socialSecurityNumber
      if (jsonObj.get("socialSecurityNumber") != null && !jsonObj.get("socialSecurityNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("socialSecurityNumber").toString()));
      }
      JsonArray jsonArraysplits = jsonObj.getAsJsonArray("splits");
      if (jsonArraysplits != null) {
        // ensure the json data is an array
        if (!jsonObj.get("splits").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get("splits").toString()));
        }

        // validate the optional field `splits` (array)
        for (int i = 0; i < jsonArraysplits.size(); i++) {
          Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
        }
      }
      // ensure the field status can be parsed to an enum value
      if (jsonObj.get("status") != null) {
        if(!jsonObj.get("status").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
        }
        StatusEnum.fromValue(jsonObj.get("status").getAsString());
      }
      // validate the optional field store
      if (jsonObj.get("store") != null && !jsonObj.get("store").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get("store").toString()));
      }
      // ensure the field storePaymentMethodMode can be parsed to an enum value
      if (jsonObj.get("storePaymentMethodMode") != null) {
        if(!jsonObj.get("storePaymentMethodMode").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `storePaymentMethodMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("storePaymentMethodMode").toString()));
        }
        StorePaymentMethodModeEnum.fromValue(jsonObj.get("storePaymentMethodMode").getAsString());
      }
      // validate the optional field telephoneNumber
      if (jsonObj.get("telephoneNumber") != null && !jsonObj.get("telephoneNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("telephoneNumber").toString()));
      }
      // validate the optional field themeId
      if (jsonObj.get("themeId") != null && !jsonObj.get("themeId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `themeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("themeId").toString()));
      }
      // validate the optional field url
      if (jsonObj.get("url") != null && !jsonObj.get("url").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("url").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PaymentLinkResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PaymentLinkResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PaymentLinkResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PaymentLinkResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<PaymentLinkResponse>() {
           @Override
           public void write(JsonWriter out, PaymentLinkResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PaymentLinkResponse read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PaymentLinkResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PaymentLinkResponse
  * @throws IOException if the JSON string is invalid with respect to PaymentLinkResponse
  */
  public static PaymentLinkResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PaymentLinkResponse.class);
  }

 /**
  * Convert an instance of PaymentLinkResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

