/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.checkout.AccountInfo;
import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.AuthenticationData;
import com.adyen.model.checkout.BrowserInfo;
import com.adyen.model.checkout.CheckoutPaymentMethod;
import com.adyen.model.checkout.Company;
import com.adyen.model.checkout.EncryptedOrderData;
import com.adyen.model.checkout.ForexQuote;
import com.adyen.model.checkout.Installments;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Mandate;
import com.adyen.model.checkout.MerchantRiskIndicator;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.PlatformChargebackLogic;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.adyen.model.checkout.ThreeDS2RequestData;
import com.adyen.model.checkout.ThreeDSecureData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * PaymentRequest
 */

public class PaymentRequest {
  public static final String SERIALIZED_NAME_ACCOUNT_INFO = "accountInfo";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_INFO)
  private AccountInfo accountInfo;

  public static final String SERIALIZED_NAME_ADDITIONAL_AMOUNT = "additionalAmount";
  @SerializedName(SERIALIZED_NAME_ADDITIONAL_AMOUNT)
  private Amount additionalAmount;

  public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
  @SerializedName(SERIALIZED_NAME_ADDITIONAL_DATA)
  private Map<String, String> additionalData = null;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Amount amount;

  public static final String SERIALIZED_NAME_APPLICATION_INFO = "applicationInfo";
  @SerializedName(SERIALIZED_NAME_APPLICATION_INFO)
  private ApplicationInfo applicationInfo;

  public static final String SERIALIZED_NAME_AUTHENTICATION_DATA = "authenticationData";
  @SerializedName(SERIALIZED_NAME_AUTHENTICATION_DATA)
  private AuthenticationData authenticationData;

  public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
  @SerializedName(SERIALIZED_NAME_BILLING_ADDRESS)
  private Address billingAddress;

  public static final String SERIALIZED_NAME_BROWSER_INFO = "browserInfo";
  @SerializedName(SERIALIZED_NAME_BROWSER_INFO)
  private BrowserInfo browserInfo;

  public static final String SERIALIZED_NAME_CAPTURE_DELAY_HOURS = "captureDelayHours";
  @SerializedName(SERIALIZED_NAME_CAPTURE_DELAY_HOURS)
  private Integer captureDelayHours;

  /**
   * The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;.  Possible values: * iOS * Android * Web
   */
  @JsonAdapter(ChannelEnum.Adapter.class)
  public enum ChannelEnum {
    IOS("iOS"),
    
    ANDROID("Android"),
    
    WEB("Web");

    private String value;

    ChannelEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ChannelEnum fromValue(String value) {
      for (ChannelEnum b : ChannelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ChannelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ChannelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ChannelEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ChannelEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CHANNEL = "channel";
  @SerializedName(SERIALIZED_NAME_CHANNEL)
  private ChannelEnum channel;

  public static final String SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  @SerializedName(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID)
  private String checkoutAttemptId;

  public static final String SERIALIZED_NAME_COMPANY = "company";
  @SerializedName(SERIALIZED_NAME_COMPANY)
  private Company company;

  public static final String SERIALIZED_NAME_CONVERSION_ID = "conversionId";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_CONVERSION_ID)
  private String conversionId;

  public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
  @SerializedName(SERIALIZED_NAME_COUNTRY_CODE)
  private String countryCode;

  public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
  @SerializedName(SERIALIZED_NAME_DATE_OF_BIRTH)
  private LocalDate dateOfBirth;

  public static final String SERIALIZED_NAME_DCC_QUOTE = "dccQuote";
  @SerializedName(SERIALIZED_NAME_DCC_QUOTE)
  private ForexQuote dccQuote;

  public static final String SERIALIZED_NAME_DELIVERY_ADDRESS = "deliveryAddress";
  @SerializedName(SERIALIZED_NAME_DELIVERY_ADDRESS)
  private Address deliveryAddress;

  public static final String SERIALIZED_NAME_DELIVERY_DATE = "deliveryDate";
  @SerializedName(SERIALIZED_NAME_DELIVERY_DATE)
  private OffsetDateTime deliveryDate;

  public static final String SERIALIZED_NAME_DEVICE_FINGERPRINT = "deviceFingerprint";
  @SerializedName(SERIALIZED_NAME_DEVICE_FINGERPRINT)
  private String deviceFingerprint;

  public static final String SERIALIZED_NAME_ENABLE_ONE_CLICK = "enableOneClick";
  @SerializedName(SERIALIZED_NAME_ENABLE_ONE_CLICK)
  private Boolean enableOneClick;

  public static final String SERIALIZED_NAME_ENABLE_PAY_OUT = "enablePayOut";
  @SerializedName(SERIALIZED_NAME_ENABLE_PAY_OUT)
  private Boolean enablePayOut;

  public static final String SERIALIZED_NAME_ENABLE_RECURRING = "enableRecurring";
  @SerializedName(SERIALIZED_NAME_ENABLE_RECURRING)
  private Boolean enableRecurring;

  /**
   * The type of the entity the payment is processed for.
   */
  @JsonAdapter(EntityTypeEnum.Adapter.class)
  public enum EntityTypeEnum {
    NATURALPERSON("NaturalPerson"),
    
    COMPANYNAME("CompanyName");

    private String value;

    EntityTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EntityTypeEnum fromValue(String value) {
      for (EntityTypeEnum b : EntityTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<EntityTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EntityTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EntityTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EntityTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ENTITY_TYPE = "entityType";
  @SerializedName(SERIALIZED_NAME_ENTITY_TYPE)
  private EntityTypeEnum entityType;

  public static final String SERIALIZED_NAME_FRAUD_OFFSET = "fraudOffset";
  @SerializedName(SERIALIZED_NAME_FRAUD_OFFSET)
  private Integer fraudOffset;

  /**
   * The reason for the amount update. Possible values:  * **delayedCharge**  * **noShow**  * **installment**
   */
  @JsonAdapter(IndustryUsageEnum.Adapter.class)
  public enum IndustryUsageEnum {
    DELAYEDCHARGE("delayedCharge"),
    
    INSTALLMENT("installment"),
    
    NOSHOW("noShow");

    private String value;

    IndustryUsageEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static IndustryUsageEnum fromValue(String value) {
      for (IndustryUsageEnum b : IndustryUsageEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<IndustryUsageEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final IndustryUsageEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public IndustryUsageEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return IndustryUsageEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INDUSTRY_USAGE = "industryUsage";
  @SerializedName(SERIALIZED_NAME_INDUSTRY_USAGE)
  private IndustryUsageEnum industryUsage;

  public static final String SERIALIZED_NAME_INSTALLMENTS = "installments";
  @SerializedName(SERIALIZED_NAME_INSTALLMENTS)
  private Installments installments;

  public static final String SERIALIZED_NAME_LINE_ITEMS = "lineItems";
  @SerializedName(SERIALIZED_NAME_LINE_ITEMS)
  private List<LineItem> lineItems = null;

  public static final String SERIALIZED_NAME_LOCALIZED_SHOPPER_STATEMENT = "localizedShopperStatement";
  @SerializedName(SERIALIZED_NAME_LOCALIZED_SHOPPER_STATEMENT)
  private Map<String, String> localizedShopperStatement = null;

  public static final String SERIALIZED_NAME_MANDATE = "mandate";
  @SerializedName(SERIALIZED_NAME_MANDATE)
  private Mandate mandate;

  public static final String SERIALIZED_NAME_MCC = "mcc";
  @SerializedName(SERIALIZED_NAME_MCC)
  private String mcc;

  public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ACCOUNT)
  private String merchantAccount;

  public static final String SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE)
  private String merchantOrderReference;

  public static final String SERIALIZED_NAME_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
  @SerializedName(SERIALIZED_NAME_MERCHANT_RISK_INDICATOR)
  private MerchantRiskIndicator merchantRiskIndicator;

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private Map<String, String> metadata = null;

  public static final String SERIALIZED_NAME_MPI_DATA = "mpiData";
  @SerializedName(SERIALIZED_NAME_MPI_DATA)
  private ThreeDSecureData mpiData;

  public static final String SERIALIZED_NAME_ORDER = "order";
  @SerializedName(SERIALIZED_NAME_ORDER)
  private EncryptedOrderData order;

  public static final String SERIALIZED_NAME_ORDER_REFERENCE = "orderReference";
  @SerializedName(SERIALIZED_NAME_ORDER_REFERENCE)
  private String orderReference;

  public static final String SERIALIZED_NAME_ORIGIN = "origin";
  @SerializedName(SERIALIZED_NAME_ORIGIN)
  private String origin;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD)
  private CheckoutPaymentMethod paymentMethod;

  public static final String SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
  @SerializedName(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC)
  private PlatformChargebackLogic platformChargebackLogic;

  public static final String SERIALIZED_NAME_RECURRING_EXPIRY = "recurringExpiry";
  @SerializedName(SERIALIZED_NAME_RECURRING_EXPIRY)
  private String recurringExpiry;

  public static final String SERIALIZED_NAME_RECURRING_FREQUENCY = "recurringFrequency";
  @SerializedName(SERIALIZED_NAME_RECURRING_FREQUENCY)
  private String recurringFrequency;

  /**
   * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   */
  @JsonAdapter(RecurringProcessingModelEnum.Adapter.class)
  public enum RecurringProcessingModelEnum {
    CARDONFILE("CardOnFile"),
    
    SUBSCRIPTION("Subscription"),
    
    UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

    private String value;

    RecurringProcessingModelEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RecurringProcessingModelEnum fromValue(String value) {
      for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RecurringProcessingModelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RecurringProcessingModelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RecurringProcessingModelEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RecurringProcessingModelEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
  @SerializedName(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL)
  private RecurringProcessingModelEnum recurringProcessingModel;

  public static final String SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD = "redirectFromIssuerMethod";
  @SerializedName(SERIALIZED_NAME_REDIRECT_FROM_ISSUER_METHOD)
  private String redirectFromIssuerMethod;

  public static final String SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD = "redirectToIssuerMethod";
  @SerializedName(SERIALIZED_NAME_REDIRECT_TO_ISSUER_METHOD)
  private String redirectToIssuerMethod;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private String reference;

  public static final String SERIALIZED_NAME_RETURN_URL = "returnUrl";
  @SerializedName(SERIALIZED_NAME_RETURN_URL)
  private String returnUrl;

  public static final String SERIALIZED_NAME_RISK_DATA = "riskData";
  @SerializedName(SERIALIZED_NAME_RISK_DATA)
  private RiskData riskData;

  public static final String SERIALIZED_NAME_SESSION_VALIDITY = "sessionValidity";
  @SerializedName(SERIALIZED_NAME_SESSION_VALIDITY)
  private String sessionValidity;

  public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
  @SerializedName(SERIALIZED_NAME_SHOPPER_EMAIL)
  private String shopperEmail;

  public static final String SERIALIZED_NAME_SHOPPER_I_P = "shopperIP";
  @SerializedName(SERIALIZED_NAME_SHOPPER_I_P)
  private String shopperIP;

  /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   */
  @JsonAdapter(ShopperInteractionEnum.Adapter.class)
  public enum ShopperInteractionEnum {
    ECOMMERCE("Ecommerce"),
    
    CONTAUTH("ContAuth"),
    
    MOTO("Moto"),
    
    POS("POS");

    private String value;

    ShopperInteractionEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ShopperInteractionEnum fromValue(String value) {
      for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ShopperInteractionEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ShopperInteractionEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ShopperInteractionEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ShopperInteractionEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_SHOPPER_INTERACTION = "shopperInteraction";
  @SerializedName(SERIALIZED_NAME_SHOPPER_INTERACTION)
  private ShopperInteractionEnum shopperInteraction;

  public static final String SERIALIZED_NAME_SHOPPER_LOCALE = "shopperLocale";
  @SerializedName(SERIALIZED_NAME_SHOPPER_LOCALE)
  private String shopperLocale;

  public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
  @SerializedName(SERIALIZED_NAME_SHOPPER_NAME)
  private Name shopperName;

  public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
  @SerializedName(SERIALIZED_NAME_SHOPPER_REFERENCE)
  private String shopperReference;

  public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
  @SerializedName(SERIALIZED_NAME_SHOPPER_STATEMENT)
  private String shopperStatement;

  public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
  @SerializedName(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER)
  private String socialSecurityNumber;

  public static final String SERIALIZED_NAME_SPLITS = "splits";
  @SerializedName(SERIALIZED_NAME_SPLITS)
  private List<Split> splits = null;

  public static final String SERIALIZED_NAME_STORE = "store";
  @SerializedName(SERIALIZED_NAME_STORE)
  private String store;

  public static final String SERIALIZED_NAME_STORE_PAYMENT_METHOD = "storePaymentMethod";
  @SerializedName(SERIALIZED_NAME_STORE_PAYMENT_METHOD)
  private Boolean storePaymentMethod;

  public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
  @SerializedName(SERIALIZED_NAME_TELEPHONE_NUMBER)
  private String telephoneNumber;

  public static final String SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
  @SerializedName(SERIALIZED_NAME_THREE_D_S2_REQUEST_DATA)
  private ThreeDS2RequestData threeDS2RequestData;

  public static final String SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_THREE_D_S_AUTHENTICATION_ONLY)
  private Boolean threeDSAuthenticationOnly = false;

  public static final String SERIALIZED_NAME_TRUSTED_SHOPPER = "trustedShopper";
  @SerializedName(SERIALIZED_NAME_TRUSTED_SHOPPER)
  private Boolean trustedShopper;

  public PaymentRequest() { 
  }

  public PaymentRequest accountInfo(AccountInfo accountInfo) {
    
    this.accountInfo = accountInfo;
    return this;
  }

   /**
   * Get accountInfo
   * @return accountInfo
  **/
  @ApiModelProperty(value = "")

  public AccountInfo getAccountInfo() {
    return accountInfo;
  }


  public void setAccountInfo(AccountInfo accountInfo) {
    this.accountInfo = accountInfo;
  }


  public PaymentRequest additionalAmount(Amount additionalAmount) {
    
    this.additionalAmount = additionalAmount;
    return this;
  }

   /**
   * Get additionalAmount
   * @return additionalAmount
  **/
  @ApiModelProperty(value = "")

  public Amount getAdditionalAmount() {
    return additionalAmount;
  }


  public void setAdditionalAmount(Amount additionalAmount) {
    this.additionalAmount = additionalAmount;
  }


  public PaymentRequest additionalData(Map<String, String> additionalData) {
    
    this.additionalData = additionalData;
    return this;
  }

  public PaymentRequest putAdditionalDataItem(String key, String additionalDataItem) {
    if (this.additionalData == null) {
      this.additionalData = new HashMap<>();
    }
    this.additionalData.put(key, additionalDataItem);
    return this;
  }

   /**
   * This field contains additional data, which may be required for a particular payment request.  The &#x60;additionalData&#x60; object consists of entries, each of which includes the key and value.
   * @return additionalData
  **/
  @ApiModelProperty(value = "This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")

  public Map<String, String> getAdditionalData() {
    return additionalData;
  }


  public void setAdditionalData(Map<String, String> additionalData) {
    this.additionalData = additionalData;
  }


  public PaymentRequest amount(Amount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "")

  public Amount getAmount() {
    return amount;
  }


  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public PaymentRequest applicationInfo(ApplicationInfo applicationInfo) {
    
    this.applicationInfo = applicationInfo;
    return this;
  }

   /**
   * Get applicationInfo
   * @return applicationInfo
  **/
  @ApiModelProperty(value = "")

  public ApplicationInfo getApplicationInfo() {
    return applicationInfo;
  }


  public void setApplicationInfo(ApplicationInfo applicationInfo) {
    this.applicationInfo = applicationInfo;
  }


  public PaymentRequest authenticationData(AuthenticationData authenticationData) {
    
    this.authenticationData = authenticationData;
    return this;
  }

   /**
   * Get authenticationData
   * @return authenticationData
  **/
  @ApiModelProperty(value = "")

  public AuthenticationData getAuthenticationData() {
    return authenticationData;
  }


  public void setAuthenticationData(AuthenticationData authenticationData) {
    this.authenticationData = authenticationData;
  }


  public PaymentRequest billingAddress(Address billingAddress) {
    
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @ApiModelProperty(value = "")

  public Address getBillingAddress() {
    return billingAddress;
  }


  public void setBillingAddress(Address billingAddress) {
    this.billingAddress = billingAddress;
  }


  public PaymentRequest browserInfo(BrowserInfo browserInfo) {
    
    this.browserInfo = browserInfo;
    return this;
  }

   /**
   * Get browserInfo
   * @return browserInfo
  **/
  @ApiModelProperty(value = "")

  public BrowserInfo getBrowserInfo() {
    return browserInfo;
  }


  public void setBrowserInfo(BrowserInfo browserInfo) {
    this.browserInfo = browserInfo;
  }


  public PaymentRequest captureDelayHours(Integer captureDelayHours) {
    
    this.captureDelayHours = captureDelayHours;
    return this;
  }

   /**
   * The delay between the authorisation and scheduled auto-capture, specified in hours.
   * @return captureDelayHours
  **/
  @ApiModelProperty(value = "The delay between the authorisation and scheduled auto-capture, specified in hours.")

  public Integer getCaptureDelayHours() {
    return captureDelayHours;
  }


  public void setCaptureDelayHours(Integer captureDelayHours) {
    this.captureDelayHours = captureDelayHours;
  }


  public PaymentRequest channel(ChannelEnum channel) {
    
    this.channel = channel;
    return this;
  }

   /**
   * The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the &#x60;sdkVersion&#x60; or &#x60;token&#x60;.  Possible values: * iOS * Android * Web
   * @return channel
  **/
  @ApiModelProperty(value = "The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the `sdkVersion` or `token`.  Possible values: * iOS * Android * Web")

  public ChannelEnum getChannel() {
    return channel;
  }


  public void setChannel(ChannelEnum channel) {
    this.channel = channel;
  }


  public PaymentRequest checkoutAttemptId(String checkoutAttemptId) {
    
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

   /**
   * Checkout attempt ID that corresponds to the Id generated by the client SDK for tracking user payment journey.
   * @return checkoutAttemptId
  **/
  @ApiModelProperty(value = "Checkout attempt ID that corresponds to the Id generated by the client SDK for tracking user payment journey.")

  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }


  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }


  public PaymentRequest company(Company company) {
    
    this.company = company;
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @ApiModelProperty(value = "")

  public Company getCompany() {
    return company;
  }


  public void setCompany(Company company) {
    this.company = company;
  }


  @Deprecated
  public PaymentRequest conversionId(String conversionId) {
    
    this.conversionId = conversionId;
    return this;
  }

   /**
   * Conversion ID that corresponds to the Id generated by the client SDK for tracking user payment journey.
   * @return conversionId
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "Conversion ID that corresponds to the Id generated by the client SDK for tracking user payment journey.")

  public String getConversionId() {
    return conversionId;
  }


  @Deprecated
  public void setConversionId(String conversionId) {
    this.conversionId = conversionId;
  }


  public PaymentRequest countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * The shopper country.  Format: [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
   * @return countryCode
  **/
  @ApiModelProperty(value = "The shopper country.  Format: [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE")

  public String getCountryCode() {
    return countryCode;
  }


  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public PaymentRequest dateOfBirth(LocalDate dateOfBirth) {
    
    this.dateOfBirth = dateOfBirth;
    return this;
  }

   /**
   * The shopper&#39;s date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
   * @return dateOfBirth
  **/
  @ApiModelProperty(value = "The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }


  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }


  public PaymentRequest dccQuote(ForexQuote dccQuote) {
    
    this.dccQuote = dccQuote;
    return this;
  }

   /**
   * Get dccQuote
   * @return dccQuote
  **/
  @ApiModelProperty(value = "")

  public ForexQuote getDccQuote() {
    return dccQuote;
  }


  public void setDccQuote(ForexQuote dccQuote) {
    this.dccQuote = dccQuote;
  }


  public PaymentRequest deliveryAddress(Address deliveryAddress) {
    
    this.deliveryAddress = deliveryAddress;
    return this;
  }

   /**
   * Get deliveryAddress
   * @return deliveryAddress
  **/
  @ApiModelProperty(value = "")

  public Address getDeliveryAddress() {
    return deliveryAddress;
  }


  public void setDeliveryAddress(Address deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }


  public PaymentRequest deliveryDate(OffsetDateTime deliveryDate) {
    
    this.deliveryDate = deliveryDate;
    return this;
  }

   /**
   * The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
   * @return deliveryDate
  **/
  @ApiModelProperty(value = "The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00")

  public OffsetDateTime getDeliveryDate() {
    return deliveryDate;
  }


  public void setDeliveryDate(OffsetDateTime deliveryDate) {
    this.deliveryDate = deliveryDate;
  }


  public PaymentRequest deviceFingerprint(String deviceFingerprint) {
    
    this.deviceFingerprint = deviceFingerprint;
    return this;
  }

   /**
   * A string containing the shopper&#39;s device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).
   * @return deviceFingerprint
  **/
  @ApiModelProperty(value = "A string containing the shopper's device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).")

  public String getDeviceFingerprint() {
    return deviceFingerprint;
  }


  public void setDeviceFingerprint(String deviceFingerprint) {
    this.deviceFingerprint = deviceFingerprint;
  }


  public PaymentRequest enableOneClick(Boolean enableOneClick) {
    
    this.enableOneClick = enableOneClick;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the shopper will be asked if the payment details should be stored for future one-click payments.
   * @return enableOneClick
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the shopper will be asked if the payment details should be stored for future one-click payments.")

  public Boolean getEnableOneClick() {
    return enableOneClick;
  }


  public void setEnableOneClick(Boolean enableOneClick) {
    this.enableOneClick = enableOneClick;
  }


  public PaymentRequest enablePayOut(Boolean enablePayOut) {
    
    this.enablePayOut = enablePayOut;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized for payouts.
   * @return enablePayOut
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be tokenized for payouts.")

  public Boolean getEnablePayOut() {
    return enablePayOut;
  }


  public void setEnablePayOut(Boolean enablePayOut) {
    this.enablePayOut = enablePayOut;
  }


  public PaymentRequest enableRecurring(Boolean enableRecurring) {
    
    this.enableRecurring = enableRecurring;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be tokenized for recurring payments.
   * @return enableRecurring
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be tokenized for recurring payments.")

  public Boolean getEnableRecurring() {
    return enableRecurring;
  }


  public void setEnableRecurring(Boolean enableRecurring) {
    this.enableRecurring = enableRecurring;
  }


  public PaymentRequest entityType(EntityTypeEnum entityType) {
    
    this.entityType = entityType;
    return this;
  }

   /**
   * The type of the entity the payment is processed for.
   * @return entityType
  **/
  @ApiModelProperty(value = "The type of the entity the payment is processed for.")

  public EntityTypeEnum getEntityType() {
    return entityType;
  }


  public void setEntityType(EntityTypeEnum entityType) {
    this.entityType = entityType;
  }


  public PaymentRequest fraudOffset(Integer fraudOffset) {
    
    this.fraudOffset = fraudOffset;
    return this;
  }

   /**
   * An integer value that is added to the normal fraud score. The value can be either positive or negative.
   * @return fraudOffset
  **/
  @ApiModelProperty(value = "An integer value that is added to the normal fraud score. The value can be either positive or negative.")

  public Integer getFraudOffset() {
    return fraudOffset;
  }


  public void setFraudOffset(Integer fraudOffset) {
    this.fraudOffset = fraudOffset;
  }


  public PaymentRequest industryUsage(IndustryUsageEnum industryUsage) {
    
    this.industryUsage = industryUsage;
    return this;
  }

   /**
   * The reason for the amount update. Possible values:  * **delayedCharge**  * **noShow**  * **installment**
   * @return industryUsage
  **/
  @ApiModelProperty(value = "The reason for the amount update. Possible values:  * **delayedCharge**  * **noShow**  * **installment**")

  public IndustryUsageEnum getIndustryUsage() {
    return industryUsage;
  }


  public void setIndustryUsage(IndustryUsageEnum industryUsage) {
    this.industryUsage = industryUsage;
  }


  public PaymentRequest installments(Installments installments) {
    
    this.installments = installments;
    return this;
  }

   /**
   * Get installments
   * @return installments
  **/
  @ApiModelProperty(value = "")

  public Installments getInstallments() {
    return installments;
  }


  public void setInstallments(Installments installments) {
    this.installments = installments;
  }


  public PaymentRequest lineItems(List<LineItem> lineItems) {
    
    this.lineItems = lineItems;
    return this;
  }

  public PaymentRequest addLineItemsItem(LineItem lineItemsItem) {
    if (this.lineItems == null) {
      this.lineItems = new ArrayList<>();
    }
    this.lineItems.add(lineItemsItem);
    return this;
  }

   /**
   * Price and product information of the refunded items, required for [partial refunds](https://docs.adyen.com/online-payments/refund#refund-a-payment). &gt; This field is required for partial refunds with 3x 4x Oney, Affirm, Afterpay, Atome, Clearpay, Klarna, Ratepay, Walley, and Zip.
   * @return lineItems
  **/
  @ApiModelProperty(value = "Price and product information of the refunded items, required for [partial refunds](https://docs.adyen.com/online-payments/refund#refund-a-payment). > This field is required for partial refunds with 3x 4x Oney, Affirm, Afterpay, Atome, Clearpay, Klarna, Ratepay, Walley, and Zip.")

  public List<LineItem> getLineItems() {
    return lineItems;
  }


  public void setLineItems(List<LineItem> lineItems) {
    this.lineItems = lineItems;
  }


  public PaymentRequest localizedShopperStatement(Map<String, String> localizedShopperStatement) {
    
    this.localizedShopperStatement = localizedShopperStatement;
    return this;
  }

  public PaymentRequest putLocalizedShopperStatementItem(String key, String localizedShopperStatementItem) {
    if (this.localizedShopperStatement == null) {
      this.localizedShopperStatement = new HashMap<>();
    }
    this.localizedShopperStatement.put(key, localizedShopperStatementItem);
    return this;
  }

   /**
   * This field allows merchants to use dynamic shopper statement in local character sets. The local shopper statement field can be supplied in markets where localized merchant descriptors are used. Currently, Adyen only supports this in the Japanese market .The available character sets at the moment are: * Processing in Japan: **ja-Kana** The character set **ja-Kana** supports UTF-8 based Katakana and alphanumeric and special characters. Merchants can use half-width or full-width characters. An example request would be: &gt; {   \&quot;shopperStatement\&quot; : \&quot;ADYEN - SELLER-A\&quot;,   \&quot;localizedShopperStatement\&quot; : {     \&quot;ja-Kana\&quot; : \&quot;ADYEN - セラーA\&quot;   } } We recommend merchants to always supply the field localizedShopperStatement in addition to the field shopperStatement.It is issuer dependent whether the localized shopper statement field is supported. In the case of non-domestic transactions (e.g. US-issued cards processed in JP) the field &#x60;shopperStatement&#x60; is used to modify the statement of the shopper. Adyen handles the complexity of ensuring the correct descriptors are assigned. Please note, this field can be used for only Visa and Mastercard transactions.
   * @return localizedShopperStatement
  **/
  @ApiModelProperty(value = "This field allows merchants to use dynamic shopper statement in local character sets. The local shopper statement field can be supplied in markets where localized merchant descriptors are used. Currently, Adyen only supports this in the Japanese market .The available character sets at the moment are: * Processing in Japan: **ja-Kana** The character set **ja-Kana** supports UTF-8 based Katakana and alphanumeric and special characters. Merchants can use half-width or full-width characters. An example request would be: > {   \"shopperStatement\" : \"ADYEN - SELLER-A\",   \"localizedShopperStatement\" : {     \"ja-Kana\" : \"ADYEN - セラーA\"   } } We recommend merchants to always supply the field localizedShopperStatement in addition to the field shopperStatement.It is issuer dependent whether the localized shopper statement field is supported. In the case of non-domestic transactions (e.g. US-issued cards processed in JP) the field `shopperStatement` is used to modify the statement of the shopper. Adyen handles the complexity of ensuring the correct descriptors are assigned. Please note, this field can be used for only Visa and Mastercard transactions.")

  public Map<String, String> getLocalizedShopperStatement() {
    return localizedShopperStatement;
  }


  public void setLocalizedShopperStatement(Map<String, String> localizedShopperStatement) {
    this.localizedShopperStatement = localizedShopperStatement;
  }


  public PaymentRequest mandate(Mandate mandate) {
    
    this.mandate = mandate;
    return this;
  }

   /**
   * Get mandate
   * @return mandate
  **/
  @ApiModelProperty(value = "")

  public Mandate getMandate() {
    return mandate;
  }


  public void setMandate(Mandate mandate) {
    this.mandate = mandate;
  }


  public PaymentRequest mcc(String mcc) {
    
    this.mcc = mcc;
    return this;
  }

   /**
   * The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.
   * @return mcc
  **/
  @ApiModelProperty(value = "The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")

  public String getMcc() {
    return mcc;
  }


  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  public PaymentRequest merchantAccount(String merchantAccount) {
    
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account identifier, with which you want to process the transaction.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account identifier, with which you want to process the transaction.")

  public String getMerchantAccount() {
    return merchantAccount;
  }


  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public PaymentRequest merchantOrderReference(String merchantOrderReference) {
    
    this.merchantOrderReference = merchantOrderReference;
    return this;
  }

   /**
   * This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. &gt; We strongly recommend you send the &#x60;merchantOrderReference&#x60; value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide &#x60;retry.orderAttemptNumber&#x60;, &#x60;retry.chainAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values in &#x60;PaymentRequest.additionalData&#x60;.
   * @return merchantOrderReference
  **/
  @ApiModelProperty(value = "This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. > We strongly recommend you send the `merchantOrderReference` value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide `retry.orderAttemptNumber`, `retry.chainAttemptNumber`, and `retry.skipRetry` values in `PaymentRequest.additionalData`.")

  public String getMerchantOrderReference() {
    return merchantOrderReference;
  }


  public void setMerchantOrderReference(String merchantOrderReference) {
    this.merchantOrderReference = merchantOrderReference;
  }


  public PaymentRequest merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
    
    this.merchantRiskIndicator = merchantRiskIndicator;
    return this;
  }

   /**
   * Get merchantRiskIndicator
   * @return merchantRiskIndicator
  **/
  @ApiModelProperty(value = "")

  public MerchantRiskIndicator getMerchantRiskIndicator() {
    return merchantRiskIndicator;
  }


  public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
    this.merchantRiskIndicator = merchantRiskIndicator;
  }


  public PaymentRequest metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public PaymentRequest putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \&quot;177\&quot; error occurs: \&quot;Metadata size exceeds limit\&quot;. * Maximum 20 characters per key. * Maximum 80 characters per value. 
   * @return metadata
  **/
  @ApiModelProperty(value = "Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \"177\" error occurs: \"Metadata size exceeds limit\". * Maximum 20 characters per key. * Maximum 80 characters per value. ")

  public Map<String, String> getMetadata() {
    return metadata;
  }


  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public PaymentRequest mpiData(ThreeDSecureData mpiData) {
    
    this.mpiData = mpiData;
    return this;
  }

   /**
   * Get mpiData
   * @return mpiData
  **/
  @ApiModelProperty(value = "")

  public ThreeDSecureData getMpiData() {
    return mpiData;
  }


  public void setMpiData(ThreeDSecureData mpiData) {
    this.mpiData = mpiData;
  }


  public PaymentRequest order(EncryptedOrderData order) {
    
    this.order = order;
    return this;
  }

   /**
   * Get order
   * @return order
  **/
  @ApiModelProperty(value = "")

  public EncryptedOrderData getOrder() {
    return order;
  }


  public void setOrder(EncryptedOrderData order) {
    this.order = order;
  }


  public PaymentRequest orderReference(String orderReference) {
    
    this.orderReference = orderReference;
    return this;
  }

   /**
   * When you are doing multiple partial (gift card) payments, this is the &#x60;pspReference&#x60; of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the &#x60;merchantOrderReference&#x60;instead.
   * @return orderReference
  **/
  @ApiModelProperty(value = "When you are doing multiple partial (gift card) payments, this is the `pspReference` of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the `merchantOrderReference`instead.")

  public String getOrderReference() {
    return orderReference;
  }


  public void setOrderReference(String orderReference) {
    this.orderReference = orderReference;
  }


  public PaymentRequest origin(String origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * Required for the 3D Secure 2 &#x60;channel&#x60; **Web** integration.  Set this parameter to the origin URL of the page that you are loading the 3D Secure Component from.
   * @return origin
  **/
  @ApiModelProperty(value = "Required for the 3D Secure 2 `channel` **Web** integration.  Set this parameter to the origin URL of the page that you are loading the 3D Secure Component from.")

  public String getOrigin() {
    return origin;
  }


  public void setOrigin(String origin) {
    this.origin = origin;
  }


  public PaymentRequest paymentMethod(CheckoutPaymentMethod paymentMethod) {
    
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * Get paymentMethod
   * @return paymentMethod
  **/
  @ApiModelProperty(required = true, value = "")

  public CheckoutPaymentMethod getPaymentMethod() {
    return paymentMethod;
  }


  public void setPaymentMethod(CheckoutPaymentMethod paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  public PaymentRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    
    this.platformChargebackLogic = platformChargebackLogic;
    return this;
  }

   /**
   * Get platformChargebackLogic
   * @return platformChargebackLogic
  **/
  @ApiModelProperty(value = "")

  public PlatformChargebackLogic getPlatformChargebackLogic() {
    return platformChargebackLogic;
  }


  public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
    this.platformChargebackLogic = platformChargebackLogic;
  }


  public PaymentRequest recurringExpiry(String recurringExpiry) {
    
    this.recurringExpiry = recurringExpiry;
    return this;
  }

   /**
   * Date after which no further authorisations shall be performed. Only for 3D Secure 2.
   * @return recurringExpiry
  **/
  @ApiModelProperty(value = "Date after which no further authorisations shall be performed. Only for 3D Secure 2.")

  public String getRecurringExpiry() {
    return recurringExpiry;
  }


  public void setRecurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
  }


  public PaymentRequest recurringFrequency(String recurringFrequency) {
    
    this.recurringFrequency = recurringFrequency;
    return this;
  }

   /**
   * Minimum number of days between authorisations. Only for 3D Secure 2.
   * @return recurringFrequency
  **/
  @ApiModelProperty(value = "Minimum number of days between authorisations. Only for 3D Secure 2.")

  public String getRecurringFrequency() {
    return recurringFrequency;
  }


  public void setRecurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
  }


  public PaymentRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    
    this.recurringProcessingModel = recurringProcessingModel;
    return this;
  }

   /**
   * Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * &#x60;Subscription&#x60; – A transaction for a fixed or variable amount, which follows a fixed schedule. * &#x60;CardOnFile&#x60; – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * &#x60;UnscheduledCardOnFile&#x60; – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder&#39;s balance drops below a certain amount. 
   * @return recurringProcessingModel
  **/
  @ApiModelProperty(value = "Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * `Subscription` – A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")

  public RecurringProcessingModelEnum getRecurringProcessingModel() {
    return recurringProcessingModel;
  }


  public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
    this.recurringProcessingModel = recurringProcessingModel;
  }


  public PaymentRequest redirectFromIssuerMethod(String redirectFromIssuerMethod) {
    
    this.redirectFromIssuerMethod = redirectFromIssuerMethod;
    return this;
  }

   /**
   * Specifies the redirect method (GET or POST) when redirecting back from the issuer.
   * @return redirectFromIssuerMethod
  **/
  @ApiModelProperty(value = "Specifies the redirect method (GET or POST) when redirecting back from the issuer.")

  public String getRedirectFromIssuerMethod() {
    return redirectFromIssuerMethod;
  }


  public void setRedirectFromIssuerMethod(String redirectFromIssuerMethod) {
    this.redirectFromIssuerMethod = redirectFromIssuerMethod;
  }


  public PaymentRequest redirectToIssuerMethod(String redirectToIssuerMethod) {
    
    this.redirectToIssuerMethod = redirectToIssuerMethod;
    return this;
  }

   /**
   * Specifies the redirect method (GET or POST) when redirecting to the issuer.
   * @return redirectToIssuerMethod
  **/
  @ApiModelProperty(value = "Specifies the redirect method (GET or POST) when redirecting to the issuer.")

  public String getRedirectToIssuerMethod() {
    return redirectToIssuerMethod;
  }


  public void setRedirectToIssuerMethod(String redirectToIssuerMethod) {
    this.redirectToIssuerMethod = redirectToIssuerMethod;
  }


  public PaymentRequest reference(String reference) {
    
    this.reference = reference;
    return this;
  }

   /**
   * The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\&quot;-\&quot;). Maximum length: 80 characters.
   * @return reference
  **/
  @ApiModelProperty(required = true, value = "The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.")

  public String getReference() {
    return reference;
  }


  public void setReference(String reference) {
    this.reference = reference;
  }


  public PaymentRequest returnUrl(String returnUrl) {
    
    this.returnUrl = returnUrl;
    return this;
  }

   /**
   * The URL to return to in case of a redirection. The format depends on the channel. This URL can have a maximum of 1024 characters. * For web, include the protocol &#x60;http://&#x60; or &#x60;https://&#x60;. You can also include your own additional query parameters, for example, shopper ID or order reference number. Example: &#x60;https://your-company.com/checkout?shopperOrder&#x3D;12xy&#x60; * For iOS, use the custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app). Example: &#x60;my-app://&#x60; * For Android, use a custom URL handled by an Activity on your app. You can configure it with an [intent filter](https://developer.android.com/guide/components/intents-filters). Example: &#x60;my-app://your.package.name&#x60;
   * @return returnUrl
  **/
  @ApiModelProperty(required = true, value = "The URL to return to in case of a redirection. The format depends on the channel. This URL can have a maximum of 1024 characters. * For web, include the protocol `http://` or `https://`. You can also include your own additional query parameters, for example, shopper ID or order reference number. Example: `https://your-company.com/checkout?shopperOrder=12xy` * For iOS, use the custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app). Example: `my-app://` * For Android, use a custom URL handled by an Activity on your app. You can configure it with an [intent filter](https://developer.android.com/guide/components/intents-filters). Example: `my-app://your.package.name`")

  public String getReturnUrl() {
    return returnUrl;
  }


  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }


  public PaymentRequest riskData(RiskData riskData) {
    
    this.riskData = riskData;
    return this;
  }

   /**
   * Get riskData
   * @return riskData
  **/
  @ApiModelProperty(value = "")

  public RiskData getRiskData() {
    return riskData;
  }


  public void setRiskData(RiskData riskData) {
    this.riskData = riskData;
  }


  public PaymentRequest sessionValidity(String sessionValidity) {
    
    this.sessionValidity = sessionValidity;
    return this;
  }

   /**
   * The date and time until when the session remains valid, in [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format.  For example: 2020-07-18T15:42:40.428+01:00
   * @return sessionValidity
  **/
  @ApiModelProperty(value = "The date and time until when the session remains valid, in [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format.  For example: 2020-07-18T15:42:40.428+01:00")

  public String getSessionValidity() {
    return sessionValidity;
  }


  public void setSessionValidity(String sessionValidity) {
    this.sessionValidity = sessionValidity;
  }


  public PaymentRequest shopperEmail(String shopperEmail) {
    
    this.shopperEmail = shopperEmail;
    return this;
  }

   /**
   * The shopper&#39;s email address. We recommend that you provide this data, as it is used in velocity fraud checks. &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperEmail&#x60; for all browser-based and mobile implementations.
   * @return shopperEmail
  **/
  @ApiModelProperty(value = "The shopper's email address. We recommend that you provide this data, as it is used in velocity fraud checks. > For 3D Secure 2 transactions, schemes require `shopperEmail` for all browser-based and mobile implementations.")

  public String getShopperEmail() {
    return shopperEmail;
  }


  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }


  public PaymentRequest shopperIP(String shopperIP) {
    
    this.shopperIP = shopperIP;
    return this;
  }

   /**
   * The shopper&#39;s IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). &gt; For 3D Secure 2 transactions, schemes require &#x60;shopperIP&#x60; for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
   * @return shopperIP
  **/
  @ApiModelProperty(value = "The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")

  public String getShopperIP() {
    return shopperIP;
  }


  public void setShopperIP(String shopperIP) {
    this.shopperIP = shopperIP;
  }


  public PaymentRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
    
    this.shopperInteraction = shopperInteraction;
    return this;
  }

   /**
   * Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * &#x60;Ecommerce&#x60; - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * &#x60;ContAuth&#x60; - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * &#x60;Moto&#x60; - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * &#x60;POS&#x60; - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
   * @return shopperInteraction
  **/
  @ApiModelProperty(value = "Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")

  public ShopperInteractionEnum getShopperInteraction() {
    return shopperInteraction;
  }


  public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }


  public PaymentRequest shopperLocale(String shopperLocale) {
    
    this.shopperLocale = shopperLocale;
    return this;
  }

   /**
   * The combination of a language code and a country code to specify the language to be used in the payment.
   * @return shopperLocale
  **/
  @ApiModelProperty(value = "The combination of a language code and a country code to specify the language to be used in the payment.")

  public String getShopperLocale() {
    return shopperLocale;
  }


  public void setShopperLocale(String shopperLocale) {
    this.shopperLocale = shopperLocale;
  }


  public PaymentRequest shopperName(Name shopperName) {
    
    this.shopperName = shopperName;
    return this;
  }

   /**
   * Get shopperName
   * @return shopperName
  **/
  @ApiModelProperty(value = "")

  public Name getShopperName() {
    return shopperName;
  }


  public void setShopperName(Name shopperName) {
    this.shopperName = shopperName;
  }


  public PaymentRequest shopperReference(String shopperReference) {
    
    this.shopperReference = shopperReference;
    return this;
  }

   /**
   * Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. &gt; Your reference must not include personally identifiable information (PII), for example name or email address.
   * @return shopperReference
  **/
  @ApiModelProperty(value = "Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")

  public String getShopperReference() {
    return shopperReference;
  }


  public void setShopperReference(String shopperReference) {
    this.shopperReference = shopperReference;
  }


  public PaymentRequest shopperStatement(String shopperStatement) {
    
    this.shopperStatement = shopperStatement;
    return this;
  }

   /**
   * The text to be shown on the shopper&#39;s bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , &#39; _ - ? + * /_**.
   * @return shopperStatement
  **/
  @ApiModelProperty(value = "The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")

  public String getShopperStatement() {
    return shopperStatement;
  }


  public void setShopperStatement(String shopperStatement) {
    this.shopperStatement = shopperStatement;
  }


  public PaymentRequest socialSecurityNumber(String socialSecurityNumber) {
    
    this.socialSecurityNumber = socialSecurityNumber;
    return this;
  }

   /**
   * The shopper&#39;s social security number.
   * @return socialSecurityNumber
  **/
  @ApiModelProperty(value = "The shopper's social security number.")

  public String getSocialSecurityNumber() {
    return socialSecurityNumber;
  }


  public void setSocialSecurityNumber(String socialSecurityNumber) {
    this.socialSecurityNumber = socialSecurityNumber;
  }


  public PaymentRequest splits(List<Split> splits) {
    
    this.splits = splits;
    return this;
  }

  public PaymentRequest addSplitsItem(Split splitsItem) {
    if (this.splits == null) {
      this.splits = new ArrayList<>();
    }
    this.splits.add(splitsItem);
    return this;
  }

   /**
   * An array of objects specifying how the payment should be split when using [Adyen for Platforms](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information) or [Issuing](https://docs.adyen.com/issuing/add-manage-funds#split).
   * @return splits
  **/
  @ApiModelProperty(value = "An array of objects specifying how the payment should be split when using [Adyen for Platforms](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information) or [Issuing](https://docs.adyen.com/issuing/add-manage-funds#split).")

  public List<Split> getSplits() {
    return splits;
  }


  public void setSplits(List<Split> splits) {
    this.splits = splits;
  }


  public PaymentRequest store(String store) {
    
    this.store = store;
    return this;
  }

   /**
   * The ecommerce or point-of-sale store that is processing the payment. Used in [partner model integrations](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners#route-payments) for Adyen for Platforms.
   * @return store
  **/
  @ApiModelProperty(value = "The ecommerce or point-of-sale store that is processing the payment. Used in [partner model integrations](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners#route-payments) for Adyen for Platforms.")

  public String getStore() {
    return store;
  }


  public void setStore(String store) {
    this.store = store;
  }


  public PaymentRequest storePaymentMethod(Boolean storePaymentMethod) {
    
    this.storePaymentMethod = storePaymentMethod;
    return this;
  }

   /**
   * When true and &#x60;shopperReference&#x60; is provided, the payment details will be stored.
   * @return storePaymentMethod
  **/
  @ApiModelProperty(value = "When true and `shopperReference` is provided, the payment details will be stored.")

  public Boolean getStorePaymentMethod() {
    return storePaymentMethod;
  }


  public void setStorePaymentMethod(Boolean storePaymentMethod) {
    this.storePaymentMethod = storePaymentMethod;
  }


  public PaymentRequest telephoneNumber(String telephoneNumber) {
    
    this.telephoneNumber = telephoneNumber;
    return this;
  }

   /**
   * The shopper&#39;s telephone number.
   * @return telephoneNumber
  **/
  @ApiModelProperty(value = "The shopper's telephone number.")

  public String getTelephoneNumber() {
    return telephoneNumber;
  }


  public void setTelephoneNumber(String telephoneNumber) {
    this.telephoneNumber = telephoneNumber;
  }


  public PaymentRequest threeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
    
    this.threeDS2RequestData = threeDS2RequestData;
    return this;
  }

   /**
   * Get threeDS2RequestData
   * @return threeDS2RequestData
  **/
  @ApiModelProperty(value = "")

  public ThreeDS2RequestData getThreeDS2RequestData() {
    return threeDS2RequestData;
  }


  public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
    this.threeDS2RequestData = threeDS2RequestData;
  }


  @Deprecated
  public PaymentRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    return this;
  }

   /**
   * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
   * @return threeDSAuthenticationOnly
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")

  public Boolean getThreeDSAuthenticationOnly() {
    return threeDSAuthenticationOnly;
  }


  @Deprecated
  public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
    this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
  }


  public PaymentRequest trustedShopper(Boolean trustedShopper) {
    
    this.trustedShopper = trustedShopper;
    return this;
  }

   /**
   * Set to true if the payment should be routed to a trusted MID.
   * @return trustedShopper
  **/
  @ApiModelProperty(value = "Set to true if the payment should be routed to a trusted MID.")

  public Boolean getTrustedShopper() {
    return trustedShopper;
  }


  public void setTrustedShopper(Boolean trustedShopper) {
    this.trustedShopper = trustedShopper;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentRequest paymentRequest = (PaymentRequest) o;
    return Objects.equals(this.accountInfo, paymentRequest.accountInfo) &&
        Objects.equals(this.additionalAmount, paymentRequest.additionalAmount) &&
        Objects.equals(this.additionalData, paymentRequest.additionalData) &&
        Objects.equals(this.amount, paymentRequest.amount) &&
        Objects.equals(this.applicationInfo, paymentRequest.applicationInfo) &&
        Objects.equals(this.authenticationData, paymentRequest.authenticationData) &&
        Objects.equals(this.billingAddress, paymentRequest.billingAddress) &&
        Objects.equals(this.browserInfo, paymentRequest.browserInfo) &&
        Objects.equals(this.captureDelayHours, paymentRequest.captureDelayHours) &&
        Objects.equals(this.channel, paymentRequest.channel) &&
        Objects.equals(this.checkoutAttemptId, paymentRequest.checkoutAttemptId) &&
        Objects.equals(this.company, paymentRequest.company) &&
        Objects.equals(this.conversionId, paymentRequest.conversionId) &&
        Objects.equals(this.countryCode, paymentRequest.countryCode) &&
        Objects.equals(this.dateOfBirth, paymentRequest.dateOfBirth) &&
        Objects.equals(this.dccQuote, paymentRequest.dccQuote) &&
        Objects.equals(this.deliveryAddress, paymentRequest.deliveryAddress) &&
        Objects.equals(this.deliveryDate, paymentRequest.deliveryDate) &&
        Objects.equals(this.deviceFingerprint, paymentRequest.deviceFingerprint) &&
        Objects.equals(this.enableOneClick, paymentRequest.enableOneClick) &&
        Objects.equals(this.enablePayOut, paymentRequest.enablePayOut) &&
        Objects.equals(this.enableRecurring, paymentRequest.enableRecurring) &&
        Objects.equals(this.entityType, paymentRequest.entityType) &&
        Objects.equals(this.fraudOffset, paymentRequest.fraudOffset) &&
        Objects.equals(this.industryUsage, paymentRequest.industryUsage) &&
        Objects.equals(this.installments, paymentRequest.installments) &&
        Objects.equals(this.lineItems, paymentRequest.lineItems) &&
        Objects.equals(this.localizedShopperStatement, paymentRequest.localizedShopperStatement) &&
        Objects.equals(this.mandate, paymentRequest.mandate) &&
        Objects.equals(this.mcc, paymentRequest.mcc) &&
        Objects.equals(this.merchantAccount, paymentRequest.merchantAccount) &&
        Objects.equals(this.merchantOrderReference, paymentRequest.merchantOrderReference) &&
        Objects.equals(this.merchantRiskIndicator, paymentRequest.merchantRiskIndicator) &&
        Objects.equals(this.metadata, paymentRequest.metadata) &&
        Objects.equals(this.mpiData, paymentRequest.mpiData) &&
        Objects.equals(this.order, paymentRequest.order) &&
        Objects.equals(this.orderReference, paymentRequest.orderReference) &&
        Objects.equals(this.origin, paymentRequest.origin) &&
        Objects.equals(this.paymentMethod, paymentRequest.paymentMethod) &&
        Objects.equals(this.platformChargebackLogic, paymentRequest.platformChargebackLogic) &&
        Objects.equals(this.recurringExpiry, paymentRequest.recurringExpiry) &&
        Objects.equals(this.recurringFrequency, paymentRequest.recurringFrequency) &&
        Objects.equals(this.recurringProcessingModel, paymentRequest.recurringProcessingModel) &&
        Objects.equals(this.redirectFromIssuerMethod, paymentRequest.redirectFromIssuerMethod) &&
        Objects.equals(this.redirectToIssuerMethod, paymentRequest.redirectToIssuerMethod) &&
        Objects.equals(this.reference, paymentRequest.reference) &&
        Objects.equals(this.returnUrl, paymentRequest.returnUrl) &&
        Objects.equals(this.riskData, paymentRequest.riskData) &&
        Objects.equals(this.sessionValidity, paymentRequest.sessionValidity) &&
        Objects.equals(this.shopperEmail, paymentRequest.shopperEmail) &&
        Objects.equals(this.shopperIP, paymentRequest.shopperIP) &&
        Objects.equals(this.shopperInteraction, paymentRequest.shopperInteraction) &&
        Objects.equals(this.shopperLocale, paymentRequest.shopperLocale) &&
        Objects.equals(this.shopperName, paymentRequest.shopperName) &&
        Objects.equals(this.shopperReference, paymentRequest.shopperReference) &&
        Objects.equals(this.shopperStatement, paymentRequest.shopperStatement) &&
        Objects.equals(this.socialSecurityNumber, paymentRequest.socialSecurityNumber) &&
        Objects.equals(this.splits, paymentRequest.splits) &&
        Objects.equals(this.store, paymentRequest.store) &&
        Objects.equals(this.storePaymentMethod, paymentRequest.storePaymentMethod) &&
        Objects.equals(this.telephoneNumber, paymentRequest.telephoneNumber) &&
        Objects.equals(this.threeDS2RequestData, paymentRequest.threeDS2RequestData) &&
        Objects.equals(this.threeDSAuthenticationOnly, paymentRequest.threeDSAuthenticationOnly) &&
        Objects.equals(this.trustedShopper, paymentRequest.trustedShopper);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountInfo, additionalAmount, additionalData, amount, applicationInfo, authenticationData, billingAddress, browserInfo, captureDelayHours, channel, checkoutAttemptId, company, conversionId, countryCode, dateOfBirth, dccQuote, deliveryAddress, deliveryDate, deviceFingerprint, enableOneClick, enablePayOut, enableRecurring, entityType, fraudOffset, industryUsage, installments, lineItems, localizedShopperStatement, mandate, mcc, merchantAccount, merchantOrderReference, merchantRiskIndicator, metadata, mpiData, order, orderReference, origin, paymentMethod, platformChargebackLogic, recurringExpiry, recurringFrequency, recurringProcessingModel, redirectFromIssuerMethod, redirectToIssuerMethod, reference, returnUrl, riskData, sessionValidity, shopperEmail, shopperIP, shopperInteraction, shopperLocale, shopperName, shopperReference, shopperStatement, socialSecurityNumber, splits, store, storePaymentMethod, telephoneNumber, threeDS2RequestData, threeDSAuthenticationOnly, trustedShopper);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentRequest {\n");
    sb.append("    accountInfo: ").append(toIndentedString(accountInfo)).append("\n");
    sb.append("    additionalAmount: ").append(toIndentedString(additionalAmount)).append("\n");
    sb.append("    additionalData: ").append(toIndentedString(additionalData)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    applicationInfo: ").append(toIndentedString(applicationInfo)).append("\n");
    sb.append("    authenticationData: ").append(toIndentedString(authenticationData)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    browserInfo: ").append(toIndentedString(browserInfo)).append("\n");
    sb.append("    captureDelayHours: ").append(toIndentedString(captureDelayHours)).append("\n");
    sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    conversionId: ").append(toIndentedString(conversionId)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    dateOfBirth: ").append(toIndentedString(dateOfBirth)).append("\n");
    sb.append("    dccQuote: ").append(toIndentedString(dccQuote)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    deliveryDate: ").append(toIndentedString(deliveryDate)).append("\n");
    sb.append("    deviceFingerprint: ").append(toIndentedString(deviceFingerprint)).append("\n");
    sb.append("    enableOneClick: ").append(toIndentedString(enableOneClick)).append("\n");
    sb.append("    enablePayOut: ").append(toIndentedString(enablePayOut)).append("\n");
    sb.append("    enableRecurring: ").append(toIndentedString(enableRecurring)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    fraudOffset: ").append(toIndentedString(fraudOffset)).append("\n");
    sb.append("    industryUsage: ").append(toIndentedString(industryUsage)).append("\n");
    sb.append("    installments: ").append(toIndentedString(installments)).append("\n");
    sb.append("    lineItems: ").append(toIndentedString(lineItems)).append("\n");
    sb.append("    localizedShopperStatement: ").append(toIndentedString(localizedShopperStatement)).append("\n");
    sb.append("    mandate: ").append(toIndentedString(mandate)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    merchantOrderReference: ").append(toIndentedString(merchantOrderReference)).append("\n");
    sb.append("    merchantRiskIndicator: ").append(toIndentedString(merchantRiskIndicator)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    mpiData: ").append(toIndentedString(mpiData)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    orderReference: ").append(toIndentedString(orderReference)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    platformChargebackLogic: ").append(toIndentedString(platformChargebackLogic)).append("\n");
    sb.append("    recurringExpiry: ").append(toIndentedString(recurringExpiry)).append("\n");
    sb.append("    recurringFrequency: ").append(toIndentedString(recurringFrequency)).append("\n");
    sb.append("    recurringProcessingModel: ").append(toIndentedString(recurringProcessingModel)).append("\n");
    sb.append("    redirectFromIssuerMethod: ").append(toIndentedString(redirectFromIssuerMethod)).append("\n");
    sb.append("    redirectToIssuerMethod: ").append(toIndentedString(redirectToIssuerMethod)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    returnUrl: ").append(toIndentedString(returnUrl)).append("\n");
    sb.append("    riskData: ").append(toIndentedString(riskData)).append("\n");
    sb.append("    sessionValidity: ").append(toIndentedString(sessionValidity)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    shopperIP: ").append(toIndentedString(shopperIP)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    shopperLocale: ").append(toIndentedString(shopperLocale)).append("\n");
    sb.append("    shopperName: ").append(toIndentedString(shopperName)).append("\n");
    sb.append("    shopperReference: ").append(toIndentedString(shopperReference)).append("\n");
    sb.append("    shopperStatement: ").append(toIndentedString(shopperStatement)).append("\n");
    sb.append("    socialSecurityNumber: ").append(toIndentedString(socialSecurityNumber)).append("\n");
    sb.append("    splits: ").append(toIndentedString(splits)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("    storePaymentMethod: ").append(toIndentedString(storePaymentMethod)).append("\n");
    sb.append("    telephoneNumber: ").append(toIndentedString(telephoneNumber)).append("\n");
    sb.append("    threeDS2RequestData: ").append(toIndentedString(threeDS2RequestData)).append("\n");
    sb.append("    threeDSAuthenticationOnly: ").append(toIndentedString(threeDSAuthenticationOnly)).append("\n");
    sb.append("    trustedShopper: ").append(toIndentedString(trustedShopper)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("accountInfo");
    openapiFields.add("additionalAmount");
    openapiFields.add("additionalData");
    openapiFields.add("amount");
    openapiFields.add("applicationInfo");
    openapiFields.add("authenticationData");
    openapiFields.add("billingAddress");
    openapiFields.add("browserInfo");
    openapiFields.add("captureDelayHours");
    openapiFields.add("channel");
    openapiFields.add("checkoutAttemptId");
    openapiFields.add("company");
    openapiFields.add("conversionId");
    openapiFields.add("countryCode");
    openapiFields.add("dateOfBirth");
    openapiFields.add("dccQuote");
    openapiFields.add("deliveryAddress");
    openapiFields.add("deliveryDate");
    openapiFields.add("deviceFingerprint");
    openapiFields.add("enableOneClick");
    openapiFields.add("enablePayOut");
    openapiFields.add("enableRecurring");
    openapiFields.add("entityType");
    openapiFields.add("fraudOffset");
    openapiFields.add("industryUsage");
    openapiFields.add("installments");
    openapiFields.add("lineItems");
    openapiFields.add("localizedShopperStatement");
    openapiFields.add("mandate");
    openapiFields.add("mcc");
    openapiFields.add("merchantAccount");
    openapiFields.add("merchantOrderReference");
    openapiFields.add("merchantRiskIndicator");
    openapiFields.add("metadata");
    openapiFields.add("mpiData");
    openapiFields.add("order");
    openapiFields.add("orderReference");
    openapiFields.add("origin");
    openapiFields.add("paymentMethod");
    openapiFields.add("platformChargebackLogic");
    openapiFields.add("recurringExpiry");
    openapiFields.add("recurringFrequency");
    openapiFields.add("recurringProcessingModel");
    openapiFields.add("redirectFromIssuerMethod");
    openapiFields.add("redirectToIssuerMethod");
    openapiFields.add("reference");
    openapiFields.add("returnUrl");
    openapiFields.add("riskData");
    openapiFields.add("sessionValidity");
    openapiFields.add("shopperEmail");
    openapiFields.add("shopperIP");
    openapiFields.add("shopperInteraction");
    openapiFields.add("shopperLocale");
    openapiFields.add("shopperName");
    openapiFields.add("shopperReference");
    openapiFields.add("shopperStatement");
    openapiFields.add("socialSecurityNumber");
    openapiFields.add("splits");
    openapiFields.add("store");
    openapiFields.add("storePaymentMethod");
    openapiFields.add("telephoneNumber");
    openapiFields.add("threeDS2RequestData");
    openapiFields.add("threeDSAuthenticationOnly");
    openapiFields.add("trustedShopper");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("amount");
    openapiRequiredFields.add("merchantAccount");
    openapiRequiredFields.add("paymentMethod");
    openapiRequiredFields.add("reference");
    openapiRequiredFields.add("returnUrl");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(PaymentRequest.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PaymentRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PaymentRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentRequest is not found in the empty JSON string", PaymentRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PaymentRequest.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PaymentRequest` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : PaymentRequest.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `accountInfo`
      if (jsonObj.getAsJsonObject("accountInfo") != null) {
        AccountInfo.validateJsonObject(jsonObj.getAsJsonObject("accountInfo"));
      }
      // validate the optional field `additionalAmount`
      if (jsonObj.getAsJsonObject("additionalAmount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("additionalAmount"));
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        Amount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      // validate the optional field `applicationInfo`
      if (jsonObj.getAsJsonObject("applicationInfo") != null) {
        ApplicationInfo.validateJsonObject(jsonObj.getAsJsonObject("applicationInfo"));
      }
      // validate the optional field `authenticationData`
      if (jsonObj.getAsJsonObject("authenticationData") != null) {
        AuthenticationData.validateJsonObject(jsonObj.getAsJsonObject("authenticationData"));
      }
      // validate the optional field `billingAddress`
      if (jsonObj.getAsJsonObject("billingAddress") != null) {
        Address.validateJsonObject(jsonObj.getAsJsonObject("billingAddress"));
      }
      // validate the optional field `browserInfo`
      if (jsonObj.getAsJsonObject("browserInfo") != null) {
        BrowserInfo.validateJsonObject(jsonObj.getAsJsonObject("browserInfo"));
      }
      // ensure the field channel can be parsed to an enum value
      if (jsonObj.get("channel") != null) {
        if(!jsonObj.get("channel").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `channel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("channel").toString()));
        }
        ChannelEnum.fromValue(jsonObj.get("channel").getAsString());
      }
      // validate the optional field checkoutAttemptId
      if (jsonObj.get("checkoutAttemptId") != null && !jsonObj.get("checkoutAttemptId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `checkoutAttemptId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("checkoutAttemptId").toString()));
      }
      // validate the optional field `company`
      if (jsonObj.getAsJsonObject("company") != null) {
        Company.validateJsonObject(jsonObj.getAsJsonObject("company"));
      }
      // validate the optional field conversionId
      if (jsonObj.get("conversionId") != null && !jsonObj.get("conversionId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `conversionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("conversionId").toString()));
      }
      // validate the optional field countryCode
      if (jsonObj.get("countryCode") != null && !jsonObj.get("countryCode").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("countryCode").toString()));
      }
      // validate the optional field `dccQuote`
      if (jsonObj.getAsJsonObject("dccQuote") != null) {
        ForexQuote.validateJsonObject(jsonObj.getAsJsonObject("dccQuote"));
      }
      // validate the optional field `deliveryAddress`
      if (jsonObj.getAsJsonObject("deliveryAddress") != null) {
        Address.validateJsonObject(jsonObj.getAsJsonObject("deliveryAddress"));
      }
      // validate the optional field deviceFingerprint
      if (jsonObj.get("deviceFingerprint") != null && !jsonObj.get("deviceFingerprint").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `deviceFingerprint` to be a primitive type in the JSON string but got `%s`", jsonObj.get("deviceFingerprint").toString()));
      }
      // ensure the field entityType can be parsed to an enum value
      if (jsonObj.get("entityType") != null) {
        if(!jsonObj.get("entityType").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `entityType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("entityType").toString()));
        }
        EntityTypeEnum.fromValue(jsonObj.get("entityType").getAsString());
      }
      // ensure the field industryUsage can be parsed to an enum value
      if (jsonObj.get("industryUsage") != null) {
        if(!jsonObj.get("industryUsage").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `industryUsage` to be a primitive type in the JSON string but got `%s`", jsonObj.get("industryUsage").toString()));
        }
        IndustryUsageEnum.fromValue(jsonObj.get("industryUsage").getAsString());
      }
      // validate the optional field `installments`
      if (jsonObj.getAsJsonObject("installments") != null) {
        Installments.validateJsonObject(jsonObj.getAsJsonObject("installments"));
      }
      JsonArray jsonArraylineItems = jsonObj.getAsJsonArray("lineItems");
      if (jsonArraylineItems != null) {
        // ensure the json data is an array
        if (!jsonObj.get("lineItems").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `lineItems` to be an array in the JSON string but got `%s`", jsonObj.get("lineItems").toString()));
        }

        // validate the optional field `lineItems` (array)
        for (int i = 0; i < jsonArraylineItems.size(); i++) {
          LineItem.validateJsonObject(jsonArraylineItems.get(i).getAsJsonObject());
        }
      }
      // validate the optional field `mandate`
      if (jsonObj.getAsJsonObject("mandate") != null) {
        Mandate.validateJsonObject(jsonObj.getAsJsonObject("mandate"));
      }
      // validate the optional field mcc
      if (jsonObj.get("mcc") != null && !jsonObj.get("mcc").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mcc").toString()));
      }
      // validate the optional field merchantAccount
      if (jsonObj.get("merchantAccount") != null && !jsonObj.get("merchantAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantAccount").toString()));
      }
      // validate the optional field merchantOrderReference
      if (jsonObj.get("merchantOrderReference") != null && !jsonObj.get("merchantOrderReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantOrderReference").toString()));
      }
      // validate the optional field `merchantRiskIndicator`
      if (jsonObj.getAsJsonObject("merchantRiskIndicator") != null) {
        MerchantRiskIndicator.validateJsonObject(jsonObj.getAsJsonObject("merchantRiskIndicator"));
      }
      // validate the optional field `mpiData`
      if (jsonObj.getAsJsonObject("mpiData") != null) {
        ThreeDSecureData.validateJsonObject(jsonObj.getAsJsonObject("mpiData"));
      }
      // validate the optional field `order`
      if (jsonObj.getAsJsonObject("order") != null) {
        EncryptedOrderData.validateJsonObject(jsonObj.getAsJsonObject("order"));
      }
      // validate the optional field orderReference
      if (jsonObj.get("orderReference") != null && !jsonObj.get("orderReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `orderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("orderReference").toString()));
      }
      // validate the optional field origin
      if (jsonObj.get("origin") != null && !jsonObj.get("origin").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `origin` to be a primitive type in the JSON string but got `%s`", jsonObj.get("origin").toString()));
      }
      // validate the optional field `paymentMethod`
      if (jsonObj.getAsJsonObject("paymentMethod") != null) {
        CheckoutPaymentMethod.validateJsonObject(jsonObj.getAsJsonObject("paymentMethod"));
      }
      // validate the optional field `platformChargebackLogic`
      if (jsonObj.getAsJsonObject("platformChargebackLogic") != null) {
        PlatformChargebackLogic.validateJsonObject(jsonObj.getAsJsonObject("platformChargebackLogic"));
      }
      // validate the optional field recurringExpiry
      if (jsonObj.get("recurringExpiry") != null && !jsonObj.get("recurringExpiry").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurringExpiry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringExpiry").toString()));
      }
      // validate the optional field recurringFrequency
      if (jsonObj.get("recurringFrequency") != null && !jsonObj.get("recurringFrequency").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurringFrequency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringFrequency").toString()));
      }
      // ensure the field recurringProcessingModel can be parsed to an enum value
      if (jsonObj.get("recurringProcessingModel") != null) {
        if(!jsonObj.get("recurringProcessingModel").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `recurringProcessingModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringProcessingModel").toString()));
        }
        RecurringProcessingModelEnum.fromValue(jsonObj.get("recurringProcessingModel").getAsString());
      }
      // validate the optional field redirectFromIssuerMethod
      if (jsonObj.get("redirectFromIssuerMethod") != null && !jsonObj.get("redirectFromIssuerMethod").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `redirectFromIssuerMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("redirectFromIssuerMethod").toString()));
      }
      // validate the optional field redirectToIssuerMethod
      if (jsonObj.get("redirectToIssuerMethod") != null && !jsonObj.get("redirectToIssuerMethod").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `redirectToIssuerMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("redirectToIssuerMethod").toString()));
      }
      // validate the optional field reference
      if (jsonObj.get("reference") != null && !jsonObj.get("reference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference").toString()));
      }
      // validate the optional field returnUrl
      if (jsonObj.get("returnUrl") != null && !jsonObj.get("returnUrl").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `returnUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("returnUrl").toString()));
      }
      // validate the optional field `riskData`
      if (jsonObj.getAsJsonObject("riskData") != null) {
        RiskData.validateJsonObject(jsonObj.getAsJsonObject("riskData"));
      }
      // validate the optional field sessionValidity
      if (jsonObj.get("sessionValidity") != null && !jsonObj.get("sessionValidity").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `sessionValidity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sessionValidity").toString()));
      }
      // validate the optional field shopperEmail
      if (jsonObj.get("shopperEmail") != null && !jsonObj.get("shopperEmail").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperEmail").toString()));
      }
      // validate the optional field shopperIP
      if (jsonObj.get("shopperIP") != null && !jsonObj.get("shopperIP").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperIP` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperIP").toString()));
      }
      // ensure the field shopperInteraction can be parsed to an enum value
      if (jsonObj.get("shopperInteraction") != null) {
        if(!jsonObj.get("shopperInteraction").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `shopperInteraction` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperInteraction").toString()));
        }
        ShopperInteractionEnum.fromValue(jsonObj.get("shopperInteraction").getAsString());
      }
      // validate the optional field shopperLocale
      if (jsonObj.get("shopperLocale") != null && !jsonObj.get("shopperLocale").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperLocale` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperLocale").toString()));
      }
      // validate the optional field `shopperName`
      if (jsonObj.getAsJsonObject("shopperName") != null) {
        Name.validateJsonObject(jsonObj.getAsJsonObject("shopperName"));
      }
      // validate the optional field shopperReference
      if (jsonObj.get("shopperReference") != null && !jsonObj.get("shopperReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperReference").toString()));
      }
      // validate the optional field shopperStatement
      if (jsonObj.get("shopperStatement") != null && !jsonObj.get("shopperStatement").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shopperStatement").toString()));
      }
      // validate the optional field socialSecurityNumber
      if (jsonObj.get("socialSecurityNumber") != null && !jsonObj.get("socialSecurityNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("socialSecurityNumber").toString()));
      }
      JsonArray jsonArraysplits = jsonObj.getAsJsonArray("splits");
      if (jsonArraysplits != null) {
        // ensure the json data is an array
        if (!jsonObj.get("splits").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get("splits").toString()));
        }

        // validate the optional field `splits` (array)
        for (int i = 0; i < jsonArraysplits.size(); i++) {
          Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
        }
      }
      // validate the optional field store
      if (jsonObj.get("store") != null && !jsonObj.get("store").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get("store").toString()));
      }
      // validate the optional field telephoneNumber
      if (jsonObj.get("telephoneNumber") != null && !jsonObj.get("telephoneNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("telephoneNumber").toString()));
      }
      // validate the optional field `threeDS2RequestData`
      if (jsonObj.getAsJsonObject("threeDS2RequestData") != null) {
        ThreeDS2RequestData.validateJsonObject(jsonObj.getAsJsonObject("threeDS2RequestData"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PaymentRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PaymentRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PaymentRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PaymentRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<PaymentRequest>() {
           @Override
           public void write(JsonWriter out, PaymentRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PaymentRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PaymentRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PaymentRequest
  * @throws IOException if the JSON string is invalid with respect to PaymentRequest
  */
  public static PaymentRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PaymentRequest.class);
  }

 /**
  * Convert an instance of PaymentRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

