/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.checkout.JSON;

/**
 * ResponseAdditionalData3DSecure
 */

public class ResponseAdditionalData3DSecure {
  public static final String SERIALIZED_NAME_CARD_HOLDER_INFO = "cardHolderInfo";
  @SerializedName(SERIALIZED_NAME_CARD_HOLDER_INFO)
  private String cardHolderInfo;

  public static final String SERIALIZED_NAME_CAVV = "cavv";
  @SerializedName(SERIALIZED_NAME_CAVV)
  private String cavv;

  public static final String SERIALIZED_NAME_CAVV_ALGORITHM = "cavvAlgorithm";
  @SerializedName(SERIALIZED_NAME_CAVV_ALGORITHM)
  private String cavvAlgorithm;

  public static final String SERIALIZED_NAME_SCA_EXEMPTION_REQUESTED = "scaExemptionRequested";
  @SerializedName(SERIALIZED_NAME_SCA_EXEMPTION_REQUESTED)
  private String scaExemptionRequested;

  public static final String SERIALIZED_NAME_THREEDS2_CARD_ENROLLED = "threeds2.cardEnrolled";
  @SerializedName(SERIALIZED_NAME_THREEDS2_CARD_ENROLLED)
  private Boolean threeds2CardEnrolled;

  public ResponseAdditionalData3DSecure() { 
  }

  public ResponseAdditionalData3DSecure cardHolderInfo(String cardHolderInfo) {
    
    this.cardHolderInfo = cardHolderInfo;
    return this;
  }

   /**
   * Information provided by the issuer to the cardholder. If this field is present, you need to display this information to the cardholder. 
   * @return cardHolderInfo
  **/
  @ApiModelProperty(value = "Information provided by the issuer to the cardholder. If this field is present, you need to display this information to the cardholder. ")

  public String getCardHolderInfo() {
    return cardHolderInfo;
  }


  public void setCardHolderInfo(String cardHolderInfo) {
    this.cardHolderInfo = cardHolderInfo;
  }


  public ResponseAdditionalData3DSecure cavv(String cavv) {
    
    this.cavv = cavv;
    return this;
  }

   /**
   * The Cardholder Authentication Verification Value (CAVV) for the 3D Secure authentication session, as a Base64-encoded 20-byte array.
   * @return cavv
  **/
  @ApiModelProperty(value = "The Cardholder Authentication Verification Value (CAVV) for the 3D Secure authentication session, as a Base64-encoded 20-byte array.")

  public String getCavv() {
    return cavv;
  }


  public void setCavv(String cavv) {
    this.cavv = cavv;
  }


  public ResponseAdditionalData3DSecure cavvAlgorithm(String cavvAlgorithm) {
    
    this.cavvAlgorithm = cavvAlgorithm;
    return this;
  }

   /**
   * The CAVV algorithm used.
   * @return cavvAlgorithm
  **/
  @ApiModelProperty(value = "The CAVV algorithm used.")

  public String getCavvAlgorithm() {
    return cavvAlgorithm;
  }


  public void setCavvAlgorithm(String cavvAlgorithm) {
    this.cavvAlgorithm = cavvAlgorithm;
  }


  public ResponseAdditionalData3DSecure scaExemptionRequested(String scaExemptionRequested) {
    
    this.scaExemptionRequested = scaExemptionRequested;
    return this;
  }

   /**
   * Shows the [exemption type](https://docs.adyen.com/payments-fundamentals/psd2-sca-compliance-and-implementation-guide#specifypreferenceinyourapirequest) that Adyen requested for the payment.   Possible values: * **lowValue**  * **secureCorporate**  * **trustedBeneficiary**  * **transactionRiskAnalysis** 
   * @return scaExemptionRequested
  **/
  @ApiModelProperty(value = "Shows the [exemption type](https://docs.adyen.com/payments-fundamentals/psd2-sca-compliance-and-implementation-guide#specifypreferenceinyourapirequest) that Adyen requested for the payment.   Possible values: * **lowValue**  * **secureCorporate**  * **trustedBeneficiary**  * **transactionRiskAnalysis** ")

  public String getScaExemptionRequested() {
    return scaExemptionRequested;
  }


  public void setScaExemptionRequested(String scaExemptionRequested) {
    this.scaExemptionRequested = scaExemptionRequested;
  }


  public ResponseAdditionalData3DSecure threeds2CardEnrolled(Boolean threeds2CardEnrolled) {
    
    this.threeds2CardEnrolled = threeds2CardEnrolled;
    return this;
  }

   /**
   * Indicates whether a card is enrolled for 3D Secure 2.
   * @return threeds2CardEnrolled
  **/
  @ApiModelProperty(value = "Indicates whether a card is enrolled for 3D Secure 2.")

  public Boolean getThreeds2CardEnrolled() {
    return threeds2CardEnrolled;
  }


  public void setThreeds2CardEnrolled(Boolean threeds2CardEnrolled) {
    this.threeds2CardEnrolled = threeds2CardEnrolled;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResponseAdditionalData3DSecure responseAdditionalData3DSecure = (ResponseAdditionalData3DSecure) o;
    return Objects.equals(this.cardHolderInfo, responseAdditionalData3DSecure.cardHolderInfo) &&
        Objects.equals(this.cavv, responseAdditionalData3DSecure.cavv) &&
        Objects.equals(this.cavvAlgorithm, responseAdditionalData3DSecure.cavvAlgorithm) &&
        Objects.equals(this.scaExemptionRequested, responseAdditionalData3DSecure.scaExemptionRequested) &&
        Objects.equals(this.threeds2CardEnrolled, responseAdditionalData3DSecure.threeds2CardEnrolled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardHolderInfo, cavv, cavvAlgorithm, scaExemptionRequested, threeds2CardEnrolled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResponseAdditionalData3DSecure {\n");
    sb.append("    cardHolderInfo: ").append(toIndentedString(cardHolderInfo)).append("\n");
    sb.append("    cavv: ").append(toIndentedString(cavv)).append("\n");
    sb.append("    cavvAlgorithm: ").append(toIndentedString(cavvAlgorithm)).append("\n");
    sb.append("    scaExemptionRequested: ").append(toIndentedString(scaExemptionRequested)).append("\n");
    sb.append("    threeds2CardEnrolled: ").append(toIndentedString(threeds2CardEnrolled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("cardHolderInfo");
    openapiFields.add("cavv");
    openapiFields.add("cavvAlgorithm");
    openapiFields.add("scaExemptionRequested");
    openapiFields.add("threeds2.cardEnrolled");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(ResponseAdditionalData3DSecure.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ResponseAdditionalData3DSecure
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ResponseAdditionalData3DSecure.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ResponseAdditionalData3DSecure is not found in the empty JSON string", ResponseAdditionalData3DSecure.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ResponseAdditionalData3DSecure.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ResponseAdditionalData3DSecure` properties.", entry.getKey()));
        }
      }
      // validate the optional field cardHolderInfo
      if (jsonObj.get("cardHolderInfo") != null && !jsonObj.get("cardHolderInfo").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `cardHolderInfo` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cardHolderInfo").toString()));
      }
      // validate the optional field cavv
      if (jsonObj.get("cavv") != null && !jsonObj.get("cavv").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `cavv` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cavv").toString()));
      }
      // validate the optional field cavvAlgorithm
      if (jsonObj.get("cavvAlgorithm") != null && !jsonObj.get("cavvAlgorithm").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `cavvAlgorithm` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cavvAlgorithm").toString()));
      }
      // validate the optional field scaExemptionRequested
      if (jsonObj.get("scaExemptionRequested") != null && !jsonObj.get("scaExemptionRequested").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `scaExemptionRequested` to be a primitive type in the JSON string but got `%s`", jsonObj.get("scaExemptionRequested").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ResponseAdditionalData3DSecure.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ResponseAdditionalData3DSecure' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ResponseAdditionalData3DSecure> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ResponseAdditionalData3DSecure.class));

       return (TypeAdapter<T>) new TypeAdapter<ResponseAdditionalData3DSecure>() {
           @Override
           public void write(JsonWriter out, ResponseAdditionalData3DSecure value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ResponseAdditionalData3DSecure read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ResponseAdditionalData3DSecure given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ResponseAdditionalData3DSecure
  * @throws IOException if the JSON string is invalid with respect to ResponseAdditionalData3DSecure
  */
  public static ResponseAdditionalData3DSecure fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ResponseAdditionalData3DSecure.class);
  }

 /**
  * Convert an instance of ResponseAdditionalData3DSecure to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

