/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.configurationwebhooks;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.configurationwebhooks.CardOrderItemDeliveryStatus;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.configurationwebhooks.JSON;

/**
 * CardOrderItem
 */

public class CardOrderItem {
  public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
  @SerializedName(SERIALIZED_NAME_BALANCE_PLATFORM)
  private String balancePlatform;

  public static final String SERIALIZED_NAME_CARD = "card";
  @SerializedName(SERIALIZED_NAME_CARD)
  private CardOrderItemDeliveryStatus card;

  public static final String SERIALIZED_NAME_CARD_ORDER_ITEM_REFERENCE = "cardOrderItemReference";
  @SerializedName(SERIALIZED_NAME_CARD_ORDER_ITEM_REFERENCE)
  private String cardOrderItemReference;

  public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
  @SerializedName(SERIALIZED_NAME_CREATION_DATE)
  private OffsetDateTime creationDate;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT_REFERENCE = "paymentInstrumentReference";
  @SerializedName(SERIALIZED_NAME_PAYMENT_INSTRUMENT_REFERENCE)
  private String paymentInstrumentReference;

  public static final String SERIALIZED_NAME_PIN = "pin";
  @SerializedName(SERIALIZED_NAME_PIN)
  private CardOrderItemDeliveryStatus pin;

  public static final String SERIALIZED_NAME_SHIPPING_METHOD = "shippingMethod";
  @SerializedName(SERIALIZED_NAME_SHIPPING_METHOD)
  private String shippingMethod;

  public CardOrderItem() { 
  }

  public CardOrderItem balancePlatform(String balancePlatform) {
    
    this.balancePlatform = balancePlatform;
    return this;
  }

   /**
   * The unique identifier of the balance platform.
   * @return balancePlatform
  **/
  @ApiModelProperty(value = "The unique identifier of the balance platform.")

  public String getBalancePlatform() {
    return balancePlatform;
  }


  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }


  public CardOrderItem card(CardOrderItemDeliveryStatus card) {
    
    this.card = card;
    return this;
  }

   /**
   * Get card
   * @return card
  **/
  @ApiModelProperty(value = "")

  public CardOrderItemDeliveryStatus getCard() {
    return card;
  }


  public void setCard(CardOrderItemDeliveryStatus card) {
    this.card = card;
  }


  public CardOrderItem cardOrderItemReference(String cardOrderItemReference) {
    
    this.cardOrderItemReference = cardOrderItemReference;
    return this;
  }

   /**
   * The unique identifier of the card order.
   * @return cardOrderItemReference
  **/
  @ApiModelProperty(value = "The unique identifier of the card order.")

  public String getCardOrderItemReference() {
    return cardOrderItemReference;
  }


  public void setCardOrderItemReference(String cardOrderItemReference) {
    this.cardOrderItemReference = cardOrderItemReference;
  }


  public CardOrderItem creationDate(OffsetDateTime creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.
   * @return creationDate
  **/
  @ApiModelProperty(value = "The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")

  public OffsetDateTime getCreationDate() {
    return creationDate;
  }


  public void setCreationDate(OffsetDateTime creationDate) {
    this.creationDate = creationDate;
  }


  public CardOrderItem id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The ID of the resource.
   * @return id
  **/
  @ApiModelProperty(value = "The ID of the resource.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public CardOrderItem paymentInstrumentReference(String paymentInstrumentReference) {
    
    this.paymentInstrumentReference = paymentInstrumentReference;
    return this;
  }

   /**
   * The unique identifier of the payment instrument related to the card order.
   * @return paymentInstrumentReference
  **/
  @ApiModelProperty(value = "The unique identifier of the payment instrument related to the card order.")

  public String getPaymentInstrumentReference() {
    return paymentInstrumentReference;
  }


  public void setPaymentInstrumentReference(String paymentInstrumentReference) {
    this.paymentInstrumentReference = paymentInstrumentReference;
  }


  public CardOrderItem pin(CardOrderItemDeliveryStatus pin) {
    
    this.pin = pin;
    return this;
  }

   /**
   * Get pin
   * @return pin
  **/
  @ApiModelProperty(value = "")

  public CardOrderItemDeliveryStatus getPin() {
    return pin;
  }


  public void setPin(CardOrderItemDeliveryStatus pin) {
    this.pin = pin;
  }


  public CardOrderItem shippingMethod(String shippingMethod) {
    
    this.shippingMethod = shippingMethod;
    return this;
  }

   /**
   * Shipping method used to deliver the card or the PIN.
   * @return shippingMethod
  **/
  @ApiModelProperty(value = "Shipping method used to deliver the card or the PIN.")

  public String getShippingMethod() {
    return shippingMethod;
  }


  public void setShippingMethod(String shippingMethod) {
    this.shippingMethod = shippingMethod;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardOrderItem cardOrderItem = (CardOrderItem) o;
    return Objects.equals(this.balancePlatform, cardOrderItem.balancePlatform) &&
        Objects.equals(this.card, cardOrderItem.card) &&
        Objects.equals(this.cardOrderItemReference, cardOrderItem.cardOrderItemReference) &&
        Objects.equals(this.creationDate, cardOrderItem.creationDate) &&
        Objects.equals(this.id, cardOrderItem.id) &&
        Objects.equals(this.paymentInstrumentReference, cardOrderItem.paymentInstrumentReference) &&
        Objects.equals(this.pin, cardOrderItem.pin) &&
        Objects.equals(this.shippingMethod, cardOrderItem.shippingMethod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(balancePlatform, card, cardOrderItemReference, creationDate, id, paymentInstrumentReference, pin, shippingMethod);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardOrderItem {\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    card: ").append(toIndentedString(card)).append("\n");
    sb.append("    cardOrderItemReference: ").append(toIndentedString(cardOrderItemReference)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    paymentInstrumentReference: ").append(toIndentedString(paymentInstrumentReference)).append("\n");
    sb.append("    pin: ").append(toIndentedString(pin)).append("\n");
    sb.append("    shippingMethod: ").append(toIndentedString(shippingMethod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("balancePlatform");
    openapiFields.add("card");
    openapiFields.add("cardOrderItemReference");
    openapiFields.add("creationDate");
    openapiFields.add("id");
    openapiFields.add("paymentInstrumentReference");
    openapiFields.add("pin");
    openapiFields.add("shippingMethod");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(CardOrderItem.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CardOrderItem
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (CardOrderItem.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in CardOrderItem is not found in the empty JSON string", CardOrderItem.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!CardOrderItem.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CardOrderItem` properties.", entry.getKey()));
        }
      }
      // validate the optional field balancePlatform
      if (jsonObj.get("balancePlatform") != null && !jsonObj.get("balancePlatform").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get("balancePlatform").toString()));
      }
      // validate the optional field `card`
      if (jsonObj.getAsJsonObject("card") != null) {
        CardOrderItemDeliveryStatus.validateJsonObject(jsonObj.getAsJsonObject("card"));
      }
      // validate the optional field cardOrderItemReference
      if (jsonObj.get("cardOrderItemReference") != null && !jsonObj.get("cardOrderItemReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `cardOrderItemReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cardOrderItemReference").toString()));
      }
      // validate the optional field id
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field paymentInstrumentReference
      if (jsonObj.get("paymentInstrumentReference") != null && !jsonObj.get("paymentInstrumentReference").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentInstrumentReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentInstrumentReference").toString()));
      }
      // validate the optional field `pin`
      if (jsonObj.getAsJsonObject("pin") != null) {
        CardOrderItemDeliveryStatus.validateJsonObject(jsonObj.getAsJsonObject("pin"));
      }
      // validate the optional field shippingMethod
      if (jsonObj.get("shippingMethod") != null && !jsonObj.get("shippingMethod").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shippingMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shippingMethod").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CardOrderItem.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CardOrderItem' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CardOrderItem> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CardOrderItem.class));

       return (TypeAdapter<T>) new TypeAdapter<CardOrderItem>() {
           @Override
           public void write(JsonWriter out, CardOrderItem value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public CardOrderItem read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CardOrderItem given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CardOrderItem
  * @throws IOException if the JSON string is invalid with respect to CardOrderItem
  */
  public static CardOrderItem fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CardOrderItem.class);
  }

 /**
  * Convert an instance of CardOrderItem to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

