/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.configurationwebhooks;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.configurationwebhooks.IbanAccountIdentification;
import com.adyen.model.configurationwebhooks.USLocalAccountIdentification;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import jakarta.ws.rs.core.GenericType;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

import com.adyen.model.configurationwebhooks.JSON;


public class PaymentInstrumentBankAccount extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(PaymentInstrumentBankAccount.class.getName());

    public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
        @SuppressWarnings("unchecked")
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentInstrumentBankAccount.class.isAssignableFrom(type.getRawType())) {
                return null; // this class only serializes 'PaymentInstrumentBankAccount' and its subtypes
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<IbanAccountIdentification> adapterIbanAccountIdentification = gson.getDelegateAdapter(this, TypeToken.get(IbanAccountIdentification.class));
            final TypeAdapter<USLocalAccountIdentification> adapterUSLocalAccountIdentification = gson.getDelegateAdapter(this, TypeToken.get(USLocalAccountIdentification.class));

            return (TypeAdapter<T>) new TypeAdapter<PaymentInstrumentBankAccount>() {
                @Override
                public void write(JsonWriter out, PaymentInstrumentBankAccount value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }

                    // check if the actual instance is of the type `IbanAccountIdentification`
                    if (value.getActualInstance() instanceof IbanAccountIdentification) {
                        JsonObject obj = adapterIbanAccountIdentification.toJsonTree((IbanAccountIdentification)value.getActualInstance()).getAsJsonObject();
                        elementAdapter.write(out, obj);
                        return;
                    }

                    // check if the actual instance is of the type `USLocalAccountIdentification`
                    if (value.getActualInstance() instanceof USLocalAccountIdentification) {
                        JsonObject obj = adapterUSLocalAccountIdentification.toJsonTree((USLocalAccountIdentification)value.getActualInstance()).getAsJsonObject();
                        elementAdapter.write(out, obj);
                        return;
                    }

                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: IbanAccountIdentification, USLocalAccountIdentification");
                }

                @Override
                public PaymentInstrumentBankAccount read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonObject jsonObject = elementAdapter.read(in).getAsJsonObject();

                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<>();
                    TypeAdapter actualAdapter = elementAdapter;

                    // deserialize IbanAccountIdentification
                    try {
                        // validate the JSON object to see if any exception is thrown
                        IbanAccountIdentification.validateJsonObject(jsonObject);
                        actualAdapter = adapterIbanAccountIdentification;
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'IbanAccountIdentification'");
                    } catch (Exception e) {
                        // deserialization failed, continue
                        errorMessages.add(String.format("Deserialization for IbanAccountIdentification failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'IbanAccountIdentification'", e);
                    }

                    // deserialize USLocalAccountIdentification
                    try {
                        // validate the JSON object to see if any exception is thrown
                        USLocalAccountIdentification.validateJsonObject(jsonObject);
                        actualAdapter = adapterUSLocalAccountIdentification;
                        match++;
                        log.log(Level.FINER, "Input data matches schema 'USLocalAccountIdentification'");
                    } catch (Exception e) {
                        // deserialization failed, continue
                        errorMessages.add(String.format("Deserialization for USLocalAccountIdentification failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'USLocalAccountIdentification'", e);
                    }

                    if (match == 1) {
                        PaymentInstrumentBankAccount ret = new PaymentInstrumentBankAccount();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonObject));
                        return ret;
                    }

                    throw new IOException(String.format("Failed deserialization for PaymentInstrumentBankAccount: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonObject.toString()));
                }
            }.nullSafe();
        }
    }

    // store a list of schema names defined in oneOf
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public PaymentInstrumentBankAccount() {
        super("oneOf", Boolean.FALSE);
    }

    public PaymentInstrumentBankAccount(IbanAccountIdentification o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    public PaymentInstrumentBankAccount(USLocalAccountIdentification o) {
        super("oneOf", Boolean.FALSE);
        setActualInstance(o);
    }

    static {
        schemas.put("IbanAccountIdentification", new GenericType<IbanAccountIdentification>() {
        });
        schemas.put("USLocalAccountIdentification", new GenericType<USLocalAccountIdentification>() {
        });
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return PaymentInstrumentBankAccount.schemas;
    }

    /**
     * Set the instance that matches the oneOf child schema, check
     * the instance parameter is valid against the oneOf child schemas:
     * IbanAccountIdentification, USLocalAccountIdentification
     *
     * It could be an instance of the 'oneOf' schemas.
     * The oneOf child schemas may themselves be a composed schema (allOf, anyOf, oneOf).
     */
    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof IbanAccountIdentification) {
            super.setActualInstance(instance);
            return;
        }

        if (instance instanceof USLocalAccountIdentification) {
            super.setActualInstance(instance);
            return;
        }

        throw new RuntimeException("Invalid instance type. Must be IbanAccountIdentification, USLocalAccountIdentification");
    }

    /**
     * Get the actual instance, which can be the following:
     * IbanAccountIdentification, USLocalAccountIdentification
     *
     * @return The actual instance (IbanAccountIdentification, USLocalAccountIdentification)
     */
    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    /**
     * Get the actual instance of `IbanAccountIdentification`. If the actual instance is not `IbanAccountIdentification`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `IbanAccountIdentification`
     * @throws ClassCastException if the instance is not `IbanAccountIdentification`
     */
    public IbanAccountIdentification getIbanAccountIdentification() throws ClassCastException {
        return (IbanAccountIdentification)super.getActualInstance();
    }

    /**
     * Get the actual instance of `USLocalAccountIdentification`. If the actual instance is not `USLocalAccountIdentification`,
     * the ClassCastException will be thrown.
     *
     * @return The actual instance of `USLocalAccountIdentification`
     * @throws ClassCastException if the instance is not `USLocalAccountIdentification`
     */
    public USLocalAccountIdentification getUSLocalAccountIdentification() throws ClassCastException {
        return (USLocalAccountIdentification)super.getActualInstance();
    }


 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PaymentInstrumentBankAccount
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
    // validate oneOf schemas one by one
    int validCount = 0;
    ArrayList<String> errorMessages = new ArrayList<>();
    // validate the json string with IbanAccountIdentification
    try {
      Logger.getLogger(IbanAccountIdentification.class.getName()).setLevel(Level.OFF);
      IbanAccountIdentification.validateJsonObject(jsonObj);
      validCount++;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for IbanAccountIdentification failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    // validate the json string with USLocalAccountIdentification
    try {
      Logger.getLogger(USLocalAccountIdentification.class.getName()).setLevel(Level.OFF);
      USLocalAccountIdentification.validateJsonObject(jsonObj);
      validCount++;
    } catch (Exception e) {
      errorMessages.add(String.format("Deserialization for USLocalAccountIdentification failed with `%s`.", e.getMessage()));
      // continue to the next one
    }
    if (validCount != 1) {
      throw new IOException(String.format("The JSON string is invalid for PaymentInstrumentBankAccount with oneOf schemas: IbanAccountIdentification, USLocalAccountIdentification. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonObj.toString()));
    }
  }

 /**
  * Create an instance of PaymentInstrumentBankAccount given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PaymentInstrumentBankAccount
  * @throws IOException if the JSON string is invalid with respect to PaymentInstrumentBankAccount
  */
  public static PaymentInstrumentBankAccount fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PaymentInstrumentBankAccount.class);
  }

 /**
  * Convert an instance of PaymentInstrumentBankAccount to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

