/*
 * Configuration webhooks
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.configurationwebhooks;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.configurationwebhooks.SweepConfigurationV2;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.configurationwebhooks.JSON;

/**
 * SweepConfigurationNotificationData
 */

public class SweepConfigurationNotificationData {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private String accountId;

  public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
  @SerializedName(SERIALIZED_NAME_BALANCE_PLATFORM)
  private String balancePlatform;

  public static final String SERIALIZED_NAME_SWEEP = "sweep";
  @SerializedName(SERIALIZED_NAME_SWEEP)
  private SweepConfigurationV2 sweep;

  public SweepConfigurationNotificationData() { 
  }

  public SweepConfigurationNotificationData accountId(String accountId) {
    
    this.accountId = accountId;
    return this;
  }

   /**
   * The unique identifier of the balance account for which the sweep was configured.
   * @return accountId
  **/
  @ApiModelProperty(value = "The unique identifier of the balance account for which the sweep was configured.")

  public String getAccountId() {
    return accountId;
  }


  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }


  public SweepConfigurationNotificationData balancePlatform(String balancePlatform) {
    
    this.balancePlatform = balancePlatform;
    return this;
  }

   /**
   * The unique identifier of the balance platform.
   * @return balancePlatform
  **/
  @ApiModelProperty(value = "The unique identifier of the balance platform.")

  public String getBalancePlatform() {
    return balancePlatform;
  }


  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }


  public SweepConfigurationNotificationData sweep(SweepConfigurationV2 sweep) {
    
    this.sweep = sweep;
    return this;
  }

   /**
   * Get sweep
   * @return sweep
  **/
  @ApiModelProperty(value = "")

  public SweepConfigurationV2 getSweep() {
    return sweep;
  }


  public void setSweep(SweepConfigurationV2 sweep) {
    this.sweep = sweep;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SweepConfigurationNotificationData sweepConfigurationNotificationData = (SweepConfigurationNotificationData) o;
    return Objects.equals(this.accountId, sweepConfigurationNotificationData.accountId) &&
        Objects.equals(this.balancePlatform, sweepConfigurationNotificationData.balancePlatform) &&
        Objects.equals(this.sweep, sweepConfigurationNotificationData.sweep);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, balancePlatform, sweep);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SweepConfigurationNotificationData {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    sweep: ").append(toIndentedString(sweep)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("accountId");
    openapiFields.add("balancePlatform");
    openapiFields.add("sweep");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(SweepConfigurationNotificationData.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to SweepConfigurationNotificationData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (SweepConfigurationNotificationData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in SweepConfigurationNotificationData is not found in the empty JSON string", SweepConfigurationNotificationData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!SweepConfigurationNotificationData.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `SweepConfigurationNotificationData` properties.", entry.getKey()));
        }
      }
      // validate the optional field accountId
      if (jsonObj.get("accountId") != null && !jsonObj.get("accountId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `accountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("accountId").toString()));
      }
      // validate the optional field balancePlatform
      if (jsonObj.get("balancePlatform") != null && !jsonObj.get("balancePlatform").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get("balancePlatform").toString()));
      }
      // validate the optional field `sweep`
      if (jsonObj.getAsJsonObject("sweep") != null) {
        SweepConfigurationV2.validateJsonObject(jsonObj.getAsJsonObject("sweep"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!SweepConfigurationNotificationData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'SweepConfigurationNotificationData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<SweepConfigurationNotificationData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(SweepConfigurationNotificationData.class));

       return (TypeAdapter<T>) new TypeAdapter<SweepConfigurationNotificationData>() {
           @Override
           public void write(JsonWriter out, SweepConfigurationNotificationData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public SweepConfigurationNotificationData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of SweepConfigurationNotificationData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of SweepConfigurationNotificationData
  * @throws IOException if the JSON string is invalid with respect to SweepConfigurationNotificationData
  */
  public static SweepConfigurationNotificationData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, SweepConfigurationNotificationData.class);
  }

 /**
  * Convert an instance of SweepConfigurationNotificationData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

