/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.legalentitymanagement.Address;
import com.adyen.model.legalentitymanagement.BirthData;
import com.adyen.model.legalentitymanagement.IdentificationData;
import com.adyen.model.legalentitymanagement.Name;
import com.adyen.model.legalentitymanagement.PhoneNumber;
import com.adyen.model.legalentitymanagement.TaxInformation;
import com.adyen.model.legalentitymanagement.WebData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.legalentitymanagement.JSON;

/**
 * Individual
 */

public class Individual {
  public static final String SERIALIZED_NAME_BIRTH_DATA = "birthData";
  @SerializedName(SERIALIZED_NAME_BIRTH_DATA)
  private BirthData birthData;

  public static final String SERIALIZED_NAME_EMAIL = "email";
  @SerializedName(SERIALIZED_NAME_EMAIL)
  private String email;

  public static final String SERIALIZED_NAME_IDENTIFICATION_DATA = "identificationData";
  @SerializedName(SERIALIZED_NAME_IDENTIFICATION_DATA)
  private IdentificationData identificationData;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private Name name;

  public static final String SERIALIZED_NAME_NATIONALITY = "nationality";
  @SerializedName(SERIALIZED_NAME_NATIONALITY)
  private String nationality;

  public static final String SERIALIZED_NAME_PHONE = "phone";
  @SerializedName(SERIALIZED_NAME_PHONE)
  private PhoneNumber phone;

  public static final String SERIALIZED_NAME_RESIDENTIAL_ADDRESS = "residentialAddress";
  @SerializedName(SERIALIZED_NAME_RESIDENTIAL_ADDRESS)
  private Address residentialAddress;

  public static final String SERIALIZED_NAME_TAX_INFORMATION = "taxInformation";
  @SerializedName(SERIALIZED_NAME_TAX_INFORMATION)
  private List<TaxInformation> taxInformation = null;

  public static final String SERIALIZED_NAME_WEB_DATA = "webData";
  @SerializedName(SERIALIZED_NAME_WEB_DATA)
  private WebData webData;

  public Individual() { 
  }

  public Individual birthData(BirthData birthData) {
    
    this.birthData = birthData;
    return this;
  }

   /**
   * Get birthData
   * @return birthData
  **/
  @ApiModelProperty(value = "")

  public BirthData getBirthData() {
    return birthData;
  }


  public void setBirthData(BirthData birthData) {
    this.birthData = birthData;
  }


  public Individual email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * The email address of the legal entity.
   * @return email
  **/
  @ApiModelProperty(value = "The email address of the legal entity.")

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


  public Individual identificationData(IdentificationData identificationData) {
    
    this.identificationData = identificationData;
    return this;
  }

   /**
   * Get identificationData
   * @return identificationData
  **/
  @ApiModelProperty(value = "")

  public IdentificationData getIdentificationData() {
    return identificationData;
  }


  public void setIdentificationData(IdentificationData identificationData) {
    this.identificationData = identificationData;
  }


  public Individual name(Name name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(required = true, value = "")

  public Name getName() {
    return name;
  }


  public void setName(Name name) {
    this.name = name;
  }


  public Individual nationality(String nationality) {
    
    this.nationality = nationality;
    return this;
  }

   /**
   * The individual&#39;s nationality.
   * @return nationality
  **/
  @ApiModelProperty(value = "The individual's nationality.")

  public String getNationality() {
    return nationality;
  }


  public void setNationality(String nationality) {
    this.nationality = nationality;
  }


  public Individual phone(PhoneNumber phone) {
    
    this.phone = phone;
    return this;
  }

   /**
   * Get phone
   * @return phone
  **/
  @ApiModelProperty(value = "")

  public PhoneNumber getPhone() {
    return phone;
  }


  public void setPhone(PhoneNumber phone) {
    this.phone = phone;
  }


  public Individual residentialAddress(Address residentialAddress) {
    
    this.residentialAddress = residentialAddress;
    return this;
  }

   /**
   * Get residentialAddress
   * @return residentialAddress
  **/
  @ApiModelProperty(required = true, value = "")

  public Address getResidentialAddress() {
    return residentialAddress;
  }


  public void setResidentialAddress(Address residentialAddress) {
    this.residentialAddress = residentialAddress;
  }


  public Individual taxInformation(List<TaxInformation> taxInformation) {
    
    this.taxInformation = taxInformation;
    return this;
  }

  public Individual addTaxInformationItem(TaxInformation taxInformationItem) {
    if (this.taxInformation == null) {
      this.taxInformation = new ArrayList<>();
    }
    this.taxInformation.add(taxInformationItem);
    return this;
  }

   /**
   * The tax information of the individual.
   * @return taxInformation
  **/
  @ApiModelProperty(value = "The tax information of the individual.")

  public List<TaxInformation> getTaxInformation() {
    return taxInformation;
  }


  public void setTaxInformation(List<TaxInformation> taxInformation) {
    this.taxInformation = taxInformation;
  }


  public Individual webData(WebData webData) {
    
    this.webData = webData;
    return this;
  }

   /**
   * Get webData
   * @return webData
  **/
  @ApiModelProperty(value = "")

  public WebData getWebData() {
    return webData;
  }


  public void setWebData(WebData webData) {
    this.webData = webData;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Individual individual = (Individual) o;
    return Objects.equals(this.birthData, individual.birthData) &&
        Objects.equals(this.email, individual.email) &&
        Objects.equals(this.identificationData, individual.identificationData) &&
        Objects.equals(this.name, individual.name) &&
        Objects.equals(this.nationality, individual.nationality) &&
        Objects.equals(this.phone, individual.phone) &&
        Objects.equals(this.residentialAddress, individual.residentialAddress) &&
        Objects.equals(this.taxInformation, individual.taxInformation) &&
        Objects.equals(this.webData, individual.webData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(birthData, email, identificationData, name, nationality, phone, residentialAddress, taxInformation, webData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Individual {\n");
    sb.append("    birthData: ").append(toIndentedString(birthData)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    identificationData: ").append(toIndentedString(identificationData)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nationality: ").append(toIndentedString(nationality)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    residentialAddress: ").append(toIndentedString(residentialAddress)).append("\n");
    sb.append("    taxInformation: ").append(toIndentedString(taxInformation)).append("\n");
    sb.append("    webData: ").append(toIndentedString(webData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("birthData");
    openapiFields.add("email");
    openapiFields.add("identificationData");
    openapiFields.add("name");
    openapiFields.add("nationality");
    openapiFields.add("phone");
    openapiFields.add("residentialAddress");
    openapiFields.add("taxInformation");
    openapiFields.add("webData");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("name");
    openapiRequiredFields.add("residentialAddress");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(Individual.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Individual
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Individual.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Individual is not found in the empty JSON string", Individual.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Individual.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Individual` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Individual.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `birthData`
      if (jsonObj.getAsJsonObject("birthData") != null) {
        BirthData.validateJsonObject(jsonObj.getAsJsonObject("birthData"));
      }
      // validate the optional field email
      if (jsonObj.get("email") != null && !jsonObj.get("email").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get("email").toString()));
      }
      // validate the optional field `identificationData`
      if (jsonObj.getAsJsonObject("identificationData") != null) {
        IdentificationData.validateJsonObject(jsonObj.getAsJsonObject("identificationData"));
      }
      // validate the optional field `name`
      if (jsonObj.getAsJsonObject("name") != null) {
        Name.validateJsonObject(jsonObj.getAsJsonObject("name"));
      }
      // validate the optional field nationality
      if (jsonObj.get("nationality") != null && !jsonObj.get("nationality").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `nationality` to be a primitive type in the JSON string but got `%s`", jsonObj.get("nationality").toString()));
      }
      // validate the optional field `phone`
      if (jsonObj.getAsJsonObject("phone") != null) {
        PhoneNumber.validateJsonObject(jsonObj.getAsJsonObject("phone"));
      }
      // validate the optional field `residentialAddress`
      if (jsonObj.getAsJsonObject("residentialAddress") != null) {
        Address.validateJsonObject(jsonObj.getAsJsonObject("residentialAddress"));
      }
      JsonArray jsonArraytaxInformation = jsonObj.getAsJsonArray("taxInformation");
      if (jsonArraytaxInformation != null) {
        // ensure the json data is an array
        if (!jsonObj.get("taxInformation").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `taxInformation` to be an array in the JSON string but got `%s`", jsonObj.get("taxInformation").toString()));
        }

        // validate the optional field `taxInformation` (array)
        for (int i = 0; i < jsonArraytaxInformation.size(); i++) {
          TaxInformation.validateJsonObject(jsonArraytaxInformation.get(i).getAsJsonObject());
        }
      }
      // validate the optional field `webData`
      if (jsonObj.getAsJsonObject("webData") != null) {
        WebData.validateJsonObject(jsonObj.getAsJsonObject("webData"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Individual.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Individual' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Individual> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Individual.class));

       return (TypeAdapter<T>) new TypeAdapter<Individual>() {
           @Override
           public void write(JsonWriter out, Individual value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Individual read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Individual given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Individual
  * @throws IOException if the JSON string is invalid with respect to Individual
  */
  public static Individual fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Individual.class);
  }

 /**
  * Convert an instance of Individual to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

