/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.legalentitymanagement.JSON;

/**
 * PciSigningRequest
 */

public class PciSigningRequest {
  public static final String SERIALIZED_NAME_PCI_TEMPLATE_REFERENCES = "pciTemplateReferences";
  @SerializedName(SERIALIZED_NAME_PCI_TEMPLATE_REFERENCES)
  private List<String> pciTemplateReferences = new ArrayList<>();

  public static final String SERIALIZED_NAME_SIGNED_BY = "signedBy";
  @SerializedName(SERIALIZED_NAME_SIGNED_BY)
  private String signedBy;

  public PciSigningRequest() { 
  }

  public PciSigningRequest pciTemplateReferences(List<String> pciTemplateReferences) {
    
    this.pciTemplateReferences = pciTemplateReferences;
    return this;
  }

  public PciSigningRequest addPciTemplateReferencesItem(String pciTemplateReferencesItem) {
    this.pciTemplateReferences.add(pciTemplateReferencesItem);
    return this;
  }

   /**
   * The array of Adyen-generated unique identifiers for the questionnaires.
   * @return pciTemplateReferences
  **/
  @ApiModelProperty(required = true, value = "The array of Adyen-generated unique identifiers for the questionnaires.")

  public List<String> getPciTemplateReferences() {
    return pciTemplateReferences;
  }


  public void setPciTemplateReferences(List<String> pciTemplateReferences) {
    this.pciTemplateReferences = pciTemplateReferences;
  }


  public PciSigningRequest signedBy(String signedBy) {
    
    this.signedBy = signedBy;
    return this;
  }

   /**
   * The [legal entity ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) of the individual who signs the PCI questionnaire.
   * @return signedBy
  **/
  @ApiModelProperty(required = true, value = "The [legal entity ID](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/legalEntities__resParam_id) of the individual who signs the PCI questionnaire.")

  public String getSignedBy() {
    return signedBy;
  }


  public void setSignedBy(String signedBy) {
    this.signedBy = signedBy;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PciSigningRequest pciSigningRequest = (PciSigningRequest) o;
    return Objects.equals(this.pciTemplateReferences, pciSigningRequest.pciTemplateReferences) &&
        Objects.equals(this.signedBy, pciSigningRequest.signedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pciTemplateReferences, signedBy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PciSigningRequest {\n");
    sb.append("    pciTemplateReferences: ").append(toIndentedString(pciTemplateReferences)).append("\n");
    sb.append("    signedBy: ").append(toIndentedString(signedBy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("pciTemplateReferences");
    openapiFields.add("signedBy");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("pciTemplateReferences");
    openapiRequiredFields.add("signedBy");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(PciSigningRequest.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PciSigningRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PciSigningRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PciSigningRequest is not found in the empty JSON string", PciSigningRequest.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PciSigningRequest.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PciSigningRequest` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : PciSigningRequest.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // ensure the json data is an array
      if (jsonObj.get("pciTemplateReferences") != null && !jsonObj.get("pciTemplateReferences").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `pciTemplateReferences` to be an array in the JSON string but got `%s`", jsonObj.get("pciTemplateReferences").toString()));
      }
      // validate the optional field signedBy
      if (jsonObj.get("signedBy") != null && !jsonObj.get("signedBy").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `signedBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("signedBy").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PciSigningRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PciSigningRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PciSigningRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PciSigningRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<PciSigningRequest>() {
           @Override
           public void write(JsonWriter out, PciSigningRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PciSigningRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PciSigningRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PciSigningRequest
  * @throws IOException if the JSON string is invalid with respect to PciSigningRequest
  */
  public static PciSigningRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PciSigningRequest.class);
  }

 /**
  * Convert an instance of PciSigningRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

