/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * Gratuity
 */

public class Gratuity {
  public static final String SERIALIZED_NAME_ALLOW_CUSTOM_AMOUNT = "allowCustomAmount";
  @SerializedName(SERIALIZED_NAME_ALLOW_CUSTOM_AMOUNT)
  private Boolean allowCustomAmount;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_PREDEFINED_TIP_ENTRIES = "predefinedTipEntries";
  @SerializedName(SERIALIZED_NAME_PREDEFINED_TIP_ENTRIES)
  private List<String> predefinedTipEntries = null;

  public static final String SERIALIZED_NAME_USE_PREDEFINED_TIP_ENTRIES = "usePredefinedTipEntries";
  @SerializedName(SERIALIZED_NAME_USE_PREDEFINED_TIP_ENTRIES)
  private Boolean usePredefinedTipEntries;

  public Gratuity() { 
  }

  public Gratuity allowCustomAmount(Boolean allowCustomAmount) {
    
    this.allowCustomAmount = allowCustomAmount;
    return this;
  }

   /**
   * Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in &#x60;predefinedTipEntries&#x60; are shown.
   * @return allowCustomAmount
  **/
  @ApiModelProperty(value = "Indicates whether one of the predefined tipping options is to let the shopper enter a custom tip. If **true**, only three of the other options defined in `predefinedTipEntries` are shown.")

  public Boolean getAllowCustomAmount() {
    return allowCustomAmount;
  }


  public void setAllowCustomAmount(Boolean allowCustomAmount) {
    this.allowCustomAmount = allowCustomAmount;
  }


  public Gratuity currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency that the tipping settings apply to.
   * @return currency
  **/
  @ApiModelProperty(value = "The currency that the tipping settings apply to.")

  public String getCurrency() {
    return currency;
  }


  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public Gratuity predefinedTipEntries(List<String> predefinedTipEntries) {
    
    this.predefinedTipEntries = predefinedTipEntries;
    return this;
  }

  public Gratuity addPredefinedTipEntriesItem(String predefinedTipEntriesItem) {
    if (this.predefinedTipEntries == null) {
      this.predefinedTipEntries = new ArrayList<>();
    }
    this.predefinedTipEntries.add(predefinedTipEntriesItem);
    return this;
  }

   /**
   * Tipping options the shopper can choose from if &#x60;usePredefinedTipEntries&#x60; is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.
   * @return predefinedTipEntries
  **/
  @ApiModelProperty(value = "Tipping options the shopper can choose from if `usePredefinedTipEntries` is **true**. The maximum number of predefined options is four, or three plus the option to enter a custom tip. The options can be a mix of:  - A percentage of the transaction amount. Example: **5%** - A tip amount in [minor units](https://docs.adyen.com/development-resources/currency-codes). Example: **500** for a EUR 5 tip.")

  public List<String> getPredefinedTipEntries() {
    return predefinedTipEntries;
  }


  public void setPredefinedTipEntries(List<String> predefinedTipEntries) {
    this.predefinedTipEntries = predefinedTipEntries;
  }


  public Gratuity usePredefinedTipEntries(Boolean usePredefinedTipEntries) {
    
    this.usePredefinedTipEntries = usePredefinedTipEntries;
    return this;
  }

   /**
   * Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).
   * @return usePredefinedTipEntries
  **/
  @ApiModelProperty(value = "Indicates whether the terminal shows a prompt to enter a tip (**false**), or predefined tipping options to choose from (**true**).")

  public Boolean getUsePredefinedTipEntries() {
    return usePredefinedTipEntries;
  }


  public void setUsePredefinedTipEntries(Boolean usePredefinedTipEntries) {
    this.usePredefinedTipEntries = usePredefinedTipEntries;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Gratuity gratuity = (Gratuity) o;
    return Objects.equals(this.allowCustomAmount, gratuity.allowCustomAmount) &&
        Objects.equals(this.currency, gratuity.currency) &&
        Objects.equals(this.predefinedTipEntries, gratuity.predefinedTipEntries) &&
        Objects.equals(this.usePredefinedTipEntries, gratuity.usePredefinedTipEntries);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowCustomAmount, currency, predefinedTipEntries, usePredefinedTipEntries);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Gratuity {\n");
    sb.append("    allowCustomAmount: ").append(toIndentedString(allowCustomAmount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    predefinedTipEntries: ").append(toIndentedString(predefinedTipEntries)).append("\n");
    sb.append("    usePredefinedTipEntries: ").append(toIndentedString(usePredefinedTipEntries)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("allowCustomAmount");
    openapiFields.add("currency");
    openapiFields.add("predefinedTipEntries");
    openapiFields.add("usePredefinedTipEntries");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(Gratuity.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Gratuity
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Gratuity.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Gratuity is not found in the empty JSON string", Gratuity.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Gratuity.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Gratuity` properties.", entry.getKey()));
        }
      }
      // validate the optional field currency
      if (jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("predefinedTipEntries") != null && !jsonObj.get("predefinedTipEntries").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `predefinedTipEntries` to be an array in the JSON string but got `%s`", jsonObj.get("predefinedTipEntries").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Gratuity.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Gratuity' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Gratuity> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Gratuity.class));

       return (TypeAdapter<T>) new TypeAdapter<Gratuity>() {
           @Override
           public void write(JsonWriter out, Gratuity value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Gratuity read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Gratuity given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Gratuity
  * @throws IOException if the JSON string is invalid with respect to Gratuity
  */
  public static Gratuity fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Gratuity.class);
  }

 /**
  * Convert an instance of Gratuity to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

