/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * Opi
 */

public class Opi {
  public static final String SERIALIZED_NAME_ENABLE_PAY_AT_TABLE = "enablePayAtTable";
  @SerializedName(SERIALIZED_NAME_ENABLE_PAY_AT_TABLE)
  private Boolean enablePayAtTable;

  public static final String SERIALIZED_NAME_PAY_AT_TABLE_STORE_NUMBER = "payAtTableStoreNumber";
  @SerializedName(SERIALIZED_NAME_PAY_AT_TABLE_STORE_NUMBER)
  private String payAtTableStoreNumber;

  public static final String SERIALIZED_NAME_PAY_AT_TABLE_U_R_L = "payAtTableURL";
  @SerializedName(SERIALIZED_NAME_PAY_AT_TABLE_U_R_L)
  private String payAtTableURL;

  public Opi() { 
  }

  public Opi enablePayAtTable(Boolean enablePayAtTable) {
    
    this.enablePayAtTable = enablePayAtTable;
    return this;
  }

   /**
   * Indicates if Pay at table is enabled.
   * @return enablePayAtTable
  **/
  @ApiModelProperty(value = "Indicates if Pay at table is enabled.")

  public Boolean getEnablePayAtTable() {
    return enablePayAtTable;
  }


  public void setEnablePayAtTable(Boolean enablePayAtTable) {
    this.enablePayAtTable = enablePayAtTable;
  }


  public Opi payAtTableStoreNumber(String payAtTableStoreNumber) {
    
    this.payAtTableStoreNumber = payAtTableStoreNumber;
    return this;
  }

   /**
   * The store number to use for Pay at Table.
   * @return payAtTableStoreNumber
  **/
  @ApiModelProperty(value = "The store number to use for Pay at Table.")

  public String getPayAtTableStoreNumber() {
    return payAtTableStoreNumber;
  }


  public void setPayAtTableStoreNumber(String payAtTableStoreNumber) {
    this.payAtTableStoreNumber = payAtTableStoreNumber;
  }


  public Opi payAtTableURL(String payAtTableURL) {
    
    this.payAtTableURL = payAtTableURL;
    return this;
  }

   /**
   * The URL and port number used for Pay at Table communication.
   * @return payAtTableURL
  **/
  @ApiModelProperty(value = "The URL and port number used for Pay at Table communication.")

  public String getPayAtTableURL() {
    return payAtTableURL;
  }


  public void setPayAtTableURL(String payAtTableURL) {
    this.payAtTableURL = payAtTableURL;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Opi opi = (Opi) o;
    return Objects.equals(this.enablePayAtTable, opi.enablePayAtTable) &&
        Objects.equals(this.payAtTableStoreNumber, opi.payAtTableStoreNumber) &&
        Objects.equals(this.payAtTableURL, opi.payAtTableURL);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enablePayAtTable, payAtTableStoreNumber, payAtTableURL);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Opi {\n");
    sb.append("    enablePayAtTable: ").append(toIndentedString(enablePayAtTable)).append("\n");
    sb.append("    payAtTableStoreNumber: ").append(toIndentedString(payAtTableStoreNumber)).append("\n");
    sb.append("    payAtTableURL: ").append(toIndentedString(payAtTableURL)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("enablePayAtTable");
    openapiFields.add("payAtTableStoreNumber");
    openapiFields.add("payAtTableURL");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(Opi.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Opi
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Opi.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Opi is not found in the empty JSON string", Opi.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Opi.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Opi` properties.", entry.getKey()));
        }
      }
      // validate the optional field payAtTableStoreNumber
      if (jsonObj.get("payAtTableStoreNumber") != null && !jsonObj.get("payAtTableStoreNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `payAtTableStoreNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("payAtTableStoreNumber").toString()));
      }
      // validate the optional field payAtTableURL
      if (jsonObj.get("payAtTableURL") != null && !jsonObj.get("payAtTableURL").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `payAtTableURL` to be a primitive type in the JSON string but got `%s`", jsonObj.get("payAtTableURL").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Opi.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Opi' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Opi> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Opi.class));

       return (TypeAdapter<T>) new TypeAdapter<Opi>() {
           @Override
           public void write(JsonWriter out, Opi value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Opi read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Opi given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Opi
  * @throws IOException if the JSON string is invalid with respect to Opi
  */
  public static Opi fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Opi.class);
  }

 /**
  * Convert an instance of Opi to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

