/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.management.PaginationLinks;
import com.adyen.model.management.PaymentMethodWrapper;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * PaymentMethodResponse
 */

public class PaymentMethodResponse {
  public static final String SERIALIZED_NAME_LINKS = "_links";
  @SerializedName(SERIALIZED_NAME_LINKS)
  private PaginationLinks links;

  public static final String SERIALIZED_NAME_DATA = "data";
  @SerializedName(SERIALIZED_NAME_DATA)
  private List<PaymentMethodWrapper> data = null;

  public static final String SERIALIZED_NAME_ITEMS_TOTAL = "itemsTotal";
  @SerializedName(SERIALIZED_NAME_ITEMS_TOTAL)
  private Integer itemsTotal;

  public static final String SERIALIZED_NAME_PAGES_TOTAL = "pagesTotal";
  @SerializedName(SERIALIZED_NAME_PAGES_TOTAL)
  private Integer pagesTotal;

  /**
   * Gets or Sets typesWithErrors
   */
  @JsonAdapter(TypesWithErrorsEnum.Adapter.class)
  public enum TypesWithErrorsEnum {
    AFTERPAYTOUCH("afterpaytouch"),
    
    ALIPAY("alipay"),
    
    ALIPAY_HK("alipay_hk"),
    
    AMEX("amex"),
    
    APPLEPAY("applepay"),
    
    BCMC("bcmc"),
    
    BLIK("blik"),
    
    CARTEBANCAIRE("cartebancaire"),
    
    CLEARPAY("clearpay"),
    
    CUP("cup"),
    
    DINERS("diners"),
    
    DIRECTEBANKING("directEbanking"),
    
    DIRECTDEBIT_GB("directdebit_GB"),
    
    DISCOVER("discover"),
    
    EBANKING_FI("ebanking_FI"),
    
    EFTPOS_AUSTRALIA("eftpos_australia"),
    
    ELO("elo"),
    
    ELOCREDIT("elocredit"),
    
    ELODEBIT("elodebit"),
    
    GIROCARD("girocard"),
    
    GIROPAY("giropay"),
    
    GOOGLEPAY("googlepay"),
    
    HIPER("hiper"),
    
    HIPERCARD("hipercard"),
    
    IDEAL("ideal"),
    
    INTERAC_CARD("interac_card"),
    
    JCB("jcb"),
    
    KLARNA("klarna"),
    
    KLARNA_ACCOUNT("klarna_account"),
    
    KLARNA_PAYNOW("klarna_paynow"),
    
    MAESTRO("maestro"),
    
    MBWAY("mbway"),
    
    MC("mc"),
    
    MCDEBIT("mcdebit"),
    
    MEALVOUCHER_FR("mealVoucher_FR"),
    
    MOBILEPAY("mobilepay"),
    
    MULTIBANCO("multibanco"),
    
    ONLINEBANKING_PL("onlineBanking_PL"),
    
    PAYPAL("paypal"),
    
    PAYSHOP("payshop"),
    
    SWISH("swish"),
    
    TRUSTLY("trustly"),
    
    TWINT("twint"),
    
    TWINT_POS("twint_pos"),
    
    VIPPS("vipps"),
    
    VISA("visa"),
    
    VISADEBIT("visadebit"),
    
    VPAY("vpay"),
    
    WECHATPAY("wechatpay"),
    
    WECHATPAY_POS("wechatpay_pos");

    private String value;

    TypesWithErrorsEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypesWithErrorsEnum fromValue(String value) {
      for (TypesWithErrorsEnum b : TypesWithErrorsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypesWithErrorsEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypesWithErrorsEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypesWithErrorsEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypesWithErrorsEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPES_WITH_ERRORS = "typesWithErrors";
  @SerializedName(SERIALIZED_NAME_TYPES_WITH_ERRORS)
  private List<TypesWithErrorsEnum> typesWithErrors = null;

  public PaymentMethodResponse() { 
  }

  public PaymentMethodResponse links(PaginationLinks links) {
    
    this.links = links;
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @ApiModelProperty(value = "")

  public PaginationLinks getLinks() {
    return links;
  }


  public void setLinks(PaginationLinks links) {
    this.links = links;
  }


  public PaymentMethodResponse data(List<PaymentMethodWrapper> data) {
    
    this.data = data;
    return this;
  }

  public PaymentMethodResponse addDataItem(PaymentMethodWrapper dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    return this;
  }

   /**
   * Payment methods details.
   * @return data
  **/
  @ApiModelProperty(value = "Payment methods details.")

  public List<PaymentMethodWrapper> getData() {
    return data;
  }


  public void setData(List<PaymentMethodWrapper> data) {
    this.data = data;
  }


  public PaymentMethodResponse itemsTotal(Integer itemsTotal) {
    
    this.itemsTotal = itemsTotal;
    return this;
  }

   /**
   * Total number of items.
   * @return itemsTotal
  **/
  @ApiModelProperty(required = true, value = "Total number of items.")

  public Integer getItemsTotal() {
    return itemsTotal;
  }


  public void setItemsTotal(Integer itemsTotal) {
    this.itemsTotal = itemsTotal;
  }


  public PaymentMethodResponse pagesTotal(Integer pagesTotal) {
    
    this.pagesTotal = pagesTotal;
    return this;
  }

   /**
   * Total number of pages.
   * @return pagesTotal
  **/
  @ApiModelProperty(required = true, value = "Total number of pages.")

  public Integer getPagesTotal() {
    return pagesTotal;
  }


  public void setPagesTotal(Integer pagesTotal) {
    this.pagesTotal = pagesTotal;
  }


  public PaymentMethodResponse typesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
    
    this.typesWithErrors = typesWithErrors;
    return this;
  }

  public PaymentMethodResponse addTypesWithErrorsItem(TypesWithErrorsEnum typesWithErrorsItem) {
    if (this.typesWithErrors == null) {
      this.typesWithErrors = new ArrayList<>();
    }
    this.typesWithErrors.add(typesWithErrorsItem);
    return this;
  }

   /**
   * Payment method types with errors.
   * @return typesWithErrors
  **/
  @ApiModelProperty(value = "Payment method types with errors.")

  public List<TypesWithErrorsEnum> getTypesWithErrors() {
    return typesWithErrors;
  }


  public void setTypesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
    this.typesWithErrors = typesWithErrors;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethodResponse paymentMethodResponse = (PaymentMethodResponse) o;
    return Objects.equals(this.links, paymentMethodResponse.links) &&
        Objects.equals(this.data, paymentMethodResponse.data) &&
        Objects.equals(this.itemsTotal, paymentMethodResponse.itemsTotal) &&
        Objects.equals(this.pagesTotal, paymentMethodResponse.pagesTotal) &&
        Objects.equals(this.typesWithErrors, paymentMethodResponse.typesWithErrors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, data, itemsTotal, pagesTotal, typesWithErrors);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethodResponse {\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    itemsTotal: ").append(toIndentedString(itemsTotal)).append("\n");
    sb.append("    pagesTotal: ").append(toIndentedString(pagesTotal)).append("\n");
    sb.append("    typesWithErrors: ").append(toIndentedString(typesWithErrors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("_links");
    openapiFields.add("data");
    openapiFields.add("itemsTotal");
    openapiFields.add("pagesTotal");
    openapiFields.add("typesWithErrors");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("itemsTotal");
    openapiRequiredFields.add("pagesTotal");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(PaymentMethodResponse.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PaymentMethodResponse
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PaymentMethodResponse.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentMethodResponse is not found in the empty JSON string", PaymentMethodResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PaymentMethodResponse.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PaymentMethodResponse` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : PaymentMethodResponse.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `_links`
      if (jsonObj.getAsJsonObject("_links") != null) {
        PaginationLinks.validateJsonObject(jsonObj.getAsJsonObject("_links"));
      }
      JsonArray jsonArraydata = jsonObj.getAsJsonArray("data");
      if (jsonArraydata != null) {
        // ensure the json data is an array
        if (!jsonObj.get("data").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `data` to be an array in the JSON string but got `%s`", jsonObj.get("data").toString()));
        }

        // validate the optional field `data` (array)
        for (int i = 0; i < jsonArraydata.size(); i++) {
          PaymentMethodWrapper.validateJsonObject(jsonArraydata.get(i).getAsJsonObject());
        }
      }
      // ensure the json data is an array
      if (jsonObj.get("typesWithErrors") != null && !jsonObj.get("typesWithErrors").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `typesWithErrors` to be an array in the JSON string but got `%s`", jsonObj.get("typesWithErrors").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PaymentMethodResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PaymentMethodResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PaymentMethodResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PaymentMethodResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<PaymentMethodResponse>() {
           @Override
           public void write(JsonWriter out, PaymentMethodResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PaymentMethodResponse read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PaymentMethodResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PaymentMethodResponse
  * @throws IOException if the JSON string is invalid with respect to PaymentMethodResponse
  */
  public static PaymentMethodResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PaymentMethodResponse.class);
  }

 /**
  * Convert an instance of PaymentMethodResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

