/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.management.TerminalProductPrice;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.management.JSON;

/**
 * TerminalProduct
 */

public class TerminalProduct {
  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ITEMS_INCLUDED = "itemsIncluded";
  @SerializedName(SERIALIZED_NAME_ITEMS_INCLUDED)
  private List<String> itemsIncluded = null;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_PRICE = "price";
  @SerializedName(SERIALIZED_NAME_PRICE)
  private TerminalProductPrice price;

  public TerminalProduct() { 
  }

  public TerminalProduct description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Information about items included and integration options.
   * @return description
  **/
  @ApiModelProperty(value = "Information about items included and integration options.")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public TerminalProduct id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the product.
   * @return id
  **/
  @ApiModelProperty(value = "The unique identifier of the product.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public TerminalProduct itemsIncluded(List<String> itemsIncluded) {
    
    this.itemsIncluded = itemsIncluded;
    return this;
  }

  public TerminalProduct addItemsIncludedItem(String itemsIncludedItem) {
    if (this.itemsIncluded == null) {
      this.itemsIncluded = new ArrayList<>();
    }
    this.itemsIncluded.add(itemsIncludedItem);
    return this;
  }

   /**
   * A list of parts included in the terminal package.
   * @return itemsIncluded
  **/
  @ApiModelProperty(value = "A list of parts included in the terminal package.")

  public List<String> getItemsIncluded() {
    return itemsIncluded;
  }


  public void setItemsIncluded(List<String> itemsIncluded) {
    this.itemsIncluded = itemsIncluded;
  }


  public TerminalProduct name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The descriptive name of the product.
   * @return name
  **/
  @ApiModelProperty(value = "The descriptive name of the product.")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public TerminalProduct price(TerminalProductPrice price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @ApiModelProperty(value = "")

  public TerminalProductPrice getPrice() {
    return price;
  }


  public void setPrice(TerminalProductPrice price) {
    this.price = price;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalProduct terminalProduct = (TerminalProduct) o;
    return Objects.equals(this.description, terminalProduct.description) &&
        Objects.equals(this.id, terminalProduct.id) &&
        Objects.equals(this.itemsIncluded, terminalProduct.itemsIncluded) &&
        Objects.equals(this.name, terminalProduct.name) &&
        Objects.equals(this.price, terminalProduct.price);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, id, itemsIncluded, name, price);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalProduct {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    itemsIncluded: ").append(toIndentedString(itemsIncluded)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("description");
    openapiFields.add("id");
    openapiFields.add("itemsIncluded");
    openapiFields.add("name");
    openapiFields.add("price");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(TerminalProduct.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TerminalProduct
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TerminalProduct.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TerminalProduct is not found in the empty JSON string", TerminalProduct.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!TerminalProduct.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TerminalProduct` properties.", entry.getKey()));
        }
      }
      // validate the optional field description
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // validate the optional field id
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("itemsIncluded") != null && !jsonObj.get("itemsIncluded").isJsonArray()) {
        log.log(Level.WARNING, String.format("Expected the field `itemsIncluded` to be an array in the JSON string but got `%s`", jsonObj.get("itemsIncluded").toString()));
      }
      // validate the optional field name
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the optional field `price`
      if (jsonObj.getAsJsonObject("price") != null) {
        TerminalProductPrice.validateJsonObject(jsonObj.getAsJsonObject("price"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TerminalProduct.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TerminalProduct' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TerminalProduct> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TerminalProduct.class));

       return (TypeAdapter<T>) new TypeAdapter<TerminalProduct>() {
           @Override
           public void write(JsonWriter out, TerminalProduct value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TerminalProduct read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TerminalProduct given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TerminalProduct
  * @throws IOException if the JSON string is invalid with respect to TerminalProduct
  */
  public static TerminalProduct fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TerminalProduct.class);
  }

 /**
  * Convert an instance of TerminalProduct to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

