/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.payment.JSON;

/**
 * AcctInfo
 */

public class AcctInfo {
  /**
   * Length of time that the cardholder has had the account with the 3DS Requestor.  Allowed values: * **01** — No account * **02** — Created during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   */
  @JsonAdapter(ChAccAgeIndEnum.Adapter.class)
  public enum ChAccAgeIndEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05");

    private String value;

    ChAccAgeIndEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ChAccAgeIndEnum fromValue(String value) {
      for (ChAccAgeIndEnum b : ChAccAgeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ChAccAgeIndEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ChAccAgeIndEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ChAccAgeIndEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ChAccAgeIndEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CH_ACC_AGE_IND = "chAccAgeInd";
  @SerializedName(SERIALIZED_NAME_CH_ACC_AGE_IND)
  private ChAccAgeIndEnum chAccAgeInd;

  public static final String SERIALIZED_NAME_CH_ACC_CHANGE = "chAccChange";
  @SerializedName(SERIALIZED_NAME_CH_ACC_CHANGE)
  private String chAccChange;

  /**
   * Length of time since the cardholder’s account information with the 3DS Requestor was last changed, including Billing or Shipping address, new payment account, or new user(s) added.  Allowed values: * **01** — Changed during this transaction * **02** — Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   */
  @JsonAdapter(ChAccChangeIndEnum.Adapter.class)
  public enum ChAccChangeIndEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04");

    private String value;

    ChAccChangeIndEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ChAccChangeIndEnum fromValue(String value) {
      for (ChAccChangeIndEnum b : ChAccChangeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ChAccChangeIndEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ChAccChangeIndEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ChAccChangeIndEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ChAccChangeIndEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CH_ACC_CHANGE_IND = "chAccChangeInd";
  @SerializedName(SERIALIZED_NAME_CH_ACC_CHANGE_IND)
  private ChAccChangeIndEnum chAccChangeInd;

  public static final String SERIALIZED_NAME_CH_ACC_PW_CHANGE = "chAccPwChange";
  @SerializedName(SERIALIZED_NAME_CH_ACC_PW_CHANGE)
  private String chAccPwChange;

  /**
   * Indicates the length of time since the cardholder’s account with the 3DS Requestor had a password change or account reset.  Allowed values: * **01** — No change * **02** — Changed during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   */
  @JsonAdapter(ChAccPwChangeIndEnum.Adapter.class)
  public enum ChAccPwChangeIndEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05");

    private String value;

    ChAccPwChangeIndEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ChAccPwChangeIndEnum fromValue(String value) {
      for (ChAccPwChangeIndEnum b : ChAccPwChangeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ChAccPwChangeIndEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ChAccPwChangeIndEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ChAccPwChangeIndEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ChAccPwChangeIndEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CH_ACC_PW_CHANGE_IND = "chAccPwChangeInd";
  @SerializedName(SERIALIZED_NAME_CH_ACC_PW_CHANGE_IND)
  private ChAccPwChangeIndEnum chAccPwChangeInd;

  public static final String SERIALIZED_NAME_CH_ACC_STRING = "chAccString";
  @SerializedName(SERIALIZED_NAME_CH_ACC_STRING)
  private String chAccString;

  public static final String SERIALIZED_NAME_NB_PURCHASE_ACCOUNT = "nbPurchaseAccount";
  @SerializedName(SERIALIZED_NAME_NB_PURCHASE_ACCOUNT)
  private String nbPurchaseAccount;

  public static final String SERIALIZED_NAME_PAYMENT_ACC_AGE = "paymentAccAge";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ACC_AGE)
  private String paymentAccAge;

  /**
   * Indicates the length of time that the payment account was enrolled in the cardholder’s account with the 3DS Requestor.  Allowed values: * **01** — No account (guest checkout) * **02** — During this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   */
  @JsonAdapter(PaymentAccIndEnum.Adapter.class)
  public enum PaymentAccIndEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05");

    private String value;

    PaymentAccIndEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static PaymentAccIndEnum fromValue(String value) {
      for (PaymentAccIndEnum b : PaymentAccIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<PaymentAccIndEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PaymentAccIndEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public PaymentAccIndEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return PaymentAccIndEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PAYMENT_ACC_IND = "paymentAccInd";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ACC_IND)
  private PaymentAccIndEnum paymentAccInd;

  public static final String SERIALIZED_NAME_PROVISION_ATTEMPTS_DAY = "provisionAttemptsDay";
  @SerializedName(SERIALIZED_NAME_PROVISION_ATTEMPTS_DAY)
  private String provisionAttemptsDay;

  public static final String SERIALIZED_NAME_SHIP_ADDRESS_USAGE = "shipAddressUsage";
  @SerializedName(SERIALIZED_NAME_SHIP_ADDRESS_USAGE)
  private String shipAddressUsage;

  /**
   * Indicates when the shipping address used for this transaction was first used with the 3DS Requestor.  Allowed values: * **01** — This transaction * **02** — Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   */
  @JsonAdapter(ShipAddressUsageIndEnum.Adapter.class)
  public enum ShipAddressUsageIndEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04");

    private String value;

    ShipAddressUsageIndEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ShipAddressUsageIndEnum fromValue(String value) {
      for (ShipAddressUsageIndEnum b : ShipAddressUsageIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ShipAddressUsageIndEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ShipAddressUsageIndEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ShipAddressUsageIndEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ShipAddressUsageIndEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_SHIP_ADDRESS_USAGE_IND = "shipAddressUsageInd";
  @SerializedName(SERIALIZED_NAME_SHIP_ADDRESS_USAGE_IND)
  private ShipAddressUsageIndEnum shipAddressUsageInd;

  /**
   * Indicates if the Cardholder Name on the account is identical to the shipping Name used for this transaction.  Allowed values: * **01** — Account Name identical to shipping Name * **02** — Account Name different to shipping Name
   */
  @JsonAdapter(ShipNameIndicatorEnum.Adapter.class)
  public enum ShipNameIndicatorEnum {
    _01("01"),
    
    _02("02");

    private String value;

    ShipNameIndicatorEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ShipNameIndicatorEnum fromValue(String value) {
      for (ShipNameIndicatorEnum b : ShipNameIndicatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ShipNameIndicatorEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ShipNameIndicatorEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ShipNameIndicatorEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ShipNameIndicatorEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_SHIP_NAME_INDICATOR = "shipNameIndicator";
  @SerializedName(SERIALIZED_NAME_SHIP_NAME_INDICATOR)
  private ShipNameIndicatorEnum shipNameIndicator;

  /**
   * Indicates whether the 3DS Requestor has experienced suspicious activity (including previous fraud) on the cardholder account.  Allowed values: * **01** — No suspicious activity has been observed * **02** — Suspicious activity has been observed
   */
  @JsonAdapter(SuspiciousAccActivityEnum.Adapter.class)
  public enum SuspiciousAccActivityEnum {
    _01("01"),
    
    _02("02");

    private String value;

    SuspiciousAccActivityEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static SuspiciousAccActivityEnum fromValue(String value) {
      for (SuspiciousAccActivityEnum b : SuspiciousAccActivityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<SuspiciousAccActivityEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SuspiciousAccActivityEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public SuspiciousAccActivityEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return SuspiciousAccActivityEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_SUSPICIOUS_ACC_ACTIVITY = "suspiciousAccActivity";
  @SerializedName(SERIALIZED_NAME_SUSPICIOUS_ACC_ACTIVITY)
  private SuspiciousAccActivityEnum suspiciousAccActivity;

  public static final String SERIALIZED_NAME_TXN_ACTIVITY_DAY = "txnActivityDay";
  @SerializedName(SERIALIZED_NAME_TXN_ACTIVITY_DAY)
  private String txnActivityDay;

  public static final String SERIALIZED_NAME_TXN_ACTIVITY_YEAR = "txnActivityYear";
  @SerializedName(SERIALIZED_NAME_TXN_ACTIVITY_YEAR)
  private String txnActivityYear;

  public AcctInfo() { 
  }

  public AcctInfo chAccAgeInd(ChAccAgeIndEnum chAccAgeInd) {
    
    this.chAccAgeInd = chAccAgeInd;
    return this;
  }

   /**
   * Length of time that the cardholder has had the account with the 3DS Requestor.  Allowed values: * **01** — No account * **02** — Created during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   * @return chAccAgeInd
  **/
  @ApiModelProperty(value = "Length of time that the cardholder has had the account with the 3DS Requestor.  Allowed values: * **01** — No account * **02** — Created during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days")

  public ChAccAgeIndEnum getChAccAgeInd() {
    return chAccAgeInd;
  }


  public void setChAccAgeInd(ChAccAgeIndEnum chAccAgeInd) {
    this.chAccAgeInd = chAccAgeInd;
  }


  public AcctInfo chAccChange(String chAccChange) {
    
    this.chAccChange = chAccChange;
    return this;
  }

   /**
   * Date that the cardholder’s account with the 3DS Requestor was last changed, including Billing or Shipping address, new payment account, or new user(s) added.  Format: **YYYYMMDD**
   * @return chAccChange
  **/
  @ApiModelProperty(value = "Date that the cardholder’s account with the 3DS Requestor was last changed, including Billing or Shipping address, new payment account, or new user(s) added.  Format: **YYYYMMDD**")

  public String getChAccChange() {
    return chAccChange;
  }


  public void setChAccChange(String chAccChange) {
    this.chAccChange = chAccChange;
  }


  public AcctInfo chAccChangeInd(ChAccChangeIndEnum chAccChangeInd) {
    
    this.chAccChangeInd = chAccChangeInd;
    return this;
  }

   /**
   * Length of time since the cardholder’s account information with the 3DS Requestor was last changed, including Billing or Shipping address, new payment account, or new user(s) added.  Allowed values: * **01** — Changed during this transaction * **02** — Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   * @return chAccChangeInd
  **/
  @ApiModelProperty(value = "Length of time since the cardholder’s account information with the 3DS Requestor was last changed, including Billing or Shipping address, new payment account, or new user(s) added.  Allowed values: * **01** — Changed during this transaction * **02** — Less than 30 days * **03** — 30–60 days * **04** — More than 60 days")

  public ChAccChangeIndEnum getChAccChangeInd() {
    return chAccChangeInd;
  }


  public void setChAccChangeInd(ChAccChangeIndEnum chAccChangeInd) {
    this.chAccChangeInd = chAccChangeInd;
  }


  public AcctInfo chAccPwChange(String chAccPwChange) {
    
    this.chAccPwChange = chAccPwChange;
    return this;
  }

   /**
   * Date that cardholder’s account with the 3DS Requestor had a password change or account reset.  Format: **YYYYMMDD**
   * @return chAccPwChange
  **/
  @ApiModelProperty(value = "Date that cardholder’s account with the 3DS Requestor had a password change or account reset.  Format: **YYYYMMDD**")

  public String getChAccPwChange() {
    return chAccPwChange;
  }


  public void setChAccPwChange(String chAccPwChange) {
    this.chAccPwChange = chAccPwChange;
  }


  public AcctInfo chAccPwChangeInd(ChAccPwChangeIndEnum chAccPwChangeInd) {
    
    this.chAccPwChangeInd = chAccPwChangeInd;
    return this;
  }

   /**
   * Indicates the length of time since the cardholder’s account with the 3DS Requestor had a password change or account reset.  Allowed values: * **01** — No change * **02** — Changed during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   * @return chAccPwChangeInd
  **/
  @ApiModelProperty(value = "Indicates the length of time since the cardholder’s account with the 3DS Requestor had a password change or account reset.  Allowed values: * **01** — No change * **02** — Changed during this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days")

  public ChAccPwChangeIndEnum getChAccPwChangeInd() {
    return chAccPwChangeInd;
  }


  public void setChAccPwChangeInd(ChAccPwChangeIndEnum chAccPwChangeInd) {
    this.chAccPwChangeInd = chAccPwChangeInd;
  }


  public AcctInfo chAccString(String chAccString) {
    
    this.chAccString = chAccString;
    return this;
  }

   /**
   * Date that the cardholder opened the account with the 3DS Requestor.  Format: **YYYYMMDD**
   * @return chAccString
  **/
  @ApiModelProperty(value = "Date that the cardholder opened the account with the 3DS Requestor.  Format: **YYYYMMDD**")

  public String getChAccString() {
    return chAccString;
  }


  public void setChAccString(String chAccString) {
    this.chAccString = chAccString;
  }


  public AcctInfo nbPurchaseAccount(String nbPurchaseAccount) {
    
    this.nbPurchaseAccount = nbPurchaseAccount;
    return this;
  }

   /**
   * Number of purchases with this cardholder account during the previous six months. Max length: 4 characters.
   * @return nbPurchaseAccount
  **/
  @ApiModelProperty(value = "Number of purchases with this cardholder account during the previous six months. Max length: 4 characters.")

  public String getNbPurchaseAccount() {
    return nbPurchaseAccount;
  }


  public void setNbPurchaseAccount(String nbPurchaseAccount) {
    this.nbPurchaseAccount = nbPurchaseAccount;
  }


  public AcctInfo paymentAccAge(String paymentAccAge) {
    
    this.paymentAccAge = paymentAccAge;
    return this;
  }

   /**
   * String that the payment account was enrolled in the cardholder’s account with the 3DS Requestor.  Format: **YYYYMMDD**
   * @return paymentAccAge
  **/
  @ApiModelProperty(value = "String that the payment account was enrolled in the cardholder’s account with the 3DS Requestor.  Format: **YYYYMMDD**")

  public String getPaymentAccAge() {
    return paymentAccAge;
  }


  public void setPaymentAccAge(String paymentAccAge) {
    this.paymentAccAge = paymentAccAge;
  }


  public AcctInfo paymentAccInd(PaymentAccIndEnum paymentAccInd) {
    
    this.paymentAccInd = paymentAccInd;
    return this;
  }

   /**
   * Indicates the length of time that the payment account was enrolled in the cardholder’s account with the 3DS Requestor.  Allowed values: * **01** — No account (guest checkout) * **02** — During this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days
   * @return paymentAccInd
  **/
  @ApiModelProperty(value = "Indicates the length of time that the payment account was enrolled in the cardholder’s account with the 3DS Requestor.  Allowed values: * **01** — No account (guest checkout) * **02** — During this transaction * **03** — Less than 30 days * **04** — 30–60 days * **05** — More than 60 days")

  public PaymentAccIndEnum getPaymentAccInd() {
    return paymentAccInd;
  }


  public void setPaymentAccInd(PaymentAccIndEnum paymentAccInd) {
    this.paymentAccInd = paymentAccInd;
  }


  public AcctInfo provisionAttemptsDay(String provisionAttemptsDay) {
    
    this.provisionAttemptsDay = provisionAttemptsDay;
    return this;
  }

   /**
   * Number of Add Card attempts in the last 24 hours. Max length: 3 characters.
   * @return provisionAttemptsDay
  **/
  @ApiModelProperty(value = "Number of Add Card attempts in the last 24 hours. Max length: 3 characters.")

  public String getProvisionAttemptsDay() {
    return provisionAttemptsDay;
  }


  public void setProvisionAttemptsDay(String provisionAttemptsDay) {
    this.provisionAttemptsDay = provisionAttemptsDay;
  }


  public AcctInfo shipAddressUsage(String shipAddressUsage) {
    
    this.shipAddressUsage = shipAddressUsage;
    return this;
  }

   /**
   * String when the shipping address used for this transaction was first used with the 3DS Requestor.  Format: **YYYYMMDD**
   * @return shipAddressUsage
  **/
  @ApiModelProperty(value = "String when the shipping address used for this transaction was first used with the 3DS Requestor.  Format: **YYYYMMDD**")

  public String getShipAddressUsage() {
    return shipAddressUsage;
  }


  public void setShipAddressUsage(String shipAddressUsage) {
    this.shipAddressUsage = shipAddressUsage;
  }


  public AcctInfo shipAddressUsageInd(ShipAddressUsageIndEnum shipAddressUsageInd) {
    
    this.shipAddressUsageInd = shipAddressUsageInd;
    return this;
  }

   /**
   * Indicates when the shipping address used for this transaction was first used with the 3DS Requestor.  Allowed values: * **01** — This transaction * **02** — Less than 30 days * **03** — 30–60 days * **04** — More than 60 days
   * @return shipAddressUsageInd
  **/
  @ApiModelProperty(value = "Indicates when the shipping address used for this transaction was first used with the 3DS Requestor.  Allowed values: * **01** — This transaction * **02** — Less than 30 days * **03** — 30–60 days * **04** — More than 60 days")

  public ShipAddressUsageIndEnum getShipAddressUsageInd() {
    return shipAddressUsageInd;
  }


  public void setShipAddressUsageInd(ShipAddressUsageIndEnum shipAddressUsageInd) {
    this.shipAddressUsageInd = shipAddressUsageInd;
  }


  public AcctInfo shipNameIndicator(ShipNameIndicatorEnum shipNameIndicator) {
    
    this.shipNameIndicator = shipNameIndicator;
    return this;
  }

   /**
   * Indicates if the Cardholder Name on the account is identical to the shipping Name used for this transaction.  Allowed values: * **01** — Account Name identical to shipping Name * **02** — Account Name different to shipping Name
   * @return shipNameIndicator
  **/
  @ApiModelProperty(value = "Indicates if the Cardholder Name on the account is identical to the shipping Name used for this transaction.  Allowed values: * **01** — Account Name identical to shipping Name * **02** — Account Name different to shipping Name")

  public ShipNameIndicatorEnum getShipNameIndicator() {
    return shipNameIndicator;
  }


  public void setShipNameIndicator(ShipNameIndicatorEnum shipNameIndicator) {
    this.shipNameIndicator = shipNameIndicator;
  }


  public AcctInfo suspiciousAccActivity(SuspiciousAccActivityEnum suspiciousAccActivity) {
    
    this.suspiciousAccActivity = suspiciousAccActivity;
    return this;
  }

   /**
   * Indicates whether the 3DS Requestor has experienced suspicious activity (including previous fraud) on the cardholder account.  Allowed values: * **01** — No suspicious activity has been observed * **02** — Suspicious activity has been observed
   * @return suspiciousAccActivity
  **/
  @ApiModelProperty(value = "Indicates whether the 3DS Requestor has experienced suspicious activity (including previous fraud) on the cardholder account.  Allowed values: * **01** — No suspicious activity has been observed * **02** — Suspicious activity has been observed")

  public SuspiciousAccActivityEnum getSuspiciousAccActivity() {
    return suspiciousAccActivity;
  }


  public void setSuspiciousAccActivity(SuspiciousAccActivityEnum suspiciousAccActivity) {
    this.suspiciousAccActivity = suspiciousAccActivity;
  }


  public AcctInfo txnActivityDay(String txnActivityDay) {
    
    this.txnActivityDay = txnActivityDay;
    return this;
  }

   /**
   * Number of transactions (successful and abandoned) for this cardholder account with the 3DS Requestor across all payment accounts in the previous 24 hours. Max length: 3 characters.
   * @return txnActivityDay
  **/
  @ApiModelProperty(value = "Number of transactions (successful and abandoned) for this cardholder account with the 3DS Requestor across all payment accounts in the previous 24 hours. Max length: 3 characters.")

  public String getTxnActivityDay() {
    return txnActivityDay;
  }


  public void setTxnActivityDay(String txnActivityDay) {
    this.txnActivityDay = txnActivityDay;
  }


  public AcctInfo txnActivityYear(String txnActivityYear) {
    
    this.txnActivityYear = txnActivityYear;
    return this;
  }

   /**
   * Number of transactions (successful and abandoned) for this cardholder account with the 3DS Requestor across all payment accounts in the previous year. Max length: 3 characters.
   * @return txnActivityYear
  **/
  @ApiModelProperty(value = "Number of transactions (successful and abandoned) for this cardholder account with the 3DS Requestor across all payment accounts in the previous year. Max length: 3 characters.")

  public String getTxnActivityYear() {
    return txnActivityYear;
  }


  public void setTxnActivityYear(String txnActivityYear) {
    this.txnActivityYear = txnActivityYear;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcctInfo acctInfo = (AcctInfo) o;
    return Objects.equals(this.chAccAgeInd, acctInfo.chAccAgeInd) &&
        Objects.equals(this.chAccChange, acctInfo.chAccChange) &&
        Objects.equals(this.chAccChangeInd, acctInfo.chAccChangeInd) &&
        Objects.equals(this.chAccPwChange, acctInfo.chAccPwChange) &&
        Objects.equals(this.chAccPwChangeInd, acctInfo.chAccPwChangeInd) &&
        Objects.equals(this.chAccString, acctInfo.chAccString) &&
        Objects.equals(this.nbPurchaseAccount, acctInfo.nbPurchaseAccount) &&
        Objects.equals(this.paymentAccAge, acctInfo.paymentAccAge) &&
        Objects.equals(this.paymentAccInd, acctInfo.paymentAccInd) &&
        Objects.equals(this.provisionAttemptsDay, acctInfo.provisionAttemptsDay) &&
        Objects.equals(this.shipAddressUsage, acctInfo.shipAddressUsage) &&
        Objects.equals(this.shipAddressUsageInd, acctInfo.shipAddressUsageInd) &&
        Objects.equals(this.shipNameIndicator, acctInfo.shipNameIndicator) &&
        Objects.equals(this.suspiciousAccActivity, acctInfo.suspiciousAccActivity) &&
        Objects.equals(this.txnActivityDay, acctInfo.txnActivityDay) &&
        Objects.equals(this.txnActivityYear, acctInfo.txnActivityYear);
  }

  @Override
  public int hashCode() {
    return Objects.hash(chAccAgeInd, chAccChange, chAccChangeInd, chAccPwChange, chAccPwChangeInd, chAccString, nbPurchaseAccount, paymentAccAge, paymentAccInd, provisionAttemptsDay, shipAddressUsage, shipAddressUsageInd, shipNameIndicator, suspiciousAccActivity, txnActivityDay, txnActivityYear);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcctInfo {\n");
    sb.append("    chAccAgeInd: ").append(toIndentedString(chAccAgeInd)).append("\n");
    sb.append("    chAccChange: ").append(toIndentedString(chAccChange)).append("\n");
    sb.append("    chAccChangeInd: ").append(toIndentedString(chAccChangeInd)).append("\n");
    sb.append("    chAccPwChange: ").append(toIndentedString(chAccPwChange)).append("\n");
    sb.append("    chAccPwChangeInd: ").append(toIndentedString(chAccPwChangeInd)).append("\n");
    sb.append("    chAccString: ").append(toIndentedString(chAccString)).append("\n");
    sb.append("    nbPurchaseAccount: ").append(toIndentedString(nbPurchaseAccount)).append("\n");
    sb.append("    paymentAccAge: ").append(toIndentedString(paymentAccAge)).append("\n");
    sb.append("    paymentAccInd: ").append(toIndentedString(paymentAccInd)).append("\n");
    sb.append("    provisionAttemptsDay: ").append(toIndentedString(provisionAttemptsDay)).append("\n");
    sb.append("    shipAddressUsage: ").append(toIndentedString(shipAddressUsage)).append("\n");
    sb.append("    shipAddressUsageInd: ").append(toIndentedString(shipAddressUsageInd)).append("\n");
    sb.append("    shipNameIndicator: ").append(toIndentedString(shipNameIndicator)).append("\n");
    sb.append("    suspiciousAccActivity: ").append(toIndentedString(suspiciousAccActivity)).append("\n");
    sb.append("    txnActivityDay: ").append(toIndentedString(txnActivityDay)).append("\n");
    sb.append("    txnActivityYear: ").append(toIndentedString(txnActivityYear)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("chAccAgeInd");
    openapiFields.add("chAccChange");
    openapiFields.add("chAccChangeInd");
    openapiFields.add("chAccPwChange");
    openapiFields.add("chAccPwChangeInd");
    openapiFields.add("chAccString");
    openapiFields.add("nbPurchaseAccount");
    openapiFields.add("paymentAccAge");
    openapiFields.add("paymentAccInd");
    openapiFields.add("provisionAttemptsDay");
    openapiFields.add("shipAddressUsage");
    openapiFields.add("shipAddressUsageInd");
    openapiFields.add("shipNameIndicator");
    openapiFields.add("suspiciousAccActivity");
    openapiFields.add("txnActivityDay");
    openapiFields.add("txnActivityYear");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(AcctInfo.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to AcctInfo
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (AcctInfo.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in AcctInfo is not found in the empty JSON string", AcctInfo.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!AcctInfo.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AcctInfo` properties.", entry.getKey()));
        }
      }
      // ensure the field chAccAgeInd can be parsed to an enum value
      if (jsonObj.get("chAccAgeInd") != null) {
        if(!jsonObj.get("chAccAgeInd").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `chAccAgeInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("chAccAgeInd").toString()));
        }
        ChAccAgeIndEnum.fromValue(jsonObj.get("chAccAgeInd").getAsString());
      }
      // validate the optional field chAccChange
      if (jsonObj.get("chAccChange") != null && !jsonObj.get("chAccChange").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `chAccChange` to be a primitive type in the JSON string but got `%s`", jsonObj.get("chAccChange").toString()));
      }
      // ensure the field chAccChangeInd can be parsed to an enum value
      if (jsonObj.get("chAccChangeInd") != null) {
        if(!jsonObj.get("chAccChangeInd").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `chAccChangeInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("chAccChangeInd").toString()));
        }
        ChAccChangeIndEnum.fromValue(jsonObj.get("chAccChangeInd").getAsString());
      }
      // validate the optional field chAccPwChange
      if (jsonObj.get("chAccPwChange") != null && !jsonObj.get("chAccPwChange").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `chAccPwChange` to be a primitive type in the JSON string but got `%s`", jsonObj.get("chAccPwChange").toString()));
      }
      // ensure the field chAccPwChangeInd can be parsed to an enum value
      if (jsonObj.get("chAccPwChangeInd") != null) {
        if(!jsonObj.get("chAccPwChangeInd").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `chAccPwChangeInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("chAccPwChangeInd").toString()));
        }
        ChAccPwChangeIndEnum.fromValue(jsonObj.get("chAccPwChangeInd").getAsString());
      }
      // validate the optional field chAccString
      if (jsonObj.get("chAccString") != null && !jsonObj.get("chAccString").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `chAccString` to be a primitive type in the JSON string but got `%s`", jsonObj.get("chAccString").toString()));
      }
      // validate the optional field nbPurchaseAccount
      if (jsonObj.get("nbPurchaseAccount") != null && !jsonObj.get("nbPurchaseAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `nbPurchaseAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("nbPurchaseAccount").toString()));
      }
      // validate the optional field paymentAccAge
      if (jsonObj.get("paymentAccAge") != null && !jsonObj.get("paymentAccAge").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentAccAge` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentAccAge").toString()));
      }
      // ensure the field paymentAccInd can be parsed to an enum value
      if (jsonObj.get("paymentAccInd") != null) {
        if(!jsonObj.get("paymentAccInd").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `paymentAccInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentAccInd").toString()));
        }
        PaymentAccIndEnum.fromValue(jsonObj.get("paymentAccInd").getAsString());
      }
      // validate the optional field provisionAttemptsDay
      if (jsonObj.get("provisionAttemptsDay") != null && !jsonObj.get("provisionAttemptsDay").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `provisionAttemptsDay` to be a primitive type in the JSON string but got `%s`", jsonObj.get("provisionAttemptsDay").toString()));
      }
      // validate the optional field shipAddressUsage
      if (jsonObj.get("shipAddressUsage") != null && !jsonObj.get("shipAddressUsage").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `shipAddressUsage` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shipAddressUsage").toString()));
      }
      // ensure the field shipAddressUsageInd can be parsed to an enum value
      if (jsonObj.get("shipAddressUsageInd") != null) {
        if(!jsonObj.get("shipAddressUsageInd").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `shipAddressUsageInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shipAddressUsageInd").toString()));
        }
        ShipAddressUsageIndEnum.fromValue(jsonObj.get("shipAddressUsageInd").getAsString());
      }
      // ensure the field shipNameIndicator can be parsed to an enum value
      if (jsonObj.get("shipNameIndicator") != null) {
        if(!jsonObj.get("shipNameIndicator").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `shipNameIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get("shipNameIndicator").toString()));
        }
        ShipNameIndicatorEnum.fromValue(jsonObj.get("shipNameIndicator").getAsString());
      }
      // ensure the field suspiciousAccActivity can be parsed to an enum value
      if (jsonObj.get("suspiciousAccActivity") != null) {
        if(!jsonObj.get("suspiciousAccActivity").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `suspiciousAccActivity` to be a primitive type in the JSON string but got `%s`", jsonObj.get("suspiciousAccActivity").toString()));
        }
        SuspiciousAccActivityEnum.fromValue(jsonObj.get("suspiciousAccActivity").getAsString());
      }
      // validate the optional field txnActivityDay
      if (jsonObj.get("txnActivityDay") != null && !jsonObj.get("txnActivityDay").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `txnActivityDay` to be a primitive type in the JSON string but got `%s`", jsonObj.get("txnActivityDay").toString()));
      }
      // validate the optional field txnActivityYear
      if (jsonObj.get("txnActivityYear") != null && !jsonObj.get("txnActivityYear").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `txnActivityYear` to be a primitive type in the JSON string but got `%s`", jsonObj.get("txnActivityYear").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AcctInfo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AcctInfo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AcctInfo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AcctInfo.class));

       return (TypeAdapter<T>) new TypeAdapter<AcctInfo>() {
           @Override
           public void write(JsonWriter out, AcctInfo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AcctInfo read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AcctInfo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AcctInfo
  * @throws IOException if the JSON string is invalid with respect to AcctInfo
  */
  public static AcctInfo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AcctInfo.class);
  }

 /**
  * Convert an instance of AcctInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

