/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.payment.AcctInfo;
import com.adyen.model.payment.DeviceRenderOptions;
import com.adyen.model.payment.Phone;
import com.adyen.model.payment.SDKEphemPubKey;
import com.adyen.model.payment.ThreeDSRequestorAuthenticationInfo;
import com.adyen.model.payment.ThreeDSRequestorPriorAuthenticationInfo;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.payment.JSON;

/**
 * ThreeDS2RequestData
 */

public class ThreeDS2RequestData {
  public static final String SERIALIZED_NAME_ACCT_INFO = "acctInfo";
  @SerializedName(SERIALIZED_NAME_ACCT_INFO)
  private AcctInfo acctInfo;

  /**
   * Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** — Not applicable * **02** — Credit * **03** — Debit
   */
  @JsonAdapter(AcctTypeEnum.Adapter.class)
  public enum AcctTypeEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03");

    private String value;

    AcctTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AcctTypeEnum fromValue(String value) {
      for (AcctTypeEnum b : AcctTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AcctTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AcctTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AcctTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AcctTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ACCT_TYPE = "acctType";
  @SerializedName(SERIALIZED_NAME_ACCT_TYPE)
  private AcctTypeEnum acctType;

  public static final String SERIALIZED_NAME_ACQUIRER_B_I_N = "acquirerBIN";
  @SerializedName(SERIALIZED_NAME_ACQUIRER_B_I_N)
  private String acquirerBIN;

  public static final String SERIALIZED_NAME_ACQUIRER_MERCHANT_I_D = "acquirerMerchantID";
  @SerializedName(SERIALIZED_NAME_ACQUIRER_MERCHANT_I_D)
  private String acquirerMerchantID;

  /**
   * Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** — Shipping Address matches Billing Address. * **N** — Shipping Address does not match Billing Address.
   */
  @JsonAdapter(AddrMatchEnum.Adapter.class)
  public enum AddrMatchEnum {
    Y("Y"),
    
    N("N");

    private String value;

    AddrMatchEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AddrMatchEnum fromValue(String value) {
      for (AddrMatchEnum b : AddrMatchEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AddrMatchEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AddrMatchEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AddrMatchEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AddrMatchEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ADDR_MATCH = "addrMatch";
  @SerializedName(SERIALIZED_NAME_ADDR_MATCH)
  private AddrMatchEnum addrMatch;

  public static final String SERIALIZED_NAME_AUTHENTICATION_ONLY = "authenticationOnly";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_AUTHENTICATION_ONLY)
  private Boolean authenticationOnly = false;

  /**
   * Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * &#x60;noPreference&#x60; * &#x60;requestNoChallenge&#x60; * &#x60;requestChallenge&#x60; * &#x60;requestChallengeAsMandate&#x60; 
   */
  @JsonAdapter(ChallengeIndicatorEnum.Adapter.class)
  public enum ChallengeIndicatorEnum {
    NOPREFERENCE("noPreference"),
    
    REQUESTNOCHALLENGE("requestNoChallenge"),
    
    REQUESTCHALLENGE("requestChallenge"),
    
    REQUESTCHALLENGEASMANDATE("requestChallengeAsMandate");

    private String value;

    ChallengeIndicatorEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ChallengeIndicatorEnum fromValue(String value) {
      for (ChallengeIndicatorEnum b : ChallengeIndicatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ChallengeIndicatorEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ChallengeIndicatorEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ChallengeIndicatorEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ChallengeIndicatorEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CHALLENGE_INDICATOR = "challengeIndicator";
  @Deprecated
  @SerializedName(SERIALIZED_NAME_CHALLENGE_INDICATOR)
  private ChallengeIndicatorEnum challengeIndicator;

  public static final String SERIALIZED_NAME_DEVICE_CHANNEL = "deviceChannel";
  @SerializedName(SERIALIZED_NAME_DEVICE_CHANNEL)
  private String deviceChannel;

  public static final String SERIALIZED_NAME_DEVICE_RENDER_OPTIONS = "deviceRenderOptions";
  @SerializedName(SERIALIZED_NAME_DEVICE_RENDER_OPTIONS)
  private DeviceRenderOptions deviceRenderOptions;

  public static final String SERIALIZED_NAME_HOME_PHONE = "homePhone";
  @SerializedName(SERIALIZED_NAME_HOME_PHONE)
  private Phone homePhone;

  public static final String SERIALIZED_NAME_MCC = "mcc";
  @SerializedName(SERIALIZED_NAME_MCC)
  private String mcc;

  public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchantName";
  @SerializedName(SERIALIZED_NAME_MERCHANT_NAME)
  private String merchantName;

  public static final String SERIALIZED_NAME_MESSAGE_VERSION = "messageVersion";
  @SerializedName(SERIALIZED_NAME_MESSAGE_VERSION)
  private String messageVersion = "2.1.0";

  public static final String SERIALIZED_NAME_MOBILE_PHONE = "mobilePhone";
  @SerializedName(SERIALIZED_NAME_MOBILE_PHONE)
  private Phone mobilePhone;

  public static final String SERIALIZED_NAME_NOTIFICATION_U_R_L = "notificationURL";
  @SerializedName(SERIALIZED_NAME_NOTIFICATION_U_R_L)
  private String notificationURL;

  public static final String SERIALIZED_NAME_PAY_TOKEN_IND = "payTokenInd";
  @SerializedName(SERIALIZED_NAME_PAY_TOKEN_IND)
  private Boolean payTokenInd;

  public static final String SERIALIZED_NAME_PAYMENT_AUTHENTICATION_USE_CASE = "paymentAuthenticationUseCase";
  @SerializedName(SERIALIZED_NAME_PAYMENT_AUTHENTICATION_USE_CASE)
  private String paymentAuthenticationUseCase;

  public static final String SERIALIZED_NAME_PURCHASE_INSTAL_DATA = "purchaseInstalData";
  @SerializedName(SERIALIZED_NAME_PURCHASE_INSTAL_DATA)
  private String purchaseInstalData;

  public static final String SERIALIZED_NAME_RECURRING_EXPIRY = "recurringExpiry";
  @SerializedName(SERIALIZED_NAME_RECURRING_EXPIRY)
  private String recurringExpiry;

  public static final String SERIALIZED_NAME_RECURRING_FREQUENCY = "recurringFrequency";
  @SerializedName(SERIALIZED_NAME_RECURRING_FREQUENCY)
  private String recurringFrequency;

  public static final String SERIALIZED_NAME_SDK_APP_I_D = "sdkAppID";
  @SerializedName(SERIALIZED_NAME_SDK_APP_I_D)
  private String sdkAppID;

  public static final String SERIALIZED_NAME_SDK_ENC_DATA = "sdkEncData";
  @SerializedName(SERIALIZED_NAME_SDK_ENC_DATA)
  private String sdkEncData;

  public static final String SERIALIZED_NAME_SDK_EPHEM_PUB_KEY = "sdkEphemPubKey";
  @SerializedName(SERIALIZED_NAME_SDK_EPHEM_PUB_KEY)
  private SDKEphemPubKey sdkEphemPubKey;

  public static final String SERIALIZED_NAME_SDK_MAX_TIMEOUT = "sdkMaxTimeout";
  @SerializedName(SERIALIZED_NAME_SDK_MAX_TIMEOUT)
  private Integer sdkMaxTimeout = 60;

  public static final String SERIALIZED_NAME_SDK_REFERENCE_NUMBER = "sdkReferenceNumber";
  @SerializedName(SERIALIZED_NAME_SDK_REFERENCE_NUMBER)
  private String sdkReferenceNumber;

  public static final String SERIALIZED_NAME_SDK_TRANS_I_D = "sdkTransID";
  @SerializedName(SERIALIZED_NAME_SDK_TRANS_I_D)
  private String sdkTransID;

  public static final String SERIALIZED_NAME_SDK_VERSION = "sdkVersion";
  @SerializedName(SERIALIZED_NAME_SDK_VERSION)
  private String sdkVersion;

  public static final String SERIALIZED_NAME_THREE_D_S_COMP_IND = "threeDSCompInd";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_COMP_IND)
  private String threeDSCompInd;

  public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_IND = "threeDSRequestorAuthenticationInd";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_IND)
  private String threeDSRequestorAuthenticationInd;

  public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO = "threeDSRequestorAuthenticationInfo";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO)
  private ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo;

  /**
   * Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
   */
  @JsonAdapter(ThreeDSRequestorChallengeIndEnum.Adapter.class)
  public enum ThreeDSRequestorChallengeIndEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05"),
    
    _06("06");

    private String value;

    ThreeDSRequestorChallengeIndEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ThreeDSRequestorChallengeIndEnum fromValue(String value) {
      for (ThreeDSRequestorChallengeIndEnum b : ThreeDSRequestorChallengeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ThreeDSRequestorChallengeIndEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ThreeDSRequestorChallengeIndEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ThreeDSRequestorChallengeIndEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ThreeDSRequestorChallengeIndEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_CHALLENGE_IND = "threeDSRequestorChallengeInd";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_REQUESTOR_CHALLENGE_IND)
  private ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd;

  public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_I_D = "threeDSRequestorID";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_REQUESTOR_I_D)
  private String threeDSRequestorID;

  public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_NAME = "threeDSRequestorName";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_REQUESTOR_NAME)
  private String threeDSRequestorName;

  public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO = "threeDSRequestorPriorAuthenticationInfo";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO)
  private ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo;

  public static final String SERIALIZED_NAME_THREE_D_S_REQUESTOR_U_R_L = "threeDSRequestorURL";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_REQUESTOR_U_R_L)
  private String threeDSRequestorURL;

  /**
   * Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** — Goods/Service Purchase * **03** — Check Acceptance * **10** — Account Funding * **11** — Quasi-Cash Transaction * **28** — Prepaid Activation and Load
   */
  @JsonAdapter(TransTypeEnum.Adapter.class)
  public enum TransTypeEnum {
    _01("01"),
    
    _03("03"),
    
    _10("10"),
    
    _11("11"),
    
    _28("28");

    private String value;

    TransTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TransTypeEnum fromValue(String value) {
      for (TransTypeEnum b : TransTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TransTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TransTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TransTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TransTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TRANS_TYPE = "transType";
  @SerializedName(SERIALIZED_NAME_TRANS_TYPE)
  private TransTypeEnum transType;

  /**
   * Identify the type of the transaction being authenticated.
   */
  @JsonAdapter(TransactionTypeEnum.Adapter.class)
  public enum TransactionTypeEnum {
    GOODSORSERVICEPURCHASE("goodsOrServicePurchase"),
    
    CHECKACCEPTANCE("checkAcceptance"),
    
    ACCOUNTFUNDING("accountFunding"),
    
    QUASICASHTRANSACTION("quasiCashTransaction"),
    
    PREPAIDACTIVATIONANDLOAD("prepaidActivationAndLoad");

    private String value;

    TransactionTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TransactionTypeEnum fromValue(String value) {
      for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TransactionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TransactionTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TransactionTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TransactionTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TYPE)
  private TransactionTypeEnum transactionType;

  public static final String SERIALIZED_NAME_WHITE_LIST_STATUS = "whiteListStatus";
  @SerializedName(SERIALIZED_NAME_WHITE_LIST_STATUS)
  private String whiteListStatus;

  public static final String SERIALIZED_NAME_WORK_PHONE = "workPhone";
  @SerializedName(SERIALIZED_NAME_WORK_PHONE)
  private Phone workPhone;

  public ThreeDS2RequestData() { 
  }

  public ThreeDS2RequestData acctInfo(AcctInfo acctInfo) {
    
    this.acctInfo = acctInfo;
    return this;
  }

   /**
   * Get acctInfo
   * @return acctInfo
  **/
  @ApiModelProperty(value = "")

  public AcctInfo getAcctInfo() {
    return acctInfo;
  }


  public void setAcctInfo(AcctInfo acctInfo) {
    this.acctInfo = acctInfo;
  }


  public ThreeDS2RequestData acctType(AcctTypeEnum acctType) {
    
    this.acctType = acctType;
    return this;
  }

   /**
   * Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** — Not applicable * **02** — Credit * **03** — Debit
   * @return acctType
  **/
  @ApiModelProperty(value = "Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** — Not applicable * **02** — Credit * **03** — Debit")

  public AcctTypeEnum getAcctType() {
    return acctType;
  }


  public void setAcctType(AcctTypeEnum acctType) {
    this.acctType = acctType;
  }


  public ThreeDS2RequestData acquirerBIN(String acquirerBIN) {
    
    this.acquirerBIN = acquirerBIN;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The acquiring BIN enrolled for 3D Secure 2. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.
   * @return acquirerBIN
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The acquiring BIN enrolled for 3D Secure 2. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.")

  public String getAcquirerBIN() {
    return acquirerBIN;
  }


  public void setAcquirerBIN(String acquirerBIN) {
    this.acquirerBIN = acquirerBIN;
  }


  public ThreeDS2RequestData acquirerMerchantID(String acquirerMerchantID) {
    
    this.acquirerMerchantID = acquirerMerchantID;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchantId that is enrolled for 3D Secure 2 by the merchant&#39;s acquirer. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.
   * @return acquirerMerchantID
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchantId that is enrolled for 3D Secure 2 by the merchant's acquirer. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.")

  public String getAcquirerMerchantID() {
    return acquirerMerchantID;
  }


  public void setAcquirerMerchantID(String acquirerMerchantID) {
    this.acquirerMerchantID = acquirerMerchantID;
  }


  public ThreeDS2RequestData addrMatch(AddrMatchEnum addrMatch) {
    
    this.addrMatch = addrMatch;
    return this;
  }

   /**
   * Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** — Shipping Address matches Billing Address. * **N** — Shipping Address does not match Billing Address.
   * @return addrMatch
  **/
  @ApiModelProperty(value = "Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** — Shipping Address matches Billing Address. * **N** — Shipping Address does not match Billing Address.")

  public AddrMatchEnum getAddrMatch() {
    return addrMatch;
  }


  public void setAddrMatch(AddrMatchEnum addrMatch) {
    this.addrMatch = addrMatch;
  }


  @Deprecated
  public ThreeDS2RequestData authenticationOnly(Boolean authenticationOnly) {
    
    this.authenticationOnly = authenticationOnly;
    return this;
  }

   /**
   * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
   * @return authenticationOnly
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")

  public Boolean getAuthenticationOnly() {
    return authenticationOnly;
  }


  @Deprecated
  public void setAuthenticationOnly(Boolean authenticationOnly) {
    this.authenticationOnly = authenticationOnly;
  }


  @Deprecated
  public ThreeDS2RequestData challengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
    
    this.challengeIndicator = challengeIndicator;
    return this;
  }

   /**
   * Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * &#x60;noPreference&#x60; * &#x60;requestNoChallenge&#x60; * &#x60;requestChallenge&#x60; * &#x60;requestChallengeAsMandate&#x60; 
   * @return challengeIndicator
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * `noPreference` * `requestNoChallenge` * `requestChallenge` * `requestChallengeAsMandate` ")

  public ChallengeIndicatorEnum getChallengeIndicator() {
    return challengeIndicator;
  }


  @Deprecated
  public void setChallengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
    this.challengeIndicator = challengeIndicator;
  }


  public ThreeDS2RequestData deviceChannel(String deviceChannel) {
    
    this.deviceChannel = deviceChannel;
    return this;
  }

   /**
   * The environment of the shopper. Allowed values: * &#x60;app&#x60; * &#x60;browser&#x60;
   * @return deviceChannel
  **/
  @ApiModelProperty(required = true, value = "The environment of the shopper. Allowed values: * `app` * `browser`")

  public String getDeviceChannel() {
    return deviceChannel;
  }


  public void setDeviceChannel(String deviceChannel) {
    this.deviceChannel = deviceChannel;
  }


  public ThreeDS2RequestData deviceRenderOptions(DeviceRenderOptions deviceRenderOptions) {
    
    this.deviceRenderOptions = deviceRenderOptions;
    return this;
  }

   /**
   * Get deviceRenderOptions
   * @return deviceRenderOptions
  **/
  @ApiModelProperty(value = "")

  public DeviceRenderOptions getDeviceRenderOptions() {
    return deviceRenderOptions;
  }


  public void setDeviceRenderOptions(DeviceRenderOptions deviceRenderOptions) {
    this.deviceRenderOptions = deviceRenderOptions;
  }


  public ThreeDS2RequestData homePhone(Phone homePhone) {
    
    this.homePhone = homePhone;
    return this;
  }

   /**
   * Get homePhone
   * @return homePhone
  **/
  @ApiModelProperty(value = "")

  public Phone getHomePhone() {
    return homePhone;
  }


  public void setHomePhone(Phone homePhone) {
    this.homePhone = homePhone;
  }


  public ThreeDS2RequestData mcc(String mcc) {
    
    this.mcc = mcc;
    return this;
  }

   /**
   * Required for merchants that have been enrolled for 3D Secure 2 by another party than Adyen, mostly [authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The &#x60;mcc&#x60; is a four-digit code with which the previously given &#x60;acquirerMerchantID&#x60; is registered at the scheme.
   * @return mcc
  **/
  @ApiModelProperty(value = "Required for merchants that have been enrolled for 3D Secure 2 by another party than Adyen, mostly [authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The `mcc` is a four-digit code with which the previously given `acquirerMerchantID` is registered at the scheme.")

  public String getMcc() {
    return mcc;
  }


  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  public ThreeDS2RequestData merchantName(String merchantName) {
    
    this.merchantName = merchantName;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchant name that the issuer presents to the shopper if they get a challenge. We recommend to use the same value that you will use in the authorization. Maximum length is 40 characters. &gt; Optional for a [full 3D Secure 2 integration](https://docs.adyen.com/online-payments/3d-secure/native-3ds2/api-integration). Use this field if you are enrolled for 3D Secure 2 with us and want to override the merchant name already configured on your account.
   * @return merchantName
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchant name that the issuer presents to the shopper if they get a challenge. We recommend to use the same value that you will use in the authorization. Maximum length is 40 characters. > Optional for a [full 3D Secure 2 integration](https://docs.adyen.com/online-payments/3d-secure/native-3ds2/api-integration). Use this field if you are enrolled for 3D Secure 2 with us and want to override the merchant name already configured on your account.")

  public String getMerchantName() {
    return merchantName;
  }


  public void setMerchantName(String merchantName) {
    this.merchantName = merchantName;
  }


  public ThreeDS2RequestData messageVersion(String messageVersion) {
    
    this.messageVersion = messageVersion;
    return this;
  }

   /**
   * The &#x60;messageVersion&#x60; value indicating the 3D Secure 2 protocol version.
   * @return messageVersion
  **/
  @ApiModelProperty(value = "The `messageVersion` value indicating the 3D Secure 2 protocol version.")

  public String getMessageVersion() {
    return messageVersion;
  }


  public void setMessageVersion(String messageVersion) {
    this.messageVersion = messageVersion;
  }


  public ThreeDS2RequestData mobilePhone(Phone mobilePhone) {
    
    this.mobilePhone = mobilePhone;
    return this;
  }

   /**
   * Get mobilePhone
   * @return mobilePhone
  **/
  @ApiModelProperty(value = "")

  public Phone getMobilePhone() {
    return mobilePhone;
  }


  public void setMobilePhone(Phone mobilePhone) {
    this.mobilePhone = mobilePhone;
  }


  public ThreeDS2RequestData notificationURL(String notificationURL) {
    
    this.notificationURL = notificationURL;
    return this;
  }

   /**
   * URL to where the issuer should send the &#x60;CRes&#x60;. Required if you are not using components for &#x60;channel&#x60; **Web** or if you are using classic integration &#x60;deviceChannel&#x60; **browser**.
   * @return notificationURL
  **/
  @ApiModelProperty(value = "URL to where the issuer should send the `CRes`. Required if you are not using components for `channel` **Web** or if you are using classic integration `deviceChannel` **browser**.")

  public String getNotificationURL() {
    return notificationURL;
  }


  public void setNotificationURL(String notificationURL) {
    this.notificationURL = notificationURL;
  }


  public ThreeDS2RequestData payTokenInd(Boolean payTokenInd) {
    
    this.payTokenInd = payTokenInd;
    return this;
  }

   /**
   * Value **true** indicates that the transaction was de-tokenised prior to being received by the ACS.
   * @return payTokenInd
  **/
  @ApiModelProperty(value = "Value **true** indicates that the transaction was de-tokenised prior to being received by the ACS.")

  public Boolean getPayTokenInd() {
    return payTokenInd;
  }


  public void setPayTokenInd(Boolean payTokenInd) {
    this.payTokenInd = payTokenInd;
  }


  public ThreeDS2RequestData paymentAuthenticationUseCase(String paymentAuthenticationUseCase) {
    
    this.paymentAuthenticationUseCase = paymentAuthenticationUseCase;
    return this;
  }

   /**
   * Indicates the type of payment for which an authentication is requested (message extension)
   * @return paymentAuthenticationUseCase
  **/
  @ApiModelProperty(value = "Indicates the type of payment for which an authentication is requested (message extension)")

  public String getPaymentAuthenticationUseCase() {
    return paymentAuthenticationUseCase;
  }


  public void setPaymentAuthenticationUseCase(String paymentAuthenticationUseCase) {
    this.paymentAuthenticationUseCase = paymentAuthenticationUseCase;
  }


  public ThreeDS2RequestData purchaseInstalData(String purchaseInstalData) {
    
    this.purchaseInstalData = purchaseInstalData;
    return this;
  }

   /**
   * Indicates the maximum number of authorisations permitted for instalment payments. Length: 1–3 characters.
   * @return purchaseInstalData
  **/
  @ApiModelProperty(value = "Indicates the maximum number of authorisations permitted for instalment payments. Length: 1–3 characters.")

  public String getPurchaseInstalData() {
    return purchaseInstalData;
  }


  public void setPurchaseInstalData(String purchaseInstalData) {
    this.purchaseInstalData = purchaseInstalData;
  }


  public ThreeDS2RequestData recurringExpiry(String recurringExpiry) {
    
    this.recurringExpiry = recurringExpiry;
    return this;
  }

   /**
   * Date after which no further authorisations shall be performed. Format: YYYYMMDD
   * @return recurringExpiry
  **/
  @ApiModelProperty(value = "Date after which no further authorisations shall be performed. Format: YYYYMMDD")

  public String getRecurringExpiry() {
    return recurringExpiry;
  }


  public void setRecurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
  }


  public ThreeDS2RequestData recurringFrequency(String recurringFrequency) {
    
    this.recurringFrequency = recurringFrequency;
    return this;
  }

   /**
   * Indicates the minimum number of days between authorisations. Maximum length: 4 characters.
   * @return recurringFrequency
  **/
  @ApiModelProperty(value = "Indicates the minimum number of days between authorisations. Maximum length: 4 characters.")

  public String getRecurringFrequency() {
    return recurringFrequency;
  }


  public void setRecurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
  }


  public ThreeDS2RequestData sdkAppID(String sdkAppID) {
    
    this.sdkAppID = sdkAppID;
    return this;
  }

   /**
   * The &#x60;sdkAppID&#x60; value as received from the 3D Secure 2 SDK. Required for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkAppID
  **/
  @ApiModelProperty(value = "The `sdkAppID` value as received from the 3D Secure 2 SDK. Required for `deviceChannel` set to **app**.")

  public String getSdkAppID() {
    return sdkAppID;
  }


  public void setSdkAppID(String sdkAppID) {
    this.sdkAppID = sdkAppID;
  }


  public ThreeDS2RequestData sdkEncData(String sdkEncData) {
    
    this.sdkEncData = sdkEncData;
    return this;
  }

   /**
   * The &#x60;sdkEncData&#x60; value as received from the 3D Secure 2 SDK. Required for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkEncData
  **/
  @ApiModelProperty(value = "The `sdkEncData` value as received from the 3D Secure 2 SDK. Required for `deviceChannel` set to **app**.")

  public String getSdkEncData() {
    return sdkEncData;
  }


  public void setSdkEncData(String sdkEncData) {
    this.sdkEncData = sdkEncData;
  }


  public ThreeDS2RequestData sdkEphemPubKey(SDKEphemPubKey sdkEphemPubKey) {
    
    this.sdkEphemPubKey = sdkEphemPubKey;
    return this;
  }

   /**
   * Get sdkEphemPubKey
   * @return sdkEphemPubKey
  **/
  @ApiModelProperty(value = "")

  public SDKEphemPubKey getSdkEphemPubKey() {
    return sdkEphemPubKey;
  }


  public void setSdkEphemPubKey(SDKEphemPubKey sdkEphemPubKey) {
    this.sdkEphemPubKey = sdkEphemPubKey;
  }


  public ThreeDS2RequestData sdkMaxTimeout(Integer sdkMaxTimeout) {
    
    this.sdkMaxTimeout = sdkMaxTimeout;
    return this;
  }

   /**
   * The maximum amount of time in minutes for the 3D Secure 2 authentication process. Optional and only for &#x60;deviceChannel&#x60; set to **app**. Defaults to **60** minutes.
   * @return sdkMaxTimeout
  **/
  @ApiModelProperty(value = "The maximum amount of time in minutes for the 3D Secure 2 authentication process. Optional and only for `deviceChannel` set to **app**. Defaults to **60** minutes.")

  public Integer getSdkMaxTimeout() {
    return sdkMaxTimeout;
  }


  public void setSdkMaxTimeout(Integer sdkMaxTimeout) {
    this.sdkMaxTimeout = sdkMaxTimeout;
  }


  public ThreeDS2RequestData sdkReferenceNumber(String sdkReferenceNumber) {
    
    this.sdkReferenceNumber = sdkReferenceNumber;
    return this;
  }

   /**
   * The &#x60;sdkReferenceNumber&#x60; value as received from the 3D Secure 2 SDK. Only for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkReferenceNumber
  **/
  @ApiModelProperty(value = "The `sdkReferenceNumber` value as received from the 3D Secure 2 SDK. Only for `deviceChannel` set to **app**.")

  public String getSdkReferenceNumber() {
    return sdkReferenceNumber;
  }


  public void setSdkReferenceNumber(String sdkReferenceNumber) {
    this.sdkReferenceNumber = sdkReferenceNumber;
  }


  public ThreeDS2RequestData sdkTransID(String sdkTransID) {
    
    this.sdkTransID = sdkTransID;
    return this;
  }

   /**
   * The &#x60;sdkTransID&#x60; value as received from the 3D Secure 2 SDK. Only for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkTransID
  **/
  @ApiModelProperty(value = "The `sdkTransID` value as received from the 3D Secure 2 SDK. Only for `deviceChannel` set to **app**.")

  public String getSdkTransID() {
    return sdkTransID;
  }


  public void setSdkTransID(String sdkTransID) {
    this.sdkTransID = sdkTransID;
  }


  public ThreeDS2RequestData sdkVersion(String sdkVersion) {
    
    this.sdkVersion = sdkVersion;
    return this;
  }

   /**
   * Version of the 3D Secure 2 mobile SDK.  Only for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkVersion
  **/
  @ApiModelProperty(value = "Version of the 3D Secure 2 mobile SDK.  Only for `deviceChannel` set to **app**.")

  public String getSdkVersion() {
    return sdkVersion;
  }


  public void setSdkVersion(String sdkVersion) {
    this.sdkVersion = sdkVersion;
  }


  public ThreeDS2RequestData threeDSCompInd(String threeDSCompInd) {
    
    this.threeDSCompInd = threeDSCompInd;
    return this;
  }

   /**
   * Completion indicator for the device fingerprinting.
   * @return threeDSCompInd
  **/
  @ApiModelProperty(value = "Completion indicator for the device fingerprinting.")

  public String getThreeDSCompInd() {
    return threeDSCompInd;
  }


  public void setThreeDSCompInd(String threeDSCompInd) {
    this.threeDSCompInd = threeDSCompInd;
  }


  public ThreeDS2RequestData threeDSRequestorAuthenticationInd(String threeDSRequestorAuthenticationInd) {
    
    this.threeDSRequestorAuthenticationInd = threeDSRequestorAuthenticationInd;
    return this;
  }

   /**
   * Indicates the type of Authentication request.
   * @return threeDSRequestorAuthenticationInd
  **/
  @ApiModelProperty(value = "Indicates the type of Authentication request.")

  public String getThreeDSRequestorAuthenticationInd() {
    return threeDSRequestorAuthenticationInd;
  }


  public void setThreeDSRequestorAuthenticationInd(String threeDSRequestorAuthenticationInd) {
    this.threeDSRequestorAuthenticationInd = threeDSRequestorAuthenticationInd;
  }


  public ThreeDS2RequestData threeDSRequestorAuthenticationInfo(ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo) {
    
    this.threeDSRequestorAuthenticationInfo = threeDSRequestorAuthenticationInfo;
    return this;
  }

   /**
   * Get threeDSRequestorAuthenticationInfo
   * @return threeDSRequestorAuthenticationInfo
  **/
  @ApiModelProperty(value = "")

  public ThreeDSRequestorAuthenticationInfo getThreeDSRequestorAuthenticationInfo() {
    return threeDSRequestorAuthenticationInfo;
  }


  public void setThreeDSRequestorAuthenticationInfo(ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo) {
    this.threeDSRequestorAuthenticationInfo = threeDSRequestorAuthenticationInfo;
  }


  public ThreeDS2RequestData threeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
    
    this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
    return this;
  }

   /**
   * Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
   * @return threeDSRequestorChallengeInd
  **/
  @ApiModelProperty(value = "Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only")

  public ThreeDSRequestorChallengeIndEnum getThreeDSRequestorChallengeInd() {
    return threeDSRequestorChallengeInd;
  }


  public void setThreeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
    this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
  }


  public ThreeDS2RequestData threeDSRequestorID(String threeDSRequestorID) {
    
    this.threeDSRequestorID = threeDSRequestorID;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor identifier assigned by the Directory Server when you enrol for 3D Secure 2.
   * @return threeDSRequestorID
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor identifier assigned by the Directory Server when you enrol for 3D Secure 2.")

  public String getThreeDSRequestorID() {
    return threeDSRequestorID;
  }


  public void setThreeDSRequestorID(String threeDSRequestorID) {
    this.threeDSRequestorID = threeDSRequestorID;
  }


  public ThreeDS2RequestData threeDSRequestorName(String threeDSRequestorName) {
    
    this.threeDSRequestorName = threeDSRequestorName;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor name assigned by the Directory Server when you enrol for 3D Secure 2.
   * @return threeDSRequestorName
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor name assigned by the Directory Server when you enrol for 3D Secure 2.")

  public String getThreeDSRequestorName() {
    return threeDSRequestorName;
  }


  public void setThreeDSRequestorName(String threeDSRequestorName) {
    this.threeDSRequestorName = threeDSRequestorName;
  }


  public ThreeDS2RequestData threeDSRequestorPriorAuthenticationInfo(ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo) {
    
    this.threeDSRequestorPriorAuthenticationInfo = threeDSRequestorPriorAuthenticationInfo;
    return this;
  }

   /**
   * Get threeDSRequestorPriorAuthenticationInfo
   * @return threeDSRequestorPriorAuthenticationInfo
  **/
  @ApiModelProperty(value = "")

  public ThreeDSRequestorPriorAuthenticationInfo getThreeDSRequestorPriorAuthenticationInfo() {
    return threeDSRequestorPriorAuthenticationInfo;
  }


  public void setThreeDSRequestorPriorAuthenticationInfo(ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo) {
    this.threeDSRequestorPriorAuthenticationInfo = threeDSRequestorPriorAuthenticationInfo;
  }


  public ThreeDS2RequestData threeDSRequestorURL(String threeDSRequestorURL) {
    
    this.threeDSRequestorURL = threeDSRequestorURL;
    return this;
  }

   /**
   * URL of the (customer service) website that will be shown to the shopper in case of technical errors during the 3D Secure 2 process.
   * @return threeDSRequestorURL
  **/
  @ApiModelProperty(value = "URL of the (customer service) website that will be shown to the shopper in case of technical errors during the 3D Secure 2 process.")

  public String getThreeDSRequestorURL() {
    return threeDSRequestorURL;
  }


  public void setThreeDSRequestorURL(String threeDSRequestorURL) {
    this.threeDSRequestorURL = threeDSRequestorURL;
  }


  public ThreeDS2RequestData transType(TransTypeEnum transType) {
    
    this.transType = transType;
    return this;
  }

   /**
   * Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** — Goods/Service Purchase * **03** — Check Acceptance * **10** — Account Funding * **11** — Quasi-Cash Transaction * **28** — Prepaid Activation and Load
   * @return transType
  **/
  @ApiModelProperty(value = "Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** — Goods/Service Purchase * **03** — Check Acceptance * **10** — Account Funding * **11** — Quasi-Cash Transaction * **28** — Prepaid Activation and Load")

  public TransTypeEnum getTransType() {
    return transType;
  }


  public void setTransType(TransTypeEnum transType) {
    this.transType = transType;
  }


  public ThreeDS2RequestData transactionType(TransactionTypeEnum transactionType) {
    
    this.transactionType = transactionType;
    return this;
  }

   /**
   * Identify the type of the transaction being authenticated.
   * @return transactionType
  **/
  @ApiModelProperty(value = "Identify the type of the transaction being authenticated.")

  public TransactionTypeEnum getTransactionType() {
    return transactionType;
  }


  public void setTransactionType(TransactionTypeEnum transactionType) {
    this.transactionType = transactionType;
  }


  public ThreeDS2RequestData whiteListStatus(String whiteListStatus) {
    
    this.whiteListStatus = whiteListStatus;
    return this;
  }

   /**
   * The &#x60;whiteListStatus&#x60; value returned from a previous 3D Secure 2 transaction, only applicable for 3D Secure 2 protocol version 2.2.0.
   * @return whiteListStatus
  **/
  @ApiModelProperty(value = "The `whiteListStatus` value returned from a previous 3D Secure 2 transaction, only applicable for 3D Secure 2 protocol version 2.2.0.")

  public String getWhiteListStatus() {
    return whiteListStatus;
  }


  public void setWhiteListStatus(String whiteListStatus) {
    this.whiteListStatus = whiteListStatus;
  }


  public ThreeDS2RequestData workPhone(Phone workPhone) {
    
    this.workPhone = workPhone;
    return this;
  }

   /**
   * Get workPhone
   * @return workPhone
  **/
  @ApiModelProperty(value = "")

  public Phone getWorkPhone() {
    return workPhone;
  }


  public void setWorkPhone(Phone workPhone) {
    this.workPhone = workPhone;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThreeDS2RequestData threeDS2RequestData = (ThreeDS2RequestData) o;
    return Objects.equals(this.acctInfo, threeDS2RequestData.acctInfo) &&
        Objects.equals(this.acctType, threeDS2RequestData.acctType) &&
        Objects.equals(this.acquirerBIN, threeDS2RequestData.acquirerBIN) &&
        Objects.equals(this.acquirerMerchantID, threeDS2RequestData.acquirerMerchantID) &&
        Objects.equals(this.addrMatch, threeDS2RequestData.addrMatch) &&
        Objects.equals(this.authenticationOnly, threeDS2RequestData.authenticationOnly) &&
        Objects.equals(this.challengeIndicator, threeDS2RequestData.challengeIndicator) &&
        Objects.equals(this.deviceChannel, threeDS2RequestData.deviceChannel) &&
        Objects.equals(this.deviceRenderOptions, threeDS2RequestData.deviceRenderOptions) &&
        Objects.equals(this.homePhone, threeDS2RequestData.homePhone) &&
        Objects.equals(this.mcc, threeDS2RequestData.mcc) &&
        Objects.equals(this.merchantName, threeDS2RequestData.merchantName) &&
        Objects.equals(this.messageVersion, threeDS2RequestData.messageVersion) &&
        Objects.equals(this.mobilePhone, threeDS2RequestData.mobilePhone) &&
        Objects.equals(this.notificationURL, threeDS2RequestData.notificationURL) &&
        Objects.equals(this.payTokenInd, threeDS2RequestData.payTokenInd) &&
        Objects.equals(this.paymentAuthenticationUseCase, threeDS2RequestData.paymentAuthenticationUseCase) &&
        Objects.equals(this.purchaseInstalData, threeDS2RequestData.purchaseInstalData) &&
        Objects.equals(this.recurringExpiry, threeDS2RequestData.recurringExpiry) &&
        Objects.equals(this.recurringFrequency, threeDS2RequestData.recurringFrequency) &&
        Objects.equals(this.sdkAppID, threeDS2RequestData.sdkAppID) &&
        Objects.equals(this.sdkEncData, threeDS2RequestData.sdkEncData) &&
        Objects.equals(this.sdkEphemPubKey, threeDS2RequestData.sdkEphemPubKey) &&
        Objects.equals(this.sdkMaxTimeout, threeDS2RequestData.sdkMaxTimeout) &&
        Objects.equals(this.sdkReferenceNumber, threeDS2RequestData.sdkReferenceNumber) &&
        Objects.equals(this.sdkTransID, threeDS2RequestData.sdkTransID) &&
        Objects.equals(this.sdkVersion, threeDS2RequestData.sdkVersion) &&
        Objects.equals(this.threeDSCompInd, threeDS2RequestData.threeDSCompInd) &&
        Objects.equals(this.threeDSRequestorAuthenticationInd, threeDS2RequestData.threeDSRequestorAuthenticationInd) &&
        Objects.equals(this.threeDSRequestorAuthenticationInfo, threeDS2RequestData.threeDSRequestorAuthenticationInfo) &&
        Objects.equals(this.threeDSRequestorChallengeInd, threeDS2RequestData.threeDSRequestorChallengeInd) &&
        Objects.equals(this.threeDSRequestorID, threeDS2RequestData.threeDSRequestorID) &&
        Objects.equals(this.threeDSRequestorName, threeDS2RequestData.threeDSRequestorName) &&
        Objects.equals(this.threeDSRequestorPriorAuthenticationInfo, threeDS2RequestData.threeDSRequestorPriorAuthenticationInfo) &&
        Objects.equals(this.threeDSRequestorURL, threeDS2RequestData.threeDSRequestorURL) &&
        Objects.equals(this.transType, threeDS2RequestData.transType) &&
        Objects.equals(this.transactionType, threeDS2RequestData.transactionType) &&
        Objects.equals(this.whiteListStatus, threeDS2RequestData.whiteListStatus) &&
        Objects.equals(this.workPhone, threeDS2RequestData.workPhone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acctInfo, acctType, acquirerBIN, acquirerMerchantID, addrMatch, authenticationOnly, challengeIndicator, deviceChannel, deviceRenderOptions, homePhone, mcc, merchantName, messageVersion, mobilePhone, notificationURL, payTokenInd, paymentAuthenticationUseCase, purchaseInstalData, recurringExpiry, recurringFrequency, sdkAppID, sdkEncData, sdkEphemPubKey, sdkMaxTimeout, sdkReferenceNumber, sdkTransID, sdkVersion, threeDSCompInd, threeDSRequestorAuthenticationInd, threeDSRequestorAuthenticationInfo, threeDSRequestorChallengeInd, threeDSRequestorID, threeDSRequestorName, threeDSRequestorPriorAuthenticationInfo, threeDSRequestorURL, transType, transactionType, whiteListStatus, workPhone);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThreeDS2RequestData {\n");
    sb.append("    acctInfo: ").append(toIndentedString(acctInfo)).append("\n");
    sb.append("    acctType: ").append(toIndentedString(acctType)).append("\n");
    sb.append("    acquirerBIN: ").append(toIndentedString(acquirerBIN)).append("\n");
    sb.append("    acquirerMerchantID: ").append(toIndentedString(acquirerMerchantID)).append("\n");
    sb.append("    addrMatch: ").append(toIndentedString(addrMatch)).append("\n");
    sb.append("    authenticationOnly: ").append(toIndentedString(authenticationOnly)).append("\n");
    sb.append("    challengeIndicator: ").append(toIndentedString(challengeIndicator)).append("\n");
    sb.append("    deviceChannel: ").append(toIndentedString(deviceChannel)).append("\n");
    sb.append("    deviceRenderOptions: ").append(toIndentedString(deviceRenderOptions)).append("\n");
    sb.append("    homePhone: ").append(toIndentedString(homePhone)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantName: ").append(toIndentedString(merchantName)).append("\n");
    sb.append("    messageVersion: ").append(toIndentedString(messageVersion)).append("\n");
    sb.append("    mobilePhone: ").append(toIndentedString(mobilePhone)).append("\n");
    sb.append("    notificationURL: ").append(toIndentedString(notificationURL)).append("\n");
    sb.append("    payTokenInd: ").append(toIndentedString(payTokenInd)).append("\n");
    sb.append("    paymentAuthenticationUseCase: ").append(toIndentedString(paymentAuthenticationUseCase)).append("\n");
    sb.append("    purchaseInstalData: ").append(toIndentedString(purchaseInstalData)).append("\n");
    sb.append("    recurringExpiry: ").append(toIndentedString(recurringExpiry)).append("\n");
    sb.append("    recurringFrequency: ").append(toIndentedString(recurringFrequency)).append("\n");
    sb.append("    sdkAppID: ").append(toIndentedString(sdkAppID)).append("\n");
    sb.append("    sdkEncData: ").append(toIndentedString(sdkEncData)).append("\n");
    sb.append("    sdkEphemPubKey: ").append(toIndentedString(sdkEphemPubKey)).append("\n");
    sb.append("    sdkMaxTimeout: ").append(toIndentedString(sdkMaxTimeout)).append("\n");
    sb.append("    sdkReferenceNumber: ").append(toIndentedString(sdkReferenceNumber)).append("\n");
    sb.append("    sdkTransID: ").append(toIndentedString(sdkTransID)).append("\n");
    sb.append("    sdkVersion: ").append(toIndentedString(sdkVersion)).append("\n");
    sb.append("    threeDSCompInd: ").append(toIndentedString(threeDSCompInd)).append("\n");
    sb.append("    threeDSRequestorAuthenticationInd: ").append(toIndentedString(threeDSRequestorAuthenticationInd)).append("\n");
    sb.append("    threeDSRequestorAuthenticationInfo: ").append(toIndentedString(threeDSRequestorAuthenticationInfo)).append("\n");
    sb.append("    threeDSRequestorChallengeInd: ").append(toIndentedString(threeDSRequestorChallengeInd)).append("\n");
    sb.append("    threeDSRequestorID: ").append(toIndentedString(threeDSRequestorID)).append("\n");
    sb.append("    threeDSRequestorName: ").append(toIndentedString(threeDSRequestorName)).append("\n");
    sb.append("    threeDSRequestorPriorAuthenticationInfo: ").append(toIndentedString(threeDSRequestorPriorAuthenticationInfo)).append("\n");
    sb.append("    threeDSRequestorURL: ").append(toIndentedString(threeDSRequestorURL)).append("\n");
    sb.append("    transType: ").append(toIndentedString(transType)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("    whiteListStatus: ").append(toIndentedString(whiteListStatus)).append("\n");
    sb.append("    workPhone: ").append(toIndentedString(workPhone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("acctInfo");
    openapiFields.add("acctType");
    openapiFields.add("acquirerBIN");
    openapiFields.add("acquirerMerchantID");
    openapiFields.add("addrMatch");
    openapiFields.add("authenticationOnly");
    openapiFields.add("challengeIndicator");
    openapiFields.add("deviceChannel");
    openapiFields.add("deviceRenderOptions");
    openapiFields.add("homePhone");
    openapiFields.add("mcc");
    openapiFields.add("merchantName");
    openapiFields.add("messageVersion");
    openapiFields.add("mobilePhone");
    openapiFields.add("notificationURL");
    openapiFields.add("payTokenInd");
    openapiFields.add("paymentAuthenticationUseCase");
    openapiFields.add("purchaseInstalData");
    openapiFields.add("recurringExpiry");
    openapiFields.add("recurringFrequency");
    openapiFields.add("sdkAppID");
    openapiFields.add("sdkEncData");
    openapiFields.add("sdkEphemPubKey");
    openapiFields.add("sdkMaxTimeout");
    openapiFields.add("sdkReferenceNumber");
    openapiFields.add("sdkTransID");
    openapiFields.add("sdkVersion");
    openapiFields.add("threeDSCompInd");
    openapiFields.add("threeDSRequestorAuthenticationInd");
    openapiFields.add("threeDSRequestorAuthenticationInfo");
    openapiFields.add("threeDSRequestorChallengeInd");
    openapiFields.add("threeDSRequestorID");
    openapiFields.add("threeDSRequestorName");
    openapiFields.add("threeDSRequestorPriorAuthenticationInfo");
    openapiFields.add("threeDSRequestorURL");
    openapiFields.add("transType");
    openapiFields.add("transactionType");
    openapiFields.add("whiteListStatus");
    openapiFields.add("workPhone");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("deviceChannel");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(ThreeDS2RequestData.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ThreeDS2RequestData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ThreeDS2RequestData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDS2RequestData is not found in the empty JSON string", ThreeDS2RequestData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ThreeDS2RequestData.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ThreeDS2RequestData` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : ThreeDS2RequestData.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field `acctInfo`
      if (jsonObj.getAsJsonObject("acctInfo") != null) {
        AcctInfo.validateJsonObject(jsonObj.getAsJsonObject("acctInfo"));
      }
      // ensure the field acctType can be parsed to an enum value
      if (jsonObj.get("acctType") != null) {
        if(!jsonObj.get("acctType").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `acctType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acctType").toString()));
        }
        AcctTypeEnum.fromValue(jsonObj.get("acctType").getAsString());
      }
      // validate the optional field acquirerBIN
      if (jsonObj.get("acquirerBIN") != null && !jsonObj.get("acquirerBIN").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `acquirerBIN` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acquirerBIN").toString()));
      }
      // validate the optional field acquirerMerchantID
      if (jsonObj.get("acquirerMerchantID") != null && !jsonObj.get("acquirerMerchantID").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `acquirerMerchantID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("acquirerMerchantID").toString()));
      }
      // ensure the field addrMatch can be parsed to an enum value
      if (jsonObj.get("addrMatch") != null) {
        if(!jsonObj.get("addrMatch").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `addrMatch` to be a primitive type in the JSON string but got `%s`", jsonObj.get("addrMatch").toString()));
        }
        AddrMatchEnum.fromValue(jsonObj.get("addrMatch").getAsString());
      }
      // ensure the field challengeIndicator can be parsed to an enum value
      if (jsonObj.get("challengeIndicator") != null) {
        if(!jsonObj.get("challengeIndicator").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `challengeIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get("challengeIndicator").toString()));
        }
        ChallengeIndicatorEnum.fromValue(jsonObj.get("challengeIndicator").getAsString());
      }
      // validate the optional field deviceChannel
      if (jsonObj.get("deviceChannel") != null && !jsonObj.get("deviceChannel").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `deviceChannel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("deviceChannel").toString()));
      }
      // validate the optional field `deviceRenderOptions`
      if (jsonObj.getAsJsonObject("deviceRenderOptions") != null) {
        DeviceRenderOptions.validateJsonObject(jsonObj.getAsJsonObject("deviceRenderOptions"));
      }
      // validate the optional field `homePhone`
      if (jsonObj.getAsJsonObject("homePhone") != null) {
        Phone.validateJsonObject(jsonObj.getAsJsonObject("homePhone"));
      }
      // validate the optional field mcc
      if (jsonObj.get("mcc") != null && !jsonObj.get("mcc").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("mcc").toString()));
      }
      // validate the optional field merchantName
      if (jsonObj.get("merchantName") != null && !jsonObj.get("merchantName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantName").toString()));
      }
      // validate the optional field messageVersion
      if (jsonObj.get("messageVersion") != null && !jsonObj.get("messageVersion").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `messageVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get("messageVersion").toString()));
      }
      // validate the optional field `mobilePhone`
      if (jsonObj.getAsJsonObject("mobilePhone") != null) {
        Phone.validateJsonObject(jsonObj.getAsJsonObject("mobilePhone"));
      }
      // validate the optional field notificationURL
      if (jsonObj.get("notificationURL") != null && !jsonObj.get("notificationURL").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `notificationURL` to be a primitive type in the JSON string but got `%s`", jsonObj.get("notificationURL").toString()));
      }
      // validate the optional field paymentAuthenticationUseCase
      if (jsonObj.get("paymentAuthenticationUseCase") != null && !jsonObj.get("paymentAuthenticationUseCase").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `paymentAuthenticationUseCase` to be a primitive type in the JSON string but got `%s`", jsonObj.get("paymentAuthenticationUseCase").toString()));
      }
      // validate the optional field purchaseInstalData
      if (jsonObj.get("purchaseInstalData") != null && !jsonObj.get("purchaseInstalData").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `purchaseInstalData` to be a primitive type in the JSON string but got `%s`", jsonObj.get("purchaseInstalData").toString()));
      }
      // validate the optional field recurringExpiry
      if (jsonObj.get("recurringExpiry") != null && !jsonObj.get("recurringExpiry").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurringExpiry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringExpiry").toString()));
      }
      // validate the optional field recurringFrequency
      if (jsonObj.get("recurringFrequency") != null && !jsonObj.get("recurringFrequency").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `recurringFrequency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("recurringFrequency").toString()));
      }
      // validate the optional field sdkAppID
      if (jsonObj.get("sdkAppID") != null && !jsonObj.get("sdkAppID").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `sdkAppID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdkAppID").toString()));
      }
      // validate the optional field sdkEncData
      if (jsonObj.get("sdkEncData") != null && !jsonObj.get("sdkEncData").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `sdkEncData` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdkEncData").toString()));
      }
      // validate the optional field `sdkEphemPubKey`
      if (jsonObj.getAsJsonObject("sdkEphemPubKey") != null) {
        SDKEphemPubKey.validateJsonObject(jsonObj.getAsJsonObject("sdkEphemPubKey"));
      }
      // validate the optional field sdkReferenceNumber
      if (jsonObj.get("sdkReferenceNumber") != null && !jsonObj.get("sdkReferenceNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `sdkReferenceNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdkReferenceNumber").toString()));
      }
      // validate the optional field sdkTransID
      if (jsonObj.get("sdkTransID") != null && !jsonObj.get("sdkTransID").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `sdkTransID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdkTransID").toString()));
      }
      // validate the optional field sdkVersion
      if (jsonObj.get("sdkVersion") != null && !jsonObj.get("sdkVersion").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `sdkVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdkVersion").toString()));
      }
      // validate the optional field threeDSCompInd
      if (jsonObj.get("threeDSCompInd") != null && !jsonObj.get("threeDSCompInd").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDSCompInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSCompInd").toString()));
      }
      // validate the optional field threeDSRequestorAuthenticationInd
      if (jsonObj.get("threeDSRequestorAuthenticationInd") != null && !jsonObj.get("threeDSRequestorAuthenticationInd").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDSRequestorAuthenticationInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSRequestorAuthenticationInd").toString()));
      }
      // validate the optional field `threeDSRequestorAuthenticationInfo`
      if (jsonObj.getAsJsonObject("threeDSRequestorAuthenticationInfo") != null) {
        ThreeDSRequestorAuthenticationInfo.validateJsonObject(jsonObj.getAsJsonObject("threeDSRequestorAuthenticationInfo"));
      }
      // ensure the field threeDSRequestorChallengeInd can be parsed to an enum value
      if (jsonObj.get("threeDSRequestorChallengeInd") != null) {
        if(!jsonObj.get("threeDSRequestorChallengeInd").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `threeDSRequestorChallengeInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSRequestorChallengeInd").toString()));
        }
        ThreeDSRequestorChallengeIndEnum.fromValue(jsonObj.get("threeDSRequestorChallengeInd").getAsString());
      }
      // validate the optional field threeDSRequestorID
      if (jsonObj.get("threeDSRequestorID") != null && !jsonObj.get("threeDSRequestorID").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDSRequestorID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSRequestorID").toString()));
      }
      // validate the optional field threeDSRequestorName
      if (jsonObj.get("threeDSRequestorName") != null && !jsonObj.get("threeDSRequestorName").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDSRequestorName` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSRequestorName").toString()));
      }
      // validate the optional field `threeDSRequestorPriorAuthenticationInfo`
      if (jsonObj.getAsJsonObject("threeDSRequestorPriorAuthenticationInfo") != null) {
        ThreeDSRequestorPriorAuthenticationInfo.validateJsonObject(jsonObj.getAsJsonObject("threeDSRequestorPriorAuthenticationInfo"));
      }
      // validate the optional field threeDSRequestorURL
      if (jsonObj.get("threeDSRequestorURL") != null && !jsonObj.get("threeDSRequestorURL").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDSRequestorURL` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSRequestorURL").toString()));
      }
      // ensure the field transType can be parsed to an enum value
      if (jsonObj.get("transType") != null) {
        if(!jsonObj.get("transType").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `transType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transType").toString()));
        }
        TransTypeEnum.fromValue(jsonObj.get("transType").getAsString());
      }
      // ensure the field transactionType can be parsed to an enum value
      if (jsonObj.get("transactionType") != null) {
        if(!jsonObj.get("transactionType").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `transactionType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transactionType").toString()));
        }
        TransactionTypeEnum.fromValue(jsonObj.get("transactionType").getAsString());
      }
      // validate the optional field whiteListStatus
      if (jsonObj.get("whiteListStatus") != null && !jsonObj.get("whiteListStatus").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `whiteListStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get("whiteListStatus").toString()));
      }
      // validate the optional field `workPhone`
      if (jsonObj.getAsJsonObject("workPhone") != null) {
        Phone.validateJsonObject(jsonObj.getAsJsonObject("workPhone"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ThreeDS2RequestData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ThreeDS2RequestData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ThreeDS2RequestData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ThreeDS2RequestData.class));

       return (TypeAdapter<T>) new TypeAdapter<ThreeDS2RequestData>() {
           @Override
           public void write(JsonWriter out, ThreeDS2RequestData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ThreeDS2RequestData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ThreeDS2RequestData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ThreeDS2RequestData
  * @throws IOException if the JSON string is invalid with respect to ThreeDS2RequestData
  */
  public static ThreeDS2RequestData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ThreeDS2RequestData.class);
  }

 /**
  * Convert an instance of ThreeDS2RequestData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

