/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.payment.JSON;

/**
 * ThreeDSecureData
 */

public class ThreeDSecureData {
  /**
   * In 3D Secure 1, the authentication response if the shopper was redirected.  In 3D Secure 2, this is the &#x60;transStatus&#x60; from the challenge result. If the transaction was frictionless, omit this parameter.
   */
  @JsonAdapter(AuthenticationResponseEnum.Adapter.class)
  public enum AuthenticationResponseEnum {
    Y("Y"),
    
    N("N"),
    
    U("U"),
    
    A("A");

    private String value;

    AuthenticationResponseEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AuthenticationResponseEnum fromValue(String value) {
      for (AuthenticationResponseEnum b : AuthenticationResponseEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AuthenticationResponseEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AuthenticationResponseEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AuthenticationResponseEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AuthenticationResponseEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_AUTHENTICATION_RESPONSE = "authenticationResponse";
  @SerializedName(SERIALIZED_NAME_AUTHENTICATION_RESPONSE)
  private AuthenticationResponseEnum authenticationResponse;

  public static final String SERIALIZED_NAME_CAVV = "cavv";
  @SerializedName(SERIALIZED_NAME_CAVV)
  private byte[] cavv;

  public static final String SERIALIZED_NAME_CAVV_ALGORITHM = "cavvAlgorithm";
  @SerializedName(SERIALIZED_NAME_CAVV_ALGORITHM)
  private String cavvAlgorithm;

  /**
   * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).
   */
  @JsonAdapter(ChallengeCancelEnum.Adapter.class)
  public enum ChallengeCancelEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05"),
    
    _06("06"),
    
    _07("07");

    private String value;

    ChallengeCancelEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ChallengeCancelEnum fromValue(String value) {
      for (ChallengeCancelEnum b : ChallengeCancelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ChallengeCancelEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ChallengeCancelEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ChallengeCancelEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ChallengeCancelEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CHALLENGE_CANCEL = "challengeCancel";
  @SerializedName(SERIALIZED_NAME_CHALLENGE_CANCEL)
  private ChallengeCancelEnum challengeCancel;

  /**
   * In 3D Secure 1, this is the enrollment response from the 3D directory server.  In 3D Secure 2, this is the &#x60;transStatus&#x60; from the &#x60;ARes&#x60;.
   */
  @JsonAdapter(DirectoryResponseEnum.Adapter.class)
  public enum DirectoryResponseEnum {
    A("A"),
    
    C("C"),
    
    D("D"),
    
    I("I"),
    
    N("N"),
    
    R("R"),
    
    U("U"),
    
    Y("Y");

    private String value;

    DirectoryResponseEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DirectoryResponseEnum fromValue(String value) {
      for (DirectoryResponseEnum b : DirectoryResponseEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DirectoryResponseEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DirectoryResponseEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DirectoryResponseEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DirectoryResponseEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DIRECTORY_RESPONSE = "directoryResponse";
  @SerializedName(SERIALIZED_NAME_DIRECTORY_RESPONSE)
  private DirectoryResponseEnum directoryResponse;

  public static final String SERIALIZED_NAME_DS_TRANS_I_D = "dsTransID";
  @SerializedName(SERIALIZED_NAME_DS_TRANS_I_D)
  private String dsTransID;

  public static final String SERIALIZED_NAME_ECI = "eci";
  @SerializedName(SERIALIZED_NAME_ECI)
  private String eci;

  public static final String SERIALIZED_NAME_RISK_SCORE = "riskScore";
  @SerializedName(SERIALIZED_NAME_RISK_SCORE)
  private String riskScore;

  public static final String SERIALIZED_NAME_THREE_D_S_VERSION = "threeDSVersion";
  @SerializedName(SERIALIZED_NAME_THREE_D_S_VERSION)
  private String threeDSVersion;

  public static final String SERIALIZED_NAME_TOKEN_AUTHENTICATION_VERIFICATION_VALUE = "tokenAuthenticationVerificationValue";
  @SerializedName(SERIALIZED_NAME_TOKEN_AUTHENTICATION_VERIFICATION_VALUE)
  private byte[] tokenAuthenticationVerificationValue;

  public static final String SERIALIZED_NAME_TRANS_STATUS_REASON = "transStatusReason";
  @SerializedName(SERIALIZED_NAME_TRANS_STATUS_REASON)
  private String transStatusReason;

  public static final String SERIALIZED_NAME_XID = "xid";
  @SerializedName(SERIALIZED_NAME_XID)
  private byte[] xid;

  public ThreeDSecureData() { 
  }

  public ThreeDSecureData authenticationResponse(AuthenticationResponseEnum authenticationResponse) {
    
    this.authenticationResponse = authenticationResponse;
    return this;
  }

   /**
   * In 3D Secure 1, the authentication response if the shopper was redirected.  In 3D Secure 2, this is the &#x60;transStatus&#x60; from the challenge result. If the transaction was frictionless, omit this parameter.
   * @return authenticationResponse
  **/
  @ApiModelProperty(value = "In 3D Secure 1, the authentication response if the shopper was redirected.  In 3D Secure 2, this is the `transStatus` from the challenge result. If the transaction was frictionless, omit this parameter.")

  public AuthenticationResponseEnum getAuthenticationResponse() {
    return authenticationResponse;
  }


  public void setAuthenticationResponse(AuthenticationResponseEnum authenticationResponse) {
    this.authenticationResponse = authenticationResponse;
  }


  public ThreeDSecureData cavv(byte[] cavv) {
    
    this.cavv = cavv;
    return this;
  }

   /**
   * The cardholder authentication value (base64 encoded, 20 bytes in a decoded form).
   * @return cavv
  **/
  @ApiModelProperty(value = "The cardholder authentication value (base64 encoded, 20 bytes in a decoded form).")

  public byte[] getCavv() {
    return cavv;
  }


  public void setCavv(byte[] cavv) {
    this.cavv = cavv;
  }


  public ThreeDSecureData cavvAlgorithm(String cavvAlgorithm) {
    
    this.cavvAlgorithm = cavvAlgorithm;
    return this;
  }

   /**
   * The CAVV algorithm used. Include this only for 3D Secure 1.
   * @return cavvAlgorithm
  **/
  @ApiModelProperty(value = "The CAVV algorithm used. Include this only for 3D Secure 1.")

  public String getCavvAlgorithm() {
    return cavvAlgorithm;
  }


  public void setCavvAlgorithm(String cavvAlgorithm) {
    this.cavvAlgorithm = cavvAlgorithm;
  }


  public ThreeDSecureData challengeCancel(ChallengeCancelEnum challengeCancel) {
    
    this.challengeCancel = challengeCancel;
    return this;
  }

   /**
   * Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).
   * @return challengeCancel
  **/
  @ApiModelProperty(value = "Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).")

  public ChallengeCancelEnum getChallengeCancel() {
    return challengeCancel;
  }


  public void setChallengeCancel(ChallengeCancelEnum challengeCancel) {
    this.challengeCancel = challengeCancel;
  }


  public ThreeDSecureData directoryResponse(DirectoryResponseEnum directoryResponse) {
    
    this.directoryResponse = directoryResponse;
    return this;
  }

   /**
   * In 3D Secure 1, this is the enrollment response from the 3D directory server.  In 3D Secure 2, this is the &#x60;transStatus&#x60; from the &#x60;ARes&#x60;.
   * @return directoryResponse
  **/
  @ApiModelProperty(value = "In 3D Secure 1, this is the enrollment response from the 3D directory server.  In 3D Secure 2, this is the `transStatus` from the `ARes`.")

  public DirectoryResponseEnum getDirectoryResponse() {
    return directoryResponse;
  }


  public void setDirectoryResponse(DirectoryResponseEnum directoryResponse) {
    this.directoryResponse = directoryResponse;
  }


  public ThreeDSecureData dsTransID(String dsTransID) {
    
    this.dsTransID = dsTransID;
    return this;
  }

   /**
   * Supported for 3D Secure 2. The unique transaction identifier assigned by the Directory Server (DS) to identify a single transaction.
   * @return dsTransID
  **/
  @ApiModelProperty(value = "Supported for 3D Secure 2. The unique transaction identifier assigned by the Directory Server (DS) to identify a single transaction.")

  public String getDsTransID() {
    return dsTransID;
  }


  public void setDsTransID(String dsTransID) {
    this.dsTransID = dsTransID;
  }


  public ThreeDSecureData eci(String eci) {
    
    this.eci = eci;
    return this;
  }

   /**
   * The electronic commerce indicator.
   * @return eci
  **/
  @ApiModelProperty(value = "The electronic commerce indicator.")

  public String getEci() {
    return eci;
  }


  public void setEci(String eci) {
    this.eci = eci;
  }


  public ThreeDSecureData riskScore(String riskScore) {
    
    this.riskScore = riskScore;
    return this;
  }

   /**
   * Risk score calculated by Directory Server (DS). Required for Cartes Bancaires integrations.
   * @return riskScore
  **/
  @ApiModelProperty(value = "Risk score calculated by Directory Server (DS). Required for Cartes Bancaires integrations.")

  public String getRiskScore() {
    return riskScore;
  }


  public void setRiskScore(String riskScore) {
    this.riskScore = riskScore;
  }


  public ThreeDSecureData threeDSVersion(String threeDSVersion) {
    
    this.threeDSVersion = threeDSVersion;
    return this;
  }

   /**
   * The version of the 3D Secure protocol.
   * @return threeDSVersion
  **/
  @ApiModelProperty(value = "The version of the 3D Secure protocol.")

  public String getThreeDSVersion() {
    return threeDSVersion;
  }


  public void setThreeDSVersion(String threeDSVersion) {
    this.threeDSVersion = threeDSVersion;
  }


  public ThreeDSecureData tokenAuthenticationVerificationValue(byte[] tokenAuthenticationVerificationValue) {
    
    this.tokenAuthenticationVerificationValue = tokenAuthenticationVerificationValue;
    return this;
  }

   /**
   * Network token authentication verification value (TAVV). The network token cryptogram.
   * @return tokenAuthenticationVerificationValue
  **/
  @ApiModelProperty(value = "Network token authentication verification value (TAVV). The network token cryptogram.")

  public byte[] getTokenAuthenticationVerificationValue() {
    return tokenAuthenticationVerificationValue;
  }


  public void setTokenAuthenticationVerificationValue(byte[] tokenAuthenticationVerificationValue) {
    this.tokenAuthenticationVerificationValue = tokenAuthenticationVerificationValue;
  }


  public ThreeDSecureData transStatusReason(String transStatusReason) {
    
    this.transStatusReason = transStatusReason;
    return this;
  }

   /**
   * Provides information on why the &#x60;transStatus&#x60; field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).
   * @return transStatusReason
  **/
  @ApiModelProperty(value = "Provides information on why the `transStatus` field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).")

  public String getTransStatusReason() {
    return transStatusReason;
  }


  public void setTransStatusReason(String transStatusReason) {
    this.transStatusReason = transStatusReason;
  }


  public ThreeDSecureData xid(byte[] xid) {
    
    this.xid = xid;
    return this;
  }

   /**
   * Supported for 3D Secure 1. The transaction identifier (Base64-encoded, 20 bytes in a decoded form).
   * @return xid
  **/
  @ApiModelProperty(value = "Supported for 3D Secure 1. The transaction identifier (Base64-encoded, 20 bytes in a decoded form).")

  public byte[] getXid() {
    return xid;
  }


  public void setXid(byte[] xid) {
    this.xid = xid;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThreeDSecureData threeDSecureData = (ThreeDSecureData) o;
    return Objects.equals(this.authenticationResponse, threeDSecureData.authenticationResponse) &&
        Arrays.equals(this.cavv, threeDSecureData.cavv) &&
        Objects.equals(this.cavvAlgorithm, threeDSecureData.cavvAlgorithm) &&
        Objects.equals(this.challengeCancel, threeDSecureData.challengeCancel) &&
        Objects.equals(this.directoryResponse, threeDSecureData.directoryResponse) &&
        Objects.equals(this.dsTransID, threeDSecureData.dsTransID) &&
        Objects.equals(this.eci, threeDSecureData.eci) &&
        Objects.equals(this.riskScore, threeDSecureData.riskScore) &&
        Objects.equals(this.threeDSVersion, threeDSecureData.threeDSVersion) &&
        Arrays.equals(this.tokenAuthenticationVerificationValue, threeDSecureData.tokenAuthenticationVerificationValue) &&
        Objects.equals(this.transStatusReason, threeDSecureData.transStatusReason) &&
        Arrays.equals(this.xid, threeDSecureData.xid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authenticationResponse, Arrays.hashCode(cavv), cavvAlgorithm, challengeCancel, directoryResponse, dsTransID, eci, riskScore, threeDSVersion, Arrays.hashCode(tokenAuthenticationVerificationValue), transStatusReason, Arrays.hashCode(xid));
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThreeDSecureData {\n");
    sb.append("    authenticationResponse: ").append(toIndentedString(authenticationResponse)).append("\n");
    sb.append("    cavv: ").append(toIndentedString(cavv)).append("\n");
    sb.append("    cavvAlgorithm: ").append(toIndentedString(cavvAlgorithm)).append("\n");
    sb.append("    challengeCancel: ").append(toIndentedString(challengeCancel)).append("\n");
    sb.append("    directoryResponse: ").append(toIndentedString(directoryResponse)).append("\n");
    sb.append("    dsTransID: ").append(toIndentedString(dsTransID)).append("\n");
    sb.append("    eci: ").append(toIndentedString(eci)).append("\n");
    sb.append("    riskScore: ").append(toIndentedString(riskScore)).append("\n");
    sb.append("    threeDSVersion: ").append(toIndentedString(threeDSVersion)).append("\n");
    sb.append("    tokenAuthenticationVerificationValue: ").append(toIndentedString(tokenAuthenticationVerificationValue)).append("\n");
    sb.append("    transStatusReason: ").append(toIndentedString(transStatusReason)).append("\n");
    sb.append("    xid: ").append(toIndentedString(xid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("authenticationResponse");
    openapiFields.add("cavv");
    openapiFields.add("cavvAlgorithm");
    openapiFields.add("challengeCancel");
    openapiFields.add("directoryResponse");
    openapiFields.add("dsTransID");
    openapiFields.add("eci");
    openapiFields.add("riskScore");
    openapiFields.add("threeDSVersion");
    openapiFields.add("tokenAuthenticationVerificationValue");
    openapiFields.add("transStatusReason");
    openapiFields.add("xid");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(ThreeDSecureData.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ThreeDSecureData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ThreeDSecureData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDSecureData is not found in the empty JSON string", ThreeDSecureData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ThreeDSecureData.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ThreeDSecureData` properties.", entry.getKey()));
        }
      }
      // ensure the field authenticationResponse can be parsed to an enum value
      if (jsonObj.get("authenticationResponse") != null) {
        if(!jsonObj.get("authenticationResponse").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `authenticationResponse` to be a primitive type in the JSON string but got `%s`", jsonObj.get("authenticationResponse").toString()));
        }
        AuthenticationResponseEnum.fromValue(jsonObj.get("authenticationResponse").getAsString());
      }
      // validate the optional field cavvAlgorithm
      if (jsonObj.get("cavvAlgorithm") != null && !jsonObj.get("cavvAlgorithm").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `cavvAlgorithm` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cavvAlgorithm").toString()));
      }
      // ensure the field challengeCancel can be parsed to an enum value
      if (jsonObj.get("challengeCancel") != null) {
        if(!jsonObj.get("challengeCancel").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `challengeCancel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("challengeCancel").toString()));
        }
        ChallengeCancelEnum.fromValue(jsonObj.get("challengeCancel").getAsString());
      }
      // ensure the field directoryResponse can be parsed to an enum value
      if (jsonObj.get("directoryResponse") != null) {
        if(!jsonObj.get("directoryResponse").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `directoryResponse` to be a primitive type in the JSON string but got `%s`", jsonObj.get("directoryResponse").toString()));
        }
        DirectoryResponseEnum.fromValue(jsonObj.get("directoryResponse").getAsString());
      }
      // validate the optional field dsTransID
      if (jsonObj.get("dsTransID") != null && !jsonObj.get("dsTransID").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `dsTransID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("dsTransID").toString()));
      }
      // validate the optional field eci
      if (jsonObj.get("eci") != null && !jsonObj.get("eci").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `eci` to be a primitive type in the JSON string but got `%s`", jsonObj.get("eci").toString()));
      }
      // validate the optional field riskScore
      if (jsonObj.get("riskScore") != null && !jsonObj.get("riskScore").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `riskScore` to be a primitive type in the JSON string but got `%s`", jsonObj.get("riskScore").toString()));
      }
      // validate the optional field threeDSVersion
      if (jsonObj.get("threeDSVersion") != null && !jsonObj.get("threeDSVersion").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `threeDSVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get("threeDSVersion").toString()));
      }
      // validate the optional field transStatusReason
      if (jsonObj.get("transStatusReason") != null && !jsonObj.get("transStatusReason").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `transStatusReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get("transStatusReason").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ThreeDSecureData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ThreeDSecureData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ThreeDSecureData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ThreeDSecureData.class));

       return (TypeAdapter<T>) new TypeAdapter<ThreeDSecureData>() {
           @Override
           public void write(JsonWriter out, ThreeDSecureData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ThreeDSecureData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ThreeDSecureData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ThreeDSecureData
  * @throws IOException if the JSON string is invalid with respect to ThreeDSecureData
  */
  public static ThreeDSecureData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ThreeDSecureData.class);
  }

 /**
  * Convert an instance of ThreeDSecureData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

