/*
 * POS Terminal Management API
 * This API provides endpoints for managing your point-of-sale (POS) payment terminals. You can use the API to obtain information about a specific terminal, retrieve overviews of your terminals and stores, and assign terminals to a merchant account or store.  For more information, refer to [Assign terminals](https://docs.adyen.com/point-of-sale/automating-terminal-management/assign-terminals-api).  ## Authentication Each request to the Terminal Management API must be signed with an API key. For this, obtain an API Key from your Customer Area, as described in [How to get the API key](https://docs.adyen.com/development-resources/api-credentials#generate-api-key). Then set this key to the `X-API-Key` header value, for example:  ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: Your_API_key\" \\ ... ``` Note that when going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning Terminal Management API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://postfmapi-test.adyen.com/postfmapi/terminal/v1/getTerminalsUnderAccount ``` When using versioned endpoints, Boolean response values are returned in string format: `\"true\"` or `\"false\"`. If you omit the version from the endpoint URL, Boolean response values are returned like this: `true` or `false`.
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.posterminalmanagement;

import java.util.Objects;
import java.util.Arrays;
import com.adyen.model.posterminalmanagement.Store;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.posterminalmanagement.JSON;

/**
 * GetTerminalDetailsResponse
 */

public class GetTerminalDetailsResponse {
  public static final String SERIALIZED_NAME_BLUETOOTH_IP = "bluetoothIp";
  @SerializedName(SERIALIZED_NAME_BLUETOOTH_IP)
  private String bluetoothIp;

  public static final String SERIALIZED_NAME_BLUETOOTH_MAC = "bluetoothMac";
  @SerializedName(SERIALIZED_NAME_BLUETOOTH_MAC)
  private String bluetoothMac;

  public static final String SERIALIZED_NAME_COMPANY_ACCOUNT = "companyAccount";
  @SerializedName(SERIALIZED_NAME_COMPANY_ACCOUNT)
  private String companyAccount;

  public static final String SERIALIZED_NAME_COUNTRY = "country";
  @SerializedName(SERIALIZED_NAME_COUNTRY)
  private String country;

  public static final String SERIALIZED_NAME_DEVICE_MODEL = "deviceModel";
  @SerializedName(SERIALIZED_NAME_DEVICE_MODEL)
  private String deviceModel;

  public static final String SERIALIZED_NAME_DHCP_ENABLED = "dhcpEnabled";
  @SerializedName(SERIALIZED_NAME_DHCP_ENABLED)
  private Boolean dhcpEnabled;

  public static final String SERIALIZED_NAME_DISPLAY_LABEL = "displayLabel";
  @SerializedName(SERIALIZED_NAME_DISPLAY_LABEL)
  private String displayLabel;

  public static final String SERIALIZED_NAME_ETHERNET_IP = "ethernetIp";
  @SerializedName(SERIALIZED_NAME_ETHERNET_IP)
  private String ethernetIp;

  public static final String SERIALIZED_NAME_ETHERNET_MAC = "ethernetMac";
  @SerializedName(SERIALIZED_NAME_ETHERNET_MAC)
  private String ethernetMac;

  public static final String SERIALIZED_NAME_FIRMWARE_VERSION = "firmwareVersion";
  @SerializedName(SERIALIZED_NAME_FIRMWARE_VERSION)
  private String firmwareVersion;

  public static final String SERIALIZED_NAME_ICCID = "iccid";
  @SerializedName(SERIALIZED_NAME_ICCID)
  private String iccid;

  public static final String SERIALIZED_NAME_LAST_ACTIVITY_DATE_TIME = "lastActivityDateTime";
  @SerializedName(SERIALIZED_NAME_LAST_ACTIVITY_DATE_TIME)
  private OffsetDateTime lastActivityDateTime;

  public static final String SERIALIZED_NAME_LAST_TRANSACTION_DATE_TIME = "lastTransactionDateTime";
  @SerializedName(SERIALIZED_NAME_LAST_TRANSACTION_DATE_TIME)
  private OffsetDateTime lastTransactionDateTime;

  public static final String SERIALIZED_NAME_LINK_NEGOTIATION = "linkNegotiation";
  @SerializedName(SERIALIZED_NAME_LINK_NEGOTIATION)
  private String linkNegotiation;

  public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
  @SerializedName(SERIALIZED_NAME_MERCHANT_ACCOUNT)
  private String merchantAccount;

  public static final String SERIALIZED_NAME_MERCHANT_INVENTORY = "merchantInventory";
  @SerializedName(SERIALIZED_NAME_MERCHANT_INVENTORY)
  private Boolean merchantInventory;

  public static final String SERIALIZED_NAME_PERMANENT_TERMINAL_ID = "permanentTerminalId";
  @SerializedName(SERIALIZED_NAME_PERMANENT_TERMINAL_ID)
  private String permanentTerminalId;

  public static final String SERIALIZED_NAME_SERIAL_NUMBER = "serialNumber";
  @SerializedName(SERIALIZED_NAME_SERIAL_NUMBER)
  private String serialNumber;

  public static final String SERIALIZED_NAME_SIM_STATUS = "simStatus";
  @SerializedName(SERIALIZED_NAME_SIM_STATUS)
  private String simStatus;

  public static final String SERIALIZED_NAME_STORE = "store";
  @SerializedName(SERIALIZED_NAME_STORE)
  private String store;

  public static final String SERIALIZED_NAME_STORE_DETAILS = "storeDetails";
  @SerializedName(SERIALIZED_NAME_STORE_DETAILS)
  private Store storeDetails;

  public static final String SERIALIZED_NAME_TERMINAL = "terminal";
  @SerializedName(SERIALIZED_NAME_TERMINAL)
  private String terminal;

  /**
   * The status of the terminal:   - &#x60;OnlineToday&#x60;, &#x60;OnlineLast1Day&#x60;, &#x60;OnlineLast2Days&#x60; etcetera to &#x60;OnlineLast7Days&#x60;: Indicates when in the past week the terminal was last online.   - &#x60;SwitchedOff&#x60;: Indicates it was more than a week ago that the terminal was last online.   - &#x60;ReAssignToInventoryPending&#x60;, &#x60;ReAssignToStorePending&#x60;, &#x60;ReAssignToMerchantInventoryPending&#x60;: Indicates the terminal is scheduled to be reassigned.
   */
  @JsonAdapter(TerminalStatusEnum.Adapter.class)
  public enum TerminalStatusEnum {
    ONLINELAST1DAY("OnlineLast1Day"),
    
    ONLINELAST2DAYS("OnlineLast2Days"),
    
    ONLINELAST3DAYS("OnlineLast3Days"),
    
    ONLINELAST4DAYS("OnlineLast4Days"),
    
    ONLINELAST5DAYS("OnlineLast5Days"),
    
    ONLINELAST6DAYS("OnlineLast6Days"),
    
    ONLINELAST7DAYS("OnlineLast7Days"),
    
    ONLINETODAY("OnlineToday"),
    
    REASSIGNTOINVENTORYPENDING("ReAssignToInventoryPending"),
    
    REASSIGNTOMERCHANTINVENTORYPENDING("ReAssignToMerchantInventoryPending"),
    
    REASSIGNTOSTOREPENDING("ReAssignToStorePending"),
    
    SWITCHEDOFF("SwitchedOff");

    private String value;

    TerminalStatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TerminalStatusEnum fromValue(String value) {
      for (TerminalStatusEnum b : TerminalStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TerminalStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TerminalStatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TerminalStatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TerminalStatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TERMINAL_STATUS = "terminalStatus";
  @SerializedName(SERIALIZED_NAME_TERMINAL_STATUS)
  private TerminalStatusEnum terminalStatus;

  public static final String SERIALIZED_NAME_WIFI_IP = "wifiIp";
  @SerializedName(SERIALIZED_NAME_WIFI_IP)
  private String wifiIp;

  public static final String SERIALIZED_NAME_WIFI_MAC = "wifiMac";
  @SerializedName(SERIALIZED_NAME_WIFI_MAC)
  private String wifiMac;

  public GetTerminalDetailsResponse() { 
  }

  public GetTerminalDetailsResponse bluetoothIp(String bluetoothIp) {
    
    this.bluetoothIp = bluetoothIp;
    return this;
  }

   /**
   * The Bluetooth IP address of the terminal.
   * @return bluetoothIp
  **/
  @ApiModelProperty(value = "The Bluetooth IP address of the terminal.")

  public String getBluetoothIp() {
    return bluetoothIp;
  }


  public void setBluetoothIp(String bluetoothIp) {
    this.bluetoothIp = bluetoothIp;
  }


  public GetTerminalDetailsResponse bluetoothMac(String bluetoothMac) {
    
    this.bluetoothMac = bluetoothMac;
    return this;
  }

   /**
   * The Bluetooth MAC address of the terminal.
   * @return bluetoothMac
  **/
  @ApiModelProperty(value = "The Bluetooth MAC address of the terminal.")

  public String getBluetoothMac() {
    return bluetoothMac;
  }


  public void setBluetoothMac(String bluetoothMac) {
    this.bluetoothMac = bluetoothMac;
  }


  public GetTerminalDetailsResponse companyAccount(String companyAccount) {
    
    this.companyAccount = companyAccount;
    return this;
  }

   /**
   * The company account that the terminal is associated with. If this is the only account level shown in the response, the terminal is assigned to the inventory of the company account.
   * @return companyAccount
  **/
  @ApiModelProperty(required = true, value = "The company account that the terminal is associated with. If this is the only account level shown in the response, the terminal is assigned to the inventory of the company account.")

  public String getCompanyAccount() {
    return companyAccount;
  }


  public void setCompanyAccount(String companyAccount) {
    this.companyAccount = companyAccount;
  }


  public GetTerminalDetailsResponse country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * The country where the terminal is used.
   * @return country
  **/
  @ApiModelProperty(value = "The country where the terminal is used.")

  public String getCountry() {
    return country;
  }


  public void setCountry(String country) {
    this.country = country;
  }


  public GetTerminalDetailsResponse deviceModel(String deviceModel) {
    
    this.deviceModel = deviceModel;
    return this;
  }

   /**
   * The model name of the terminal.
   * @return deviceModel
  **/
  @ApiModelProperty(value = "The model name of the terminal.")

  public String getDeviceModel() {
    return deviceModel;
  }


  public void setDeviceModel(String deviceModel) {
    this.deviceModel = deviceModel;
  }


  public GetTerminalDetailsResponse dhcpEnabled(Boolean dhcpEnabled) {
    
    this.dhcpEnabled = dhcpEnabled;
    return this;
  }

   /**
   * Indicates whether assigning IP addresses through a DHCP server is enabled on the terminal.
   * @return dhcpEnabled
  **/
  @ApiModelProperty(value = "Indicates whether assigning IP addresses through a DHCP server is enabled on the terminal.")

  public Boolean getDhcpEnabled() {
    return dhcpEnabled;
  }


  public void setDhcpEnabled(Boolean dhcpEnabled) {
    this.dhcpEnabled = dhcpEnabled;
  }


  public GetTerminalDetailsResponse displayLabel(String displayLabel) {
    
    this.displayLabel = displayLabel;
    return this;
  }

   /**
   * The label shown on the status bar of the display. This label (if any) is specified in your Customer Area.
   * @return displayLabel
  **/
  @ApiModelProperty(value = "The label shown on the status bar of the display. This label (if any) is specified in your Customer Area.")

  public String getDisplayLabel() {
    return displayLabel;
  }


  public void setDisplayLabel(String displayLabel) {
    this.displayLabel = displayLabel;
  }


  public GetTerminalDetailsResponse ethernetIp(String ethernetIp) {
    
    this.ethernetIp = ethernetIp;
    return this;
  }

   /**
   * The terminal&#39;s IP address in your Ethernet network.
   * @return ethernetIp
  **/
  @ApiModelProperty(value = "The terminal's IP address in your Ethernet network.")

  public String getEthernetIp() {
    return ethernetIp;
  }


  public void setEthernetIp(String ethernetIp) {
    this.ethernetIp = ethernetIp;
  }


  public GetTerminalDetailsResponse ethernetMac(String ethernetMac) {
    
    this.ethernetMac = ethernetMac;
    return this;
  }

   /**
   * The terminal&#39;s MAC address in your Ethernet network.
   * @return ethernetMac
  **/
  @ApiModelProperty(value = "The terminal's MAC address in your Ethernet network.")

  public String getEthernetMac() {
    return ethernetMac;
  }


  public void setEthernetMac(String ethernetMac) {
    this.ethernetMac = ethernetMac;
  }


  public GetTerminalDetailsResponse firmwareVersion(String firmwareVersion) {
    
    this.firmwareVersion = firmwareVersion;
    return this;
  }

   /**
   * The software release currently in use on the terminal.
   * @return firmwareVersion
  **/
  @ApiModelProperty(value = "The software release currently in use on the terminal.")

  public String getFirmwareVersion() {
    return firmwareVersion;
  }


  public void setFirmwareVersion(String firmwareVersion) {
    this.firmwareVersion = firmwareVersion;
  }


  public GetTerminalDetailsResponse iccid(String iccid) {
    
    this.iccid = iccid;
    return this;
  }

   /**
   * The integrated circuit card identifier (ICCID) of the SIM card in the terminal.
   * @return iccid
  **/
  @ApiModelProperty(value = "The integrated circuit card identifier (ICCID) of the SIM card in the terminal.")

  public String getIccid() {
    return iccid;
  }


  public void setIccid(String iccid) {
    this.iccid = iccid;
  }


  public GetTerminalDetailsResponse lastActivityDateTime(OffsetDateTime lastActivityDateTime) {
    
    this.lastActivityDateTime = lastActivityDateTime;
    return this;
  }

   /**
   * Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.
   * @return lastActivityDateTime
  **/
  @ApiModelProperty(value = "Date and time of the last activity on the terminal. Not included when the last activity was more than 14 days ago.")

  public OffsetDateTime getLastActivityDateTime() {
    return lastActivityDateTime;
  }


  public void setLastActivityDateTime(OffsetDateTime lastActivityDateTime) {
    this.lastActivityDateTime = lastActivityDateTime;
  }


  public GetTerminalDetailsResponse lastTransactionDateTime(OffsetDateTime lastTransactionDateTime) {
    
    this.lastTransactionDateTime = lastTransactionDateTime;
    return this;
  }

   /**
   * Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.
   * @return lastTransactionDateTime
  **/
  @ApiModelProperty(value = "Date and time of the last transaction on the terminal. Not included when the last transaction was more than 14 days ago.")

  public OffsetDateTime getLastTransactionDateTime() {
    return lastTransactionDateTime;
  }


  public void setLastTransactionDateTime(OffsetDateTime lastTransactionDateTime) {
    this.lastTransactionDateTime = lastTransactionDateTime;
  }


  public GetTerminalDetailsResponse linkNegotiation(String linkNegotiation) {
    
    this.linkNegotiation = linkNegotiation;
    return this;
  }

   /**
   * The Ethernet link negotiation that the terminal uses:   - &#x60;auto&#x60;: Auto-negotiation  - &#x60;100full&#x60;: 100 Mbps full duplex
   * @return linkNegotiation
  **/
  @ApiModelProperty(value = "The Ethernet link negotiation that the terminal uses:   - `auto`: Auto-negotiation  - `100full`: 100 Mbps full duplex")

  public String getLinkNegotiation() {
    return linkNegotiation;
  }


  public void setLinkNegotiation(String linkNegotiation) {
    this.linkNegotiation = linkNegotiation;
  }


  public GetTerminalDetailsResponse merchantAccount(String merchantAccount) {
    
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account that the terminal is associated with. If the response doesn&#39;t contain a &#x60;store&#x60; the terminal is assigned to this merchant account.
   * @return merchantAccount
  **/
  @ApiModelProperty(value = "The merchant account that the terminal is associated with. If the response doesn't contain a `store` the terminal is assigned to this merchant account.")

  public String getMerchantAccount() {
    return merchantAccount;
  }


  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public GetTerminalDetailsResponse merchantInventory(Boolean merchantInventory) {
    
    this.merchantInventory = merchantInventory;
    return this;
  }

   /**
   * Boolean that indicates if the terminal is assigned to the merchant inventory. This is returned when the terminal is assigned to a merchant account.  - If **true**, this indicates that the terminal is in the merchant inventory. This also means that the terminal cannot be boarded.  - If **false**, this indicates that the terminal is assigned to the merchant account as an in-store terminal. This means that the terminal is ready to be boarded, or is already boarded.
   * @return merchantInventory
  **/
  @ApiModelProperty(value = "Boolean that indicates if the terminal is assigned to the merchant inventory. This is returned when the terminal is assigned to a merchant account.  - If **true**, this indicates that the terminal is in the merchant inventory. This also means that the terminal cannot be boarded.  - If **false**, this indicates that the terminal is assigned to the merchant account as an in-store terminal. This means that the terminal is ready to be boarded, or is already boarded.")

  public Boolean getMerchantInventory() {
    return merchantInventory;
  }


  public void setMerchantInventory(Boolean merchantInventory) {
    this.merchantInventory = merchantInventory;
  }


  public GetTerminalDetailsResponse permanentTerminalId(String permanentTerminalId) {
    
    this.permanentTerminalId = permanentTerminalId;
    return this;
  }

   /**
   * The permanent terminal ID.
   * @return permanentTerminalId
  **/
  @ApiModelProperty(value = "The permanent terminal ID.")

  public String getPermanentTerminalId() {
    return permanentTerminalId;
  }


  public void setPermanentTerminalId(String permanentTerminalId) {
    this.permanentTerminalId = permanentTerminalId;
  }


  public GetTerminalDetailsResponse serialNumber(String serialNumber) {
    
    this.serialNumber = serialNumber;
    return this;
  }

   /**
   * The serial number of the terminal.
   * @return serialNumber
  **/
  @ApiModelProperty(value = "The serial number of the terminal.")

  public String getSerialNumber() {
    return serialNumber;
  }


  public void setSerialNumber(String serialNumber) {
    this.serialNumber = serialNumber;
  }


  public GetTerminalDetailsResponse simStatus(String simStatus) {
    
    this.simStatus = simStatus;
    return this;
  }

   /**
   * On a terminal that supports 3G or 4G connectivity, indicates the status of the SIM card in the terminal: ACTIVE or INVENTORY.
   * @return simStatus
  **/
  @ApiModelProperty(value = "On a terminal that supports 3G or 4G connectivity, indicates the status of the SIM card in the terminal: ACTIVE or INVENTORY.")

  public String getSimStatus() {
    return simStatus;
  }


  public void setSimStatus(String simStatus) {
    this.simStatus = simStatus;
  }


  public GetTerminalDetailsResponse store(String store) {
    
    this.store = store;
    return this;
  }

   /**
   * The store code of the store that the terminal is assigned to.
   * @return store
  **/
  @ApiModelProperty(value = "The store code of the store that the terminal is assigned to.")

  public String getStore() {
    return store;
  }


  public void setStore(String store) {
    this.store = store;
  }


  public GetTerminalDetailsResponse storeDetails(Store storeDetails) {
    
    this.storeDetails = storeDetails;
    return this;
  }

   /**
   * Get storeDetails
   * @return storeDetails
  **/
  @ApiModelProperty(value = "")

  public Store getStoreDetails() {
    return storeDetails;
  }


  public void setStoreDetails(Store storeDetails) {
    this.storeDetails = storeDetails;
  }


  public GetTerminalDetailsResponse terminal(String terminal) {
    
    this.terminal = terminal;
    return this;
  }

   /**
   * The unique terminal ID.
   * @return terminal
  **/
  @ApiModelProperty(required = true, value = "The unique terminal ID.")

  public String getTerminal() {
    return terminal;
  }


  public void setTerminal(String terminal) {
    this.terminal = terminal;
  }


  public GetTerminalDetailsResponse terminalStatus(TerminalStatusEnum terminalStatus) {
    
    this.terminalStatus = terminalStatus;
    return this;
  }

   /**
   * The status of the terminal:   - &#x60;OnlineToday&#x60;, &#x60;OnlineLast1Day&#x60;, &#x60;OnlineLast2Days&#x60; etcetera to &#x60;OnlineLast7Days&#x60;: Indicates when in the past week the terminal was last online.   - &#x60;SwitchedOff&#x60;: Indicates it was more than a week ago that the terminal was last online.   - &#x60;ReAssignToInventoryPending&#x60;, &#x60;ReAssignToStorePending&#x60;, &#x60;ReAssignToMerchantInventoryPending&#x60;: Indicates the terminal is scheduled to be reassigned.
   * @return terminalStatus
  **/
  @ApiModelProperty(value = "The status of the terminal:   - `OnlineToday`, `OnlineLast1Day`, `OnlineLast2Days` etcetera to `OnlineLast7Days`: Indicates when in the past week the terminal was last online.   - `SwitchedOff`: Indicates it was more than a week ago that the terminal was last online.   - `ReAssignToInventoryPending`, `ReAssignToStorePending`, `ReAssignToMerchantInventoryPending`: Indicates the terminal is scheduled to be reassigned.")

  public TerminalStatusEnum getTerminalStatus() {
    return terminalStatus;
  }


  public void setTerminalStatus(TerminalStatusEnum terminalStatus) {
    this.terminalStatus = terminalStatus;
  }


  public GetTerminalDetailsResponse wifiIp(String wifiIp) {
    
    this.wifiIp = wifiIp;
    return this;
  }

   /**
   * The terminal&#39;s IP address in your Wi-Fi network.
   * @return wifiIp
  **/
  @ApiModelProperty(value = "The terminal's IP address in your Wi-Fi network.")

  public String getWifiIp() {
    return wifiIp;
  }


  public void setWifiIp(String wifiIp) {
    this.wifiIp = wifiIp;
  }


  public GetTerminalDetailsResponse wifiMac(String wifiMac) {
    
    this.wifiMac = wifiMac;
    return this;
  }

   /**
   * The terminal&#39;s MAC address in your Wi-Fi network.
   * @return wifiMac
  **/
  @ApiModelProperty(value = "The terminal's MAC address in your Wi-Fi network.")

  public String getWifiMac() {
    return wifiMac;
  }


  public void setWifiMac(String wifiMac) {
    this.wifiMac = wifiMac;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetTerminalDetailsResponse getTerminalDetailsResponse = (GetTerminalDetailsResponse) o;
    return Objects.equals(this.bluetoothIp, getTerminalDetailsResponse.bluetoothIp) &&
        Objects.equals(this.bluetoothMac, getTerminalDetailsResponse.bluetoothMac) &&
        Objects.equals(this.companyAccount, getTerminalDetailsResponse.companyAccount) &&
        Objects.equals(this.country, getTerminalDetailsResponse.country) &&
        Objects.equals(this.deviceModel, getTerminalDetailsResponse.deviceModel) &&
        Objects.equals(this.dhcpEnabled, getTerminalDetailsResponse.dhcpEnabled) &&
        Objects.equals(this.displayLabel, getTerminalDetailsResponse.displayLabel) &&
        Objects.equals(this.ethernetIp, getTerminalDetailsResponse.ethernetIp) &&
        Objects.equals(this.ethernetMac, getTerminalDetailsResponse.ethernetMac) &&
        Objects.equals(this.firmwareVersion, getTerminalDetailsResponse.firmwareVersion) &&
        Objects.equals(this.iccid, getTerminalDetailsResponse.iccid) &&
        Objects.equals(this.lastActivityDateTime, getTerminalDetailsResponse.lastActivityDateTime) &&
        Objects.equals(this.lastTransactionDateTime, getTerminalDetailsResponse.lastTransactionDateTime) &&
        Objects.equals(this.linkNegotiation, getTerminalDetailsResponse.linkNegotiation) &&
        Objects.equals(this.merchantAccount, getTerminalDetailsResponse.merchantAccount) &&
        Objects.equals(this.merchantInventory, getTerminalDetailsResponse.merchantInventory) &&
        Objects.equals(this.permanentTerminalId, getTerminalDetailsResponse.permanentTerminalId) &&
        Objects.equals(this.serialNumber, getTerminalDetailsResponse.serialNumber) &&
        Objects.equals(this.simStatus, getTerminalDetailsResponse.simStatus) &&
        Objects.equals(this.store, getTerminalDetailsResponse.store) &&
        Objects.equals(this.storeDetails, getTerminalDetailsResponse.storeDetails) &&
        Objects.equals(this.terminal, getTerminalDetailsResponse.terminal) &&
        Objects.equals(this.terminalStatus, getTerminalDetailsResponse.terminalStatus) &&
        Objects.equals(this.wifiIp, getTerminalDetailsResponse.wifiIp) &&
        Objects.equals(this.wifiMac, getTerminalDetailsResponse.wifiMac);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bluetoothIp, bluetoothMac, companyAccount, country, deviceModel, dhcpEnabled, displayLabel, ethernetIp, ethernetMac, firmwareVersion, iccid, lastActivityDateTime, lastTransactionDateTime, linkNegotiation, merchantAccount, merchantInventory, permanentTerminalId, serialNumber, simStatus, store, storeDetails, terminal, terminalStatus, wifiIp, wifiMac);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetTerminalDetailsResponse {\n");
    sb.append("    bluetoothIp: ").append(toIndentedString(bluetoothIp)).append("\n");
    sb.append("    bluetoothMac: ").append(toIndentedString(bluetoothMac)).append("\n");
    sb.append("    companyAccount: ").append(toIndentedString(companyAccount)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    deviceModel: ").append(toIndentedString(deviceModel)).append("\n");
    sb.append("    dhcpEnabled: ").append(toIndentedString(dhcpEnabled)).append("\n");
    sb.append("    displayLabel: ").append(toIndentedString(displayLabel)).append("\n");
    sb.append("    ethernetIp: ").append(toIndentedString(ethernetIp)).append("\n");
    sb.append("    ethernetMac: ").append(toIndentedString(ethernetMac)).append("\n");
    sb.append("    firmwareVersion: ").append(toIndentedString(firmwareVersion)).append("\n");
    sb.append("    iccid: ").append(toIndentedString(iccid)).append("\n");
    sb.append("    lastActivityDateTime: ").append(toIndentedString(lastActivityDateTime)).append("\n");
    sb.append("    lastTransactionDateTime: ").append(toIndentedString(lastTransactionDateTime)).append("\n");
    sb.append("    linkNegotiation: ").append(toIndentedString(linkNegotiation)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    merchantInventory: ").append(toIndentedString(merchantInventory)).append("\n");
    sb.append("    permanentTerminalId: ").append(toIndentedString(permanentTerminalId)).append("\n");
    sb.append("    serialNumber: ").append(toIndentedString(serialNumber)).append("\n");
    sb.append("    simStatus: ").append(toIndentedString(simStatus)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("    storeDetails: ").append(toIndentedString(storeDetails)).append("\n");
    sb.append("    terminal: ").append(toIndentedString(terminal)).append("\n");
    sb.append("    terminalStatus: ").append(toIndentedString(terminalStatus)).append("\n");
    sb.append("    wifiIp: ").append(toIndentedString(wifiIp)).append("\n");
    sb.append("    wifiMac: ").append(toIndentedString(wifiMac)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("bluetoothIp");
    openapiFields.add("bluetoothMac");
    openapiFields.add("companyAccount");
    openapiFields.add("country");
    openapiFields.add("deviceModel");
    openapiFields.add("dhcpEnabled");
    openapiFields.add("displayLabel");
    openapiFields.add("ethernetIp");
    openapiFields.add("ethernetMac");
    openapiFields.add("firmwareVersion");
    openapiFields.add("iccid");
    openapiFields.add("lastActivityDateTime");
    openapiFields.add("lastTransactionDateTime");
    openapiFields.add("linkNegotiation");
    openapiFields.add("merchantAccount");
    openapiFields.add("merchantInventory");
    openapiFields.add("permanentTerminalId");
    openapiFields.add("serialNumber");
    openapiFields.add("simStatus");
    openapiFields.add("store");
    openapiFields.add("storeDetails");
    openapiFields.add("terminal");
    openapiFields.add("terminalStatus");
    openapiFields.add("wifiIp");
    openapiFields.add("wifiMac");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("companyAccount");
    openapiRequiredFields.add("terminal");
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(GetTerminalDetailsResponse.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to GetTerminalDetailsResponse
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (GetTerminalDetailsResponse.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in GetTerminalDetailsResponse is not found in the empty JSON string", GetTerminalDetailsResponse.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!GetTerminalDetailsResponse.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `GetTerminalDetailsResponse` properties.", entry.getKey()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : GetTerminalDetailsResponse.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      // validate the optional field bluetoothIp
      if (jsonObj.get("bluetoothIp") != null && !jsonObj.get("bluetoothIp").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `bluetoothIp` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bluetoothIp").toString()));
      }
      // validate the optional field bluetoothMac
      if (jsonObj.get("bluetoothMac") != null && !jsonObj.get("bluetoothMac").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `bluetoothMac` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bluetoothMac").toString()));
      }
      // validate the optional field companyAccount
      if (jsonObj.get("companyAccount") != null && !jsonObj.get("companyAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `companyAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("companyAccount").toString()));
      }
      // validate the optional field country
      if (jsonObj.get("country") != null && !jsonObj.get("country").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country").toString()));
      }
      // validate the optional field deviceModel
      if (jsonObj.get("deviceModel") != null && !jsonObj.get("deviceModel").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `deviceModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("deviceModel").toString()));
      }
      // validate the optional field displayLabel
      if (jsonObj.get("displayLabel") != null && !jsonObj.get("displayLabel").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `displayLabel` to be a primitive type in the JSON string but got `%s`", jsonObj.get("displayLabel").toString()));
      }
      // validate the optional field ethernetIp
      if (jsonObj.get("ethernetIp") != null && !jsonObj.get("ethernetIp").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `ethernetIp` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ethernetIp").toString()));
      }
      // validate the optional field ethernetMac
      if (jsonObj.get("ethernetMac") != null && !jsonObj.get("ethernetMac").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `ethernetMac` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ethernetMac").toString()));
      }
      // validate the optional field firmwareVersion
      if (jsonObj.get("firmwareVersion") != null && !jsonObj.get("firmwareVersion").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `firmwareVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get("firmwareVersion").toString()));
      }
      // validate the optional field iccid
      if (jsonObj.get("iccid") != null && !jsonObj.get("iccid").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `iccid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("iccid").toString()));
      }
      // validate the optional field linkNegotiation
      if (jsonObj.get("linkNegotiation") != null && !jsonObj.get("linkNegotiation").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `linkNegotiation` to be a primitive type in the JSON string but got `%s`", jsonObj.get("linkNegotiation").toString()));
      }
      // validate the optional field merchantAccount
      if (jsonObj.get("merchantAccount") != null && !jsonObj.get("merchantAccount").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get("merchantAccount").toString()));
      }
      // validate the optional field permanentTerminalId
      if (jsonObj.get("permanentTerminalId") != null && !jsonObj.get("permanentTerminalId").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `permanentTerminalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("permanentTerminalId").toString()));
      }
      // validate the optional field serialNumber
      if (jsonObj.get("serialNumber") != null && !jsonObj.get("serialNumber").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `serialNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("serialNumber").toString()));
      }
      // validate the optional field simStatus
      if (jsonObj.get("simStatus") != null && !jsonObj.get("simStatus").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `simStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get("simStatus").toString()));
      }
      // validate the optional field store
      if (jsonObj.get("store") != null && !jsonObj.get("store").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get("store").toString()));
      }
      // validate the optional field `storeDetails`
      if (jsonObj.getAsJsonObject("storeDetails") != null) {
        Store.validateJsonObject(jsonObj.getAsJsonObject("storeDetails"));
      }
      // validate the optional field terminal
      if (jsonObj.get("terminal") != null && !jsonObj.get("terminal").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `terminal` to be a primitive type in the JSON string but got `%s`", jsonObj.get("terminal").toString()));
      }
      // ensure the field terminalStatus can be parsed to an enum value
      if (jsonObj.get("terminalStatus") != null) {
        if(!jsonObj.get("terminalStatus").isJsonPrimitive()) {
          throw new IllegalArgumentException(String.format("Expected the field `terminalStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get("terminalStatus").toString()));
        }
        TerminalStatusEnum.fromValue(jsonObj.get("terminalStatus").getAsString());
      }
      // validate the optional field wifiIp
      if (jsonObj.get("wifiIp") != null && !jsonObj.get("wifiIp").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `wifiIp` to be a primitive type in the JSON string but got `%s`", jsonObj.get("wifiIp").toString()));
      }
      // validate the optional field wifiMac
      if (jsonObj.get("wifiMac") != null && !jsonObj.get("wifiMac").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `wifiMac` to be a primitive type in the JSON string but got `%s`", jsonObj.get("wifiMac").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GetTerminalDetailsResponse.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GetTerminalDetailsResponse' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GetTerminalDetailsResponse> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GetTerminalDetailsResponse.class));

       return (TypeAdapter<T>) new TypeAdapter<GetTerminalDetailsResponse>() {
           @Override
           public void write(JsonWriter out, GetTerminalDetailsResponse value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GetTerminalDetailsResponse read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GetTerminalDetailsResponse given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GetTerminalDetailsResponse
  * @throws IOException if the JSON string is invalid with respect to GetTerminalDetailsResponse
  */
  public static GetTerminalDetailsResponse fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GetTerminalDetailsResponse.class);
  }

 /**
  * Convert an instance of GetTerminalDetailsResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

