/*
 * Transfer webhooks
 *
 * The version of the OpenAPI document: 3
 * Contact: developer-experience@adyen.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transferwebhooks;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.adyen.model.transferwebhooks.JSON;

/**
 * BalanceMutation
 */

public class BalanceMutation {
  public static final String SERIALIZED_NAME_BALANCE = "balance";
  @SerializedName(SERIALIZED_NAME_BALANCE)
  private Long balance;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_RECEIVED = "received";
  @SerializedName(SERIALIZED_NAME_RECEIVED)
  private Long received;

  public static final String SERIALIZED_NAME_RESERVED = "reserved";
  @SerializedName(SERIALIZED_NAME_RESERVED)
  private Long reserved;

  public BalanceMutation() { 
  }

  public BalanceMutation balance(Long balance) {
    
    this.balance = balance;
    return this;
  }

   /**
   * The amount in the payment&#39;s currency that is debited or credited on the balance accounting register.
   * @return balance
  **/
  @ApiModelProperty(value = "The amount in the payment's currency that is debited or credited on the balance accounting register.")

  public Long getBalance() {
    return balance;
  }


  public void setBalance(Long balance) {
    this.balance = balance;
  }


  public BalanceMutation currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).
   * @return currency
  **/
  @ApiModelProperty(value = "The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).")

  public String getCurrency() {
    return currency;
  }


  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public BalanceMutation received(Long received) {
    
    this.received = received;
    return this;
  }

   /**
   * The amount in the payment&#39;s currency that is debited or credited on the received accounting register.
   * @return received
  **/
  @ApiModelProperty(value = "The amount in the payment's currency that is debited or credited on the received accounting register.")

  public Long getReceived() {
    return received;
  }


  public void setReceived(Long received) {
    this.received = received;
  }


  public BalanceMutation reserved(Long reserved) {
    
    this.reserved = reserved;
    return this;
  }

   /**
   * The amount in the payment&#39;s currency that is debited or credited on the reserved accounting register.
   * @return reserved
  **/
  @ApiModelProperty(value = "The amount in the payment's currency that is debited or credited on the reserved accounting register.")

  public Long getReserved() {
    return reserved;
  }


  public void setReserved(Long reserved) {
    this.reserved = reserved;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceMutation balanceMutation = (BalanceMutation) o;
    return Objects.equals(this.balance, balanceMutation.balance) &&
        Objects.equals(this.currency, balanceMutation.currency) &&
        Objects.equals(this.received, balanceMutation.received) &&
        Objects.equals(this.reserved, balanceMutation.reserved);
  }

  @Override
  public int hashCode() {
    return Objects.hash(balance, currency, received, reserved);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceMutation {\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    received: ").append(toIndentedString(received)).append("\n");
    sb.append("    reserved: ").append(toIndentedString(reserved)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("balance");
    openapiFields.add("currency");
    openapiFields.add("received");
    openapiFields.add("reserved");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }
  /**
  * logger for Deserialization Errors
  */
  private static final Logger log = Logger.getLogger(BalanceMutation.class.getName());

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to BalanceMutation
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (BalanceMutation.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in BalanceMutation is not found in the empty JSON string", BalanceMutation.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!BalanceMutation.openapiFields.contains(entry.getKey())) {
          log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BalanceMutation` properties.", entry.getKey()));
        }
      }
      // validate the optional field currency
      if (jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonPrimitive()) {
        log.log(Level.WARNING, String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!BalanceMutation.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'BalanceMutation' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<BalanceMutation> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(BalanceMutation.class));

       return (TypeAdapter<T>) new TypeAdapter<BalanceMutation>() {
           @Override
           public void write(JsonWriter out, BalanceMutation value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public BalanceMutation read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of BalanceMutation given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of BalanceMutation
  * @throws IOException if the JSON string is invalid with respect to BalanceMutation
  */
  public static BalanceMutation fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, BalanceMutation.class);
  }

 /**
  * Convert an instance of BalanceMutation to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

