/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.Avs;
import com.adyen.model.checkout.InstallmentsNumber;
import com.adyen.model.checkout.ShopperInput;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ModelConfiguration
 */
@JsonPropertyOrder({
  ModelConfiguration.JSON_PROPERTY_AVS,
  ModelConfiguration.JSON_PROPERTY_CARD_HOLDER_NAME,
  ModelConfiguration.JSON_PROPERTY_INSTALLMENTS,
  ModelConfiguration.JSON_PROPERTY_SHOPPER_INPUT
})
@JsonTypeName("Configuration")

public class ModelConfiguration {
  public static final String JSON_PROPERTY_AVS = "avs";
  private Avs avs;

  /**
   * Determines whether the cardholder name should be provided or not.  Permitted values: * NONE * OPTIONAL * REQUIRED
   */
  public enum CardHolderNameEnum {
    NONE("NONE"),
    
    OPTIONAL("OPTIONAL"),
    
    REQUIRED("REQUIRED");

    private String value;

    CardHolderNameEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CardHolderNameEnum fromValue(String value) {
      for (CardHolderNameEnum b : CardHolderNameEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CARD_HOLDER_NAME = "cardHolderName";
  private CardHolderNameEnum cardHolderName;

  public static final String JSON_PROPERTY_INSTALLMENTS = "installments";
  private InstallmentsNumber installments;

  public static final String JSON_PROPERTY_SHOPPER_INPUT = "shopperInput";
  private ShopperInput shopperInput;

  public ModelConfiguration() { 
  }

  public ModelConfiguration avs(Avs avs) {
    this.avs = avs;
    return this;
  }

   /**
   * Get avs
   * @return avs
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Avs getAvs() {
    return avs;
  }


  @JsonProperty(JSON_PROPERTY_AVS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvs(Avs avs) {
    this.avs = avs;
  }


  public ModelConfiguration cardHolderName(CardHolderNameEnum cardHolderName) {
    this.cardHolderName = cardHolderName;
    return this;
  }

   /**
   * Determines whether the cardholder name should be provided or not.  Permitted values: * NONE * OPTIONAL * REQUIRED
   * @return cardHolderName
  **/
  @ApiModelProperty(value = "Determines whether the cardholder name should be provided or not.  Permitted values: * NONE * OPTIONAL * REQUIRED")
  @JsonProperty(JSON_PROPERTY_CARD_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CardHolderNameEnum getCardHolderName() {
    return cardHolderName;
  }


  @JsonProperty(JSON_PROPERTY_CARD_HOLDER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardHolderName(CardHolderNameEnum cardHolderName) {
    this.cardHolderName = cardHolderName;
  }


  public ModelConfiguration installments(InstallmentsNumber installments) {
    this.installments = installments;
    return this;
  }

   /**
   * Get installments
   * @return installments
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INSTALLMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InstallmentsNumber getInstallments() {
    return installments;
  }


  @JsonProperty(JSON_PROPERTY_INSTALLMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallments(InstallmentsNumber installments) {
    this.installments = installments;
  }


  public ModelConfiguration shopperInput(ShopperInput shopperInput) {
    this.shopperInput = shopperInput;
    return this;
  }

   /**
   * Get shopperInput
   * @return shopperInput
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SHOPPER_INPUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShopperInput getShopperInput() {
    return shopperInput;
  }


  @JsonProperty(JSON_PROPERTY_SHOPPER_INPUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInput(ShopperInput shopperInput) {
    this.shopperInput = shopperInput;
  }


  /**
   * Return true if this Configuration object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModelConfiguration configuration = (ModelConfiguration) o;
    return Objects.equals(this.avs, configuration.avs) &&
        Objects.equals(this.cardHolderName, configuration.cardHolderName) &&
        Objects.equals(this.installments, configuration.installments) &&
        Objects.equals(this.shopperInput, configuration.shopperInput);
  }

  @Override
  public int hashCode() {
    return Objects.hash(avs, cardHolderName, installments, shopperInput);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModelConfiguration {\n");
    sb.append("    avs: ").append(toIndentedString(avs)).append("\n");
    sb.append("    cardHolderName: ").append(toIndentedString(cardHolderName)).append("\n");
    sb.append("    installments: ").append(toIndentedString(installments)).append("\n");
    sb.append("    shopperInput: ").append(toIndentedString(shopperInput)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ModelConfiguration given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ModelConfiguration
   * @throws JsonProcessingException if the JSON string is invalid with respect to ModelConfiguration
   */
  public static ModelConfiguration fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ModelConfiguration.class);
  }
/**
  * Convert an instance of ModelConfiguration to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

