/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ShopperInput
 */
@JsonPropertyOrder({
  ShopperInput.JSON_PROPERTY_BILLING_ADDRESS,
  ShopperInput.JSON_PROPERTY_DELIVERY_ADDRESS,
  ShopperInput.JSON_PROPERTY_PERSONAL_DETAILS
})

public class ShopperInput {
  /**
   * Specifies visibility of billing address fields.  Permitted values: * editable * hidden * readOnly
   */
  public enum BillingAddressEnum {
    EDITABLE("editable"),
    
    HIDDEN("hidden"),
    
    READONLY("readOnly");

    private String value;

    BillingAddressEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BillingAddressEnum fromValue(String value) {
      for (BillingAddressEnum b : BillingAddressEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
  private BillingAddressEnum billingAddress;

  /**
   * Specifies visibility of delivery address fields.  Permitted values: * editable * hidden * readOnly
   */
  public enum DeliveryAddressEnum {
    EDITABLE("editable"),
    
    HIDDEN("hidden"),
    
    READONLY("readOnly");

    private String value;

    DeliveryAddressEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DeliveryAddressEnum fromValue(String value) {
      for (DeliveryAddressEnum b : DeliveryAddressEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
  private DeliveryAddressEnum deliveryAddress;

  /**
   * Specifies visibility of personal details.  Permitted values: * editable * hidden * readOnly
   */
  public enum PersonalDetailsEnum {
    EDITABLE("editable"),
    
    HIDDEN("hidden"),
    
    READONLY("readOnly");

    private String value;

    PersonalDetailsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PersonalDetailsEnum fromValue(String value) {
      for (PersonalDetailsEnum b : PersonalDetailsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERSONAL_DETAILS = "personalDetails";
  private PersonalDetailsEnum personalDetails;

  public ShopperInput() { 
  }

  public ShopperInput billingAddress(BillingAddressEnum billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Specifies visibility of billing address fields.  Permitted values: * editable * hidden * readOnly
   * @return billingAddress
  **/
  @ApiModelProperty(value = "Specifies visibility of billing address fields.  Permitted values: * editable * hidden * readOnly")
  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BillingAddressEnum getBillingAddress() {
    return billingAddress;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingAddress(BillingAddressEnum billingAddress) {
    this.billingAddress = billingAddress;
  }


  public ShopperInput deliveryAddress(DeliveryAddressEnum deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
    return this;
  }

   /**
   * Specifies visibility of delivery address fields.  Permitted values: * editable * hidden * readOnly
   * @return deliveryAddress
  **/
  @ApiModelProperty(value = "Specifies visibility of delivery address fields.  Permitted values: * editable * hidden * readOnly")
  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DeliveryAddressEnum getDeliveryAddress() {
    return deliveryAddress;
  }


  @JsonProperty(JSON_PROPERTY_DELIVERY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeliveryAddress(DeliveryAddressEnum deliveryAddress) {
    this.deliveryAddress = deliveryAddress;
  }


  public ShopperInput personalDetails(PersonalDetailsEnum personalDetails) {
    this.personalDetails = personalDetails;
    return this;
  }

   /**
   * Specifies visibility of personal details.  Permitted values: * editable * hidden * readOnly
   * @return personalDetails
  **/
  @ApiModelProperty(value = "Specifies visibility of personal details.  Permitted values: * editable * hidden * readOnly")
  @JsonProperty(JSON_PROPERTY_PERSONAL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PersonalDetailsEnum getPersonalDetails() {
    return personalDetails;
  }


  @JsonProperty(JSON_PROPERTY_PERSONAL_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPersonalDetails(PersonalDetailsEnum personalDetails) {
    this.personalDetails = personalDetails;
  }


  /**
   * Return true if this ShopperInput object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShopperInput shopperInput = (ShopperInput) o;
    return Objects.equals(this.billingAddress, shopperInput.billingAddress) &&
        Objects.equals(this.deliveryAddress, shopperInput.deliveryAddress) &&
        Objects.equals(this.personalDetails, shopperInput.personalDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billingAddress, deliveryAddress, personalDetails);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShopperInput {\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    deliveryAddress: ").append(toIndentedString(deliveryAddress)).append("\n");
    sb.append("    personalDetails: ").append(toIndentedString(personalDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ShopperInput given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ShopperInput
   * @throws JsonProcessingException if the JSON string is invalid with respect to ShopperInput
   */
  public static ShopperInput fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ShopperInput.class);
  }
/**
  * Convert an instance of ShopperInput to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

