/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Attachment
 */
@JsonPropertyOrder({
  Attachment.JSON_PROPERTY_CONTENT,
  Attachment.JSON_PROPERTY_CONTENT_TYPE,
  Attachment.JSON_PROPERTY_FILENAME,
  Attachment.JSON_PROPERTY_PAGE_NAME,
  Attachment.JSON_PROPERTY_PAGE_TYPE
})

public class Attachment {
  public static final String JSON_PROPERTY_CONTENT = "content";
  private byte[] content;

  public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
  private String contentType;

  public static final String JSON_PROPERTY_FILENAME = "filename";
  private String filename;

  public static final String JSON_PROPERTY_PAGE_NAME = "pageName";
  private String pageName;

  public static final String JSON_PROPERTY_PAGE_TYPE = "pageType";
  private String pageType;

  public Attachment() { 
  }

  public Attachment content(byte[] content) {
    this.content = content;
    return this;
  }

   /**
   * The document in Base64-encoded string format.
   * @return content
  **/
  @ApiModelProperty(required = true, value = "The document in Base64-encoded string format.")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public byte[] getContent() {
    return content;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContent(byte[] content) {
    this.content = content;
  }


  public Attachment contentType(String contentType) {
    this.contentType = contentType;
    return this;
  }

   /**
   * The file format.   Possible values: **application/pdf**, **image/jpg**, **image/jpeg**, **image/png**. 
   * @return contentType
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The file format.   Possible values: **application/pdf**, **image/jpg**, **image/jpeg**, **image/png**. ")
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContentType() {
    return contentType;
  }


  @Deprecated
  @JsonProperty(JSON_PROPERTY_CONTENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentType(String contentType) {
    this.contentType = contentType;
  }


  public Attachment filename(String filename) {
    this.filename = filename;
    return this;
  }

   /**
   * The name of the file including the file extension.
   * @return filename
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "The name of the file including the file extension.")
  @JsonProperty(JSON_PROPERTY_FILENAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFilename() {
    return filename;
  }


  @Deprecated
  @JsonProperty(JSON_PROPERTY_FILENAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilename(String filename) {
    this.filename = filename;
  }


  public Attachment pageName(String pageName) {
    this.pageName = pageName;
    return this;
  }

   /**
   * The name of the file including the file extension.
   * @return pageName
  **/
  @ApiModelProperty(value = "The name of the file including the file extension.")
  @JsonProperty(JSON_PROPERTY_PAGE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPageName() {
    return pageName;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageName(String pageName) {
    this.pageName = pageName;
  }


  public Attachment pageType(String pageType) {
    this.pageType = pageType;
    return this;
  }

   /**
   * Specifies which side of the ID card is uploaded.  * When &#x60;type&#x60; is **driversLicense** or **identityCard**, set this to **front** or **back**.  * When omitted, we infer the page number based on the order of attachments.
   * @return pageType
  **/
  @ApiModelProperty(value = "Specifies which side of the ID card is uploaded.  * When `type` is **driversLicense** or **identityCard**, set this to **front** or **back**.  * When omitted, we infer the page number based on the order of attachments.")
  @JsonProperty(JSON_PROPERTY_PAGE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPageType() {
    return pageType;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageType(String pageType) {
    this.pageType = pageType;
  }


  /**
   * Return true if this Attachment object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Attachment attachment = (Attachment) o;
    return Arrays.equals(this.content, attachment.content) &&
        Objects.equals(this.contentType, attachment.contentType) &&
        Objects.equals(this.filename, attachment.filename) &&
        Objects.equals(this.pageName, attachment.pageName) &&
        Objects.equals(this.pageType, attachment.pageType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Arrays.hashCode(content), contentType, filename, pageName, pageType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Attachment {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    filename: ").append(toIndentedString(filename)).append("\n");
    sb.append("    pageName: ").append(toIndentedString(pageName)).append("\n");
    sb.append("    pageType: ").append(toIndentedString(pageType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Attachment given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Attachment
   * @throws JsonProcessingException if the JSON string is invalid with respect to Attachment
   */
  public static Attachment fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Attachment.class);
  }
/**
  * Convert an instance of Attachment to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

