/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.Company;
import com.adyen.model.management.ListCompanyResponse;
import com.adyen.model.management.ListMerchantResponse;
import com.adyen.model.management.RestServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AccountCompanyLevelApi extends Service {
    protected String baseURL;

    public AccountCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://management-test.adyen.com/v1");
    }

    /**
    * Get a list of company accounts
    *
    * @return {@link ListCompanyResponse }
    * @throws ApiException if fails to make API call
    */
    public ListCompanyResponse listCompanyAccounts() throws ApiException, IOException {
        return listCompanyAccounts(null,  null,  null);
    }

    /**
    * Get a list of company accounts
    *
    * @param pageNumber {@link Integer } Query: The number of the page to fetch. (optional)
    * @param pageSize {@link Integer } Query: The number of items to have on a page, maximum 100. The default is 10 items on a page. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ListCompanyResponse }
    * @throws ApiException if fails to make API call
    */
    public ListCompanyResponse listCompanyAccounts(Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (pageNumber != null) {
        queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
        queryParams.put("pageSize", pageSize.toString());
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListCompanyResponse.fromJson(jsonResult);
    }

    /**
    * Get a company account
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @return {@link Company }
    * @throws ApiException if fails to make API call
    */
    public Company getCompanyAccount(String companyId) throws ApiException, IOException {
        return getCompanyAccount(companyId, null);
    }

    /**
    * Get a company account
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link Company }
    * @throws ApiException if fails to make API call
    */
    public Company getCompanyAccount(String companyId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Company.fromJson(jsonResult);
    }

    /**
    * Get a list of merchant accounts
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @return {@link ListMerchantResponse }
    * @throws ApiException if fails to make API call
    */
    public ListMerchantResponse listMerchantAccounts(String companyId) throws ApiException, IOException {
        return listMerchantAccounts(companyId, null,  null,  null);
    }

    /**
    * Get a list of merchant accounts
    *
    * @param companyId {@link String } The unique identifier of the company account. (required)
    * @param pageNumber {@link Integer } Query: The number of the page to fetch. (optional)
    * @param pageSize {@link Integer } Query: The number of items to have on a page, maximum 100. The default is 10 items on a page. (optional)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ListMerchantResponse }
    * @throws ApiException if fails to make API call
    */
    public ListMerchantResponse listMerchantAccounts(String companyId, Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        //Add query params
        Map<String, String> queryParams = new HashMap<>();
        if (pageNumber != null) {
        queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
        queryParams.put("pageSize", pageSize.toString());
        }

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/merchants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListMerchantResponse.fromJson(jsonResult);
    }
}
