/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Avs
 */
@JsonPropertyOrder({
  Avs.JSON_PROPERTY_ADDRESS_EDITABLE,
  Avs.JSON_PROPERTY_ENABLED
})

public class Avs {
  public static final String JSON_PROPERTY_ADDRESS_EDITABLE = "addressEditable";
  private Boolean addressEditable;

  /**
   * Specifies whether the shopper should enter their billing address during checkout.  Allowed values: * yes — Perform AVS checks for every card payment. * automatic — Perform AVS checks only when required to optimize the conversion rate. * no — Do not perform AVS checks.
   */
  public enum EnabledEnum {
    YES("yes"),
    
    NO("no"),
    
    AUTOMATIC("automatic");

    private String value;

    EnabledEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EnabledEnum fromValue(String value) {
      for (EnabledEnum b : EnabledEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private EnabledEnum enabled;

  public Avs() { 
  }

  public Avs addressEditable(Boolean addressEditable) {
    this.addressEditable = addressEditable;
    return this;
  }

   /**
   * Indicates whether the shopper is allowed to modify the billing address for the current payment request.
   * @return addressEditable
  **/
  @ApiModelProperty(value = "Indicates whether the shopper is allowed to modify the billing address for the current payment request.")
  @JsonProperty(JSON_PROPERTY_ADDRESS_EDITABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAddressEditable() {
    return addressEditable;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS_EDITABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddressEditable(Boolean addressEditable) {
    this.addressEditable = addressEditable;
  }


  public Avs enabled(EnabledEnum enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Specifies whether the shopper should enter their billing address during checkout.  Allowed values: * yes — Perform AVS checks for every card payment. * automatic — Perform AVS checks only when required to optimize the conversion rate. * no — Do not perform AVS checks.
   * @return enabled
  **/
  @ApiModelProperty(value = "Specifies whether the shopper should enter their billing address during checkout.  Allowed values: * yes — Perform AVS checks for every card payment. * automatic — Perform AVS checks only when required to optimize the conversion rate. * no — Do not perform AVS checks.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EnabledEnum getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(EnabledEnum enabled) {
    this.enabled = enabled;
  }


  /**
   * Return true if this Avs object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Avs avs = (Avs) o;
    return Objects.equals(this.addressEditable, avs.addressEditable) &&
        Objects.equals(this.enabled, avs.enabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressEditable, enabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Avs {\n");
    sb.append("    addressEditable: ").append(toIndentedString(addressEditable)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Avs given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Avs
   * @throws JsonProcessingException if the JSON string is invalid with respect to Avs
   */
  public static Avs fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Avs.class);
  }
/**
  * Convert an instance of Avs to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

