/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * FraudCheckResult
 */
@JsonPropertyOrder({
  FraudCheckResult.JSON_PROPERTY_ACCOUNT_SCORE,
  FraudCheckResult.JSON_PROPERTY_CHECK_ID,
  FraudCheckResult.JSON_PROPERTY_NAME
})

public class FraudCheckResult {
  public static final String JSON_PROPERTY_ACCOUNT_SCORE = "accountScore";
  private Integer accountScore;

  public static final String JSON_PROPERTY_CHECK_ID = "checkId";
  private Integer checkId;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public FraudCheckResult() { 
  }

  public FraudCheckResult accountScore(Integer accountScore) {
    this.accountScore = accountScore;
    return this;
  }

   /**
   * The fraud score generated by the risk check.
   * @return accountScore
  **/
  @ApiModelProperty(required = true, value = "The fraud score generated by the risk check.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAccountScore() {
    return accountScore;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountScore(Integer accountScore) {
    this.accountScore = accountScore;
  }


  public FraudCheckResult checkId(Integer checkId) {
    this.checkId = checkId;
    return this;
  }

   /**
   * The ID of the risk check.
   * @return checkId
  **/
  @ApiModelProperty(required = true, value = "The ID of the risk check.")
  @JsonProperty(JSON_PROPERTY_CHECK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCheckId() {
    return checkId;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckId(Integer checkId) {
    this.checkId = checkId;
  }


  public FraudCheckResult name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the risk check.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the risk check.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  /**
   * Return true if this FraudCheckResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FraudCheckResult fraudCheckResult = (FraudCheckResult) o;
    return Objects.equals(this.accountScore, fraudCheckResult.accountScore) &&
        Objects.equals(this.checkId, fraudCheckResult.checkId) &&
        Objects.equals(this.name, fraudCheckResult.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountScore, checkId, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FraudCheckResult {\n");
    sb.append("    accountScore: ").append(toIndentedString(accountScore)).append("\n");
    sb.append("    checkId: ").append(toIndentedString(checkId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of FraudCheckResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of FraudCheckResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to FraudCheckResult
   */
  public static FraudCheckResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, FraudCheckResult.class);
  }
/**
  * Convert an instance of FraudCheckResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

