/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.payment.AdjustAuthorisationRequest;
import com.adyen.model.payment.AuthenticationResultRequest;
import com.adyen.model.payment.AuthenticationResultResponse;
import com.adyen.model.payment.CancelOrRefundRequest;
import com.adyen.model.payment.CancelRequest;
import com.adyen.model.payment.CaptureRequest;
import com.adyen.model.payment.DonationRequest;
import com.adyen.model.payment.ModificationResult;
import com.adyen.model.payment.PaymentRequest;
import com.adyen.model.payment.PaymentRequest3d;
import com.adyen.model.payment.PaymentRequest3ds2;
import com.adyen.model.payment.PaymentResult;
import com.adyen.model.payment.RefundRequest;
import com.adyen.model.payment.ServiceError;
import com.adyen.model.payment.TechnicalCancelRequest;
import com.adyen.model.payment.ThreeDS2ResultRequest;
import com.adyen.model.payment.ThreeDS2ResultResponse;
import com.adyen.model.payment.VoidPendingRefundRequest;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PaymentApi extends Service {
    protected String baseURL;

    public PaymentApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://pal-test.adyen.com/pal/servlet/Payment/v68");
    }

    /**
    * Change the authorised amount
    *
    * @param adjustAuthorisationRequest {@link AdjustAuthorisationRequest }  (required)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult adjustAuthorisation(AdjustAuthorisationRequest adjustAuthorisationRequest) throws ApiException, IOException {
        return adjustAuthorisation(adjustAuthorisationRequest, null);
    }

    /**
    * Change the authorised amount
    *
    * @param adjustAuthorisationRequest {@link AdjustAuthorisationRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult adjustAuthorisation(AdjustAuthorisationRequest adjustAuthorisationRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = adjustAuthorisationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/adjustAuthorisation", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    /**
    * Create an authorisation
    *
    * @param paymentRequest {@link PaymentRequest }  (required)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise(PaymentRequest paymentRequest) throws ApiException, IOException {
        return authorise(paymentRequest, null);
    }

    /**
    * Create an authorisation
    *
    * @param paymentRequest {@link PaymentRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise(PaymentRequest paymentRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    /**
    * Complete a 3DS authorisation
    *
    * @param paymentRequest3d {@link PaymentRequest3d }  (required)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise3d(PaymentRequest3d paymentRequest3d) throws ApiException, IOException {
        return authorise3d(paymentRequest3d, null);
    }

    /**
    * Complete a 3DS authorisation
    *
    * @param paymentRequest3d {@link PaymentRequest3d }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise3d(PaymentRequest3d paymentRequest3d, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentRequest3d.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise3d", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    /**
    * Complete a 3DS2 authorisation
    *
    * @param paymentRequest3ds2 {@link PaymentRequest3ds2 }  (required)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise3ds2(PaymentRequest3ds2 paymentRequest3ds2) throws ApiException, IOException {
        return authorise3ds2(paymentRequest3ds2, null);
    }

    /**
    * Complete a 3DS2 authorisation
    *
    * @param paymentRequest3ds2 {@link PaymentRequest3ds2 }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PaymentResult }
    * @throws ApiException if fails to make API call
    */
    public PaymentResult authorise3ds2(PaymentRequest3ds2 paymentRequest3ds2, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = paymentRequest3ds2.toJson();
        Resource resource = new Resource(this, this.baseURL + "/authorise3ds2", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return PaymentResult.fromJson(jsonResult);
    }

    /**
    * Cancel an authorisation
    *
    * @param cancelRequest {@link CancelRequest }  (required)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult cancel(CancelRequest cancelRequest) throws ApiException, IOException {
        return cancel(cancelRequest, null);
    }

    /**
    * Cancel an authorisation
    *
    * @param cancelRequest {@link CancelRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult cancel(CancelRequest cancelRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = cancelRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/cancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    /**
    * Cancel or refund a payment
    *
    * @param cancelOrRefundRequest {@link CancelOrRefundRequest }  (required)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest) throws ApiException, IOException {
        return cancelOrRefund(cancelOrRefundRequest, null);
    }

    /**
    * Cancel or refund a payment
    *
    * @param cancelOrRefundRequest {@link CancelOrRefundRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = cancelOrRefundRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/cancelOrRefund", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    /**
    * Capture an authorisation
    *
    * @param captureRequest {@link CaptureRequest }  (required)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult capture(CaptureRequest captureRequest) throws ApiException, IOException {
        return capture(captureRequest, null);
    }

    /**
    * Capture an authorisation
    *
    * @param captureRequest {@link CaptureRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult capture(CaptureRequest captureRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = captureRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/capture", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    /**
    * Create a donation
    *
    * @param donationRequest {@link DonationRequest }  (required)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult donate(DonationRequest donationRequest) throws ApiException, IOException {
        return donate(donationRequest, null);
    }

    /**
    * Create a donation
    *
    * @param donationRequest {@link DonationRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult donate(DonationRequest donationRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = donationRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/donate", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    /**
    * Get the 3DS authentication result
    *
    * @param authenticationResultRequest {@link AuthenticationResultRequest }  (required)
    * @return {@link AuthenticationResultResponse }
    * @throws ApiException if fails to make API call
    */
    public AuthenticationResultResponse getAuthenticationResult(AuthenticationResultRequest authenticationResultRequest) throws ApiException, IOException {
        return getAuthenticationResult(authenticationResultRequest, null);
    }

    /**
    * Get the 3DS authentication result
    *
    * @param authenticationResultRequest {@link AuthenticationResultRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link AuthenticationResultResponse }
    * @throws ApiException if fails to make API call
    */
    public AuthenticationResultResponse getAuthenticationResult(AuthenticationResultRequest authenticationResultRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = authenticationResultRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/getAuthenticationResult", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return AuthenticationResultResponse.fromJson(jsonResult);
    }

    /**
    * Refund a captured payment
    *
    * @param refundRequest {@link RefundRequest }  (required)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult refund(RefundRequest refundRequest) throws ApiException, IOException {
        return refund(refundRequest, null);
    }

    /**
    * Refund a captured payment
    *
    * @param refundRequest {@link RefundRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult refund(RefundRequest refundRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = refundRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/refund", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    /**
    * Get the 3DS2 authentication result
    *
    * @param threeDS2ResultRequest {@link ThreeDS2ResultRequest }  (required)
    * @return {@link ThreeDS2ResultResponse }
    * @throws ApiException if fails to make API call
    */
    public ThreeDS2ResultResponse retrieve3ds2Result(ThreeDS2ResultRequest threeDS2ResultRequest) throws ApiException, IOException {
        return retrieve3ds2Result(threeDS2ResultRequest, null);
    }

    /**
    * Get the 3DS2 authentication result
    *
    * @param threeDS2ResultRequest {@link ThreeDS2ResultRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ThreeDS2ResultResponse }
    * @throws ApiException if fails to make API call
    */
    public ThreeDS2ResultResponse retrieve3ds2Result(ThreeDS2ResultRequest threeDS2ResultRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = threeDS2ResultRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/retrieve3ds2Result", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ThreeDS2ResultResponse.fromJson(jsonResult);
    }

    /**
    * Cancel an authorisation using your reference
    *
    * @param technicalCancelRequest {@link TechnicalCancelRequest }  (required)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult technicalCancel(TechnicalCancelRequest technicalCancelRequest) throws ApiException, IOException {
        return technicalCancel(technicalCancelRequest, null);
    }

    /**
    * Cancel an authorisation using your reference
    *
    * @param technicalCancelRequest {@link TechnicalCancelRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult technicalCancel(TechnicalCancelRequest technicalCancelRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = technicalCancelRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/technicalCancel", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }

    /**
    * Cancel an in-person refund
    *
    * @param voidPendingRefundRequest {@link VoidPendingRefundRequest }  (required)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult voidPendingRefund(VoidPendingRefundRequest voidPendingRefundRequest) throws ApiException, IOException {
        return voidPendingRefund(voidPendingRefundRequest, null);
    }

    /**
    * Cancel an in-person refund
    *
    * @param voidPendingRefundRequest {@link VoidPendingRefundRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link ModificationResult }
    * @throws ApiException if fails to make API call
    */
    public ModificationResult voidPendingRefund(VoidPendingRefundRequest voidPendingRefundRequest, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = voidPendingRefundRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/voidPendingRefund", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return ModificationResult.fromJson(jsonResult);
    }
}
