/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.PayoutSettings;
import com.adyen.model.management.PayoutSettingsRequest;
import com.adyen.model.management.PayoutSettingsResponse;
import com.adyen.model.management.UpdatePayoutSettingsRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PayoutSettingsMerchantLevelApi
extends Service {
    protected String baseURL = this.createBaseURL("https://management-test.adyen.com/v1");

    public PayoutSettingsMerchantLevelApi(Client client) {
        super(client);
    }

    public void deletePayoutSetting(String merchantId, String payoutSettingsId) throws ApiException, IOException {
        this.deletePayoutSetting(merchantId, payoutSettingsId, null);
    }

    public void deletePayoutSetting(String merchantId, String payoutSettingsId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (payoutSettingsId == null) {
            throw new IllegalArgumentException("Please provide the payoutSettingsId path parameter");
        }
        pathParams.put("payoutSettingsId", payoutSettingsId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}", null);
        resource.request(requestBody, null, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public PayoutSettingsResponse listPayoutSettings(String merchantId) throws ApiException, IOException {
        return this.listPayoutSettings(merchantId, null);
    }

    public PayoutSettingsResponse listPayoutSettings(String merchantId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/payoutSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PayoutSettingsResponse.fromJson(jsonResult);
    }

    public PayoutSettings getPayoutSetting(String merchantId, String payoutSettingsId) throws ApiException, IOException {
        return this.getPayoutSetting(merchantId, payoutSettingsId, null);
    }

    public PayoutSettings getPayoutSetting(String merchantId, String payoutSettingsId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (payoutSettingsId == null) {
            throw new IllegalArgumentException("Please provide the payoutSettingsId path parameter");
        }
        pathParams.put("payoutSettingsId", payoutSettingsId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return PayoutSettings.fromJson(jsonResult);
    }

    public PayoutSettings updatePayoutSetting(String merchantId, String payoutSettingsId, UpdatePayoutSettingsRequest updatePayoutSettingsRequest) throws ApiException, IOException {
        return this.updatePayoutSetting(merchantId, payoutSettingsId, updatePayoutSettingsRequest, null);
    }

    public PayoutSettings updatePayoutSetting(String merchantId, String payoutSettingsId, UpdatePayoutSettingsRequest updatePayoutSettingsRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (payoutSettingsId == null) {
            throw new IllegalArgumentException("Please provide the payoutSettingsId path parameter");
        }
        pathParams.put("payoutSettingsId", payoutSettingsId);
        String requestBody = updatePayoutSettingsRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return PayoutSettings.fromJson(jsonResult);
    }

    public PayoutSettings addPayoutSetting(String merchantId, PayoutSettingsRequest payoutSettingsRequest) throws ApiException, IOException {
        return this.addPayoutSetting(merchantId, payoutSettingsRequest, null);
    }

    public PayoutSettings addPayoutSetting(String merchantId, PayoutSettingsRequest payoutSettingsRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = payoutSettingsRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/payoutSettings", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PayoutSettings.fromJson(jsonResult);
    }
}

