/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * GeneratePciDescriptionResponse
 */
@JsonPropertyOrder({
  GeneratePciDescriptionResponse.JSON_PROPERTY_CONTENT,
  GeneratePciDescriptionResponse.JSON_PROPERTY_LANGUAGE,
  GeneratePciDescriptionResponse.JSON_PROPERTY_PCI_TEMPLATE_REFERENCES
})

public class GeneratePciDescriptionResponse {
  public static final String JSON_PROPERTY_CONTENT = "content";
  private byte[] content;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_PCI_TEMPLATE_REFERENCES = "pciTemplateReferences";
  private List<String> pciTemplateReferences = null;

  public GeneratePciDescriptionResponse() { 
  }

  public GeneratePciDescriptionResponse content(byte[] content) {
    this.content = content;
    return this;
  }

   /**
   * The generated questionnaires in a base64 encoded format.
   * @return content
  **/
  @ApiModelProperty(value = "The generated questionnaires in a base64 encoded format.")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public byte[] getContent() {
    return content;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContent(byte[] content) {
    this.content = content;
  }


  public GeneratePciDescriptionResponse language(String language) {
    this.language = language;
    return this;
  }

   /**
   * The two-letter [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code for the questionnaire. For example, **en**.
   * @return language
  **/
  @ApiModelProperty(value = "The two-letter [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code for the questionnaire. For example, **en**.")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public GeneratePciDescriptionResponse pciTemplateReferences(List<String> pciTemplateReferences) {
    this.pciTemplateReferences = pciTemplateReferences;
    return this;
  }

  public GeneratePciDescriptionResponse addPciTemplateReferencesItem(String pciTemplateReferencesItem) {
    if (this.pciTemplateReferences == null) {
      this.pciTemplateReferences = new ArrayList<>();
    }
    this.pciTemplateReferences.add(pciTemplateReferencesItem);
    return this;
  }

   /**
   * The array of Adyen-generated unique identifiers for the questionnaires.
   * @return pciTemplateReferences
  **/
  @ApiModelProperty(value = "The array of Adyen-generated unique identifiers for the questionnaires.")
  @JsonProperty(JSON_PROPERTY_PCI_TEMPLATE_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPciTemplateReferences() {
    return pciTemplateReferences;
  }


  @JsonProperty(JSON_PROPERTY_PCI_TEMPLATE_REFERENCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPciTemplateReferences(List<String> pciTemplateReferences) {
    this.pciTemplateReferences = pciTemplateReferences;
  }


  /**
   * Return true if this GeneratePciDescriptionResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeneratePciDescriptionResponse generatePciDescriptionResponse = (GeneratePciDescriptionResponse) o;
    return Arrays.equals(this.content, generatePciDescriptionResponse.content) &&
        Objects.equals(this.language, generatePciDescriptionResponse.language) &&
        Objects.equals(this.pciTemplateReferences, generatePciDescriptionResponse.pciTemplateReferences);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Arrays.hashCode(content), language, pciTemplateReferences);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeneratePciDescriptionResponse {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    pciTemplateReferences: ").append(toIndentedString(pciTemplateReferences)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of GeneratePciDescriptionResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GeneratePciDescriptionResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to GeneratePciDescriptionResponse
   */
  public static GeneratePciDescriptionResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GeneratePciDescriptionResponse.class);
  }
/**
  * Convert an instance of GeneratePciDescriptionResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

