/*
 * Management API
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AdditionalSettings
 */
@JsonPropertyOrder({
  AdditionalSettings.JSON_PROPERTY_INCLUDE_EVENT_CODES,
  AdditionalSettings.JSON_PROPERTY_PROPERTIES
})

public class AdditionalSettings {
  public static final String JSON_PROPERTY_INCLUDE_EVENT_CODES = "includeEventCodes";
  private List<String> includeEventCodes = null;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Map<String, Boolean> properties = null;

  public AdditionalSettings() { 
  }

  public AdditionalSettings includeEventCodes(List<String> includeEventCodes) {
    this.includeEventCodes = includeEventCodes;
    return this;
  }

  public AdditionalSettings addIncludeEventCodesItem(String includeEventCodesItem) {
    if (this.includeEventCodes == null) {
      this.includeEventCodes = new ArrayList<>();
    }
    this.includeEventCodes.add(includeEventCodesItem);
    return this;
  }

   /**
   * Object containing list of event codes for which the notifcation will be sent. 
   * @return includeEventCodes
  **/
  @ApiModelProperty(value = "Object containing list of event codes for which the notifcation will be sent. ")
  @JsonProperty(JSON_PROPERTY_INCLUDE_EVENT_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getIncludeEventCodes() {
    return includeEventCodes;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_EVENT_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeEventCodes(List<String> includeEventCodes) {
    this.includeEventCodes = includeEventCodes;
  }


  public AdditionalSettings properties(Map<String, Boolean> properties) {
    this.properties = properties;
    return this;
  }

  public AdditionalSettings putPropertiesItem(String key, Boolean propertiesItem) {
    if (this.properties == null) {
      this.properties = new HashMap<>();
    }
    this.properties.put(key, propertiesItem);
    return this;
  }

   /**
   * Object containing boolean key-value pairs. The key can be any [standard webhook additional setting](https://docs.adyen.com/development-resources/webhooks/additional-settings), and the value indicates if the setting is enabled. For example, &#x60;captureDelayHours&#x60;: **true** means the standard notifications you get will contain the number of hours remaining until the payment will be captured.
   * @return properties
  **/
  @ApiModelProperty(value = "Object containing boolean key-value pairs. The key can be any [standard webhook additional setting](https://docs.adyen.com/development-resources/webhooks/additional-settings), and the value indicates if the setting is enabled. For example, `captureDelayHours`: **true** means the standard notifications you get will contain the number of hours remaining until the payment will be captured.")
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Boolean> getProperties() {
    return properties;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProperties(Map<String, Boolean> properties) {
    this.properties = properties;
  }


  /**
   * Return true if this AdditionalSettings object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalSettings additionalSettings = (AdditionalSettings) o;
    return Objects.equals(this.includeEventCodes, additionalSettings.includeEventCodes) &&
        Objects.equals(this.properties, additionalSettings.properties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(includeEventCodes, properties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalSettings {\n");
    sb.append("    includeEventCodes: ").append(toIndentedString(includeEventCodes)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AdditionalSettings given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AdditionalSettings
   * @throws JsonProcessingException if the JSON string is invalid with respect to AdditionalSettings
   */
  public static AdditionalSettings fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AdditionalSettings.class);
  }
/**
  * Convert an instance of AdditionalSettings to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

