/*
 * Adyen Payment API
 * A set of API endpoints that allow you to initiate, settle, and modify payments on the Adyen payments platform. You can use the API to accept card payments (including One-Click and 3D Secure), bank transfers, ewallets, and many other payment methods.  To learn more about the API, visit [Classic integration](https://docs.adyen.com/classic-integration).  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Payments API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Payment/v68/authorise ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Payment/v68/authorise ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.payment.FraudCheckResultWrapper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * FraudResult
 */
@JsonPropertyOrder({
  FraudResult.JSON_PROPERTY_ACCOUNT_SCORE,
  FraudResult.JSON_PROPERTY_RESULTS
})

public class FraudResult {
  public static final String JSON_PROPERTY_ACCOUNT_SCORE = "accountScore";
  private Integer accountScore;

  public static final String JSON_PROPERTY_RESULTS = "results";
  private List<FraudCheckResultWrapper> results = null;

  public FraudResult() { 
  }

  public FraudResult accountScore(Integer accountScore) {
    this.accountScore = accountScore;
    return this;
  }

   /**
   * The total fraud score generated by the risk checks.
   * @return accountScore
  **/
  @ApiModelProperty(required = true, value = "The total fraud score generated by the risk checks.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAccountScore() {
    return accountScore;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountScore(Integer accountScore) {
    this.accountScore = accountScore;
  }


  public FraudResult results(List<FraudCheckResultWrapper> results) {
    this.results = results;
    return this;
  }

  public FraudResult addResultsItem(FraudCheckResultWrapper resultsItem) {
    if (this.results == null) {
      this.results = new ArrayList<>();
    }
    this.results.add(resultsItem);
    return this;
  }

   /**
   * The result of the individual risk checks.
   * @return results
  **/
  @ApiModelProperty(value = "The result of the individual risk checks.")
  @JsonProperty(JSON_PROPERTY_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<FraudCheckResultWrapper> getResults() {
    return results;
  }


  @JsonProperty(JSON_PROPERTY_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResults(List<FraudCheckResultWrapper> results) {
    this.results = results;
  }


  /**
   * Return true if this FraudResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FraudResult fraudResult = (FraudResult) o;
    return Objects.equals(this.accountScore, fraudResult.accountScore) &&
        Objects.equals(this.results, fraudResult.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountScore, results);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FraudResult {\n");
    sb.append("    accountScore: ").append(toIndentedString(accountScore)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of FraudResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of FraudResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to FraudResult
   */
  public static FraudResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, FraudResult.class);
  }
/**
  * Convert an instance of FraudResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

