/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountNumber", "clearingCode", "type"})
public class HKLocalAccountIdentification {
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_CLEARING_CODE = "clearingCode";
    private String clearingCode;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.HKLOCAL;

    public HKLocalAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 9- to 12-character bank account number (alphanumeric), without separators or whitespace. Starts with the 3-digit branch code.")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public HKLocalAccountIdentification clearingCode(String clearingCode) {
        this.clearingCode = clearingCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The 3-digit clearing code, without separators or whitespace.")
    @JsonProperty(value="clearingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClearingCode() {
        return this.clearingCode;
    }

    @JsonProperty(value="clearingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClearingCode(String clearingCode) {
        this.clearingCode = clearingCode;
    }

    public HKLocalAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**hkLocal**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HKLocalAccountIdentification hkLocalAccountIdentification = (HKLocalAccountIdentification)o;
        return Objects.equals(this.accountNumber, hkLocalAccountIdentification.accountNumber) && Objects.equals(this.clearingCode, hkLocalAccountIdentification.clearingCode) && Objects.equals((Object)this.type, (Object)hkLocalAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.clearingCode, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HKLocalAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    clearingCode: ").append(this.toIndentedString(this.clearingCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static HKLocalAccountIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (HKLocalAccountIdentification)JSON.getMapper().readValue(jsonString, HKLocalAccountIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        HKLOCAL("hkLocal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

