/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"balancePlatform", "description", "id", "properties", "reference", "txVariant"})
public class PaymentInstrumentGroup {
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, String> properties = null;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_TX_VARIANT = "txVariant";
    private String txVariant;

    public PaymentInstrumentGroup balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [balance platform](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balancePlatforms/{id}__queryParam_id) to which the payment instrument group belongs.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public PaymentInstrumentGroup description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the payment instrument group, maximum 300 characters.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentInstrumentGroup id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the payment instrument group.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public PaymentInstrumentGroup properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public PaymentInstrumentGroup putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Properties of the payment instrument group.")
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public PaymentInstrumentGroup reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment instrument group, maximum 150 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentInstrumentGroup txVariant(String txVariant) {
        this.txVariant = txVariant;
        return this;
    }

    @ApiModelProperty(required=true, value="The tx variant of the payment instrument group.")
    @JsonProperty(value="txVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTxVariant() {
        return this.txVariant;
    }

    @JsonProperty(value="txVariant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTxVariant(String txVariant) {
        this.txVariant = txVariant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInstrumentGroup paymentInstrumentGroup = (PaymentInstrumentGroup)o;
        return Objects.equals(this.balancePlatform, paymentInstrumentGroup.balancePlatform) && Objects.equals(this.description, paymentInstrumentGroup.description) && Objects.equals(this.id, paymentInstrumentGroup.id) && Objects.equals(this.properties, paymentInstrumentGroup.properties) && Objects.equals(this.reference, paymentInstrumentGroup.reference) && Objects.equals(this.txVariant, paymentInstrumentGroup.txVariant);
    }

    public int hashCode() {
        return Objects.hash(this.balancePlatform, this.description, this.id, this.properties, this.reference, this.txVariant);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInstrumentGroup {\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    txVariant: ").append(this.toIndentedString(this.txVariant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentInstrumentGroup fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentInstrumentGroup)JSON.getMapper().readValue(jsonString, PaymentInstrumentGroup.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

