/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.CardDetails;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.SubMerchant;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"billingAddress", "paymentMethod", "shopperEmail", "shopperName", "shopperReference", "storedPaymentMethodId", "subMerchant", "telephoneNumber", "walletIdentifier", "walletOwnerTaxId"})
public class FundRecipient {
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private CardDetails paymentMethod;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    private String storedPaymentMethodId;
    public static final String JSON_PROPERTY_SUB_MERCHANT = "subMerchant";
    private SubMerchant subMerchant;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    public static final String JSON_PROPERTY_WALLET_IDENTIFIER = "walletIdentifier";
    private String walletIdentifier;
    public static final String JSON_PROPERTY_WALLET_OWNER_TAX_ID = "walletOwnerTaxId";
    private String walletOwnerTaxId;

    public FundRecipient billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public FundRecipient paymentMethod(CardDetails paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardDetails getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(CardDetails paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public FundRecipient shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="the email address of the person")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public FundRecipient shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public FundRecipient shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public FundRecipient storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    @JsonProperty(value="storedPaymentMethodId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public FundRecipient subMerchant(SubMerchant subMerchant) {
        this.subMerchant = subMerchant;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="subMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubMerchant getSubMerchant() {
        return this.subMerchant;
    }

    @JsonProperty(value="subMerchant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubMerchant(SubMerchant subMerchant) {
        this.subMerchant = subMerchant;
    }

    public FundRecipient telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="the telephone number of the person")
    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public FundRecipient walletIdentifier(String walletIdentifier) {
        this.walletIdentifier = walletIdentifier;
        return this;
    }

    @ApiModelProperty(value="indicates where the money is going")
    @JsonProperty(value="walletIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWalletIdentifier() {
        return this.walletIdentifier;
    }

    @JsonProperty(value="walletIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWalletIdentifier(String walletIdentifier) {
        this.walletIdentifier = walletIdentifier;
    }

    public FundRecipient walletOwnerTaxId(String walletOwnerTaxId) {
        this.walletOwnerTaxId = walletOwnerTaxId;
        return this;
    }

    @ApiModelProperty(value="indicates the tax identifier of the fund recepient")
    @JsonProperty(value="walletOwnerTaxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWalletOwnerTaxId() {
        return this.walletOwnerTaxId;
    }

    @JsonProperty(value="walletOwnerTaxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWalletOwnerTaxId(String walletOwnerTaxId) {
        this.walletOwnerTaxId = walletOwnerTaxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundRecipient fundRecipient = (FundRecipient)o;
        return Objects.equals(this.billingAddress, fundRecipient.billingAddress) && Objects.equals(this.paymentMethod, fundRecipient.paymentMethod) && Objects.equals(this.shopperEmail, fundRecipient.shopperEmail) && Objects.equals(this.shopperName, fundRecipient.shopperName) && Objects.equals(this.shopperReference, fundRecipient.shopperReference) && Objects.equals(this.storedPaymentMethodId, fundRecipient.storedPaymentMethodId) && Objects.equals(this.subMerchant, fundRecipient.subMerchant) && Objects.equals(this.telephoneNumber, fundRecipient.telephoneNumber) && Objects.equals(this.walletIdentifier, fundRecipient.walletIdentifier) && Objects.equals(this.walletOwnerTaxId, fundRecipient.walletOwnerTaxId);
    }

    public int hashCode() {
        return Objects.hash(this.billingAddress, this.paymentMethod, this.shopperEmail, this.shopperName, this.shopperReference, this.storedPaymentMethodId, this.subMerchant, this.telephoneNumber, this.walletIdentifier, this.walletOwnerTaxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundRecipient {\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    subMerchant: ").append(this.toIndentedString(this.subMerchant)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    walletIdentifier: ").append(this.toIndentedString(this.walletIdentifier)).append("\n");
        sb.append("    walletOwnerTaxId: ").append(this.toIndentedString(this.walletOwnerTaxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FundRecipient fromJson(String jsonString) throws JsonProcessingException {
        return (FundRecipient)JSON.getMapper().readValue(jsonString, FundRecipient.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

