/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.AccountHolderCapability;
import com.adyen.model.configurationwebhooks.ContactDetails;
import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"balancePlatform", "capabilities", "contactDetails", "description", "id", "legalEntityId", "metadata", "migratedAccountHolderCode", "primaryBalanceAccount", "reference", "status", "timeZone"})
public class AccountHolder {
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, AccountHolderCapability> capabilities = null;
    public static final String JSON_PROPERTY_CONTACT_DETAILS = "contactDetails";
    private ContactDetails contactDetails;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_MIGRATED_ACCOUNT_HOLDER_CODE = "migratedAccountHolderCode";
    private String migratedAccountHolderCode;
    public static final String JSON_PROPERTY_PRIMARY_BALANCE_ACCOUNT = "primaryBalanceAccount";
    private String primaryBalanceAccount;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TIME_ZONE = "timeZone";
    private String timeZone;

    public AccountHolder balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [balance platform](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balancePlatforms/{id}__queryParam_id) to which the account holder belongs. Required in the request if your API credentials can be used for multiple balance platforms.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public AccountHolder capabilities(Map<String, AccountHolderCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public AccountHolder putCapabilitiesItem(String key, AccountHolderCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, AccountHolderCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that an account holder can do in your platform. The key is a capability required for your integration. For example, **issueCard** for Issuing. The value is an object containing the settings for the capability.")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, AccountHolderCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(Map<String, AccountHolderCapability> capabilities) {
        this.capabilities = capabilities;
    }

    public AccountHolder contactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="contactDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactDetails getContactDetails() {
        return this.contactDetails;
    }

    @JsonProperty(value="contactDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactDetails(ContactDetails contactDetails) {
        this.contactDetails = contactDetails;
    }

    public AccountHolder description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the account holder, maximum 300 characters.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public AccountHolder id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the account holder.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AccountHolder legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id) associated with the account holder. Adyen performs a verification process against the legal entity of the account holder.")
    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    public AccountHolder metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public AccountHolder putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public AccountHolder migratedAccountHolderCode(String migratedAccountHolderCode) {
        this.migratedAccountHolderCode = migratedAccountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the migrated account holder in the classic integration.")
    @JsonProperty(value="migratedAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMigratedAccountHolderCode() {
        return this.migratedAccountHolderCode;
    }

    @JsonProperty(value="migratedAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMigratedAccountHolderCode(String migratedAccountHolderCode) {
        this.migratedAccountHolderCode = migratedAccountHolderCode;
    }

    public AccountHolder primaryBalanceAccount(String primaryBalanceAccount) {
        this.primaryBalanceAccount = primaryBalanceAccount;
        return this;
    }

    @ApiModelProperty(value="The ID of the account holder's primary balance account. By default, this is set to the first balance account that you create for the account holder. To assign a different balance account, send a PATCH request.")
    @JsonProperty(value="primaryBalanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrimaryBalanceAccount() {
        return this.primaryBalanceAccount;
    }

    @JsonProperty(value="primaryBalanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryBalanceAccount(String primaryBalanceAccount) {
        this.primaryBalanceAccount = primaryBalanceAccount;
    }

    public AccountHolder reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the account holder, maximum 150 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public AccountHolder status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the account holder.  Possible values:    * **Active**: The account holder is active. This is the default status when creating an account holder.    * **Inactive (Deprecated)**: The account holder is temporarily inactive due to missing KYC details. You can set the account back to active by providing the missing KYC details.    * **Suspended**: The account holder is permanently deactivated by Adyen. This action cannot be undone.   * **Closed**: The account holder is permanently deactivated by you. This action cannot be undone.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AccountHolder timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The time zone of the account holder. For example, **Europe/Amsterdam**. Defaults to the time zone of the balance platform if no time zone is set. For possible values, see the [list of time zone codes](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).")
    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="timeZone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolder accountHolder = (AccountHolder)o;
        return Objects.equals(this.balancePlatform, accountHolder.balancePlatform) && Objects.equals(this.capabilities, accountHolder.capabilities) && Objects.equals(this.contactDetails, accountHolder.contactDetails) && Objects.equals(this.description, accountHolder.description) && Objects.equals(this.id, accountHolder.id) && Objects.equals(this.legalEntityId, accountHolder.legalEntityId) && Objects.equals(this.metadata, accountHolder.metadata) && Objects.equals(this.migratedAccountHolderCode, accountHolder.migratedAccountHolderCode) && Objects.equals(this.primaryBalanceAccount, accountHolder.primaryBalanceAccount) && Objects.equals(this.reference, accountHolder.reference) && Objects.equals((Object)this.status, (Object)accountHolder.status) && Objects.equals(this.timeZone, accountHolder.timeZone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balancePlatform, this.capabilities, this.contactDetails, this.description, this.id, this.legalEntityId, this.metadata, this.migratedAccountHolderCode, this.primaryBalanceAccount, this.reference, this.status, this.timeZone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolder {\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    contactDetails: ").append(this.toIndentedString(this.contactDetails)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    migratedAccountHolderCode: ").append(this.toIndentedString(this.migratedAccountHolderCode)).append("\n");
        sb.append("    primaryBalanceAccount: ").append(this.toIndentedString(this.primaryBalanceAccount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolder fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolder)JSON.getMapper().readValue(jsonString, AccountHolder.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE("Active"),
        CLOSED("Closed"),
        INACTIVE("Inactive"),
        SUSPENDED("Suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

