/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"logo", "qrCodeData"})
public class ReceiptOptions {
    public static final String JSON_PROPERTY_LOGO = "logo";
    private String logo;
    public static final String JSON_PROPERTY_QR_CODE_DATA = "qrCodeData";
    private String qrCodeData;

    public ReceiptOptions logo(String logo) {
        this.logo = logo;
        return this;
    }

    @ApiModelProperty(value="The receipt logo converted to a Base64-encoded string. The image must be a .bmp file of < 256 KB, dimensions 240 (H) x 384 (W) px.")
    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogo() {
        return this.logo;
    }

    @JsonProperty(value="logo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(String logo) {
        this.logo = logo;
    }

    public ReceiptOptions qrCodeData(String qrCodeData) {
        this.qrCodeData = qrCodeData;
        return this;
    }

    @ApiModelProperty(value="Data to print on the receipt as a QR code. This can include static text and the following variables:  - `${merchantreference}`: the merchant reference of the transaction. - `${pspreference}`: the PSP reference of the transaction.   For example, **http://www.example.com/order/${pspreference}/${merchantreference}**.")
    @JsonProperty(value="qrCodeData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQrCodeData() {
        return this.qrCodeData;
    }

    @JsonProperty(value="qrCodeData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQrCodeData(String qrCodeData) {
        this.qrCodeData = qrCodeData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceiptOptions receiptOptions = (ReceiptOptions)o;
        return Objects.equals(this.logo, receiptOptions.logo) && Objects.equals(this.qrCodeData, receiptOptions.qrCodeData);
    }

    public int hashCode() {
        return Objects.hash(this.logo, this.qrCodeData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReceiptOptions {\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    qrCodeData: ").append(this.toIndentedString(this.qrCodeData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ReceiptOptions fromJson(String jsonString) throws JsonProcessingException {
        return (ReceiptOptions)JSON.getMapper().readValue(jsonString, ReceiptOptions.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

