/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"askSignatureOnScreen", "deviceName", "deviceSlogan", "skipSignature"})
public class Signature {
    public static final String JSON_PROPERTY_ASK_SIGNATURE_ON_SCREEN = "askSignatureOnScreen";
    private Boolean askSignatureOnScreen;
    public static final String JSON_PROPERTY_DEVICE_NAME = "deviceName";
    private String deviceName;
    public static final String JSON_PROPERTY_DEVICE_SLOGAN = "deviceSlogan";
    private String deviceSlogan;
    public static final String JSON_PROPERTY_SKIP_SIGNATURE = "skipSignature";
    private Boolean skipSignature;

    public Signature askSignatureOnScreen(Boolean askSignatureOnScreen) {
        this.askSignatureOnScreen = askSignatureOnScreen;
        return this;
    }

    @ApiModelProperty(value="If `skipSignature` is false, indicates whether the shopper should provide a signature on the display (**true**) or on the merchant receipt (**false**).")
    @JsonProperty(value="askSignatureOnScreen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAskSignatureOnScreen() {
        return this.askSignatureOnScreen;
    }

    @JsonProperty(value="askSignatureOnScreen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAskSignatureOnScreen(Boolean askSignatureOnScreen) {
        this.askSignatureOnScreen = askSignatureOnScreen;
    }

    public Signature deviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @ApiModelProperty(value="Name that identifies the terminal.")
    @JsonProperty(value="deviceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceName() {
        return this.deviceName;
    }

    @JsonProperty(value="deviceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Signature deviceSlogan(String deviceSlogan) {
        this.deviceSlogan = deviceSlogan;
        return this;
    }

    @ApiModelProperty(value="Slogan shown on the start screen of the device.")
    @JsonProperty(value="deviceSlogan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceSlogan() {
        return this.deviceSlogan;
    }

    @JsonProperty(value="deviceSlogan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceSlogan(String deviceSlogan) {
        this.deviceSlogan = deviceSlogan;
    }

    public Signature skipSignature(Boolean skipSignature) {
        this.skipSignature = skipSignature;
        return this;
    }

    @ApiModelProperty(value="Skip asking for a signature. This is possible because all global card schemes (American Express, Diners, Discover, JCB, MasterCard, VISA, and UnionPay) regard a signature as optional.")
    @JsonProperty(value="skipSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSkipSignature() {
        return this.skipSignature;
    }

    @JsonProperty(value="skipSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSkipSignature(Boolean skipSignature) {
        this.skipSignature = skipSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Objects.equals(this.askSignatureOnScreen, signature.askSignatureOnScreen) && Objects.equals(this.deviceName, signature.deviceName) && Objects.equals(this.deviceSlogan, signature.deviceSlogan) && Objects.equals(this.skipSignature, signature.skipSignature);
    }

    public int hashCode() {
        return Objects.hash(this.askSignatureOnScreen, this.deviceName, this.deviceSlogan, this.skipSignature);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Signature {\n");
        sb.append("    askSignatureOnScreen: ").append(this.toIndentedString(this.askSignatureOnScreen)).append("\n");
        sb.append("    deviceName: ").append(this.toIndentedString(this.deviceName)).append("\n");
        sb.append("    deviceSlogan: ").append(this.toIndentedString(this.deviceSlogan)).append("\n");
        sb.append("    skipSignature: ").append(this.toIndentedString(this.skipSignature)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Signature fromJson(String jsonString) throws JsonProcessingException {
        return (Signature)JSON.getMapper().readValue(jsonString, Signature.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

