/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.ForceEntryModeType;
import com.adyen.model.nexo.LoyaltyHandlingType;
import com.adyen.model.nexo.PaymentType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CardAcquisitionTransaction", propOrder={"allowedPaymentBrand", "allowedLoyaltyBrand", "forceEntryMode"})
public class CardAcquisitionTransaction {
    @XmlElement(name="AllowedPaymentBrand")
    @Schema(description="Card payment brands allowed by the Sale System for the payment transaction.")
    protected List<String> allowedPaymentBrand;
    @XmlElement(name="AllowedLoyaltyBrand")
    @Schema(description="Loyalty brands or programs allowed by the Sale System for the loyalty transaction.")
    protected List<String> allowedLoyaltyBrand;
    @XmlElement(name="ForceEntryMode")
    @Schema(description="Payment instrument entry mode requested by the Sale System.")
    protected List<ForceEntryModeType> forceEntryMode;
    @XmlElement(name="LoyaltyHandling")
    @Schema(description="Type of Loyalty processing requested by the Sale System.")
    protected LoyaltyHandlingType loyaltyHandling;
    @XmlElement(name="CustomerLanguage")
    @Schema(description="Language of the Customer --Rule: If the language is selected by the Sale System before the request to the POI.")
    protected String customerLanguage;
    @XmlElement(name="ForceCustomerSelectionFlag")
    @Schema(description="Indicates if the Customer realises the selection of the card application.")
    protected Boolean forceCustomerSelectionFlag;
    @XmlElement(name="TotalAmount")
    @Schema(description="Amount of a transaction. --Rule: Mandatory for contactless card, otherwise absent")
    protected BigDecimal totalAmount;
    @XmlElement(name="PaymentType")
    @Schema(description="Type of payment transaction. --Rule: Mandatory for contactless card, otherwise absent")
    protected PaymentType paymentType;
    @XmlElement(name="CashBackFlag")
    @Schema(description="Cash back has been requested with the payment transaction. --Rule: For contactless, True if cash back has been requested, default False. Otherwise absent.")
    protected Boolean cashBackFlag;

    public List<String> getAllowedPaymentBrand() {
        if (this.allowedPaymentBrand == null) {
            this.allowedPaymentBrand = new ArrayList<String>();
        }
        return this.allowedPaymentBrand;
    }

    public List<String> getAllowedLoyaltyBrand() {
        if (this.allowedLoyaltyBrand == null) {
            this.allowedLoyaltyBrand = new ArrayList<String>();
        }
        return this.allowedLoyaltyBrand;
    }

    public List<ForceEntryModeType> getForceEntryMode() {
        if (this.forceEntryMode == null) {
            this.forceEntryMode = new ArrayList<ForceEntryModeType>();
        }
        return this.forceEntryMode;
    }

    public LoyaltyHandlingType getLoyaltyHandling() {
        if (this.loyaltyHandling == null) {
            return LoyaltyHandlingType.ALLOWED;
        }
        return this.loyaltyHandling;
    }

    public void setLoyaltyHandling(LoyaltyHandlingType value) {
        this.loyaltyHandling = value;
    }

    public String getCustomerLanguage() {
        return this.customerLanguage;
    }

    public void setCustomerLanguage(String value) {
        this.customerLanguage = value;
    }

    public boolean isForceCustomerSelectionFlag() {
        if (this.forceCustomerSelectionFlag == null) {
            return false;
        }
        return this.forceCustomerSelectionFlag;
    }

    public void setForceCustomerSelectionFlag(Boolean value) {
        this.forceCustomerSelectionFlag = value;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal value) {
        this.totalAmount = value;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType value) {
        this.paymentType = value;
    }

    public Boolean isCashBackFlag() {
        return this.cashBackFlag;
    }

    public void setCashBackFlag(Boolean value) {
        this.cashBackFlag = value;
    }
}

