/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.Amount;
import com.adyen.model.transferwebhooks.BalanceMutation;
import com.adyen.model.transferwebhooks.CounterpartyV3;
import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.PaymentInstrument;
import com.adyen.model.transferwebhooks.RelayedAuthorisationData;
import com.adyen.model.transferwebhooks.ResourceReference;
import com.adyen.model.transferwebhooks.TransactionRulesResult;
import com.adyen.model.transferwebhooks.TransferEvent;
import com.adyen.model.transferwebhooks.TransferNotificationTransferTracking;
import com.adyen.model.transferwebhooks.TransferNotificationValidationFact;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolder", "amount", "balanceAccount", "balanceAccountId", "balancePlatform", "balances", "category", "counterparty", "creationDate", "description", "direction", "events", "id", "modificationMerchantReference", "modificationPspReference", "panEntryMode", "paymentInstrument", "paymentInstrumentId", "paymentMerchantReference", "platformPaymentType", "priority", "processingType", "pspPaymentReference", "reason", "reference", "referenceForBeneficiary", "relayedAuthorisationData", "sequenceNumber", "status", "tracking", "transactionId", "transactionRulesResult", "type", "validationFacts"})
public class TransferData {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
    private ResourceReference accountHolder;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT = "balanceAccount";
    private ResourceReference balanceAccount;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private List<BalanceMutation> balances = null;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private CounterpartyV3 counterparty;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<TransferEvent> events = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_MODIFICATION_MERCHANT_REFERENCE = "modificationMerchantReference";
    private String modificationMerchantReference;
    public static final String JSON_PROPERTY_MODIFICATION_PSP_REFERENCE = "modificationPspReference";
    private String modificationPspReference;
    public static final String JSON_PROPERTY_PAN_ENTRY_MODE = "panEntryMode";
    private PanEntryModeEnum panEntryMode;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT = "paymentInstrument";
    private PaymentInstrument paymentInstrument;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;
    public static final String JSON_PROPERTY_PAYMENT_MERCHANT_REFERENCE = "paymentMerchantReference";
    private String paymentMerchantReference;
    public static final String JSON_PROPERTY_PLATFORM_PAYMENT_TYPE = "platformPaymentType";
    private PlatformPaymentTypeEnum platformPaymentType;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private PriorityEnum priority;
    public static final String JSON_PROPERTY_PROCESSING_TYPE = "processingType";
    private ProcessingTypeEnum processingType;
    public static final String JSON_PROPERTY_PSP_PAYMENT_REFERENCE = "pspPaymentReference";
    private String pspPaymentReference;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    private String referenceForBeneficiary;
    public static final String JSON_PROPERTY_RELAYED_AUTHORISATION_DATA = "relayedAuthorisationData";
    private RelayedAuthorisationData relayedAuthorisationData;
    public static final String JSON_PROPERTY_SEQUENCE_NUMBER = "sequenceNumber";
    private Integer sequenceNumber;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TRACKING = "tracking";
    private TransferNotificationTransferTracking tracking;
    public static final String JSON_PROPERTY_TRANSACTION_ID = "transactionId";
    private String transactionId;
    public static final String JSON_PROPERTY_TRANSACTION_RULES_RESULT = "transactionRulesResult";
    private TransactionRulesResult transactionRulesResult;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VALIDATION_FACTS = "validationFacts";
    private List<TransferNotificationValidationFact> validationFacts = null;

    public TransferData accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public TransferData amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferData balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
    }

    public TransferData balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The unique identifier of the source [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).")
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @Deprecated
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public TransferData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platform.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public TransferData balances(List<BalanceMutation> balances) {
        this.balances = balances;
        return this;
    }

    public TransferData addBalancesItem(BalanceMutation balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<BalanceMutation>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @ApiModelProperty(value="The list of the latest balance statuses in the transfer.")
    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BalanceMutation> getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(List<BalanceMutation> balances) {
        this.balances = balances;
    }

    public TransferData category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of transfer.  Possible values:   - **bank**: Transfer to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: Transfer initiated by a Adyen-issued card.  - **platformPayment**: Fund movements related to payments that are acquired for your users.")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public TransferData counterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CounterpartyV3 getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
    }

    public TransferData creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public TransferData description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , ' + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] & $ % # @** **~ = + - _ ' \" ! ?**")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public TransferData direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="The direction of the transfer.  Possible values: **incoming**, **outgoing**.")
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public TransferData events(List<TransferEvent> events) {
        this.events = events;
        return this;
    }

    public TransferData addEventsItem(TransferEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<TransferEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="The list of events leading up to the current status of the transfer.")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferEvent> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvents(List<TransferEvent> events) {
        this.events = events;
    }

    public TransferData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the resource.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TransferData modificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The capture's merchant reference included in the transfer.")
    @JsonProperty(value="modificationMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModificationMerchantReference() {
        return this.modificationMerchantReference;
    }

    @Deprecated
    @JsonProperty(value="modificationMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
    }

    public TransferData modificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The capture reference included in the transfer.")
    @JsonProperty(value="modificationPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModificationPspReference() {
        return this.modificationPspReference;
    }

    @Deprecated
    @JsonProperty(value="modificationPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
    }

    public TransferData panEntryMode(PanEntryModeEnum panEntryMode) {
        this.panEntryMode = panEntryMode;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Indicates the method used for entering the PAN to initiate a transaction.  Possible values: **manual**, **chip**, **magstripe**, **contactless**, **cof**, **ecommerce**, **token**.")
    @JsonProperty(value="panEntryMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PanEntryModeEnum getPanEntryMode() {
        return this.panEntryMode;
    }

    @Deprecated
    @JsonProperty(value="panEntryMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPanEntryMode(PanEntryModeEnum panEntryMode) {
        this.panEntryMode = panEntryMode;
    }

    public TransferData paymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentInstrument getPaymentInstrument() {
        return this.paymentInstrument;
    }

    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
    }

    public TransferData paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) used in the transfer.")
    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @Deprecated
    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public TransferData paymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The payment's merchant reference included in the transfer.")
    @JsonProperty(value="paymentMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMerchantReference() {
        return this.paymentMerchantReference;
    }

    @Deprecated
    @JsonProperty(value="paymentMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
    }

    public TransferData platformPaymentType(PlatformPaymentTypeEnum platformPaymentType) {
        this.platformPaymentType = platformPaymentType;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The type of the related split.")
    @JsonProperty(value="platformPaymentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformPaymentTypeEnum getPlatformPaymentType() {
        return this.platformPaymentType;
    }

    @Deprecated
    @JsonProperty(value="platformPaymentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformPaymentType(PlatformPaymentTypeEnum platformPaymentType) {
        this.platformPaymentType = platformPaymentType;
    }

    public TransferData priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with `category` **bank**.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).")
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public TransferData processingType(ProcessingTypeEnum processingType) {
        this.processingType = processingType;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Contains information about how the payment was processed. For example, **ecommerce** for online or **pos** for in-person payments.")
    @JsonProperty(value="processingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessingTypeEnum getProcessingType() {
        return this.processingType;
    }

    @Deprecated
    @JsonProperty(value="processingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessingType(ProcessingTypeEnum processingType) {
        this.processingType = processingType;
    }

    public TransferData pspPaymentReference(String pspPaymentReference) {
        this.pspPaymentReference = pspPaymentReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The payment reference included in the transfer.")
    @JsonProperty(value="pspPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspPaymentReference() {
        return this.pspPaymentReference;
    }

    @Deprecated
    @JsonProperty(value="pspPaymentReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspPaymentReference(String pspPaymentReference) {
        this.pspPaymentReference = pspPaymentReference;
    }

    public TransferData reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Additional information about the status of the transfer.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TransferData reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the transfer, used internally within your platform. If you don't provide this in the request, Adyen generates a unique reference.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public TransferData referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value=" A reference that is sent to the recipient. This reference is also sent in all webhooks related to the transfer, so you can use it to track statuses for both the source and recipient of funds.   Supported characters: **a-z**, **A-Z**, **0-9**. The maximum length depends on the `category`.  - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.")
    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public TransferData relayedAuthorisationData(RelayedAuthorisationData relayedAuthorisationData) {
        this.relayedAuthorisationData = relayedAuthorisationData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="relayedAuthorisationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelayedAuthorisationData getRelayedAuthorisationData() {
        return this.relayedAuthorisationData;
    }

    @JsonProperty(value="relayedAuthorisationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelayedAuthorisationData(RelayedAuthorisationData relayedAuthorisationData) {
        this.relayedAuthorisationData = relayedAuthorisationData;
    }

    public TransferData sequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    @ApiModelProperty(value="The sequence number of the transfer notification. The numbers start from 1 and increase with each new notification for a specific transfer.  It can help you restore the correct sequence of events even if they arrive out of order.")
    @JsonProperty(value="sequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    @JsonProperty(value="sequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public TransferData status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The result of the transfer.   For example, **authorised**, **refused**, or **error**.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransferData tracking(TransferNotificationTransferTracking tracking) {
        this.tracking = tracking;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="tracking")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferNotificationTransferTracking getTracking() {
        return this.tracking;
    }

    @JsonProperty(value="tracking")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTracking(TransferNotificationTransferTracking tracking) {
        this.tracking = tracking;
    }

    public TransferData transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The ID of the transaction that is created based on the transfer.")
    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransactionId() {
        return this.transactionId;
    }

    @Deprecated
    @JsonProperty(value="transactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransferData transactionRulesResult(TransactionRulesResult transactionRulesResult) {
        this.transactionRulesResult = transactionRulesResult;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="transactionRulesResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionRulesResult getTransactionRulesResult() {
        return this.transactionRulesResult;
    }

    @JsonProperty(value="transactionRulesResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionRulesResult(TransactionRulesResult transactionRulesResult) {
        this.transactionRulesResult = transactionRulesResult;
    }

    public TransferData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of transfer or transaction. For example, **refund**, **payment**, **internalTransfer**, **bankTransfer**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TransferData validationFacts(List<TransferNotificationValidationFact> validationFacts) {
        this.validationFacts = validationFacts;
        return this;
    }

    public TransferData addValidationFactsItem(TransferNotificationValidationFact validationFactsItem) {
        if (this.validationFacts == null) {
            this.validationFacts = new ArrayList<TransferNotificationValidationFact>();
        }
        this.validationFacts.add(validationFactsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The evaluation of the validation facts. See [validation checks](https://docs.adyen.com/issuing/validation-checks) for more information.")
    @JsonProperty(value="validationFacts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferNotificationValidationFact> getValidationFacts() {
        return this.validationFacts;
    }

    @Deprecated
    @JsonProperty(value="validationFacts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidationFacts(List<TransferNotificationValidationFact> validationFacts) {
        this.validationFacts = validationFacts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferData transferData = (TransferData)o;
        return Objects.equals(this.accountHolder, transferData.accountHolder) && Objects.equals(this.amount, transferData.amount) && Objects.equals(this.balanceAccount, transferData.balanceAccount) && Objects.equals(this.balanceAccountId, transferData.balanceAccountId) && Objects.equals(this.balancePlatform, transferData.balancePlatform) && Objects.equals(this.balances, transferData.balances) && Objects.equals((Object)this.category, (Object)transferData.category) && Objects.equals(this.counterparty, transferData.counterparty) && Objects.equals(this.creationDate, transferData.creationDate) && Objects.equals(this.description, transferData.description) && Objects.equals((Object)this.direction, (Object)transferData.direction) && Objects.equals(this.events, transferData.events) && Objects.equals(this.id, transferData.id) && Objects.equals(this.modificationMerchantReference, transferData.modificationMerchantReference) && Objects.equals(this.modificationPspReference, transferData.modificationPspReference) && Objects.equals((Object)this.panEntryMode, (Object)transferData.panEntryMode) && Objects.equals(this.paymentInstrument, transferData.paymentInstrument) && Objects.equals(this.paymentInstrumentId, transferData.paymentInstrumentId) && Objects.equals(this.paymentMerchantReference, transferData.paymentMerchantReference) && Objects.equals((Object)this.platformPaymentType, (Object)transferData.platformPaymentType) && Objects.equals((Object)this.priority, (Object)transferData.priority) && Objects.equals((Object)this.processingType, (Object)transferData.processingType) && Objects.equals(this.pspPaymentReference, transferData.pspPaymentReference) && Objects.equals((Object)this.reason, (Object)transferData.reason) && Objects.equals(this.reference, transferData.reference) && Objects.equals(this.referenceForBeneficiary, transferData.referenceForBeneficiary) && Objects.equals(this.relayedAuthorisationData, transferData.relayedAuthorisationData) && Objects.equals(this.sequenceNumber, transferData.sequenceNumber) && Objects.equals((Object)this.status, (Object)transferData.status) && Objects.equals(this.tracking, transferData.tracking) && Objects.equals(this.transactionId, transferData.transactionId) && Objects.equals(this.transactionRulesResult, transferData.transactionRulesResult) && Objects.equals((Object)this.type, (Object)transferData.type) && Objects.equals(this.validationFacts, transferData.validationFacts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolder, this.amount, this.balanceAccount, this.balanceAccountId, this.balancePlatform, this.balances, this.category, this.counterparty, this.creationDate, this.description, this.direction, this.events, this.id, this.modificationMerchantReference, this.modificationPspReference, this.panEntryMode, this.paymentInstrument, this.paymentInstrumentId, this.paymentMerchantReference, this.platformPaymentType, this.priority, this.processingType, this.pspPaymentReference, this.reason, this.reference, this.referenceForBeneficiary, this.relayedAuthorisationData, this.sequenceNumber, this.status, this.tracking, this.transactionId, this.transactionRulesResult, this.type, this.validationFacts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferData {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    modificationMerchantReference: ").append(this.toIndentedString(this.modificationMerchantReference)).append("\n");
        sb.append("    modificationPspReference: ").append(this.toIndentedString(this.modificationPspReference)).append("\n");
        sb.append("    panEntryMode: ").append(this.toIndentedString((Object)this.panEntryMode)).append("\n");
        sb.append("    paymentInstrument: ").append(this.toIndentedString(this.paymentInstrument)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    paymentMerchantReference: ").append(this.toIndentedString(this.paymentMerchantReference)).append("\n");
        sb.append("    platformPaymentType: ").append(this.toIndentedString((Object)this.platformPaymentType)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    processingType: ").append(this.toIndentedString((Object)this.processingType)).append("\n");
        sb.append("    pspPaymentReference: ").append(this.toIndentedString(this.pspPaymentReference)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    relayedAuthorisationData: ").append(this.toIndentedString(this.relayedAuthorisationData)).append("\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tracking: ").append(this.toIndentedString(this.tracking)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionRulesResult: ").append(this.toIndentedString(this.transactionRulesResult)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    validationFacts: ").append(this.toIndentedString(this.validationFacts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferData fromJson(String jsonString) throws JsonProcessingException {
        return (TransferData)JSON.getMapper().readValue(jsonString, TransferData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSAL("atmWithdrawalReversal"),
        BALANCEADJUSTMENT("balanceAdjustment"),
        BALANCEROLLOVER("balanceRollover"),
        BANKTRANSFER("bankTransfer"),
        CAPTURE("capture"),
        CAPTUREREVERSAL("captureReversal"),
        CARDTRANSFER("cardTransfer"),
        CHARGEBACK("chargeback"),
        CHARGEBACKREVERSAL("chargebackReversal"),
        DEPOSITCORRECTION("depositCorrection"),
        FEE("fee"),
        GRANT("grant"),
        INSTALLMENT("installment"),
        INSTALLMENTREVERSAL("installmentReversal"),
        INTERNALTRANSFER("internalTransfer"),
        INVOICEDEDUCTION("invoiceDeduction"),
        LEFTOVER("leftover"),
        MANUALCORRECTION("manualCorrection"),
        MISCCOST("miscCost"),
        PAYMENT("payment"),
        PAYMENTCOST("paymentCost"),
        REFUND("refund"),
        REFUNDREVERSAL("refundReversal"),
        REPAYMENT("repayment"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        SECONDCHARGEBACK("secondChargeback");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        APPROVALPENDING("approvalPending"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
        ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
        AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
        AUTHADJUSTMENTERROR("authAdjustmentError"),
        AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
        AUTHORISED("authorised"),
        BANKTRANSFER("bankTransfer"),
        BANKTRANSFERPENDING("bankTransferPending"),
        BOOKED("booked"),
        BOOKINGPENDING("bookingPending"),
        CANCELLED("cancelled"),
        CAPTUREPENDING("capturePending"),
        CAPTUREREVERSALPENDING("captureReversalPending"),
        CAPTUREREVERSED("captureReversed"),
        CAPTURED("captured"),
        CAPTUREDEXTERNALLY("capturedExternally"),
        CHARGEBACK("chargeback"),
        CHARGEBACKEXTERNALLY("chargebackExternally"),
        CHARGEBACKPENDING("chargebackPending"),
        CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
        CHARGEBACKREVERSED("chargebackReversed"),
        CREDITED("credited"),
        DEPOSITCORRECTION("depositCorrection"),
        DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
        DISPUTE("dispute"),
        DISPUTECLOSED("disputeClosed"),
        DISPUTEEXPIRED("disputeExpired"),
        DISPUTENEEDSREVIEW("disputeNeedsReview"),
        ERROR("error"),
        EXPIRED("expired"),
        FAILED("failed"),
        FEE("fee"),
        FEEPENDING("feePending"),
        INTERNALTRANSFER("internalTransfer"),
        INTERNALTRANSFERPENDING("internalTransferPending"),
        INVOICEDEDUCTION("invoiceDeduction"),
        INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
        MANUALCORRECTIONPENDING("manualCorrectionPending"),
        MANUALLYCORRECTED("manuallyCorrected"),
        MATCHEDSTATEMENT("matchedStatement"),
        MATCHEDSTATEMENTPENDING("matchedStatementPending"),
        MERCHANTPAYIN("merchantPayin"),
        MERCHANTPAYINPENDING("merchantPayinPending"),
        MERCHANTPAYINREVERSED("merchantPayinReversed"),
        MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
        MISCCOST("miscCost"),
        MISCCOSTPENDING("miscCostPending"),
        OPERATIONAUTHORIZED("operationAuthorized"),
        OPERATIONBOOKED("operationBooked"),
        OPERATIONPENDING("operationPending"),
        OPERATIONRECEIVED("operationReceived"),
        PAYMENTCOST("paymentCost"),
        PAYMENTCOSTPENDING("paymentCostPending"),
        RECEIVED("received"),
        REFUNDPENDING("refundPending"),
        REFUNDREVERSALPENDING("refundReversalPending"),
        REFUNDREVERSED("refundReversed"),
        REFUNDED("refunded"),
        REFUNDEDEXTERNALLY("refundedExternally"),
        REFUSED("refused"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
        RETURNED("returned"),
        SECONDCHARGEBACK("secondChargeback"),
        SECONDCHARGEBACKPENDING("secondChargebackPending"),
        UNDEFINED("undefined");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProcessingTypeEnum {
        ATMWITHDRAW("atmWithdraw"),
        BALANCEINQUIRY("balanceInquiry"),
        ECOMMERCE("ecommerce"),
        MOTO("moto"),
        POS("pos"),
        PURCHASEWITHCASHBACK("purchaseWithCashback"),
        RECURRING("recurring"),
        TOKEN("token");

        private String value;

        private ProcessingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProcessingTypeEnum fromValue(String value) {
            for (ProcessingTypeEnum b : ProcessingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PriorityEnum {
        CROSSBORDER("crossBorder"),
        DIRECTDEBIT("directDebit"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PlatformPaymentTypeEnum {
        BALANCEACCOUNT("BalanceAccount"),
        COMMISSION("Commission"),
        DEFAULT("Default"),
        PAYMENTFEE("PaymentFee"),
        VAT("VAT");

        private String value;

        private PlatformPaymentTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlatformPaymentTypeEnum fromValue(String value) {
            for (PlatformPaymentTypeEnum b : PlatformPaymentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PanEntryModeEnum {
        CHIP("chip"),
        COF("cof"),
        CONTACTLESS("contactless"),
        ECOMMERCE("ecommerce"),
        MAGSTRIPE("magstripe"),
        MANUAL("manual"),
        TOKEN("token");

        private String value;

        private PanEntryModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PanEntryModeEnum fromValue(String value) {
            for (PanEntryModeEnum b : PanEntryModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CategoryEnum {
        BANK("bank"),
        INTERNAL("internal"),
        ISSUEDCARD("issuedCard"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

