/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.AccountHolder;
import com.adyen.model.balanceplatform.AccountHolderInfo;
import com.adyen.model.balanceplatform.AccountHolderUpdateRequest;
import com.adyen.model.balanceplatform.PaginatedBalanceAccountsResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class AccountHoldersApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public AccountHoldersApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public AccountHoldersApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public AccountHolder getAccountHolder(String id) throws ApiException, IOException {
        return this.getAccountHolder(id, null);
    }

    public AccountHolder getAccountHolder(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/accountHolders/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return AccountHolder.fromJson(jsonResult);
    }

    public PaginatedBalanceAccountsResponse getAllBalanceAccountsOfAccountHolder(String id) throws ApiException, IOException {
        return this.getAllBalanceAccountsOfAccountHolder(id, null, null, null);
    }

    public PaginatedBalanceAccountsResponse getAllBalanceAccountsOfAccountHolder(String id, Integer offset, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/accountHolders/{id}/balanceAccounts", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaginatedBalanceAccountsResponse.fromJson(jsonResult);
    }

    public AccountHolder updateAccountHolder(String id, AccountHolderUpdateRequest accountHolderUpdateRequest) throws ApiException, IOException {
        return this.updateAccountHolder(id, accountHolderUpdateRequest, null);
    }

    public AccountHolder updateAccountHolder(String id, AccountHolderUpdateRequest accountHolderUpdateRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = accountHolderUpdateRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/accountHolders/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return AccountHolder.fromJson(jsonResult);
    }

    public AccountHolder createAccountHolder(AccountHolderInfo accountHolderInfo) throws ApiException, IOException {
        return this.createAccountHolder(accountHolderInfo, null);
    }

    public AccountHolder createAccountHolder(AccountHolderInfo accountHolderInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = accountHolderInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/accountHolders", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return AccountHolder.fromJson(jsonResult);
    }
}

