/*
 * Notification Configuration API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Notification Configuration API provides endpoints for setting up and testing notifications that inform you of events on your platform, for example when a verification check or a payout has been completed.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/notifications). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Notification Configuration API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Notification/v6/createNotificationConfiguration ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayconfiguration;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * NotificationEventConfiguration
 */
@JsonPropertyOrder({
  NotificationEventConfiguration.JSON_PROPERTY_EVENT_TYPE,
  NotificationEventConfiguration.JSON_PROPERTY_INCLUDE_MODE
})

public class NotificationEventConfiguration {
  /**
   * The type of event.  Possible values: **ACCOUNT_CLOSED**, **ACCOUNT_CREATED**, **ACCOUNT_FUNDS_BELOW_THRESHOLD**, **ACCOUNT_HOLDER_CREATED**, **ACCOUNT_HOLDER_LIMIT_REACHED**, **ACCOUNT_HOLDER_PAYOUT**, **ACCOUNT_HOLDER_STATUS_CHANGE**, **ACCOUNT_HOLDER_STORE_STATUS_CHANGE**, **ACCOUNT_HOLDER_UPCOMING_DEADLINE**, **ACCOUNT_HOLDER_UPDATED**, **ACCOUNT_HOLDER_VERIFICATION**, **ACCOUNT_UPDATED**, **BENEFICIARY_SETUP**, **COMPENSATE_NEGATIVE_BALANCE**, **DIRECT_DEBIT_INITIATED**, **PAYMENT_FAILURE**, **REFUND_FUNDS_TRANSFER**, **REPORT_AVAILABLE**, **SCHEDULED_REFUNDS**, **TRANSFER_FUNDS**.
   */
  public enum EventTypeEnum {
    ACCOUNT_CLOSED("ACCOUNT_CLOSED"),
    
    ACCOUNT_CREATED("ACCOUNT_CREATED"),
    
    ACCOUNT_FUNDS_BELOW_THRESHOLD("ACCOUNT_FUNDS_BELOW_THRESHOLD"),
    
    ACCOUNT_HOLDER_CREATED("ACCOUNT_HOLDER_CREATED"),
    
    ACCOUNT_HOLDER_LIMIT_REACHED("ACCOUNT_HOLDER_LIMIT_REACHED"),
    
    ACCOUNT_HOLDER_MIGRATED("ACCOUNT_HOLDER_MIGRATED"),
    
    ACCOUNT_HOLDER_PAYOUT("ACCOUNT_HOLDER_PAYOUT"),
    
    ACCOUNT_HOLDER_STATUS_CHANGE("ACCOUNT_HOLDER_STATUS_CHANGE"),
    
    ACCOUNT_HOLDER_STORE_STATUS_CHANGE("ACCOUNT_HOLDER_STORE_STATUS_CHANGE"),
    
    ACCOUNT_HOLDER_UPCOMING_DEADLINE("ACCOUNT_HOLDER_UPCOMING_DEADLINE"),
    
    ACCOUNT_HOLDER_UPDATED("ACCOUNT_HOLDER_UPDATED"),
    
    ACCOUNT_HOLDER_VERIFICATION("ACCOUNT_HOLDER_VERIFICATION"),
    
    ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
    
    BENEFICIARY_SETUP("BENEFICIARY_SETUP"),
    
    COMPENSATE_NEGATIVE_BALANCE("COMPENSATE_NEGATIVE_BALANCE"),
    
    DIRECT_DEBIT_INITIATED("DIRECT_DEBIT_INITIATED"),
    
    FUNDS_MIGRATED("FUNDS_MIGRATED"),
    
    PAYMENT_FAILURE("PAYMENT_FAILURE"),
    
    PENDING_CREDIT("PENDING_CREDIT"),
    
    REFUND_FUNDS_TRANSFER("REFUND_FUNDS_TRANSFER"),
    
    REPORT_AVAILABLE("REPORT_AVAILABLE"),
    
    SCHEDULED_REFUNDS("SCHEDULED_REFUNDS"),
    
    SCORE_SIGNAL_TRIGGERED("SCORE_SIGNAL_TRIGGERED"),
    
    TRANSFER_FUNDS("TRANSFER_FUNDS"),
    
    TRANSFER_NOT_PAIDOUT_TRANSFERS("TRANSFER_NOT_PAIDOUT_TRANSFERS");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypeEnum fromValue(String value) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
  private EventTypeEnum eventType;

  /**
   * Indicates whether the specified &#x60;eventType&#x60; is sent to your webhook endpoint. Possible values: * **INCLUDE**: Send the specified &#x60;eventType&#x60;. * **EXCLUDE**: Send all event types except the specified &#x60;eventType&#x60; and other event types with the &#x60;includeMode&#x60; set to **EXCLUDE**.
   */
  public enum IncludeModeEnum {
    EXCLUDE("EXCLUDE"),
    
    INCLUDE("INCLUDE");

    private String value;

    IncludeModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IncludeModeEnum fromValue(String value) {
      for (IncludeModeEnum b : IncludeModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INCLUDE_MODE = "includeMode";
  private IncludeModeEnum includeMode;

  public NotificationEventConfiguration() { 
  }

  public NotificationEventConfiguration eventType(EventTypeEnum eventType) {
    this.eventType = eventType;
    return this;
  }

   /**
   * The type of event.  Possible values: **ACCOUNT_CLOSED**, **ACCOUNT_CREATED**, **ACCOUNT_FUNDS_BELOW_THRESHOLD**, **ACCOUNT_HOLDER_CREATED**, **ACCOUNT_HOLDER_LIMIT_REACHED**, **ACCOUNT_HOLDER_PAYOUT**, **ACCOUNT_HOLDER_STATUS_CHANGE**, **ACCOUNT_HOLDER_STORE_STATUS_CHANGE**, **ACCOUNT_HOLDER_UPCOMING_DEADLINE**, **ACCOUNT_HOLDER_UPDATED**, **ACCOUNT_HOLDER_VERIFICATION**, **ACCOUNT_UPDATED**, **BENEFICIARY_SETUP**, **COMPENSATE_NEGATIVE_BALANCE**, **DIRECT_DEBIT_INITIATED**, **PAYMENT_FAILURE**, **REFUND_FUNDS_TRANSFER**, **REPORT_AVAILABLE**, **SCHEDULED_REFUNDS**, **TRANSFER_FUNDS**.
   * @return eventType
  **/
  @ApiModelProperty(required = true, value = "The type of event.  Possible values: **ACCOUNT_CLOSED**, **ACCOUNT_CREATED**, **ACCOUNT_FUNDS_BELOW_THRESHOLD**, **ACCOUNT_HOLDER_CREATED**, **ACCOUNT_HOLDER_LIMIT_REACHED**, **ACCOUNT_HOLDER_PAYOUT**, **ACCOUNT_HOLDER_STATUS_CHANGE**, **ACCOUNT_HOLDER_STORE_STATUS_CHANGE**, **ACCOUNT_HOLDER_UPCOMING_DEADLINE**, **ACCOUNT_HOLDER_UPDATED**, **ACCOUNT_HOLDER_VERIFICATION**, **ACCOUNT_UPDATED**, **BENEFICIARY_SETUP**, **COMPENSATE_NEGATIVE_BALANCE**, **DIRECT_DEBIT_INITIATED**, **PAYMENT_FAILURE**, **REFUND_FUNDS_TRANSFER**, **REPORT_AVAILABLE**, **SCHEDULED_REFUNDS**, **TRANSFER_FUNDS**.")
  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EventTypeEnum getEventType() {
    return eventType;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventType(EventTypeEnum eventType) {
    this.eventType = eventType;
  }


  public NotificationEventConfiguration includeMode(IncludeModeEnum includeMode) {
    this.includeMode = includeMode;
    return this;
  }

   /**
   * Indicates whether the specified &#x60;eventType&#x60; is sent to your webhook endpoint. Possible values: * **INCLUDE**: Send the specified &#x60;eventType&#x60;. * **EXCLUDE**: Send all event types except the specified &#x60;eventType&#x60; and other event types with the &#x60;includeMode&#x60; set to **EXCLUDE**.
   * @return includeMode
  **/
  @ApiModelProperty(required = true, value = "Indicates whether the specified `eventType` is sent to your webhook endpoint. Possible values: * **INCLUDE**: Send the specified `eventType`. * **EXCLUDE**: Send all event types except the specified `eventType` and other event types with the `includeMode` set to **EXCLUDE**.")
  @JsonProperty(JSON_PROPERTY_INCLUDE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IncludeModeEnum getIncludeMode() {
    return includeMode;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeMode(IncludeModeEnum includeMode) {
    this.includeMode = includeMode;
  }


  /**
   * Return true if this NotificationEventConfiguration object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NotificationEventConfiguration notificationEventConfiguration = (NotificationEventConfiguration) o;
    return Objects.equals(this.eventType, notificationEventConfiguration.eventType) &&
        Objects.equals(this.includeMode, notificationEventConfiguration.includeMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventType, includeMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NotificationEventConfiguration {\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    includeMode: ").append(toIndentedString(includeMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of NotificationEventConfiguration given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of NotificationEventConfiguration
   * @throws JsonProcessingException if the JSON string is invalid with respect to NotificationEventConfiguration
   */
  public static NotificationEventConfiguration fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, NotificationEventConfiguration.class);
  }
/**
  * Convert an instance of NotificationEventConfiguration to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

