/*
 * Adyen BinLookup API
 * The BIN Lookup API provides endpoints for retrieving information, such as cost estimates, and 3D Secure supported version based on a given BIN.  ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning The BinLookup API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/BinLookup/v54/get3dsAvailability ```## Going live  To authneticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/BinLookup/v54/get3dsAvailability ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 54
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.binlookup;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * MerchantDetails
 */
@JsonPropertyOrder({
  MerchantDetails.JSON_PROPERTY_COUNTRY_CODE,
  MerchantDetails.JSON_PROPERTY_ENROLLED_IN3_D_SECURE,
  MerchantDetails.JSON_PROPERTY_MCC
})

public class MerchantDetails {
  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_ENROLLED_IN3_D_SECURE = "enrolledIn3DSecure";
  private Boolean enrolledIn3DSecure;

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public MerchantDetails() { 
  }

  public MerchantDetails countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

   /**
   * 2-letter ISO 3166 country code of the card acceptor location. &gt; This parameter is required for the merchants who don&#39;t use Adyen as the payment authorisation gateway.
   * @return countryCode
  **/
  @ApiModelProperty(value = "2-letter ISO 3166 country code of the card acceptor location. > This parameter is required for the merchants who don't use Adyen as the payment authorisation gateway.")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public MerchantDetails enrolledIn3DSecure(Boolean enrolledIn3DSecure) {
    this.enrolledIn3DSecure = enrolledIn3DSecure;
    return this;
  }

   /**
   * If true, indicates that the merchant is enrolled in 3D Secure for the card network.
   * @return enrolledIn3DSecure
  **/
  @ApiModelProperty(value = "If true, indicates that the merchant is enrolled in 3D Secure for the card network.")
  @JsonProperty(JSON_PROPERTY_ENROLLED_IN3_D_SECURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnrolledIn3DSecure() {
    return enrolledIn3DSecure;
  }


  @JsonProperty(JSON_PROPERTY_ENROLLED_IN3_D_SECURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnrolledIn3DSecure(Boolean enrolledIn3DSecure) {
    this.enrolledIn3DSecure = enrolledIn3DSecure;
  }


  public MerchantDetails mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

   /**
   * The merchant category code (MCC) is a four-digit number which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.  The list of MCCs can be found [here](https://en.wikipedia.org/wiki/Merchant_category_code).
   * @return mcc
  **/
  @ApiModelProperty(value = "The merchant category code (MCC) is a four-digit number which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.  The list of MCCs can be found [here](https://en.wikipedia.org/wiki/Merchant_category_code).")
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMcc() {
    return mcc;
  }


  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  /**
   * Return true if this MerchantDetails object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantDetails merchantDetails = (MerchantDetails) o;
    return Objects.equals(this.countryCode, merchantDetails.countryCode) &&
        Objects.equals(this.enrolledIn3DSecure, merchantDetails.enrolledIn3DSecure) &&
        Objects.equals(this.mcc, merchantDetails.mcc);
  }

  @Override
  public int hashCode() {
    return Objects.hash(countryCode, enrolledIn3DSecure, mcc);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantDetails {\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    enrolledIn3DSecure: ").append(toIndentedString(enrolledIn3DSecure)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of MerchantDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of MerchantDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to MerchantDetails
   */
  public static MerchantDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, MerchantDetails.class);
  }
/**
  * Convert an instance of MerchantDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

