/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 70
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.Amount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ForexQuote
 */
@JsonPropertyOrder({
  ForexQuote.JSON_PROPERTY_ACCOUNT,
  ForexQuote.JSON_PROPERTY_ACCOUNT_TYPE,
  ForexQuote.JSON_PROPERTY_BASE_AMOUNT,
  ForexQuote.JSON_PROPERTY_BASE_POINTS,
  ForexQuote.JSON_PROPERTY_BUY,
  ForexQuote.JSON_PROPERTY_INTERBANK,
  ForexQuote.JSON_PROPERTY_REFERENCE,
  ForexQuote.JSON_PROPERTY_SELL,
  ForexQuote.JSON_PROPERTY_SIGNATURE,
  ForexQuote.JSON_PROPERTY_SOURCE,
  ForexQuote.JSON_PROPERTY_TYPE,
  ForexQuote.JSON_PROPERTY_VALID_TILL
})

public class ForexQuote {
  public static final String JSON_PROPERTY_ACCOUNT = "account";
  private String account;

  public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
  private String accountType;

  public static final String JSON_PROPERTY_BASE_AMOUNT = "baseAmount";
  private Amount baseAmount;

  public static final String JSON_PROPERTY_BASE_POINTS = "basePoints";
  private Integer basePoints;

  public static final String JSON_PROPERTY_BUY = "buy";
  private Amount buy;

  public static final String JSON_PROPERTY_INTERBANK = "interbank";
  private Amount interbank;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_SELL = "sell";
  private Amount sell;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SOURCE = "source";
  private String source;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_VALID_TILL = "validTill";
  private OffsetDateTime validTill;

  public ForexQuote() { 
  }

  public ForexQuote account(String account) {
    this.account = account;
    return this;
  }

   /**
   * The account name.
   * @return account
  **/
  @ApiModelProperty(value = "The account name.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccount() {
    return account;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccount(String account) {
    this.account = account;
  }


  public ForexQuote accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * The account type.
   * @return accountType
  **/
  @ApiModelProperty(value = "The account type.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountType() {
    return accountType;
  }


  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }


  public ForexQuote baseAmount(Amount baseAmount) {
    this.baseAmount = baseAmount;
    return this;
  }

   /**
   * Get baseAmount
   * @return baseAmount
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getBaseAmount() {
    return baseAmount;
  }


  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseAmount(Amount baseAmount) {
    this.baseAmount = baseAmount;
  }


  public ForexQuote basePoints(Integer basePoints) {
    this.basePoints = basePoints;
    return this;
  }

   /**
   * The base points.
   * @return basePoints
  **/
  @ApiModelProperty(required = true, value = "The base points.")
  @JsonProperty(JSON_PROPERTY_BASE_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBasePoints() {
    return basePoints;
  }


  @JsonProperty(JSON_PROPERTY_BASE_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBasePoints(Integer basePoints) {
    this.basePoints = basePoints;
  }


  public ForexQuote buy(Amount buy) {
    this.buy = buy;
    return this;
  }

   /**
   * Get buy
   * @return buy
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BUY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getBuy() {
    return buy;
  }


  @JsonProperty(JSON_PROPERTY_BUY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBuy(Amount buy) {
    this.buy = buy;
  }


  public ForexQuote interbank(Amount interbank) {
    this.interbank = interbank;
    return this;
  }

   /**
   * Get interbank
   * @return interbank
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERBANK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getInterbank() {
    return interbank;
  }


  @JsonProperty(JSON_PROPERTY_INTERBANK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInterbank(Amount interbank) {
    this.interbank = interbank;
  }


  public ForexQuote reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * The reference assigned to the forex quote request.
   * @return reference
  **/
  @ApiModelProperty(value = "The reference assigned to the forex quote request.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public ForexQuote sell(Amount sell) {
    this.sell = sell;
    return this;
  }

   /**
   * Get sell
   * @return sell
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SELL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getSell() {
    return sell;
  }


  @JsonProperty(JSON_PROPERTY_SELL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSell(Amount sell) {
    this.sell = sell;
  }


  public ForexQuote signature(String signature) {
    this.signature = signature;
    return this;
  }

   /**
   * The signature to validate the integrity.
   * @return signature
  **/
  @ApiModelProperty(value = "The signature to validate the integrity.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSignature() {
    return signature;
  }


  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignature(String signature) {
    this.signature = signature;
  }


  public ForexQuote source(String source) {
    this.source = source;
    return this;
  }

   /**
   * The source of the forex quote.
   * @return source
  **/
  @ApiModelProperty(value = "The source of the forex quote.")
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(String source) {
    this.source = source;
  }


  public ForexQuote type(String type) {
    this.type = type;
    return this;
  }

   /**
   * The type of forex.
   * @return type
  **/
  @ApiModelProperty(value = "The type of forex.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public ForexQuote validTill(OffsetDateTime validTill) {
    this.validTill = validTill;
    return this;
  }

   /**
   * The date until which the forex quote is valid.
   * @return validTill
  **/
  @ApiModelProperty(required = true, value = "The date until which the forex quote is valid.")
  @JsonProperty(JSON_PROPERTY_VALID_TILL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getValidTill() {
    return validTill;
  }


  @JsonProperty(JSON_PROPERTY_VALID_TILL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValidTill(OffsetDateTime validTill) {
    this.validTill = validTill;
  }


  /**
   * Return true if this ForexQuote object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ForexQuote forexQuote = (ForexQuote) o;
    return Objects.equals(this.account, forexQuote.account) &&
        Objects.equals(this.accountType, forexQuote.accountType) &&
        Objects.equals(this.baseAmount, forexQuote.baseAmount) &&
        Objects.equals(this.basePoints, forexQuote.basePoints) &&
        Objects.equals(this.buy, forexQuote.buy) &&
        Objects.equals(this.interbank, forexQuote.interbank) &&
        Objects.equals(this.reference, forexQuote.reference) &&
        Objects.equals(this.sell, forexQuote.sell) &&
        Objects.equals(this.signature, forexQuote.signature) &&
        Objects.equals(this.source, forexQuote.source) &&
        Objects.equals(this.type, forexQuote.type) &&
        Objects.equals(this.validTill, forexQuote.validTill);
  }

  @Override
  public int hashCode() {
    return Objects.hash(account, accountType, baseAmount, basePoints, buy, interbank, reference, sell, signature, source, type, validTill);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ForexQuote {\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    baseAmount: ").append(toIndentedString(baseAmount)).append("\n");
    sb.append("    basePoints: ").append(toIndentedString(basePoints)).append("\n");
    sb.append("    buy: ").append(toIndentedString(buy)).append("\n");
    sb.append("    interbank: ").append(toIndentedString(interbank)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    sell: ").append(toIndentedString(sell)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validTill: ").append(toIndentedString(validTill)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ForexQuote given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ForexQuote
   * @throws JsonProcessingException if the JSON string is invalid with respect to ForexQuote
   */
  public static ForexQuote fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ForexQuote.class);
  }
/**
  * Convert an instance of ForexQuote to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

